/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import javax.swing.JComponent;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;

public abstract class JDRObject
implements Serializable,
Cloneable {
    public static Paint draftColor = Color.lightGray;
    protected boolean selected;

    public void setSelected(boolean bl) {
        this.selected = bl;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public BBox getBBox() {
        return null;
    }

    public void mergeBBox(BBox bBox) {
        BBox bBox2 = this.getBBox();
        if (bBox2 != null) {
            bBox.merge(bBox2);
        }
    }

    public BBox getControlBBox() {
        return this.getBBox();
    }

    public abstract void transform(double[] var1);

    public void translate(Point point) {
        this.translate(point.x, point.y);
    }

    public void translate(JDRPoint jDRPoint) {
        this.translate(jDRPoint.x, jDRPoint.y);
    }

    public void translate(Point2D point2D) {
        this.translate(point2D.getX(), point2D.getY());
    }

    public abstract void translate(double var1, double var3);

    public abstract void scale(double var1, double var3);

    public void scale(double d) {
        this.scale(d, d);
    }

    public void scale(Point2D point2D, double d, double d2) {
        this.translate(new Point2D.Double(-point2D.getX(), -point2D.getY()));
        this.scale(d, d2);
        this.translate(point2D);
    }

    public void scale(Point2D point2D, double d) {
        this.scale(point2D, d, d);
    }

    public void scale(JDRPoint jDRPoint, double d) {
        this.scale(jDRPoint.getPoint2D(), d);
    }

    public void scale(JDRPoint jDRPoint, double d, double d2) {
        this.scale(jDRPoint.getPoint2D(), d, d2);
    }

    public void scale(Point point, double d) {
        this.scale(new Point2D.Double(point.x, point.y), d);
    }

    public void scaleX(double d) {
        this.scale(d, 1.0);
    }

    public void scaleX(Point2D point2D, double d) {
        this.scale(point2D, d, 1.0);
    }

    public void scaleX(JDRPoint jDRPoint, double d) {
        this.scaleX(jDRPoint.getPoint2D(), d);
    }

    public void scaleX(Point point, double d) {
        this.scaleX(new Point2D.Double(point.x, point.y), d);
    }

    public void scaleY(double d) {
        this.scale(1.0, d);
    }

    public void scaleY(JDRPoint jDRPoint, double d) {
        this.scaleY(jDRPoint.getPoint2D(), d);
    }

    public void scaleY(Point point, double d) {
        this.scaleY(new Point2D.Double(point.x, point.y), d);
    }

    public void scaleY(Point2D point2D, double d) {
        this.scale(point2D, 1.0, d);
    }

    public abstract void shear(double var1, double var3);

    public void shear(double d) {
        this.shear(d, d);
    }

    public void shear(Point2D point2D, double d) {
        this.translate(new Point2D.Double(-point2D.getX(), -point2D.getY()));
        this.shear(d);
        this.translate(point2D);
    }

    public void shear(Point2D point2D, double d, double d2) {
        this.translate(new Point2D.Double(-point2D.getX(), -point2D.getY()));
        this.shear(d, d2);
        this.translate(point2D);
    }

    public void shear(JDRPoint jDRPoint, double d, double d2) {
        this.translate(-jDRPoint.x, -jDRPoint.y);
        this.shear(d, d2);
        this.translate(jDRPoint.x, jDRPoint.y);
    }

    public void shear(JDRPoint jDRPoint, double d) {
        this.shear(jDRPoint.getPoint2D(), d);
    }

    public void shear(Point point, double d) {
        this.shear(new Point2D.Double(point.x, point.y), d);
    }

    public void shearX(double d) {
        this.shear(d, 0.0);
    }

    public void shearX(Point2D point2D, double d) {
        this.translate(new Point2D.Double(-point2D.getX(), -point2D.getY()));
        this.shearX(d);
        this.translate(point2D);
    }

    public void shearX(JDRPoint jDRPoint, double d) {
        this.shearX(jDRPoint.getPoint2D(), d);
    }

    public void shearX(Point point, double d) {
        this.shearX(new Point2D.Double(point.x, point.y), d);
    }

    public void shearY(double d) {
        this.shear(0.0, d);
    }

    public void shearY(JDRPoint jDRPoint, double d) {
        this.shearY(jDRPoint.getPoint2D(), d);
    }

    public void shearY(Point point, double d) {
        this.shearY(new Point2D.Double(point.x, point.y), d);
    }

    public void shearY(Point2D point2D, double d) {
        this.translate(new Point2D.Double(-point2D.getX(), -point2D.getY()));
        this.shearY(d);
        this.translate(point2D);
    }

    public abstract void rotate(double var1);

    public void rotate(Point2D point2D, double d) {
        this.translate(new Point2D.Double(-point2D.getX(), -point2D.getY()));
        this.rotate(d);
        this.translate(point2D);
    }

    public void rotate(JDRPoint jDRPoint, double d) {
        this.rotate(jDRPoint.getPoint2D(), d);
    }

    public void rotate(Point point, double d) {
        this.rotate(new Point2D.Double(point.x, point.y), d);
    }

    public void drawControls(Graphics graphics, boolean bl) {
    }

    public void draw(Graphics graphics, boolean bl, JComponent jComponent) {
        this.draw(graphics, bl);
    }

    public abstract void draw(Graphics var1);

    public void drawDraft(Graphics graphics) {
        this.draw(graphics);
    }

    public void draw(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl) {
            graphics2D.setPaint(draftColor);
            this.drawDraft(graphics);
        } else {
            this.draw(graphics);
        }
    }

    public abstract void saveEPS(PrintWriter var1) throws IOException;

    public int psLevel() {
        return 1;
    }

    public abstract void saveSVG(PrintWriter var1) throws IOException;

    public abstract String pgf(AffineTransform var1);

    public abstract Object clone();

    public void makeEqual(JDRObject jDRObject) {
        this.selected = jDRObject.isSelected();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof JDRObject)) {
            return false;
        }
        JDRObject jDRObject = (JDRObject)object;
        return this.selected == jDRObject.selected;
    }

    public JDRPoint getControl(Point point, boolean bl) {
        return null;
    }

    public JDRObjectLoaderListener getListener() {
        return null;
    }
}

