/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.JDRLineLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;

public class JDRLine
extends JDRSegment {
    private static JDRLineLoaderListener listener = new JDRLineLoaderListener();

    public JDRLine(double d, double d2, double d3, double d4) {
        super(d, d2, d3, d4);
    }

    public JDRLine(Point point, Point point2) {
        super(point, point2);
    }

    public JDRLine(Point2D point2D, Point2D point2D2) {
        super(point2D, point2D2);
    }

    public JDRLine(JDRPoint jDRPoint, JDRPoint jDRPoint2) {
        super(jDRPoint, jDRPoint2);
    }

    public JDRLine() {
    }

    @Override
    public JDRLine reverse() {
        JDRLine jDRLine = (JDRLine)this.clone();
        jDRLine.start.x = this.end.x;
        jDRLine.start.y = this.end.y;
        jDRLine.end.x = this.start.x;
        jDRLine.end.y = this.start.y;
        return jDRLine;
    }

    @Override
    public JDRPathSegment split() {
        JDRPoint jDRPoint = new JDRPoint(this.getP(0.5));
        JDRLine jDRLine = new JDRLine(jDRPoint, this.end);
        this.end = jDRPoint;
        return jDRLine;
    }

    @Override
    public Object clone() {
        JDRLine jDRLine = new JDRLine((JDRPoint)this.start.clone(), (JDRPoint)this.end.clone());
        jDRLine.makeEqual(this);
        return jDRLine;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        return object instanceof JDRLine;
    }

    @Override
    public void draw(Graphics graphics) {
        graphics.drawLine((int)this.start.x, (int)this.start.y, (int)this.end.x, (int)this.end.y);
    }

    @Override
    public void draw(Graphics graphics, double d) {
        graphics.drawLine((int)(d * this.start.x), (int)(d * this.start.y), (int)(d * this.end.x), (int)(d * this.end.y));
    }

    @Override
    public void drawDraft(Graphics graphics, double d, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setPaint(JDRObject.draftColor);
        graphics2D.drawLine((int)(this.start.x * d), (int)(this.start.y * d), (int)(this.end.x * d), (int)(this.end.y * d));
        if (this.isSelected()) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setPaint(this.start.getSelectedPaint());
            graphics2D.setStroke(guideStroke);
            graphics2D.drawLine((int)(this.start.x * d), (int)(this.start.y * d), (int)(this.end.x * d), (int)(this.end.y * d));
            graphics2D.setStroke(stroke);
        }
        this.start.draw(graphics, d);
        if (bl) {
            this.end.draw(graphics, d);
        }
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        printWriter.print("L ");
        this.end.saveSVG(printWriter);
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        this.end.saveEPS(printWriter);
        printWriter.println("lineto");
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        return "\\pgfpathlineto{" + this.end.pgf(affineTransform) + "}";
    }

    @Override
    public void appendToGeneralPath(GeneralPath generalPath) {
        generalPath.lineTo((float)this.end.x, (float)this.end.y);
    }

    @Override
    public void appendReflectionToGeneralPath(GeneralPath generalPath, JDRLine jDRLine) {
        Point2D point2D = this.start.getReflection(jDRLine);
        generalPath.lineTo((float)point2D.getX(), (float)point2D.getY());
    }

    @Override
    public JDRPathSegment getReflection(JDRLine jDRLine) {
        Point2D point2D = this.start.getReflection(jDRLine);
        Point2D point2D2 = this.end.getReflection(jDRLine);
        return new JDRLine(point2D, point2D2);
    }

    public AffineTransform getReflectionTransform(AffineTransform affineTransform) {
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        double d = this.start.x - this.end.x;
        double d2 = this.start.y - this.end.y;
        if (Math.abs(d) < 1.0) {
            affineTransform.setTransform(-1.0, 0.0, 0.0, 1.0, 2.0 * this.end.x, 0.0);
        } else if (Math.abs(d2) < 1.0) {
            affineTransform.setTransform(1.0, 0.0, 0.0, -1.0, 0.0, 2.0 * this.end.y);
        } else {
            double d3 = d2 / d;
            double d4 = d / d2;
            double d5 = 2.0 / (d3 + d4);
            affineTransform.setTransform(d5 * d4 - 1.0, d5, d5, d5 * d3 - 1.0, d5 * (d3 * this.start.x - this.start.y), d5 * (d4 * this.start.y - this.start.x));
        }
        return affineTransform;
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return listener;
    }

    @Override
    public String toString() {
        return "JDRLine:(" + this.start.x + "," + this.start.y + ")(" + this.end.x + "," + this.end.y + "),startMarker=" + this.startMarker + ",endMarker=" + this.endMarker;
    }

    @Override
    public String info() {
        return "line[" + this.start.info() + "," + this.end.info() + "]";
    }

    @Override
    public boolean isGap() {
        return false;
    }
}

