/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class JDRGroupListener
implements JDRObjectLoaderListener {
    @Override
    public char getJDRid(float f) {
        return 'G';
    }

    @Override
    public void writeJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRGroup jDRGroup = (JDRGroup)jDRObject;
        JDRObjectLoader jDRObjectLoader = JDR.getObjectLoader();
        int n = jDRGroup.size();
        dataOutputStream.writeInt(n);
        int n2 = JDR.messageSystem.getProgress();
        JDR.messageSystem.resetProgress(n);
        for (int i = 0; i < n; ++i) {
            jDRObjectLoader.saveJDR(jDRGroup.get(i), dataOutputStream, f);
            JDR.messageSystem.incrementProgress();
        }
        JDR.messageSystem.setProgress(n2);
    }

    @Override
    public JDRObject readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        int n = dataInputStream.readInt();
        int n2 = JDR.messageSystem.getProgress();
        JDR.messageSystem.resetProgress(n);
        JDRGroup jDRGroup = new JDRGroup(n);
        JDRObjectLoader jDRObjectLoader = JDR.getObjectLoader();
        for (int i = 0; i < n; ++i) {
            JDRCompleteObject jDRCompleteObject = (JDRCompleteObject)jDRObjectLoader.loadJDR(dataInputStream, f);
            if (jDRCompleteObject != null) {
                jDRGroup.add(jDRCompleteObject);
            }
            JDR.messageSystem.incrementProgress();
        }
        JDR.messageSystem.setProgress(n2);
        return jDRGroup;
    }

    @Override
    public char getAJRid(float f) {
        return 'G';
    }

    @Override
    public void writeAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRGroup jDRGroup = (JDRGroup)jDRObject;
        JDRObjectLoader jDRObjectLoader = AJR.getObjectLoader();
        int n = jDRGroup.size();
        AJR.writeInt(printWriter, n);
        int n2 = JDR.messageSystem.getProgress();
        JDR.messageSystem.resetProgress(n);
        for (int i = 0; i < n; ++i) {
            jDRObjectLoader.saveAJR(jDRGroup.get(i), printWriter, f);
            JDR.messageSystem.incrementProgress();
        }
        JDR.messageSystem.setProgress(n2);
    }

    @Override
    public JDRObject readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        int n = AJR.readInt(bufferedReader);
        int n2 = JDR.messageSystem.getProgress();
        JDR.messageSystem.resetProgress(n);
        JDRGroup jDRGroup = new JDRGroup(n);
        JDRObjectLoader jDRObjectLoader = AJR.getObjectLoader();
        for (int i = 0; i < n; ++i) {
            JDRCompleteObject jDRCompleteObject = (JDRCompleteObject)jDRObjectLoader.loadAJR(bufferedReader, f);
            jDRGroup.add(jDRCompleteObject);
            JDR.messageSystem.incrementProgress();
        }
        JDR.messageSystem.setProgress(n2);
        return jDRGroup;
    }
}

