/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JComponent;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.CanOnlyMergePathsException;
import uk.ac.uea.cmp.nlct.jdr.EmptyPathException;
import uk.ac.uea.cmp.nlct.jdr.IllFittingPathException;
import uk.ac.uea.cmp.nlct.jdr.InvalidShapeException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmap;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRCompoundShape;
import uk.ac.uea.cmp.nlct.jdr.JDRGroupListener;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPartialSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRRotationalPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPath;
import uk.ac.uea.cmp.nlct.jdr.JDRText;
import uk.ac.uea.cmp.nlct.jdr.JDRTextPath;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.NoPathException;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class JDRGroup
extends JDRCompleteObject {
    private JDRCompleteObject[] objectList_;
    private int capacity_ = 10;
    private int size_ = 0;
    private static JDRGroupListener groupListener = new JDRGroupListener();
    public static int init_capacity_memory = 5;
    public static int init_capacity_speed = 20;
    public static final int PATH = 0;
    public static final int TEXT = 1;
    public static final int BITMAP = 2;
    public static final int GROUP = 3;
    public static final int TEXTPATH = 4;
    public static final int SYMMETRIC = 5;
    public static final int SYMTEXTPATH = 6;
    public static final int PATTERN = 7;
    public static final int COMPOUND = 8;
    public static final int SHAPE = 9;
    public static final int TEXTUAL = 10;
    public static final int NON_TEXTUAL_SHAPE = 11;
    public static final int ANY = 12;
    public static final int MAX_OBJECT_TYPES = 13;

    public JDRGroup() {
        this(JDRGroup.getInitCapacity());
    }

    public JDRGroup(int n) {
        this.capacity_ = n;
        this.size_ = 0;
        this.objectList_ = new JDRCompleteObject[n];
    }

    public int getCapacity() {
        return this.capacity_;
    }

    public void setCapacity(int n) throws IllegalArgumentException {
        if (n < this.size_) {
            throw new IllegalArgumentException("Can't set capacity to " + n + " for group of size " + this.size_);
        }
        this.enlargeList(n);
    }

    private void enlargeList() {
        if (JDR.getOptimize() == 0) {
            this.enlargeList(2 * this.capacity_);
        } else {
            this.enlargeList(this.capacity_ + 5);
        }
    }

    private void enlargeList(int n) {
        this.capacity_ = n;
        JDRCompleteObject[] jDRCompleteObjectArray = new JDRCompleteObject[this.capacity_];
        for (int i = 0; i < this.size_; ++i) {
            jDRCompleteObjectArray[i] = this.objectList_[i];
        }
        this.objectList_ = jDRCompleteObjectArray;
    }

    private void addObjectToList(JDRCompleteObject jDRCompleteObject) throws NullPointerException {
        if (jDRCompleteObject == null) {
            throw new NullPointerException("Null objects may not be added to group");
        }
        if (this.capacity_ == this.size_) {
            this.enlargeList();
        }
        this.objectList_[this.size_] = jDRCompleteObject;
        jDRCompleteObject.parent = this;
        ++this.size_;
    }

    private void addObjectToList(int n, JDRCompleteObject jDRCompleteObject) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (n < 0 || n > this.size_) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (jDRCompleteObject == null) {
            throw new NullPointerException("Null objects may not be added to group");
        }
        if (this.capacity_ == this.size_) {
            this.enlargeList();
        }
        for (int i = this.size_; i > n; --i) {
            this.objectList_[i] = this.objectList_[i - 1];
        }
        this.objectList_[n] = jDRCompleteObject;
        jDRCompleteObject.parent = this;
        ++this.size_;
    }

    private JDRCompleteObject removeObjectFromList(JDRCompleteObject jDRCompleteObject) {
        int n = -1;
        for (int i = 0; i < this.size_; ++i) {
            if (this.objectList_[i] != jDRCompleteObject) continue;
            n = i;
            break;
        }
        if (n == -1) {
            return null;
        }
        return this.removeObjectFromList(n);
    }

    private JDRCompleteObject removeObjectFromList(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n >= this.size_) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        JDRCompleteObject jDRCompleteObject = this.objectList_[n];
        for (int i = n; i < this.size_ - 1; ++i) {
            this.objectList_[i] = this.objectList_[i + 1];
        }
        --this.size_;
        if (jDRCompleteObject.parent == this) {
            jDRCompleteObject.parent = null;
        }
        return jDRCompleteObject;
    }

    private JDRCompleteObject setObject(int n, JDRCompleteObject jDRCompleteObject) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (n < 0 || n >= this.size_) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (jDRCompleteObject == null) {
            throw new NullPointerException("Group can't contain null objects");
        }
        JDRCompleteObject jDRCompleteObject2 = this.objectList_[n];
        this.objectList_[n] = jDRCompleteObject;
        jDRCompleteObject.parent = this;
        return jDRCompleteObject2;
    }

    @Override
    public boolean refresh() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject.refresh()) continue;
            this.remove(i);
            --i;
        }
        return true;
    }

    @Override
    public void updateBounds(Graphics graphics) {
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).updateBounds(graphics);
        }
    }

    public void add(JDRCompleteObject jDRCompleteObject) throws NullPointerException {
        this.addObjectToList(jDRCompleteObject);
    }

    public void add(int n, JDRCompleteObject jDRCompleteObject) throws NullPointerException, ArrayIndexOutOfBoundsException {
        this.addObjectToList(n, jDRCompleteObject);
    }

    public JDRCompleteObject set(int n, JDRCompleteObject jDRCompleteObject) {
        return this.setObject(n, jDRCompleteObject);
    }

    public JDRCompleteObject remove(int n) throws ArrayIndexOutOfBoundsException {
        return this.removeObjectFromList(n);
    }

    public boolean remove(JDRCompleteObject jDRCompleteObject) {
        return this.removeObjectFromList(jDRCompleteObject) != null;
    }

    public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.get((int)i).parent = null;
        }
        this.size_ = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRGroup)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        JDRGroup jDRGroup = (JDRGroup)object;
        if (this.size_ != jDRGroup.size_) {
            return false;
        }
        for (int i = 0; i < this.size_; ++i) {
            if (this.get(i) == jDRGroup.get(i)) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.size_;
    }

    public boolean isEmpty() {
        return this.size_ == 0;
    }

    public boolean contains(Object object) throws NullPointerException {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i = 0; i < this.size_; ++i) {
            if (this.get(i) != object) continue;
            return true;
        }
        return false;
    }

    public int numberSelected() {
        int n = 0;
        for (int i = 0; i < this.size_; ++i) {
            if (!this.get(i).isSelected()) continue;
            ++n;
        }
        return n;
    }

    public boolean anySelected() {
        for (int i = 0; i < this.size_; ++i) {
            if (!this.get(i).isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean anySelected(Point2D point2D) {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !jDRCompleteObject.getBBox().contains(point2D)) continue;
            return true;
        }
        return false;
    }

    public boolean anyPathsSelected() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRGroup ? ((JDRGroup)jDRCompleteObject).anyPathsSelected() : jDRCompleteObject instanceof JDRPath)) continue;
            return true;
        }
        return false;
    }

    public boolean anyTextPathsSelected() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRGroup ? ((JDRGroup)jDRCompleteObject).anyTextPathsSelected() : jDRCompleteObject instanceof JDRTextPath)) continue;
            return true;
        }
        return false;
    }

    public boolean anySymmetricPathsSelected() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRGroup ? ((JDRGroup)jDRCompleteObject).anySymmetricPathsSelected() : jDRCompleteObject instanceof JDRSymmetricPath)) continue;
            return true;
        }
        return false;
    }

    public int numberPathsSelected() {
        int n = 0;
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRPath)) continue;
            ++n;
        }
        return n;
    }

    public int numberSymmetricPathsSelected() {
        int n = 0;
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRSymmetricPath)) continue;
            ++n;
        }
        return n;
    }

    public int numberTextPathsSelected() {
        int n = 0;
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRTextPath)) continue;
            ++n;
        }
        return n;
    }

    public boolean anyTextSelected() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRGroup ? ((JDRGroup)jDRCompleteObject).anyTextSelected() : jDRCompleteObject instanceof JDRText)) continue;
            return true;
        }
        return false;
    }

    public int numberTextSelected() {
        int n = 0;
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRText)) continue;
            ++n;
        }
        return n;
    }

    public boolean anyBitmapsSelected() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRGroup ? ((JDRGroup)jDRCompleteObject).anyBitmapsSelected() : jDRCompleteObject instanceof JDRBitmap)) continue;
            return true;
        }
        return false;
    }

    public int numberBitmapsSelected() {
        int n = 0;
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRBitmap)) continue;
            ++n;
        }
        return n;
    }

    public boolean anyGroupsSelected() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRGroup)) continue;
            return true;
        }
        return false;
    }

    @Override
    public JDRTextual getTextual() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            JDRTextual jDRTextual = jDRCompleteObject.getTextual();
            if (jDRTextual == null) continue;
            return jDRTextual;
        }
        return null;
    }

    @Override
    public boolean hasTextual() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.hasTextual()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasShape() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.hasShape()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JDRSymmetricPath getSymmetricPath() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            JDRSymmetricPath jDRSymmetricPath = jDRCompleteObject.getSymmetricPath();
            if (jDRSymmetricPath == null) continue;
            return jDRSymmetricPath;
        }
        return null;
    }

    @Override
    public boolean hasSymmetricPath() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.hasSymmetricPath()) continue;
            return true;
        }
        return false;
    }

    @Override
    public JDRPattern getPattern() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            JDRPattern jDRPattern = jDRCompleteObject.getPattern();
            if (jDRPattern == null) continue;
            return jDRPattern;
        }
        return null;
    }

    @Override
    public boolean hasPattern() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.hasPattern()) continue;
            return true;
        }
        return false;
    }

    public int numberGroupsSelected() {
        int n = 0;
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected() || !(jDRCompleteObject instanceof JDRGroup)) continue;
            ++n;
        }
        return n;
    }

    public int[] numberSelected(int[] nArray) {
        int n;
        if (nArray == null) {
            nArray = new int[13];
        }
        for (n = 0; n < 13; ++n) {
            nArray[n] = 0;
        }
        for (n = 0; n < this.size_; ++n) {
            JDRCompleteObject jDRCompleteObject = this.get(n);
            if (!jDRCompleteObject.isSelected()) continue;
            nArray[12] = nArray[12] + 1;
            if (jDRCompleteObject instanceof JDRPath) {
                nArray[0] = nArray[0] + 1;
                nArray[9] = nArray[9] + 1;
                nArray[11] = nArray[11] + 1;
                continue;
            }
            if (jDRCompleteObject instanceof JDRCompoundShape) {
                nArray[8] = nArray[8] + 1;
                nArray[9] = nArray[9] + 1;
                boolean bl = jDRCompleteObject.hasSymmetricPath();
                if (jDRCompleteObject.hasTextual()) {
                    nArray[4] = nArray[4] + 1;
                    nArray[10] = nArray[10] + 1;
                    if (bl) {
                        nArray[6] = nArray[6] + 1;
                    }
                } else {
                    nArray[11] = nArray[11] + 1;
                }
                if (bl) {
                    nArray[5] = nArray[5] + 1;
                }
                if (!jDRCompleteObject.hasPattern()) continue;
                nArray[7] = nArray[7] + 1;
                continue;
            }
            if (jDRCompleteObject instanceof JDRText) {
                nArray[1] = nArray[1] + 1;
                nArray[10] = nArray[10] + 1;
                continue;
            }
            if (jDRCompleteObject instanceof JDRBitmap) {
                nArray[2] = nArray[2] + 1;
                continue;
            }
            if (!(jDRCompleteObject instanceof JDRGroup)) continue;
            nArray[3] = nArray[3] + 1;
        }
        return nArray;
    }

    public void numberAnySelected(int[] nArray, boolean[] blArray) {
        int n;
        for (n = 0; n < 13; ++n) {
            nArray[n] = 0;
            blArray[n] = false;
        }
        for (n = 0; n < this.size_; ++n) {
            boolean bl;
            JDRCompleteObject jDRCompleteObject = this.get(n);
            if (!jDRCompleteObject.isSelected()) continue;
            nArray[12] = nArray[12] + 1;
            blArray[12] = true;
            if (jDRCompleteObject instanceof JDRPath) {
                nArray[0] = nArray[0] + 1;
                blArray[0] = true;
                nArray[9] = nArray[9] + 1;
                blArray[9] = true;
                nArray[11] = nArray[11] + 1;
                blArray[11] = true;
                continue;
            }
            if (jDRCompleteObject instanceof JDRCompoundShape) {
                nArray[8] = nArray[8] + 1;
                blArray[8] = true;
                nArray[9] = nArray[9] + 1;
                blArray[9] = true;
                bl = jDRCompleteObject.hasSymmetricPath();
                if (jDRCompleteObject.hasTextual()) {
                    nArray[4] = nArray[4] + 1;
                    blArray[4] = true;
                    nArray[10] = nArray[10] + 1;
                    blArray[10] = true;
                    if (bl) {
                        nArray[6] = nArray[6] + 1;
                        blArray[6] = true;
                    }
                } else {
                    nArray[11] = nArray[11] + 1;
                    blArray[11] = true;
                }
                if (bl) {
                    nArray[5] = nArray[5] + 1;
                    blArray[5] = true;
                }
                if (!jDRCompleteObject.hasPattern()) continue;
                nArray[7] = nArray[7] + 1;
                blArray[7] = true;
                continue;
            }
            if (jDRCompleteObject instanceof JDRText) {
                nArray[1] = nArray[1] + 1;
                blArray[1] = true;
                nArray[10] = nArray[10] + 1;
                blArray[10] = true;
                continue;
            }
            if (jDRCompleteObject instanceof JDRBitmap) {
                nArray[2] = nArray[2] + 1;
                blArray[2] = true;
                continue;
            }
            if (!(jDRCompleteObject instanceof JDRGroup)) continue;
            nArray[3] = nArray[3] + 1;
            blArray[3] = true;
            bl = false;
            for (int i = 0; i < 13; ++i) {
                if (blArray[i]) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            ((JDRGroup)jDRCompleteObject).anySelected(blArray);
        }
    }

    public void anySelected(boolean[] blArray) {
        for (int i = 0; i < this.size_; ++i) {
            int n;
            boolean bl;
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected()) continue;
            if (jDRCompleteObject instanceof JDRPath) {
                blArray[0] = true;
                blArray[9] = true;
                blArray[11] = true;
            } else if (jDRCompleteObject instanceof JDRText) {
                blArray[1] = true;
                blArray[10] = true;
            } else if (jDRCompleteObject instanceof JDRBitmap) {
                blArray[2] = true;
            } else if (jDRCompleteObject instanceof JDRCompoundShape) {
                blArray[8] = true;
                blArray[9] = true;
                bl = jDRCompleteObject.hasSymmetricPath();
                if (jDRCompleteObject.hasTextual()) {
                    blArray[4] = true;
                    blArray[10] = true;
                    if (bl) {
                        blArray[6] = true;
                    }
                } else {
                    blArray[11] = true;
                }
                if (bl) {
                    blArray[5] = true;
                }
                if (jDRCompleteObject.hasPattern()) {
                    blArray[7] = true;
                }
            } else if (jDRCompleteObject instanceof JDRGroup) {
                blArray[3] = true;
                bl = false;
                for (n = 0; n < 13; ++n) {
                    if (blArray[n]) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    ((JDRGroup)jDRCompleteObject).anySelected(blArray);
                }
            }
            bl = true;
            for (n = 0; n < 13; ++n) {
                if (blArray[n]) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            return;
        }
    }

    public JDRCompleteObject getSelected() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isSelected()) continue;
            return jDRCompleteObject;
        }
        return null;
    }

    public JDRGroup getAllIntersects(BBox bBox) {
        JDRGroup jDRGroup = new JDRGroup();
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.intersects(bBox)) continue;
            jDRGroup.add(jDRCompleteObject);
        }
        return jDRGroup;
    }

    public JDRGroup getAllInside(BBox bBox) {
        JDRGroup jDRGroup = new JDRGroup();
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isCompletelyInsideBox(bBox)) continue;
            jDRGroup.add(jDRCompleteObject);
        }
        return jDRGroup;
    }

    public int selectAllIntersects(BBox bBox) {
        int n = 0;
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.intersects(bBox)) continue;
            jDRCompleteObject.setSelected(true);
            ++n;
        }
        return n;
    }

    public int selectAllInside(BBox bBox) {
        int n = 0;
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!jDRCompleteObject.isCompletelyInsideBox(bBox)) continue;
            jDRCompleteObject.setSelected(true);
            ++n;
        }
        return n;
    }

    public JDRStroke getStroke() {
        JDRShape jDRShape = this.getShape();
        if (jDRShape != null) {
            return jDRShape.getStroke();
        }
        return null;
    }

    public JDRBasicStroke getBasicStroke() {
        for (int i = 0; i < this.size(); ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!(jDRCompleteObject instanceof JDRShape) || !(((JDRShape)jDRCompleteObject).getStroke() instanceof JDRBasicStroke)) continue;
            return (JDRBasicStroke)((JDRShape)jDRCompleteObject).getStroke();
        }
        return null;
    }

    public JDRPaint getLinePaint() {
        JDRShape jDRShape = this.getShape();
        if (jDRShape != null) {
            return jDRShape.getLinePaint();
        }
        return null;
    }

    public JDRPaint getFillPaint() {
        JDRShape jDRShape = this.getShape();
        if (jDRShape != null) {
            return jDRShape.getFillPaint();
        }
        return null;
    }

    public JDRPaint getTextPaint() {
        JDRText jDRText = this.getText();
        if (jDRText != null) {
            return jDRText.getTextPaint();
        }
        return null;
    }

    public JDRText getText() {
        for (int i = 0; i < this.size_; ++i) {
            JDRText jDRText;
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRText) {
                return (JDRText)jDRCompleteObject;
            }
            if (!(jDRCompleteObject instanceof JDRGroup) || (jDRText = ((JDRGroup)jDRCompleteObject).getText()) == null) continue;
            return jDRText;
        }
        return null;
    }

    public JDRPath getPath() {
        for (int i = 0; i < this.size_; ++i) {
            JDRPath jDRPath;
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRPath) {
                return (JDRPath)jDRCompleteObject;
            }
            if (!(jDRCompleteObject instanceof JDRGroup) || (jDRPath = ((JDRGroup)jDRCompleteObject).getPath()) == null) continue;
            return jDRPath;
        }
        return null;
    }

    public JDRShape getShape() {
        for (int i = 0; i < this.size_; ++i) {
            JDRShape jDRShape;
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRShape) {
                return (JDRShape)jDRCompleteObject;
            }
            if (!(jDRCompleteObject instanceof JDRGroup) || (jDRShape = ((JDRGroup)jDRCompleteObject).getShape()) == null) continue;
            return jDRShape;
        }
        return null;
    }

    public JDRShape getNonTextShape() {
        for (int i = 0; i < this.size_; ++i) {
            JDRShape jDRShape;
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRShape && !(jDRCompleteObject instanceof JDRTextual)) {
                return (JDRShape)jDRCompleteObject;
            }
            if (!(jDRCompleteObject instanceof JDRGroup) || (jDRShape = ((JDRGroup)jDRCompleteObject).getNonTextShape()) == null) continue;
            return jDRShape;
        }
        return null;
    }

    public JDRTextPath getTextPath() {
        for (int i = 0; i < this.size_; ++i) {
            JDRTextPath jDRTextPath;
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRTextPath) {
                return (JDRTextPath)jDRCompleteObject;
            }
            if (!(jDRCompleteObject instanceof JDRGroup) || (jDRTextPath = ((JDRGroup)jDRCompleteObject).getTextPath()) == null) continue;
            return jDRTextPath;
        }
        return null;
    }

    public JDRBitmap getBitmap() {
        for (int i = 0; i < this.size_; ++i) {
            JDRBitmap jDRBitmap;
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRBitmap) {
                return (JDRBitmap)jDRCompleteObject;
            }
            if (!(jDRCompleteObject instanceof JDRGroup) || (jDRBitmap = ((JDRGroup)jDRCompleteObject).getBitmap()) == null) continue;
            return jDRBitmap;
        }
        return null;
    }

    public JDRRotationalPattern getRotationalPattern() {
        for (int i = 0; i < this.size_; ++i) {
            JDRRotationalPattern jDRRotationalPattern;
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRRotationalPattern) {
                return (JDRRotationalPattern)jDRCompleteObject;
            }
            if (!(jDRCompleteObject instanceof JDRGroup) || (jDRRotationalPattern = ((JDRGroup)jDRCompleteObject).getRotationalPattern()) == null) continue;
            return jDRRotationalPattern;
        }
        return null;
    }

    public void setStroke(JDRStroke jDRStroke) {
        if (this.objectList_ == null) {
            return;
        }
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRShape) {
                ((JDRShape)jDRCompleteObject).setStroke(jDRStroke);
                continue;
            }
            if (!(jDRCompleteObject instanceof JDRGroup)) continue;
            ((JDRGroup)jDRCompleteObject).setStroke(jDRStroke);
        }
    }

    public void setLinePaint(JDRPaint jDRPaint) {
        if (this.objectList_ == null) {
            return;
        }
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRShape) {
                ((JDRShape)jDRCompleteObject).setLinePaint(jDRPaint);
                continue;
            }
            if (!(jDRCompleteObject instanceof JDRGroup)) continue;
            ((JDRGroup)jDRCompleteObject).setLinePaint(jDRPaint);
        }
    }

    public void setFillPaint(JDRPaint jDRPaint) {
        if (this.objectList_ == null) {
            return;
        }
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRShape) {
                ((JDRShape)jDRCompleteObject).setFillPaint(jDRPaint);
                continue;
            }
            if (!(jDRCompleteObject instanceof JDRGroup)) continue;
            ((JDRGroup)jDRCompleteObject).setFillPaint(jDRPaint);
        }
    }

    public void setTextPaint(JDRPaint jDRPaint) {
        if (this.objectList_ == null) {
            return;
        }
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRTextual) {
                ((JDRTextual)((Object)jDRCompleteObject)).setTextPaint(jDRPaint);
                continue;
            }
            if (!(jDRCompleteObject instanceof JDRGroup)) continue;
            ((JDRGroup)jDRCompleteObject).setTextPaint(jDRPaint);
        }
    }

    @Override
    public BBox getBBox() {
        if (this.isEmpty()) {
            return null;
        }
        BBox bBox = this.get(0).getBBox();
        for (int i = 1; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            jDRCompleteObject.mergeBBox(bBox);
        }
        return bBox;
    }

    @Override
    public void mergeBBox(BBox bBox) {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            jDRCompleteObject.mergeBBox(bBox);
        }
    }

    public JDRCompleteObject get(int n) throws ArrayIndexOutOfBoundsException {
        return this.objectList_[n];
    }

    public JDRCompleteObject lastElement() {
        if (this.size_ == 0) {
            return null;
        }
        return this.objectList_[this.size_ - 1];
    }

    public JDRCompleteObject firstElement() {
        if (this.size_ == 0) {
            return null;
        }
        return this.objectList_[0];
    }

    @Override
    public void setSelected(boolean bl) {
        super.setSelected(bl);
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).setSelected(bl);
        }
    }

    @Override
    public void rotate(double d) {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        Point2D.Double double_ = new Point2D.Double(bBox.getMinX() + bBox.getWidth() / 2.0, bBox.getMinY() + bBox.getHeight() / 2.0);
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).rotate(double_, d);
        }
    }

    @Override
    public void rotate(Point2D point2D, double d) {
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).rotate(point2D, d);
        }
    }

    @Override
    public void scale(double d, double d2) {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        Point2D.Double double_ = new Point2D.Double(bBox.getMinX(), bBox.getMinY());
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).scale(double_, d, d2);
        }
    }

    @Override
    public void scale(Point2D point2D, double d, double d2) {
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).scale(point2D, d, d2);
        }
    }

    @Override
    public void scaleX(double d) {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        Point2D.Double double_ = new Point2D.Double(bBox.getMinX(), bBox.getMinY());
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).scaleX(double_, d);
        }
    }

    @Override
    public void scaleY(double d) {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        Point2D.Double double_ = new Point2D.Double(bBox.getMinX(), bBox.getMinY());
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).scaleY(double_, d);
        }
    }

    @Override
    public void shear(double d, double d2) {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        Point2D.Double double_ = new Point2D.Double(bBox.getMinX(), bBox.getMaxY());
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).shear(double_, d, d2);
        }
    }

    @Override
    public void shear(Point2D point2D, double d, double d2) {
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).shear(point2D, d, d2);
        }
    }

    public void leftAlign() {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        double d = bBox.getMinX();
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).leftAlign(d);
        }
    }

    public void rightAlign() {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        double d = bBox.getMaxX();
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).rightAlign(d);
        }
    }

    public void centreAlign() {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        double d = bBox.getMinX() + 0.5 * bBox.getWidth();
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).centreAlign(d);
        }
    }

    public void topAlign() {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        double d = bBox.getMinY();
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).topAlign(d);
        }
    }

    public void middleAlign() {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        double d = bBox.getMinY() + 0.5 * bBox.getHeight();
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).middleAlign(d);
        }
    }

    public void bottomAlign() {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return;
        }
        double d = bBox.getMaxY();
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).bottomAlign(d);
        }
    }

    @Override
    public void translate(double d, double d2) {
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).translate(d, d2);
        }
    }

    @Override
    public void transform(double[] dArray) {
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).transform(dArray);
        }
    }

    public boolean moveToBack(JDRCompleteObject jDRCompleteObject) {
        if (!this.remove(jDRCompleteObject)) {
            return false;
        }
        this.add(0, jDRCompleteObject);
        return true;
    }

    public boolean moveToFront(JDRCompleteObject jDRCompleteObject) {
        if (!this.remove(jDRCompleteObject)) {
            return false;
        }
        this.add(jDRCompleteObject);
        return true;
    }

    public JDRShape mergePaths(int[] nArray) throws NoPathException, EmptyPathException, CanOnlyMergePathsException, IllFittingPathException {
        int n;
        int n2 = nArray.length;
        if (n2 == 0) {
            throw new NoPathException();
        }
        JDRCompleteObject jDRCompleteObject = this.get(nArray[0]);
        if (!(jDRCompleteObject instanceof JDRShape)) {
            throw new CanOnlyMergePathsException();
        }
        JDRShape jDRShape = (JDRShape)jDRCompleteObject.clone();
        if (jDRShape.size() == 0) {
            throw new EmptyPathException();
        }
        boolean bl = jDRShape.isClosed();
        if (bl) {
            jDRShape.open(false);
        }
        JDRPoint jDRPoint = jDRShape.getFirstSegment().getStart();
        JDRPoint jDRPoint2 = jDRShape.getLastSegment().getEnd();
        for (n = 1; n < n2; ++n) {
            jDRCompleteObject = this.get(nArray[n]);
            if (!(jDRCompleteObject instanceof JDRShape)) {
                throw new CanOnlyMergePathsException();
            }
            JDRShape jDRShape2 = (JDRShape)jDRCompleteObject;
            int n3 = jDRShape2.size();
            for (int i = 0; i < n3; ++i) {
                JDRPathSegment jDRPathSegment = jDRShape2.get(i);
                if (i == 0) {
                    jDRShape.add(new JDRSegment(jDRPoint2, jDRPathSegment.getStart()));
                }
                jDRPathSegment = jDRPathSegment instanceof JDRPartialSegment ? ((JDRPartialSegment)jDRPathSegment).getFullSegment() : (JDRSegment)jDRPathSegment.clone();
                jDRShape.add((JDRSegment)jDRPathSegment);
                jDRPoint2 = jDRPathSegment.getEnd();
            }
        }
        for (n = n2 - 1; n >= 0; --n) {
            this.remove(nArray[n]);
        }
        if (bl) {
            jDRShape.close(new JDRSegment(jDRPoint2, jDRPoint));
        }
        this.add(nArray[0], jDRShape);
        return jDRShape;
    }

    public int indexOf(Object object) {
        for (int i = 0; i < this.size_; ++i) {
            if (this.get(i) != object) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        for (int i = this.size_ - 1; i >= 0; --i) {
            if (this.get(i) != object) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void drawFlowFrame(Graphics graphics) {
        if (this.flowframe == null) {
            for (int i = 0; i < this.size_; ++i) {
                this.get(i).drawFlowFrame(graphics);
            }
        } else {
            this.flowframe.draw(graphics, this.getBBox());
        }
    }

    @Override
    public void draw(Graphics graphics) {
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).draw(graphics);
        }
    }

    @Override
    public void draw(Graphics graphics, boolean bl) {
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).draw(graphics, bl);
        }
    }

    @Override
    public void draw(Graphics graphics, boolean bl, JComponent jComponent) {
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).draw(graphics, bl, jComponent);
        }
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        String string = System.getProperty("line.separator", "\n");
        String string2 = new String("");
        if (!this.description.equals("")) {
            string2 = string2 + "% " + this.description + string;
        }
        for (int i = 0; i < this.size_; ++i) {
            string2 = string2 + this.get(i).pgf(affineTransform);
        }
        return string2;
    }

    @Override
    public void saveFlowframe(Rectangle2D rectangle2D, PrintWriter printWriter, double d) throws IOException, InvalidShapeException {
        if (this.flowframe != null) {
            this.flowframe.tex(this, rectangle2D, printWriter, d);
        } else {
            for (int i = 0; i < this.size_; ++i) {
                this.get(i).saveFlowframe(rectangle2D, printWriter, d);
            }
        }
    }

    public boolean isFlowframeDefined(int n, String string) {
        if (this.flowframe != null && this.flowframe.getType() == n && this.flowframe.label.equals(string)) {
            return true;
        }
        for (int i = 0; i < this.size(); ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!(jDRCompleteObject instanceof JDRGroup ? ((JDRGroup)jDRCompleteObject).isFlowframeDefined(n, string) : jDRCompleteObject.flowframe != null && jDRCompleteObject.flowframe.getType() == n && jDRCompleteObject.flowframe.label.equals(string))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        JDRGroup jDRGroup = new JDRGroup(this.size_);
        jDRGroup.makeEqual(this);
        return jDRGroup;
    }

    @Override
    public void makeEqual(JDRObject jDRObject) {
        JDRGroup jDRGroup = (JDRGroup)jDRObject;
        super.makeEqual(jDRObject);
        this.clear();
        for (int i = 0; i < jDRGroup.size_; ++i) {
            this.add((JDRCompleteObject)jDRGroup.get(i).clone());
        }
    }

    public boolean anyFlowFrameData() {
        for (int i = 0; i < this.size(); ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject.flowframe != null) {
                return true;
            }
            if (!(jDRCompleteObject instanceof JDRGroup) || !((JDRGroup)jDRCompleteObject).anyFlowFrameData()) continue;
            return true;
        }
        return false;
    }

    public boolean anyDraftBitmaps() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (!(jDRCompleteObject instanceof JDRBitmap ? ((JDRBitmap)jDRCompleteObject).isDraft() : jDRCompleteObject instanceof JDRGroup && ((JDRGroup)jDRCompleteObject).anyDraftBitmaps())) continue;
            return true;
        }
        return false;
    }

    public boolean anyTextPaths() {
        for (int i = 0; i < this.size_; ++i) {
            JDRCompleteObject jDRCompleteObject = this.get(i);
            if (jDRCompleteObject instanceof JDRTextPath) {
                return true;
            }
            if (!(jDRCompleteObject instanceof JDRGroup) || !((JDRGroup)jDRCompleteObject).anyTextPaths()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).saveEPS(printWriter);
        }
    }

    @Override
    public int psLevel() {
        int n = 1;
        for (int i = 0; i < this.size_; ++i) {
            n = Math.max(n, this.get(i).psLevel());
        }
        return n;
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        printWriter.println("   <g>");
        if (!this.description.equals("")) {
            printWriter.println("   <desc>" + this.description + "</desc>");
        }
        for (int i = 0; i < this.size_; ++i) {
            this.get(i).saveSVG(printWriter);
        }
        printWriter.println("   </g>");
    }

    public String toString() {
        return "JDRGroup: size=" + this.size() + "," + this.getBBox();
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return groupListener;
    }

    public static int getInitCapacity() {
        if (JDR.getOptimize() == 0) {
            return init_capacity_speed;
        }
        return init_capacity_memory;
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "Group:" + string;
        string2 = string2 + "size: " + this.size_ + string;
        string2 = string2 + "capacity: " + this.capacity_ + string;
        string2 = string2 + "description: " + this.description + string;
        string2 = string2 + "flowframe: " + this.flowframe + string;
        string2 = string2 + "is selected: " + this.isSelected() + string;
        BBox bBox = this.getBBox();
        string2 = bBox == null ? string2 + "bounding box: null" + string : string2 + "bounding box: " + this.getBBox().info() + string;
        string2 = string2 + "hash code: " + this.hashCode() + string;
        for (int i = 0; i < this.size_; ++i) {
            string2 = string2 + "Object " + i + ":" + string;
            string2 = string2 + this.objectList_[i].info() + string;
        }
        return string2;
    }

    @Override
    public String[] getDescriptionInfo() {
        return new String[]{"" + this.size()};
    }

    @Override
    public void fade(double d) {
        for (int i = 0; i < this.size_; ++i) {
            this.objectList_[i].fade(d);
        }
    }
}

