/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import java.util.Enumeration;
import java.util.Vector;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidGridException;
import uk.ac.uea.cmp.nlct.jdr.JDRGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRGridLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRGridLoader {
    private Vector<JDRGridLoaderListener> listeners_ = new Vector();

    public void saveJDR(JDRGrid jDRGrid, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRGridLoaderListener jDRGridLoaderListener = jDRGrid.getListener();
        if (jDRGridLoaderListener == null) {
            throw new InvalidGridException("Grid " + jDRGrid + " doesn't have a valid listener");
        }
        dataOutputStream.writeByte(jDRGridLoaderListener.getJDRid(f));
        jDRGridLoaderListener.writeJDR(jDRGrid, dataOutputStream, f);
    }

    public JDRGrid loadJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        byte by = dataInputStream.readByte();
        Enumeration<JDRGridLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRGridLoaderListener jDRGridLoaderListener = enumeration.nextElement();
            if (jDRGridLoaderListener.getJDRid(f) != by) continue;
            return jDRGridLoaderListener.readJDR(dataInputStream, f);
        }
        throw new InvalidGridException(by);
    }

    public void saveAJR(JDRGrid jDRGrid, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRGridLoaderListener jDRGridLoaderListener = jDRGrid.getListener();
        if (jDRGridLoaderListener == null) {
            throw new InvalidGridException("Grid " + jDRGrid + " doesn't have a valid listener");
        }
        AJR.writeInt(printWriter, jDRGridLoaderListener.getAJRid(f));
        jDRGridLoaderListener.writeAJR(jDRGrid, printWriter, f);
    }

    public JDRGrid loadAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        byte by = (byte)AJR.readInt(bufferedReader);
        Enumeration<JDRGridLoaderListener> enumeration = this.listeners_.elements();
        while (enumeration.hasMoreElements()) {
            JDRGridLoaderListener jDRGridLoaderListener = enumeration.nextElement();
            if (jDRGridLoaderListener.getAJRid(f) != by) continue;
            return jDRGridLoaderListener.readAJR(bufferedReader, f);
        }
        throw new InvalidGridException(by);
    }

    public void addListener(JDRGridLoaderListener jDRGridLoaderListener) {
        this.listeners_.add(jDRGridLoaderListener);
    }

    public Vector<JDRGridLoaderListener> getListeners() {
        return this.listeners_;
    }
}

