/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidAlphaValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidGrayValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPaintException;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRGrayListener
implements JDRPaintLoaderListener {
    private String remainder = "";

    @Override
    public char getJDRid(float f) {
        return 'Y';
    }

    @Override
    public void writeJDR(JDRPaint jDRPaint, DataOutputStream dataOutputStream, float f) throws IOException {
        JDRGray jDRGray = (JDRGray)jDRPaint;
        dataOutputStream.writeFloat((float)jDRGray.getGray());
        dataOutputStream.writeFloat((float)jDRGray.getAlpha());
    }

    @Override
    public JDRPaint readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        double d = dataInputStream.readFloat();
        if (d < 0.0 || d > 1.0) {
            throw new InvalidGrayValueException(d);
        }
        double d2 = dataInputStream.readFloat();
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidAlphaValueException(d2);
        }
        return new JDRGray(d, d2);
    }

    @Override
    public char getAJRid(float f) {
        return 'Y';
    }

    @Override
    public void writeAJR(JDRPaint jDRPaint, PrintWriter printWriter, float f) throws IOException {
        JDRGray jDRGray = (JDRGray)jDRPaint;
        AJR.writeFloat(printWriter, (float)jDRGray.getGray());
        AJR.writeFloat(printWriter, (float)jDRGray.getAlpha());
    }

    @Override
    public JDRPaint readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        double d = AJR.readFloat(bufferedReader);
        if (d < 0.0 || d > 1.0) {
            throw new InvalidGrayValueException(d, AJR.getLineNum());
        }
        double d2 = AJR.readFloat(bufferedReader);
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidAlphaValueException(d2, AJR.getLineNum());
        }
        return new JDRGray(d, d2);
    }

    @Override
    public int getConfigId() {
        return 6;
    }

    @Override
    public String getConfigString(JDRPaint jDRPaint) {
        JDRGray jDRGray = (JDRGray)jDRPaint;
        return "" + jDRGray.getGray() + "," + jDRGray.getAlpha();
    }

    @Override
    public JDRPaint parseConfig(String string) throws InvalidFormatException {
        String[] stringArray = string.split(",", 3);
        if (stringArray.length < 2) {
            throw new InvalidPaintException("Invalid grey config format");
        }
        double d = 0.0;
        double d2 = 0.0;
        try {
            d = Double.parseDouble(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid grey value " + stringArray[0]);
        }
        try {
            d2 = Double.parseDouble(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid alpha value " + stringArray[1]);
        }
        this.remainder = stringArray.length == 3 ? stringArray[2] : "";
        return new JDRGray(d, d2);
    }

    @Override
    public String getConfigRemainder() {
        return this.remainder;
    }
}

