/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidAlphaValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidGrayValueException;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRGrayListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class JDRGray
implements JDRPaint,
Serializable {
    private double gray;
    private double alpha;
    private static JDRGrayListener listener = new JDRGrayListener();

    public JDRGray(double d) throws InvalidGrayValueException {
        if (d < 0.0 && d > 1.0) {
            throw new InvalidGrayValueException(d);
        }
        this.gray = d;
        this.alpha = 1.0;
    }

    public JDRGray(double d, double d2) throws InvalidGrayValueException, InvalidAlphaValueException {
        if (d < 0.0 && d > 1.0) {
            throw new InvalidGrayValueException(d);
        }
        if (d2 < 0.0 && d2 > 1.0) {
            throw new InvalidAlphaValueException(d2);
        }
        this.gray = d;
        this.alpha = d2;
    }

    public JDRGray() {
        this.gray = 0.0;
        this.alpha = 1.0;
    }

    @Override
    public JDRGray getJDRGray() {
        return this;
    }

    @Override
    public JDRColorCMYK getJDRColorCMYK() {
        double d = 1.0 - this.gray;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            return new JDRColorCMYK(d2, d3, d4, d, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRColorCMYK();
        }
    }

    @Override
    public JDRColor getJDRColor() {
        JDRColor jDRColor = null;
        try {
            jDRColor = new JDRColor(this.gray, this.gray, this.gray, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return jDRColor;
    }

    @Override
    public JDRColorHSB getJDRColorHSB() {
        try {
            return new JDRColorHSB(0.0, 0.0, this.gray);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRColorHSB();
        }
    }

    @Override
    public Paint getPaint(BBox bBox) {
        return this.getColor();
    }

    @Override
    public Color getColor() {
        float f = (float)this.gray;
        return new Color(f, f, f, (float)this.alpha);
    }

    @Override
    public String toString() {
        return new String("JDRGray@Gray:" + this.gray + "Alpha:" + this.alpha);
    }

    @Override
    public Object clone() {
        try {
            return new JDRGray(this.gray, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRGray();
        }
    }

    @Override
    public String pgf(BBox bBox) {
        return "\\color[gray]{" + PGF.format(this.gray) + "}";
    }

    @Override
    public String pgffillcolor(BBox bBox) {
        if (this.alpha == 1.0) {
            return "\\color[gray]{" + PGF.format(this.gray) + "}";
        }
        return "\\pgfsetfillopacity{" + PGF.format(this.alpha) + "}" + "\\color[gray]{" + PGF.format(this.gray) + "}";
    }

    @Override
    public String pgfstrokecolor(BBox bBox) {
        if (this.alpha == 1.0) {
            return "\\color[gray]{" + this.gray + "}";
        }
        return "\\pgfsetstrokeopacity{" + this.alpha + "}" + "\\color[gray]{" + this.gray + "}";
    }

    @Override
    public void saveEPS(PrintWriter printWriter, BBox bBox) throws IOException {
        printWriter.println("" + this.gray + " setgray");
    }

    @Override
    public int psLevel() {
        return 1;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    public double getGray() {
        return this.gray;
    }

    public void setAlpha(double d) throws InvalidAlphaValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidAlphaValueException(d);
        }
        this.alpha = d;
    }

    public void setGray(double d) throws InvalidGrayValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidGrayValueException(d);
        }
        this.gray = d;
    }

    @Override
    public String svg() {
        return "gray(" + 100.0 * this.gray + "%)";
    }

    @Override
    public String svgFill() {
        return "fill=\"" + this.svg() + "\" fill-opacity=\"" + this.getAlpha() + "\"";
    }

    @Override
    public String svgLine() {
        return "stroke=\"" + this.svg() + "\" stroke-opacity=\"" + this.getAlpha() + "\"";
    }

    @Override
    public String getID() {
        return Integer.toHexString((int)(this.gray * 255.0)) + "." + Integer.toHexString((int)(this.gray * 255.0));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRGray)) {
            return false;
        }
        JDRGray jDRGray = (JDRGray)object;
        return this.getGray() == jDRGray.getGray() && this.getAlpha() == jDRGray.getAlpha();
    }

    @Override
    public JDRPaintLoaderListener getListener() {
        return listener;
    }

    @Override
    public void fade(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("illegal fade factor " + d + ". (Negative factors not permitted)");
        }
        this.alpha *= d;
        if (this.alpha > 1.0) {
            this.alpha = 1.0;
        }
    }
}

