/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidStartColourException;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRShading;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class JDRGradientListener
implements JDRPaintLoaderListener {
    private String remainder = "";

    @Override
    public char getJDRid(float f) {
        return 'G';
    }

    @Override
    public void writeJDR(JDRPaint jDRPaint, DataOutputStream dataOutputStream, float f) throws IOException {
        JDRGradient jDRGradient = (JDRGradient)jDRPaint;
        JDRPaint jDRPaint2 = jDRGradient.getStartColor();
        JDRPaint jDRPaint3 = jDRGradient.getEndColor();
        JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
        jDRPaintLoader.saveJDR(jDRPaint2, dataOutputStream, f);
        jDRPaintLoader.saveJDR(jDRPaint3, dataOutputStream, f);
        dataOutputStream.writeInt(jDRGradient.getDirection());
    }

    @Override
    public JDRPaint readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
        JDRPaint jDRPaint = jDRPaintLoader.loadJDR(dataInputStream, f);
        if (jDRPaint instanceof JDRShading) {
            throw new InvalidStartColourException();
        }
        JDRPaint jDRPaint2 = jDRPaintLoader.loadJDR(dataInputStream, f);
        if (jDRPaint2 instanceof JDRShading) {
            throw new InvalidStartColourException();
        }
        int n = dataInputStream.readInt();
        return new JDRGradient(n, jDRPaint, jDRPaint2);
    }

    @Override
    public char getAJRid(float f) {
        return 'G';
    }

    @Override
    public void writeAJR(JDRPaint jDRPaint, PrintWriter printWriter, float f) throws IOException {
        JDRGradient jDRGradient = (JDRGradient)jDRPaint;
        JDRPaint jDRPaint2 = jDRGradient.getStartColor();
        JDRPaint jDRPaint3 = jDRGradient.getEndColor();
        JDRPaintLoader jDRPaintLoader = AJR.getPaintLoader();
        jDRPaintLoader.saveAJR(jDRPaint2, printWriter, f);
        jDRPaintLoader.saveAJR(jDRPaint3, printWriter, f);
        AJR.writeInt(printWriter, jDRGradient.getDirection());
    }

    @Override
    public JDRPaint readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        JDRPaintLoader jDRPaintLoader = AJR.getPaintLoader();
        JDRPaint jDRPaint = jDRPaintLoader.loadAJR(bufferedReader, f);
        if (jDRPaint instanceof JDRShading) {
            throw new InvalidStartColourException();
        }
        JDRPaint jDRPaint2 = jDRPaintLoader.loadAJR(bufferedReader, f);
        if (jDRPaint2 instanceof JDRShading) {
            throw new InvalidStartColourException();
        }
        int n = AJR.readInt(bufferedReader);
        return new JDRGradient(n, jDRPaint, jDRPaint2);
    }

    @Override
    public int getConfigId() {
        return 3;
    }

    @Override
    public String getConfigString(JDRPaint jDRPaint) {
        JDRGradient jDRGradient = (JDRGradient)jDRPaint;
        JDRPaint jDRPaint2 = jDRGradient.getStartColor();
        JDRPaint jDRPaint3 = jDRGradient.getEndColor();
        JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
        String string = jDRPaintLoader.getConfigString(jDRPaint2) + "," + jDRPaintLoader.getConfigString(jDRPaint3) + "," + jDRGradient.getDirection();
        return string;
    }

    @Override
    public JDRPaint parseConfig(String string) throws InvalidFormatException {
        JDRPaintLoader jDRPaintLoader = JDR.getPaintLoader();
        JDRPaint jDRPaint = jDRPaintLoader.parseConfig(string);
        string = jDRPaintLoader.getConfigRemainder();
        JDRPaint jDRPaint2 = jDRPaintLoader.parseConfig(string);
        string = jDRPaintLoader.getConfigRemainder();
        String[] stringArray = string.split(",", 2);
        int n = 0;
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidFormatException("Invalid gradient paint specs: direction missing");
        }
        this.remainder = stringArray.length == 1 ? "" : stringArray[1];
        return new JDRGradient(n, jDRPaint, jDRPaint2);
    }

    @Override
    public String getConfigRemainder() {
        return this.remainder;
    }
}

