/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.awt.Point;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidEndColourException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidGradientDirectionException;
import uk.ac.uea.cmp.nlct.jdr.InvalidStartColourException;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRGradientListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;
import uk.ac.uea.cmp.nlct.jdr.JDRShading;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class JDRGradient
implements JDRPaint,
Serializable,
JDRShading {
    private JDRPaint startColor;
    private JDRPaint endColor;
    private int direction;
    public static final int NORTH = 0;
    public static final int NORTH_EAST = 1;
    public static final int EAST = 2;
    public static final int SOUTH_EAST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTH_WEST = 5;
    public static final int WEST = 6;
    public static final int NORTH_WEST = 7;
    private static int pgfshadeid = 0;
    private static JDRGradientListener listener = new JDRGradientListener();

    public JDRGradient(JDRPaint jDRPaint, JDRPaint jDRPaint2) throws InvalidStartColourException, InvalidEndColourException {
        if (jDRPaint instanceof JDRShading) {
            throw new InvalidStartColourException();
        }
        if (jDRPaint2 instanceof JDRShading) {
            throw new InvalidEndColourException();
        }
        this.startColor = jDRPaint;
        this.endColor = jDRPaint2;
        this.direction = 0;
    }

    public JDRGradient(int n, JDRPaint jDRPaint, JDRPaint jDRPaint2) throws InvalidGradientDirectionException, InvalidStartColourException, InvalidEndColourException {
        if (jDRPaint instanceof JDRShading) {
            throw new InvalidStartColourException();
        }
        if (jDRPaint2 instanceof JDRShading) {
            throw new InvalidEndColourException();
        }
        if (n < 0 || n > 7) {
            throw new InvalidGradientDirectionException(n);
        }
        this.startColor = jDRPaint;
        this.endColor = jDRPaint2;
        this.direction = n;
    }

    public JDRGradient() {
        this.startColor = new JDRColor();
        this.endColor = new JDRColor();
        this.direction = 0;
    }

    @Override
    public Color getColor() {
        return this.startColor.getColor();
    }

    @Override
    public JDRColor getJDRColor() {
        return this.startColor.getJDRColor();
    }

    @Override
    public JDRColorCMYK getJDRColorCMYK() {
        return this.startColor.getJDRColorCMYK();
    }

    @Override
    public JDRColorHSB getJDRColorHSB() {
        return this.startColor.getJDRColorHSB();
    }

    @Override
    public JDRGray getJDRGray() {
        return this.startColor.getJDRGray();
    }

    @Override
    public Paint getPaint(BBox bBox) {
        Point point;
        Point point2;
        int n = (int)(bBox.getMinX() + 0.5 * bBox.getWidth());
        int n2 = (int)(bBox.getMinY() + 0.5 * bBox.getHeight());
        switch (this.direction) {
            case 0: {
                point2 = new Point(n, (int)bBox.getMaxY());
                point = new Point(n, (int)bBox.getMinY());
                break;
            }
            case 1: {
                point2 = new Point((int)bBox.getMinX(), (int)bBox.getMaxY());
                point = new Point((int)bBox.getMaxX(), (int)bBox.getMinY());
                break;
            }
            case 2: {
                point2 = new Point((int)bBox.getMinX(), n2);
                point = new Point((int)bBox.getMaxX(), n2);
                break;
            }
            case 3: {
                point2 = new Point((int)bBox.getMinX(), (int)bBox.getMinY());
                point = new Point((int)bBox.getMaxX(), (int)bBox.getMaxY());
                break;
            }
            case 4: {
                point2 = new Point(n, (int)bBox.getMinY());
                point = new Point(n, (int)bBox.getMaxY());
                break;
            }
            case 5: {
                point2 = new Point((int)bBox.getMaxX(), (int)bBox.getMinY());
                point = new Point((int)bBox.getMinX(), (int)bBox.getMaxY());
                break;
            }
            case 6: {
                point2 = new Point((int)bBox.getMaxX(), n2);
                point = new Point((int)bBox.getMinX(), n2);
                break;
            }
            case 7: {
                point2 = new Point((int)bBox.getMaxX(), (int)bBox.getMaxY());
                point = new Point((int)bBox.getMinX(), (int)bBox.getMinY());
                break;
            }
            default: {
                point2 = new Point(0, 0);
                point = new Point(0, 0);
            }
        }
        return new GradientPaint(point2.x, point2.y, this.startColor.getColor(), point.x, point.y, this.endColor.getColor());
    }

    @Override
    public Object clone() {
        try {
            return new JDRGradient(this.direction, this.startColor, this.endColor);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRGradient();
        }
    }

    @Override
    public String toString() {
        return new String("JDRGradient@D:" + this.direction + this.startColor + this.endColor);
    }

    private String pgfdeclareverticalshading(JDRPaint jDRPaint, JDRPaint jDRPaint2) {
        String string = "\\pgfdeclareverticalshading{jdrlinear" + pgfshadeid + "}{" + "100bp}{";
        Color color = jDRPaint.getColor();
        double d = (double)color.getRed() / 255.0;
        double d2 = (double)color.getGreen() / 255.0;
        double d3 = (double)color.getBlue() / 255.0;
        String string2 = "(" + PGF.format(d) + "," + PGF.format(d2) + "," + PGF.format(d3) + ")";
        string = string + "rgb(0bp)=" + string2 + "; ";
        string = string + "rgb(32.5bp)=" + string2 + "; ";
        Color color2 = jDRPaint2.getColor();
        d = (double)color2.getRed() / 255.0;
        d2 = (double)color2.getGreen() / 255.0;
        d3 = (double)color2.getBlue() / 255.0;
        String string3 = "(" + PGF.format(d) + "," + PGF.format(d2) + "," + PGF.format(d3) + ")";
        string = string + "rgb(67.5bp)=" + string3 + "; ";
        string = string + "rgb(100bp)=" + string3;
        string = string + "}";
        return string;
    }

    private String pgfdeclarehorizontalshading(JDRPaint jDRPaint, JDRPaint jDRPaint2) {
        String string = "\\pgfdeclarehorizontalshading{jdrlinear" + pgfshadeid + "}{" + "100bp}{";
        Color color = jDRPaint.getColor();
        double d = (double)color.getRed() / 255.0;
        double d2 = (double)color.getGreen() / 255.0;
        double d3 = (double)color.getBlue() / 255.0;
        String string2 = "(" + PGF.format(d) + "," + PGF.format(d2) + "," + PGF.format(d3) + ")";
        string = string + "rgb(0bp)=" + string2 + "; ";
        string = string + "rgb(32.5bp)=" + string2 + "; ";
        Color color2 = jDRPaint2.getColor();
        d = (double)color2.getRed() / 255.0;
        d2 = (double)color2.getGreen() / 255.0;
        d3 = (double)color2.getBlue() / 255.0;
        String string3 = "(" + PGF.format(d) + "," + PGF.format(d2) + "," + PGF.format(d3) + ")";
        string = string + "rgb(67.5bp)=" + string3 + "; ";
        string = string + "rgb(100bp)=" + string3;
        string = string + "}";
        return string;
    }

    @Override
    public String pgffillcolor(BBox bBox) {
        if (bBox == null) {
            return this.startColor.pgffillcolor(bBox);
        }
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        int n = 0;
        double d = bBox.getHeight();
        double d2 = bBox.getWidth();
        switch (this.direction) {
            case 0: {
                string2 = this.pgfdeclareverticalshading(this.startColor, this.endColor);
                n = 0;
                break;
            }
            case 1: {
                string2 = this.pgfdeclareverticalshading(this.startColor, this.endColor);
                n = 45;
                break;
            }
            case 2: {
                string2 = this.pgfdeclarehorizontalshading(this.startColor, this.endColor);
                n = 0;
                break;
            }
            case 3: {
                string2 = this.pgfdeclarehorizontalshading(this.startColor, this.endColor);
                n = 45;
                break;
            }
            case 4: {
                string2 = this.pgfdeclareverticalshading(this.endColor, this.startColor);
                n = 0;
                break;
            }
            case 5: {
                string2 = this.pgfdeclareverticalshading(this.endColor, this.startColor);
                n = 45;
                break;
            }
            case 6: {
                string2 = this.pgfdeclarehorizontalshading(this.endColor, this.startColor);
                n = 0;
                break;
            }
            case 7: {
                string2 = this.pgfdeclarehorizontalshading(this.endColor, this.startColor);
                n = 45;
            }
        }
        double d3 = this.getAlpha();
        if (d3 != 1.0) {
            string2 = string2 + "\\pgfsetfillopacity{" + PGF.format(d3) + "}";
        }
        string2 = string2 + string + "\\pgfshadepath{jdrlinear" + pgfshadeid + "}{" + PGF.format(-n) + "}";
        ++pgfshadeid;
        return string2;
    }

    @Override
    public String getID() {
        return "gradient-" + this.startColor.getID() + "-" + this.endColor.getID() + "-" + this.direction;
    }

    private void svgDef(PrintWriter printWriter) throws IOException {
        printWriter.println("      <linearGradient id=\"" + this.getID() + "\"");
        printWriter.println("         gradientUnits=\"objectBoundingBox\"");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 100;
        switch (this.direction) {
            case 0: {
                n = 50;
                n2 = 100;
                n3 = 50;
                n2 = 0;
                break;
            }
            case 1: {
                n = 0;
                n2 = 100;
                n3 = 100;
                n4 = 0;
                break;
            }
            case 2: {
                n = 0;
                n2 = 50;
                n3 = 100;
                n4 = 50;
                break;
            }
            case 3: {
                n = 0;
                n2 = 0;
                n3 = 100;
                n4 = 100;
                break;
            }
            case 4: {
                n = 50;
                n2 = 0;
                n3 = 50;
                n4 = 100;
                break;
            }
            case 5: {
                n = 100;
                n2 = 0;
                n3 = 0;
                n4 = 100;
                break;
            }
            case 6: {
                n = 100;
                n2 = 50;
                n3 = 0;
                n4 = 50;
                break;
            }
            case 7: {
                n = 100;
                n2 = 100;
                n3 = 0;
                n4 = 0;
            }
        }
        printWriter.println("         x1=\"" + n + "%\" " + "y1=\"" + n2 + "%\" " + "x2=\"" + n3 + "%\" " + "y2=\"" + n4 + "%\">");
        printWriter.println("         <stop offset=\"0%\" stop-color=\"" + this.startColor.svg() + "\" stroke-opacity=\"" + this.startColor.getAlpha() + "\"/>");
        printWriter.println("         <stop offset=\"100%\" stop-color=\"" + this.endColor.svg() + "\" stroke-opacity=\"" + this.endColor.getAlpha() + "\"/>");
        printWriter.println("      </linearGradient>");
    }

    public static void svgDefs(PrintWriter printWriter, JDRGroup jDRGroup) throws IOException {
        JDRPaint jDRPaint;
        Object object;
        Hashtable<String, JDRGradient> hashtable = new Hashtable<String, JDRGradient>();
        for (int i = 0; i < jDRGroup.size(); ++i) {
            object = jDRGroup.get(i);
            if (object instanceof JDRShape) {
                jDRPaint = ((JDRShape)object).getLinePaint();
                if (jDRPaint instanceof JDRGradient) {
                    hashtable.put(((JDRGradient)jDRPaint).getID(), (JDRGradient)jDRPaint);
                }
                if ((jDRPaint = ((JDRShape)object).getFillPaint()) instanceof JDRGradient) {
                    hashtable.put(((JDRGradient)jDRPaint).getID(), (JDRGradient)jDRPaint);
                }
            }
            if (!(object instanceof JDRTextual) || !((jDRPaint = ((JDRTextual)object).getTextPaint()) instanceof JDRGradient)) continue;
            hashtable.put(((JDRGradient)jDRPaint).getID(), (JDRGradient)jDRPaint);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            jDRPaint = (JDRGradient)hashtable.get(object);
            super.svgDef(printWriter);
        }
    }

    @Override
    public String svgFill() {
        return "fill=\"url(#" + this.getID() + ")\"";
    }

    @Override
    public String svgLine() {
        return "stroke=\"url(#" + this.getID() + ")\"";
    }

    @Override
    public String svg() {
        return "url(#" + this.getID() + ")";
    }

    @Override
    public double getAlpha() {
        return 0.5 * (this.startColor.getAlpha() + this.endColor.getAlpha());
    }

    @Override
    public String pgf(BBox bBox) {
        return this.startColor.pgf(bBox);
    }

    @Override
    public String pgfstrokecolor(BBox bBox) {
        return this.startColor.pgfstrokecolor(bBox);
    }

    @Override
    public int psLevel() {
        return 2;
    }

    @Override
    public void saveEPS(PrintWriter printWriter, BBox bBox) throws IOException {
        String string;
        String string2;
        if (bBox == null) {
            this.startColor.saveEPS(printWriter, bBox);
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = bBox.getMinX();
        double d6 = bBox.getMaxX();
        double d7 = bBox.getMinY();
        double d8 = bBox.getMaxY();
        switch (this.direction) {
            case 0: {
                d = d5 + 0.5 * bBox.getWidth();
                d4 = d7;
                d3 = d;
                d2 = d8;
                break;
            }
            case 1: {
                d = d5;
                d4 = d7;
                d3 = d6;
                d2 = d8;
                break;
            }
            case 2: {
                d = d5;
                d4 = d7 + 0.5 * bBox.getHeight();
                d3 = d6;
                d2 = d4;
                break;
            }
            case 3: {
                d = d5;
                d4 = d8;
                d3 = d6;
                d2 = d7;
                break;
            }
            case 4: {
                d3 = d5 + 0.5 * bBox.getWidth();
                d2 = d7;
                d4 = d8;
                break;
            }
            case 5: {
                d = d6;
                d4 = d8;
                d3 = d5;
                d2 = d7;
                break;
            }
            case 6: {
                d3 = d5;
                d2 = d7 + 0.5 * bBox.getHeight();
                d = d6;
                d4 = d2;
                break;
            }
            case 7: {
                d = d6;
                d4 = d7;
                d3 = d5;
                d2 = d8;
            }
        }
        printWriter.println("<<");
        printWriter.println("   /ShadingType 2");
        if (this.startColor instanceof JDRColor) {
            JDRColor jDRColor = (JDRColor)this.startColor;
            printWriter.println("   /ColorSpace /DeviceRGB");
            string2 = "/C0 [" + jDRColor.getRed() + " " + jDRColor.getGreen() + " " + jDRColor.getBlue() + "]";
            jDRColor = this.endColor instanceof JDRColor ? (JDRColor)this.endColor : ((JDRColorCMYK)this.endColor).getJDRColor();
            string = "/C1 [" + jDRColor.getRed() + " " + jDRColor.getGreen() + " " + jDRColor.getBlue() + "]";
        } else {
            JDRColorCMYK jDRColorCMYK = (JDRColorCMYK)this.startColor;
            printWriter.println("   /ColorSpace /DeviceCMYK");
            string2 = "/C0 [" + jDRColorCMYK.getCyan() + " " + jDRColorCMYK.getMagenta() + " " + jDRColorCMYK.getYellow() + " " + jDRColorCMYK.getKey() + "]";
            jDRColorCMYK = this.endColor instanceof JDRColorCMYK ? (JDRColorCMYK)this.endColor : ((JDRColor)this.endColor).getJDRColorCMYK();
            string = "/C1 [" + jDRColorCMYK.getCyan() + " " + jDRColorCMYK.getMagenta() + " " + jDRColorCMYK.getYellow() + " " + jDRColorCMYK.getKey() + "]";
        }
        printWriter.println("   /BBox [" + d5 + " " + d7 + " " + d6 + " " + d8 + "]");
        printWriter.println("   /Coords [" + d + " " + d2 + " " + d3 + " " + d4 + "]");
        printWriter.println("      /Function <<");
        printWriter.println("         /FunctionType 2");
        printWriter.println("         /Domain [0 1]");
        printWriter.println("         " + string2);
        printWriter.println("         " + string);
        printWriter.println("         /N 1");
        printWriter.println("   >>");
        printWriter.print(">> ");
    }

    public JDRRadial getJDRRadial() {
        try {
            return new JDRRadial(this.direction, this.startColor, this.endColor);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRRadial();
        }
    }

    @Override
    public JDRShading convertShading(String string) throws InvalidFormatException {
        if (string.equals("JDRRadial")) {
            return this.getJDRRadial();
        }
        if (string.equals("JDRGradient")) {
            return this;
        }
        throw new InvalidFormatException("Can't convert from JDRGradient to " + string);
    }

    @Override
    public JDRPaintLoaderListener getListener() {
        return listener;
    }

    @Override
    public JDRPaint getStartColor() {
        return this.startColor;
    }

    @Override
    public JDRPaint getEndColor() {
        return this.endColor;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setStartColor(JDRPaint jDRPaint) throws InvalidStartColourException {
        if (jDRPaint instanceof JDRShading) {
            throw new InvalidStartColourException();
        }
        this.startColor = jDRPaint;
    }

    public void setEndColor(JDRPaint jDRPaint) throws InvalidEndColourException {
        if (jDRPaint instanceof JDRShading) {
            throw new InvalidEndColourException();
        }
        this.endColor = jDRPaint;
    }

    public void setDirection(int n) throws InvalidGradientDirectionException {
        if (n < 0 || n > 7) {
            throw new InvalidGradientDirectionException(n);
        }
        this.direction = n;
    }

    @Override
    public void reduceToGreyScale() {
        this.startColor = this.startColor.getJDRGray();
        this.endColor = this.endColor.getJDRGray();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRGradient)) {
            return false;
        }
        JDRGradient jDRGradient = (JDRGradient)object;
        return this.getDirection() == jDRGradient.getDirection() && this.startColor.equals(jDRGradient.startColor) && this.endColor.equals(jDRGradient.endColor);
    }

    @Override
    public void fade(double d) {
        this.startColor.fade(d);
        this.endColor.fade(d);
    }
}

