/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontFamilyLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontShapeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontSizeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFontWeightException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRFont
implements Cloneable,
Serializable {
    public static final int SERIES_MEDIUM = 0;
    public static final int SERIES_BOLD = 1;
    public static final int SHAPE_UPRIGHT = 0;
    public static final int SHAPE_EM = 1;
    public static final int SHAPE_ITALIC = 2;
    public static final int SHAPE_SLANTED = 3;
    public static final int SHAPE_SC = 4;
    private String family = "SansSerif";
    private int weight = 0;
    private int shape = 0;
    private int size = 10;

    public JDRFont(String string, int n, int n2, int n3) throws InvalidFontShapeException, InvalidFontWeightException, InvalidFontSizeException {
        this.setFamily(string);
        this.setWeight(n);
        this.setShape(n2);
        this.setSize(n3);
    }

    public JDRFont() {
        this.family = "SansSerif";
        this.weight = 0;
        this.shape = 0;
        this.size = 10;
    }

    public String getFamily() {
        return this.family;
    }

    public int getWeight() {
        return this.weight;
    }

    public int getShape() {
        return this.shape;
    }

    public int getSize() {
        return this.size;
    }

    public void setFamily(String string) {
        this.family = string;
    }

    public void setWeight(int n) throws InvalidFontWeightException {
        if (n < 0 || n > 1) {
            throw new InvalidFontWeightException(n);
        }
        this.weight = n;
    }

    public void setShape(int n) throws InvalidFontShapeException {
        if (n < 0 || n > 4) {
            throw new InvalidFontShapeException(n);
        }
        this.shape = n;
    }

    public void setSize(int n) throws InvalidFontSizeException {
        if (n < 0) {
            throw new InvalidFontSizeException(n);
        }
        this.size = n;
    }

    public void save(DataOutputStream dataOutputStream, float f) throws IOException {
        dataOutputStream.writeInt(this.family.length());
        dataOutputStream.writeChars(this.family);
        dataOutputStream.writeByte((byte)this.shape);
        dataOutputStream.writeByte((byte)this.weight);
        dataOutputStream.writeInt(this.size);
    }

    public static JDRFont read(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        int n;
        int n2 = dataInputStream.readInt();
        JDRFont jDRFont = new JDRFont();
        if (n2 <= 0) {
            throw new InvalidFontFamilyLengthException(n2);
        }
        char[] cArray = new char[n2];
        for (n = 0; n < n2; ++n) {
            cArray[n] = dataInputStream.readChar();
        }
        jDRFont.setFamily(new String(cArray));
        n = dataInputStream.readByte();
        jDRFont.setShape(n);
        byte by = dataInputStream.readByte();
        jDRFont.setWeight(by);
        int n3 = dataInputStream.readInt();
        jDRFont.setSize(n3);
        return jDRFont;
    }

    public void saveAJR(PrintWriter printWriter, float f) throws IOException {
        AJR.writeInt(printWriter, this.family.length());
        printWriter.print(this.family + " ");
        AJR.writeInt(printWriter, this.shape);
        AJR.writeInt(printWriter, this.weight);
        AJR.writeInt(printWriter, this.size);
        printWriter.println();
    }

    public static JDRFont readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        int n = AJR.readInt(bufferedReader);
        JDRFont jDRFont = new JDRFont();
        if (n <= 0) {
            throw new InvalidFontFamilyLengthException(n, AJR.getLineNum());
        }
        String string = AJR.readString(bufferedReader, n);
        jDRFont.setFamily(string);
        int n2 = AJR.readInt(bufferedReader);
        jDRFont.setShape(n2);
        int n3 = AJR.readInt(bufferedReader);
        jDRFont.setWeight(n3);
        int n4 = AJR.readInt(bufferedReader);
        jDRFont.setSize(n4);
        return jDRFont;
    }

    public String svg() {
        return "font-family=\"" + this.family + "\"" + " font-weight=\"" + (this.weight == 0 ? "normal" : "bold") + "\"" + " font-style=\"" + (this.shape == 0 ? "normal" : "italic") + "\"" + " font-size=\"" + this.size + "\"";
    }

    public String saveEPS() {
        return "";
    }

    public Object clone() {
        try {
            return new JDRFont(this.family, this.weight, this.shape, this.size);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRFont();
        }
    }

    public void makeEqual(JDRFont jDRFont) {
        this.family = jDRFont.family;
        this.weight = jDRFont.weight;
        this.shape = jDRFont.shape;
        this.size = jDRFont.size;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRFont)) {
            return false;
        }
        JDRFont jDRFont = (JDRFont)object;
        if (!this.family.equals(jDRFont.family)) {
            return false;
        }
        if (this.weight != jDRFont.weight) {
            return false;
        }
        if (this.shape != jDRFont.shape) {
            return false;
        }
        return this.size == jDRFont.size;
    }

    public String info() {
        return "family=" + this.family + ",weight=" + this.weight + ",shape=" + this.shape + ",size=" + this.size;
    }
}

