/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.FlowFrame;
import uk.ac.uea.cmp.nlct.jdr.InvalidShapeException;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPath;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;

public abstract class JDRCompleteObject
extends JDRObject {
    public FlowFrame flowframe = null;
    public String description = "";
    public static Font annoteFont = new Font("SansSerif", 0, 10);
    protected boolean editMode = false;
    protected JDRCompleteObject parent = null;

    public BBox getExtent() {
        BBox bBox;
        BBox bBox2 = this.getBBox();
        if (bBox2 == null) {
            return null;
        }
        BBox bBox3 = bBox2;
        if (this.isEdited() && (bBox = this.getControlBBox()) != null) {
            bBox3.merge(bBox);
        }
        if (this.flowframe != null) {
            bBox3.merge(this.flowframe.getLabelBounds(bBox2));
        }
        return bBox3;
    }

    public boolean isCompletelyInsideBox(BBox bBox) {
        BBox bBox2;
        BBox bBox3 = bBox2 = this.isEdited() ? this.getControlBBox() : this.getBBox();
        if (bBox2 == null) {
            return false;
        }
        return bBox.contains(new Point2D.Double(bBox2.getMinX(), bBox2.getMinY())) && bBox.contains(new Point2D.Double(bBox2.getMinX(), bBox2.getMaxY())) && bBox.contains(new Point2D.Double(bBox2.getMaxX(), bBox2.getMinY())) && bBox.contains(new Point2D.Double(bBox2.getMaxX(), bBox2.getMaxY()));
    }

    public boolean intersects(BBox bBox) {
        BBox bBox2;
        BBox bBox3 = bBox2 = this.isEdited() ? this.getControlBBox() : this.getBBox();
        if (bBox2 == null) {
            return false;
        }
        return bBox2.getRectangle().intersects(bBox.getMinX(), bBox.getMinY(), bBox.getWidth(), bBox.getHeight());
    }

    public boolean intersects(Rectangle rectangle) {
        BBox bBox;
        BBox bBox2 = bBox = this.isEdited() ? this.getControlBBox() : this.getBBox();
        if (bBox == null) {
            return false;
        }
        return bBox.getRectangle().intersects(rectangle);
    }

    public boolean contains(JDRPoint jDRPoint) {
        return this.contains(jDRPoint.getPoint2D());
    }

    public boolean contains(Point point) {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return false;
        }
        return bBox.contains(point);
    }

    public boolean contains(Point2D point2D) {
        BBox bBox = this.getBBox();
        if (bBox == null) {
            return false;
        }
        return bBox.contains(point2D);
    }

    public boolean refresh() {
        return true;
    }

    public void reset() {
    }

    public void updateBounds(Graphics graphics) {
    }

    public void leftAlign(double d) {
        BBox bBox = this.getBBox();
        if (bBox != null) {
            this.translate(d - bBox.getMinX(), 0.0);
        }
    }

    public void rightAlign(double d) {
        BBox bBox = this.getBBox();
        if (bBox != null) {
            this.translate(d - bBox.getMaxX(), 0.0);
        }
    }

    public void centreAlign(double d) {
        BBox bBox = this.getBBox();
        if (bBox != null) {
            double d2 = bBox.getMinX() + 0.5 * (bBox.getMaxX() - bBox.getMinX());
            this.translate(d - d2, 0.0);
        }
    }

    public void topAlign(double d) {
        BBox bBox = this.getBBox();
        if (bBox != null) {
            this.translate(0.0, d - bBox.getMinY());
        }
    }

    public void middleAlign(double d) {
        BBox bBox = this.getBBox();
        if (bBox != null) {
            double d2 = bBox.getMinY() + 0.5 * (bBox.getMaxY() - bBox.getMinY());
            this.translate(0.0, d - d2);
        }
    }

    public void bottomAlign(double d) {
        BBox bBox = this.getBBox();
        if (bBox != null) {
            this.translate(0.0, d - bBox.getMaxY());
        }
    }

    public void drawFlowFrame(Graphics graphics) {
        if (this.flowframe != null) {
            graphics.setColor(Color.lightGray);
            this.flowframe.draw(graphics, this.getBBox());
        }
    }

    @Override
    public abstract void draw(Graphics var1);

    @Override
    public void draw(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (bl) {
            graphics2D.setPaint(draftColor);
            this.drawDraft(graphics);
        } else {
            this.draw(graphics);
            this.drawFlowFrame(graphics2D);
        }
    }

    public void saveFlowframe(Rectangle2D rectangle2D, PrintWriter printWriter, double d) throws IOException, InvalidShapeException {
        if (this.flowframe != null) {
            this.flowframe.tex(this, rectangle2D, printWriter, d);
        }
    }

    @Override
    public void makeEqual(JDRObject jDRObject) {
        super.makeEqual(jDRObject);
        JDRCompleteObject jDRCompleteObject = (JDRCompleteObject)jDRObject;
        this.description = jDRCompleteObject.description;
        this.parent = jDRCompleteObject.parent;
        if (jDRCompleteObject.flowframe != null) {
            if (this.flowframe == null) {
                this.flowframe = (FlowFrame)jDRCompleteObject.flowframe.clone();
            } else {
                this.flowframe.makeEqual(jDRCompleteObject.flowframe);
            }
        } else {
            this.flowframe = null;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof JDRCompleteObject)) {
            return false;
        }
        JDRCompleteObject jDRCompleteObject = (JDRCompleteObject)object;
        if (this.flowframe == null ? jDRCompleteObject.flowframe != null : !this.flowframe.equals(jDRCompleteObject.flowframe)) {
            return false;
        }
        return this.description.equals(jDRCompleteObject.description);
    }

    public JDRCompleteObject getParent() {
        return this.parent;
    }

    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        string2 = string2 + "description: " + this.description + string;
        string2 = string2 + "flowframe: " + this.flowframe + string;
        string2 = string2 + "is selected: " + this.isSelected() + string;
        string2 = string2 + "bounding box: " + this.getBBox().info() + string;
        string2 = string2 + "hash code: " + this.hashCode() + string;
        return string2;
    }

    @Override
    public abstract String pgf(AffineTransform var1);

    @Override
    public abstract void saveSVG(PrintWriter var1) throws IOException;

    @Override
    public abstract void saveEPS(PrintWriter var1) throws IOException;

    @Override
    public void rotate(double d) {
        BBox bBox = this.getBBox();
        if (bBox != null) {
            Point2D.Double double_ = new Point2D.Double(bBox.getMidX(), bBox.getMidY());
            this.rotate(double_, d);
        }
    }

    @Override
    public abstract void rotate(Point2D var1, double var2);

    @Override
    public void scale(double d, double d2) {
        BBox bBox = this.getBBox();
        if (bBox != null) {
            Point2D.Double double_ = new Point2D.Double(bBox.getMinX(), bBox.getMinY());
            this.scale(double_, d, d2);
        }
    }

    @Override
    public abstract void scale(Point2D var1, double var2, double var4);

    @Override
    public void shear(double d, double d2) {
        BBox bBox = this.getBBox();
        if (bBox != null) {
            Point2D.Double double_ = new Point2D.Double(bBox.getMinX(), bBox.getMaxY());
            this.shear(double_, d, d2);
        }
    }

    @Override
    public abstract void shear(Point2D var1, double var2, double var4);

    @Override
    public abstract void translate(double var1, double var3);

    @Override
    public abstract void transform(double[] var1);

    @Override
    public abstract Object clone();

    public void setEditMode(boolean bl) {
        this.editMode = bl;
    }

    public boolean isEdited() {
        return this.editMode;
    }

    public abstract boolean hasTextual();

    public abstract JDRTextual getTextual();

    public abstract boolean hasShape();

    public abstract boolean hasSymmetricPath();

    public abstract JDRSymmetricPath getSymmetricPath();

    public abstract boolean hasPattern();

    public abstract JDRPattern getPattern();

    public abstract String[] getDescriptionInfo();

    public abstract void fade(double var1);
}

