/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidAlphaValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidBlueValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidGreenValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPaintException;
import uk.ac.uea.cmp.nlct.jdr.InvalidRedValueException;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRColorListener
implements JDRPaintLoaderListener {
    private String remainder = "";

    @Override
    public char getJDRid(float f) {
        return 'R';
    }

    @Override
    public void writeJDR(JDRPaint jDRPaint, DataOutputStream dataOutputStream, float f) throws IOException {
        JDRColor jDRColor = (JDRColor)jDRPaint;
        dataOutputStream.writeFloat((float)jDRColor.getRed());
        dataOutputStream.writeFloat((float)jDRColor.getGreen());
        dataOutputStream.writeFloat((float)jDRColor.getBlue());
        dataOutputStream.writeFloat((float)jDRColor.getAlpha());
    }

    @Override
    public JDRPaint readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        double d = dataInputStream.readFloat();
        double d2 = dataInputStream.readFloat();
        double d3 = dataInputStream.readFloat();
        double d4 = dataInputStream.readFloat();
        return new JDRColor(d, d2, d3, d4);
    }

    @Override
    public char getAJRid(float f) {
        return 'R';
    }

    @Override
    public void writeAJR(JDRPaint jDRPaint, PrintWriter printWriter, float f) throws IOException {
        JDRColor jDRColor = (JDRColor)jDRPaint;
        AJR.writeFloat(printWriter, (float)jDRColor.getRed());
        AJR.writeFloat(printWriter, (float)jDRColor.getGreen());
        AJR.writeFloat(printWriter, (float)jDRColor.getBlue());
        AJR.writeFloat(printWriter, (float)jDRColor.getAlpha());
    }

    @Override
    public JDRPaint readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        double d = AJR.readFloat(bufferedReader);
        if (d < 0.0 || d > 1.0) {
            throw new InvalidRedValueException(d, AJR.getLineNum());
        }
        double d2 = AJR.readFloat(bufferedReader);
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidGreenValueException(d2, AJR.getLineNum());
        }
        double d3 = AJR.readFloat(bufferedReader);
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidBlueValueException(d3, AJR.getLineNum());
        }
        double d4 = AJR.readFloat(bufferedReader);
        if (d4 < 0.0 || d4 > 1.0) {
            throw new InvalidAlphaValueException(d4, AJR.getLineNum());
        }
        return new JDRColor(d, d2, d3, d4);
    }

    @Override
    public int getConfigId() {
        return 1;
    }

    @Override
    public String getConfigString(JDRPaint jDRPaint) {
        JDRColor jDRColor = (JDRColor)jDRPaint;
        return "" + jDRColor.getRed() + "," + jDRColor.getGreen() + "," + jDRColor.getBlue() + "," + jDRColor.getAlpha();
    }

    @Override
    public JDRPaint parseConfig(String string) throws InvalidFormatException {
        String[] stringArray = string.split(",", 5);
        if (stringArray.length < 4) {
            throw new InvalidPaintException("Invalid RGB config format");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            d = Double.parseDouble(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid red value " + stringArray[0]);
        }
        try {
            d2 = Double.parseDouble(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid green value " + stringArray[1]);
        }
        try {
            d3 = Double.parseDouble(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid blue value " + stringArray[2]);
        }
        try {
            d4 = Double.parseDouble(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid alpha value " + stringArray[3]);
        }
        this.remainder = stringArray.length == 5 ? stringArray[4] : "";
        return new JDRColor(d, d2, d3, d4);
    }

    @Override
    public String getConfigRemainder() {
        return this.remainder;
    }
}

