/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidAlphaValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidBrightnessValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidHueValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPaintException;
import uk.ac.uea.cmp.nlct.jdr.InvalidSaturationValueException;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRColorHSBListener
implements JDRPaintLoaderListener {
    private String remainder = "";

    @Override
    public char getJDRid(float f) {
        return 'S';
    }

    @Override
    public void writeJDR(JDRPaint jDRPaint, DataOutputStream dataOutputStream, float f) throws IOException {
        JDRColorHSB jDRColorHSB = (JDRColorHSB)jDRPaint;
        dataOutputStream.writeFloat((float)jDRColorHSB.getHue());
        dataOutputStream.writeFloat((float)jDRColorHSB.getSaturation());
        dataOutputStream.writeFloat((float)jDRColorHSB.getBrightness());
        dataOutputStream.writeFloat((float)jDRColorHSB.getAlpha());
    }

    @Override
    public JDRPaint readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        double d = dataInputStream.readFloat();
        if (d < 0.0 || d >= 360.0) {
            throw new InvalidHueValueException(d);
        }
        double d2 = dataInputStream.readFloat();
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidSaturationValueException(d2);
        }
        double d3 = dataInputStream.readFloat();
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidBrightnessValueException(d3);
        }
        double d4 = dataInputStream.readFloat();
        if (d4 < 0.0 || d4 > 1.0) {
            throw new InvalidAlphaValueException(d4);
        }
        return new JDRColorHSB(d, d2, d3, d4);
    }

    @Override
    public char getAJRid(float f) {
        return 'S';
    }

    @Override
    public void writeAJR(JDRPaint jDRPaint, PrintWriter printWriter, float f) throws IOException {
        JDRColorHSB jDRColorHSB = (JDRColorHSB)jDRPaint;
        AJR.writeFloat(printWriter, (float)jDRColorHSB.getHue());
        AJR.writeFloat(printWriter, (float)jDRColorHSB.getSaturation());
        AJR.writeFloat(printWriter, (float)jDRColorHSB.getBrightness());
        AJR.writeFloat(printWriter, (float)jDRColorHSB.getAlpha());
    }

    @Override
    public JDRPaint readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        double d = AJR.readFloat(bufferedReader);
        if (d < 0.0 || d > 1.0) {
            throw new InvalidHueValueException(d, AJR.getLineNum());
        }
        double d2 = AJR.readFloat(bufferedReader);
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidSaturationValueException(d2, AJR.getLineNum());
        }
        double d3 = AJR.readFloat(bufferedReader);
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidBrightnessValueException(d3, AJR.getLineNum());
        }
        double d4 = AJR.readFloat(bufferedReader);
        if (d4 < 0.0 || d4 > 1.0) {
            throw new InvalidAlphaValueException(d4, AJR.getLineNum());
        }
        return new JDRColorHSB(d, d2, d3, d4);
    }

    @Override
    public int getConfigId() {
        return 5;
    }

    @Override
    public String getConfigString(JDRPaint jDRPaint) {
        JDRColorHSB jDRColorHSB = (JDRColorHSB)jDRPaint;
        return "" + jDRColorHSB.getHue() + "," + jDRColorHSB.getSaturation() + "," + jDRColorHSB.getBrightness() + "," + jDRColorHSB.getAlpha();
    }

    @Override
    public JDRPaint parseConfig(String string) throws InvalidFormatException {
        String[] stringArray = string.split(",", 5);
        if (stringArray.length < 4) {
            throw new InvalidPaintException("Invalid HSB config format");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            d = Double.parseDouble(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid hue value " + stringArray[0]);
        }
        try {
            d2 = Double.parseDouble(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid saturation value " + stringArray[1]);
        }
        try {
            d3 = Double.parseDouble(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid brightness value " + stringArray[2]);
        }
        try {
            d4 = Double.parseDouble(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid alpha value " + stringArray[3]);
        }
        this.remainder = stringArray.length == 5 ? stringArray[4] : "";
        return new JDRColorHSB(d, d2, d3, d4);
    }

    @Override
    public String getConfigRemainder() {
        return this.remainder;
    }
}

