/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidAlphaValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidBrightnessValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidHueValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidSaturationValueException;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSBListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class JDRColorHSB
implements JDRPaint,
Serializable {
    private double hue;
    private double saturation;
    private double brightness;
    private double alpha;
    private static JDRColorHSBListener listener = new JDRColorHSBListener();

    public JDRColorHSB(double d, double d2, double d3) throws InvalidHueValueException, InvalidSaturationValueException, InvalidBrightnessValueException {
        if (d < 0.0 || d >= 360.0) {
            throw new InvalidHueValueException(d);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidSaturationValueException(d2);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidBrightnessValueException(d3);
        }
        this.hue = d;
        this.saturation = d2;
        this.brightness = d3;
        this.alpha = 1.0;
    }

    public JDRColorHSB(double d, double d2, double d3, double d4) throws InvalidHueValueException, InvalidSaturationValueException, InvalidBrightnessValueException, InvalidAlphaValueException {
        if (d < 0.0 || d >= 360.0) {
            throw new InvalidHueValueException(d);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidSaturationValueException(d2);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidBrightnessValueException(d3);
        }
        if (d4 < 0.0 || d4 > 1.0) {
            throw new InvalidAlphaValueException(d4);
        }
        this.hue = d;
        this.saturation = d2;
        this.brightness = d3;
        this.alpha = d4;
    }

    public JDRColorHSB() {
        this.hue = 0.0;
        this.saturation = 0.0;
        this.brightness = 0.0;
        this.alpha = 1.0;
    }

    @Override
    public JDRGray getJDRGray() {
        return this.getJDRColor().getJDRGray();
    }

    @Override
    public JDRColorCMYK getJDRColorCMYK() {
        return this.getJDRColor().getJDRColorCMYK();
    }

    @Override
    public JDRColorHSB getJDRColorHSB() {
        return this;
    }

    @Override
    public JDRColor getJDRColor() {
        double d;
        double d2;
        double d3;
        int n = (int)Math.floor(this.hue / 60.0) % 6;
        double d4 = this.hue / 60.0 - Math.floor(this.hue / 60.0);
        double d5 = this.brightness * (1.0 - this.saturation);
        double d6 = this.brightness * (1.0 - d4 * this.saturation);
        double d7 = this.brightness * (1.0 - (1.0 - d4) * this.saturation);
        switch (n) {
            case 0: {
                d3 = this.brightness;
                d2 = d7;
                d = d5;
                break;
            }
            case 1: {
                d3 = d6;
                d2 = this.brightness;
                d = d5;
                break;
            }
            case 2: {
                d3 = d5;
                d2 = this.brightness;
                d = d7;
                break;
            }
            case 3: {
                d3 = d5;
                d2 = d6;
                d = this.brightness;
                break;
            }
            case 4: {
                d3 = d7;
                d2 = d5;
                d = this.brightness;
                break;
            }
            default: {
                d3 = this.brightness;
                d2 = d5;
                d = d6;
            }
        }
        JDRColor jDRColor = null;
        try {
            jDRColor = new JDRColor(d3, d2, d, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return jDRColor;
    }

    @Override
    public Paint getPaint(BBox bBox) {
        return this.getColor();
    }

    @Override
    public Color getColor() {
        return this.getJDRColor().getColor();
    }

    @Override
    public String toString() {
        return new String("JDRColorHSB@H:" + this.hue + "S:" + this.saturation + "B:" + this.brightness + "A:" + this.alpha);
    }

    @Override
    public Object clone() {
        try {
            return new JDRColorHSB(this.hue, this.saturation, this.brightness, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRColorHSB();
        }
    }

    @Override
    public String pgf(BBox bBox) {
        return this.getJDRColor().pgf(bBox);
    }

    @Override
    public String pgfstrokecolor(BBox bBox) {
        if (this.alpha == 1.0) {
            return this.pgf(bBox);
        }
        return "\\pgfsetstrokeopacity{" + PGF.format(this.alpha) + "}" + this.pgf(bBox);
    }

    @Override
    public String pgffillcolor(BBox bBox) {
        if (this.alpha == 1.0) {
            return this.pgf(bBox);
        }
        return "\\pgfsetfillopacity{" + PGF.format(this.alpha) + "}" + this.pgf(bBox);
    }

    @Override
    public void saveEPS(PrintWriter printWriter, BBox bBox) throws IOException {
        printWriter.println("" + this.hue / 360.0 + " " + this.saturation + " " + this.brightness + " sethsbcolor");
    }

    @Override
    public int psLevel() {
        return 1;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) throws InvalidAlphaValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidAlphaValueException(d);
        }
        this.alpha = d;
    }

    public void setHue(double d) throws InvalidHueValueException {
        if (d < 0.0 || d >= 360.0) {
            throw new InvalidHueValueException(d);
        }
        this.hue = d;
    }

    public void setSaturation(double d) throws InvalidSaturationValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidSaturationValueException(d);
        }
        this.saturation = d;
    }

    public void setBrightness(double d) throws InvalidBrightnessValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidBrightnessValueException(d);
        }
        this.brightness = d;
    }

    public double getHue() {
        return this.hue;
    }

    public double getSaturation() {
        return this.saturation;
    }

    public double getBrightness() {
        return this.brightness;
    }

    @Override
    public String getID() {
        return Integer.toHexString((int)this.hue) + "." + Integer.toHexString((int)(255.0 * this.saturation)) + "." + Integer.toHexString((int)(255.0 * this.brightness)) + "." + Integer.toHexString((int)(255.0 * this.alpha));
    }

    @Override
    public String svg() {
        return this.getJDRColor().svg();
    }

    @Override
    public String svgFill() {
        return "fill=\"" + this.getJDRColor().svg() + "\" fill-opacity=\"" + this.getAlpha() + "\"";
    }

    @Override
    public String svgLine() {
        return "stroke=\"" + this.getJDRColor().svg() + "\" stroke-opacity=\"" + this.getAlpha() + "\"";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRColorHSB)) {
            return false;
        }
        JDRColorHSB jDRColorHSB = (JDRColorHSB)object;
        return this.getHue() == jDRColorHSB.getHue() && this.getSaturation() == jDRColorHSB.getSaturation() && this.getBrightness() == jDRColorHSB.getBrightness() && this.getAlpha() == jDRColorHSB.getAlpha();
    }

    @Override
    public JDRPaintLoaderListener getListener() {
        return listener;
    }

    @Override
    public void fade(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("illegal fade factor " + d + ". (Negative factors not permitted)");
        }
        this.alpha *= d;
        if (this.alpha > 1.0) {
            this.alpha = 1.0;
        }
    }
}

