/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidAlphaValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidBlackValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidCyanValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidMagentaValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPaintException;
import uk.ac.uea.cmp.nlct.jdr.InvalidYellowValueException;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRColorCMYKListener
implements JDRPaintLoaderListener {
    private String remainder = "";

    @Override
    public char getJDRid(float f) {
        return 'C';
    }

    @Override
    public void writeJDR(JDRPaint jDRPaint, DataOutputStream dataOutputStream, float f) throws IOException {
        JDRColorCMYK jDRColorCMYK = (JDRColorCMYK)jDRPaint;
        dataOutputStream.writeFloat((float)jDRColorCMYK.getCyan());
        dataOutputStream.writeFloat((float)jDRColorCMYK.getMagenta());
        dataOutputStream.writeFloat((float)jDRColorCMYK.getYellow());
        dataOutputStream.writeFloat((float)jDRColorCMYK.getKey());
        dataOutputStream.writeFloat((float)jDRColorCMYK.getAlpha());
    }

    @Override
    public JDRPaint readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        double d = dataInputStream.readFloat();
        if (d < 0.0 || d > 1.0) {
            throw new InvalidCyanValueException(d);
        }
        double d2 = dataInputStream.readFloat();
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidMagentaValueException(d2);
        }
        double d3 = dataInputStream.readFloat();
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidYellowValueException(d3);
        }
        double d4 = dataInputStream.readFloat();
        if (d4 < 0.0 || d4 > 1.0) {
            throw new InvalidBlackValueException(d4);
        }
        double d5 = dataInputStream.readFloat();
        if (d5 < 0.0 || d5 > 1.0) {
            throw new InvalidAlphaValueException(d5);
        }
        return new JDRColorCMYK(d, d2, d3, d4, d5);
    }

    @Override
    public char getAJRid(float f) {
        return 'C';
    }

    @Override
    public void writeAJR(JDRPaint jDRPaint, PrintWriter printWriter, float f) throws IOException {
        JDRColorCMYK jDRColorCMYK = (JDRColorCMYK)jDRPaint;
        AJR.writeFloat(printWriter, (float)jDRColorCMYK.getCyan());
        AJR.writeFloat(printWriter, (float)jDRColorCMYK.getMagenta());
        AJR.writeFloat(printWriter, (float)jDRColorCMYK.getYellow());
        AJR.writeFloat(printWriter, (float)jDRColorCMYK.getKey());
        AJR.writeFloat(printWriter, (float)jDRColorCMYK.getAlpha());
    }

    @Override
    public JDRPaint readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        double d = AJR.readFloat(bufferedReader);
        if (d < 0.0 || d > 1.0) {
            throw new InvalidCyanValueException(d, AJR.getLineNum());
        }
        double d2 = AJR.readFloat(bufferedReader);
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidMagentaValueException(d2, AJR.getLineNum());
        }
        double d3 = AJR.readFloat(bufferedReader);
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidYellowValueException(d3, AJR.getLineNum());
        }
        double d4 = AJR.readFloat(bufferedReader);
        if (d4 < 0.0 || d4 > 1.0) {
            throw new InvalidBlackValueException(d4, AJR.getLineNum());
        }
        double d5 = AJR.readFloat(bufferedReader);
        if (d5 < 0.0 || d5 > 1.0) {
            throw new InvalidAlphaValueException(d5, AJR.getLineNum());
        }
        return new JDRColorCMYK(d, d2, d3, d4, d5);
    }

    @Override
    public int getConfigId() {
        return 2;
    }

    @Override
    public String getConfigString(JDRPaint jDRPaint) {
        JDRColorCMYK jDRColorCMYK = (JDRColorCMYK)jDRPaint;
        return "" + jDRColorCMYK.getCyan() + "," + jDRColorCMYK.getMagenta() + "," + jDRColorCMYK.getYellow() + "," + jDRColorCMYK.getKey() + "," + jDRColorCMYK.getAlpha();
    }

    @Override
    public JDRPaint parseConfig(String string) throws InvalidFormatException {
        String[] stringArray = string.split(",", 6);
        if (stringArray.length < 5) {
            throw new InvalidPaintException("Invalid CMYK config format");
        }
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        try {
            d = Double.parseDouble(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid cyan value " + stringArray[0]);
        }
        try {
            d2 = Double.parseDouble(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid magenta value " + stringArray[1]);
        }
        try {
            d3 = Double.parseDouble(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid yellow value " + stringArray[2]);
        }
        try {
            d4 = Double.parseDouble(stringArray[3]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid black value " + stringArray[3]);
        }
        try {
            d5 = Double.parseDouble(stringArray[4]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidPaintException("Invalid alpha value " + stringArray[4]);
        }
        this.remainder = stringArray.length == 6 ? stringArray[5] : "";
        return new JDRColorCMYK(d, d3, d2, d4, d5);
    }

    @Override
    public String getConfigRemainder() {
        return this.remainder;
    }
}

