/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidAlphaValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidBlackValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidCyanValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidMagentaValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidYellowValueException;
import uk.ac.uea.cmp.nlct.jdr.JDRColor;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYKListener;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class JDRColorCMYK
implements JDRPaint,
Serializable {
    private double cyan;
    private double magenta;
    private double yellow;
    private double key;
    private double alpha;
    private static JDRColorCMYKListener listener = new JDRColorCMYKListener();

    public JDRColorCMYK(double d, double d2, double d3, double d4) throws InvalidCyanValueException, InvalidMagentaValueException, InvalidYellowValueException, InvalidBlackValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidCyanValueException(d);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidMagentaValueException(d2);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidYellowValueException(d3);
        }
        if (d4 < 0.0 || d4 > 1.0) {
            throw new InvalidBlackValueException(d4);
        }
        this.cyan = d;
        this.magenta = d2;
        this.yellow = d3;
        this.key = d4;
        this.alpha = 1.0;
    }

    public JDRColorCMYK(double d, double d2, double d3, double d4, double d5) throws InvalidCyanValueException, InvalidMagentaValueException, InvalidYellowValueException, InvalidBlackValueException, InvalidAlphaValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidCyanValueException(d);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidMagentaValueException(d2);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidYellowValueException(d3);
        }
        if (d4 < 0.0 || d4 > 1.0) {
            throw new InvalidBlackValueException(d4);
        }
        if (d5 < 0.0 || d5 > 1.0) {
            throw new InvalidAlphaValueException(d5);
        }
        this.cyan = d;
        this.magenta = d2;
        this.yellow = d3;
        this.key = d4;
        this.alpha = d5;
    }

    public JDRColorCMYK() {
        this.cyan = 0.0;
        this.magenta = 0.0;
        this.yellow = 0.0;
        this.key = 1.0;
        this.alpha = 1.0;
    }

    @Override
    public JDRColorCMYK getJDRColorCMYK() {
        return this;
    }

    @Override
    public JDRGray getJDRGray() {
        double d = this.key == 0.0 ? 1.0 - (this.cyan + this.magenta + this.yellow) / 3.0 : 1.0 - this.key;
        try {
            return new JDRGray(d, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRGray();
        }
    }

    @Override
    public JDRColor getJDRColor() {
        double d = 1.0 - Math.min(1.0, this.cyan * (1.0 - this.key) + this.key);
        double d2 = 1.0 - Math.min(1.0, this.magenta * (1.0 - this.key) + this.key);
        double d3 = 1.0 - Math.min(1.0, this.yellow * (1.0 - this.key) + this.key);
        JDRColor jDRColor = null;
        try {
            jDRColor = new JDRColor(d, d2, d3, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return jDRColor;
    }

    @Override
    public JDRColorHSB getJDRColorHSB() {
        return this.getJDRColor().getJDRColorHSB();
    }

    @Override
    public Paint getPaint(BBox bBox) {
        return this.getColor();
    }

    @Override
    public Color getColor() {
        double d = 1.0 - Math.min(1.0, this.cyan * (1.0 - this.key) + this.key);
        double d2 = 1.0 - Math.min(1.0, this.magenta * (1.0 - this.key) + this.key);
        double d3 = 1.0 - Math.min(1.0, this.yellow * (1.0 - this.key) + this.key);
        return new Color((float)d, (float)d2, (float)d3, (float)this.alpha);
    }

    @Override
    public String toString() {
        return new String("JDRColorCMYK@C:" + this.cyan + "M:" + this.magenta + "Y:" + this.yellow + "K:" + this.key + "A:" + this.alpha);
    }

    @Override
    public Object clone() {
        try {
            return new JDRColorCMYK(this.cyan, this.magenta, this.yellow, this.key, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRColorCMYK();
        }
    }

    @Override
    public String pgf(BBox bBox) {
        return "\\color[cmyk]{" + PGF.format(this.cyan) + "," + PGF.format(this.magenta) + "," + PGF.format(this.yellow) + "," + PGF.format(this.key) + "}";
    }

    @Override
    public String pgfstrokecolor(BBox bBox) {
        if (this.alpha == 1.0) {
            return "\\color[cmyk]{" + PGF.format(this.cyan) + "," + PGF.format(this.magenta) + "," + PGF.format(this.yellow) + "," + PGF.format(this.key) + "}";
        }
        return "\\pgfsetstrokeopacity{" + PGF.format(this.alpha) + "}" + "\\color[cmyk]{" + PGF.format(this.cyan) + "," + PGF.format(this.magenta) + "," + PGF.format(this.yellow) + "," + PGF.format(this.key) + "}";
    }

    @Override
    public String pgffillcolor(BBox bBox) {
        if (this.alpha == 1.0) {
            return "\\color[cmyk]{" + PGF.format(this.cyan) + "," + PGF.format(this.magenta) + "," + PGF.format(this.yellow) + "," + PGF.format(this.key) + "}";
        }
        return "\\pgfsetfillopacity{" + PGF.format(this.alpha) + "}" + "\\color[cmyk]{" + PGF.format(this.cyan) + "," + PGF.format(this.magenta) + "," + PGF.format(this.yellow) + "," + PGF.format(this.key) + "}";
    }

    @Override
    public void saveEPS(PrintWriter printWriter, BBox bBox) throws IOException {
        printWriter.println("" + this.cyan + " " + this.magenta + " " + this.yellow + " " + this.key + " setcmykcolor");
    }

    @Override
    public int psLevel() {
        return 2;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) throws InvalidAlphaValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidAlphaValueException(d);
        }
        this.alpha = d;
    }

    public double getCyan() {
        return this.cyan;
    }

    public double getMagenta() {
        return this.magenta;
    }

    public double getYellow() {
        return this.yellow;
    }

    public double getKey() {
        return this.key;
    }

    public void setCyan(double d) throws InvalidCyanValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidCyanValueException(d);
        }
        this.cyan = d;
    }

    public void setMagenta(double d) throws InvalidMagentaValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidMagentaValueException(d);
        }
        this.magenta = d;
    }

    public void setYellow(double d) throws InvalidYellowValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidYellowValueException(d);
        }
        this.yellow = d;
    }

    public void setKey(double d) throws InvalidBlackValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidBlackValueException(d);
        }
        this.key = d;
    }

    @Override
    public String getID() {
        return Integer.toHexString((int)(255.0 * this.cyan)) + "." + Integer.toHexString((int)(255.0 * this.magenta)) + "." + Integer.toHexString((int)(255.0 * this.yellow)) + "." + Integer.toHexString((int)(255.0 * this.key)) + "." + Integer.toHexString((int)(255.0 * this.alpha));
    }

    @Override
    public String svg() {
        return this.getJDRColor().svg();
    }

    @Override
    public String svgFill() {
        return "fill=\"" + this.svg() + "\" fill-opacity=\"" + this.getAlpha() + "\"";
    }

    @Override
    public String svgLine() {
        return "stroke=\"" + this.svg() + "\" stroke-opacity=\"" + this.getAlpha() + "\"";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRColorCMYK)) {
            return false;
        }
        JDRColorCMYK jDRColorCMYK = (JDRColorCMYK)object;
        return this.getCyan() == jDRColorCMYK.getCyan() && this.getYellow() == jDRColorCMYK.getYellow() && this.getMagenta() == jDRColorCMYK.getMagenta() && this.getKey() == jDRColorCMYK.getKey() && this.getAlpha() == jDRColorCMYK.getAlpha();
    }

    @Override
    public JDRPaintLoaderListener getListener() {
        return listener;
    }

    @Override
    public void fade(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("illegal fade factor " + d + ". (Negative factors not permitted)");
        }
        this.alpha *= d;
        if (this.alpha > 1.0) {
            this.alpha = 1.0;
        }
    }
}

