/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.Paint;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidAlphaValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidBlueValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidGreenValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidRedValueException;
import uk.ac.uea.cmp.nlct.jdr.JDRColorCMYK;
import uk.ac.uea.cmp.nlct.jdr.JDRColorHSB;
import uk.ac.uea.cmp.nlct.jdr.JDRColorListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGray;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPaintLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class JDRColor
implements JDRPaint,
Serializable {
    private double red;
    private double green;
    private double blue;
    private double alpha;
    private static JDRColorListener listener = new JDRColorListener();

    public JDRColor(double d, double d2, double d3) throws InvalidRedValueException, InvalidGreenValueException, InvalidBlueValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidRedValueException(d);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidGreenValueException(d2);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidBlueValueException(d3);
        }
        this.red = d;
        this.green = d2;
        this.blue = d3;
        this.alpha = 1.0;
    }

    public JDRColor(double d, double d2, double d3, double d4) throws InvalidRedValueException, InvalidGreenValueException, InvalidBlueValueException, InvalidAlphaValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidRedValueException(d);
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new InvalidGreenValueException(d2);
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new InvalidBlueValueException(d3);
        }
        if (d4 < 0.0 || d4 > 1.0) {
            throw new InvalidAlphaValueException(d4);
        }
        this.red = d;
        this.green = d2;
        this.blue = d3;
        this.alpha = d4;
    }

    public JDRColor(Color color) {
        this.red = (double)color.getRed() / 255.0;
        this.green = (double)color.getGreen() / 255.0;
        this.blue = (double)color.getBlue() / 255.0;
        this.alpha = (double)color.getAlpha() / 255.0;
    }

    public JDRColor() {
        this.red = 0.0;
        this.green = 0.0;
        this.blue = 0.0;
        this.alpha = 1.0;
    }

    @Override
    public JDRColor getJDRColor() {
        return this;
    }

    @Override
    public JDRGray getJDRGray() {
        double d = (this.red + this.green + this.blue) / 3.0;
        try {
            return new JDRGray(d, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRGray();
        }
    }

    @Override
    public JDRColorCMYK getJDRColorCMYK() {
        double d = Math.min(1.0 - this.red, Math.min(1.0 - this.green, 1.0 - this.blue));
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (d < 1.0) {
            d2 = (1.0 - this.red - d) / (1.0 - d);
            d3 = (1.0 - this.green - d) / (1.0 - d);
            d4 = (1.0 - this.blue - d) / (1.0 - d);
        }
        try {
            return new JDRColorCMYK(d2, d3, d4, d, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRColorCMYK();
        }
    }

    @Override
    public JDRColorHSB getJDRColorHSB() {
        double d = Math.max(Math.max(this.red, this.green), this.blue);
        double d2 = Math.min(Math.min(this.red, this.green), this.blue);
        double d3 = 0.0;
        if (d == d2) {
            d3 = 0.0;
        } else if (d == this.red && this.green >= this.blue) {
            d3 = 60.0 * (this.green - this.blue) / (d - d2);
        } else if (d == this.red && this.green < this.blue) {
            d3 = 60.0 * (this.green - this.blue) / (d - d2) + 360.0;
        } else if (d == this.green) {
            d3 = 60.0 * (this.blue - this.red) / (d - d2) + 120.0;
        } else if (d == this.blue) {
            d3 = 60.0 * (this.red - this.green) / (d - d2) + 240.0;
        }
        double d4 = d == 0.0 ? 0.0 : 1.0 - d2 / d;
        double d5 = d;
        try {
            return new JDRColorHSB(d3, d4, d5);
        }
        catch (InvalidFormatException invalidFormatException) {
            return new JDRColorHSB();
        }
    }

    @Override
    public Paint getPaint(BBox bBox) {
        return this.getColor();
    }

    @Override
    public Color getColor() {
        return new Color((float)this.red, (float)this.green, (float)this.blue, (float)this.alpha);
    }

    @Override
    public String toString() {
        return new String("JDRColor@R:" + this.red + "G:" + this.green + "B:" + this.blue + "A:" + this.alpha);
    }

    @Override
    public Object clone() {
        JDRColor jDRColor = null;
        try {
            jDRColor = new JDRColor(this.red, this.green, this.blue, this.alpha);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return jDRColor;
    }

    @Override
    public String pgf(BBox bBox) {
        return "\\color[rgb]{" + PGF.format(this.red) + "," + PGF.format(this.green) + "," + PGF.format(this.blue) + "}";
    }

    @Override
    public String pgffillcolor(BBox bBox) {
        if (this.alpha == 1.0) {
            return "\\color[rgb]{" + PGF.format(this.red) + "," + PGF.format(this.green) + "," + PGF.format(this.blue) + "}";
        }
        return "\\pgfsetfillopacity{" + PGF.format(this.alpha) + "}" + "\\color[rgb]{" + PGF.format(this.red) + "," + PGF.format(this.green) + "," + PGF.format(this.blue) + "}";
    }

    @Override
    public String pgfstrokecolor(BBox bBox) {
        if (this.alpha == 1.0) {
            return "\\color[rgb]{" + this.red + "," + this.green + "," + this.blue + "}";
        }
        return "\\pgfsetstrokeopacity{" + this.alpha + "}" + "\\color[rgb]{" + this.red + "," + this.green + "," + this.blue + "}";
    }

    @Override
    public void saveEPS(PrintWriter printWriter, BBox bBox) throws IOException {
        printWriter.println("" + this.red + " " + this.green + " " + this.blue + " setrgbcolor");
    }

    @Override
    public int psLevel() {
        return 1;
    }

    @Override
    public double getAlpha() {
        return this.alpha;
    }

    public double getRed() {
        return this.red;
    }

    public double getBlue() {
        return this.blue;
    }

    public double getGreen() {
        return this.green;
    }

    public void setRed(double d) throws InvalidRedValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidRedValueException(d);
        }
        this.red = d;
    }

    public void setGreen(double d) throws InvalidGreenValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidGreenValueException(d);
        }
        this.green = d;
    }

    public void setBlue(double d) throws InvalidBlueValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidBlueValueException(d);
        }
        this.blue = d;
    }

    public void setAlpha(double d) throws InvalidAlphaValueException {
        if (d < 0.0 || d > 1.0) {
            throw new InvalidAlphaValueException(d);
        }
        this.alpha = d;
    }

    @Override
    public String svg() {
        return "rgb(" + 100.0 * this.red + "%," + 100.0 * this.green + "%," + 100.0 * this.blue + "%)";
    }

    @Override
    public String svgFill() {
        return "fill=\"" + this.svg() + "\" fill-opacity=\"" + this.getAlpha() + "\"";
    }

    @Override
    public String svgLine() {
        return "stroke=\"" + this.svg() + "\" stroke-opacity=\"" + this.getAlpha() + "\"";
    }

    @Override
    public String getID() {
        Color color = this.getColor();
        return Integer.toHexString(color.getRed()) + "." + Integer.toHexString(color.getGreen()) + "." + Integer.toHexString(color.getBlue()) + "." + Integer.toHexString(color.getAlpha());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRColor)) {
            return false;
        }
        JDRColor jDRColor = (JDRColor)object;
        return this.getRed() == jDRColor.getRed() && this.getGreen() == jDRColor.getGreen() && this.getBlue() == jDRColor.getBlue() && this.getAlpha() == jDRColor.getAlpha();
    }

    @Override
    public JDRPaintLoaderListener getListener() {
        return listener;
    }

    @Override
    public void fade(double d) {
        if (d < 0.0) {
            throw new IllegalArgumentException("illegal fade factor " + d + ". (Negative factors not permitted)");
        }
        this.alpha *= d;
        if (this.alpha > 1.0) {
            this.alpha = 1.0;
        }
    }
}

