/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFilenameLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidLatexFilenameLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidLatexImagCmdLengthException;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmap;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRBitmapListener
implements JDRObjectLoaderListener {
    @Override
    public char getJDRid(float f) {
        return 'I';
    }

    @Override
    public void writeJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRBitmap jDRBitmap = (JDRBitmap)jDRObject;
        String string = jDRBitmap.getFilename();
        dataOutputStream.writeInt(string.length());
        dataOutputStream.writeChars(string);
        dataOutputStream.writeBoolean(true);
        String string2 = jDRBitmap.getLaTeXLinkName();
        dataOutputStream.writeInt(string2.length());
        dataOutputStream.writeChars(string2);
        dataOutputStream.writeInt(jDRBitmap.latexCommand.length());
        dataOutputStream.writeChars(jDRBitmap.latexCommand);
        double[] dArray = new double[6];
        jDRBitmap.getTransformation(dArray);
        for (int i = 0; i < 6; ++i) {
            dataOutputStream.writeDouble(dArray[i]);
        }
    }

    @Override
    public JDRObject readJDR(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        int n;
        Object[] objectArray;
        int n2 = dataInputStream.readInt();
        if (n2 <= 0) {
            throw new InvalidFilenameLengthException(n2);
        }
        char[] cArray = new char[n2];
        for (int i = 0; i < n2; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        String string = new String(cArray);
        String string2 = null;
        String string3 = "\\pgfimage";
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            if (n2 <= 0) {
                throw new InvalidLatexFilenameLengthException(n2);
            }
            objectArray = new char[n2];
            for (n = 0; n < n2; ++n) {
                objectArray[n] = dataInputStream.readChar();
            }
            string2 = new String((char[])objectArray);
            n2 = dataInputStream.readInt();
            if (n2 < 0) {
                throw new InvalidLatexImagCmdLengthException(n2);
            }
            if (n2 > 0) {
                char[] cArray2 = new char[n2];
                for (int i = 0; i < n2; ++i) {
                    cArray2[i] = dataInputStream.readChar();
                }
                string3 = new String(cArray2);
            }
        }
        objectArray = new double[6];
        for (n = 0; n < 6; ++n) {
            objectArray[n] = dataInputStream.readDouble();
        }
        String string4 = string;
        if ((string = JDRBitmap.checkFilename(string)) == null) {
            return null;
        }
        if (!string4.equals(string)) {
            string2 = JDRBitmap.getLaTeXPath(string);
        }
        JDRBitmap jDRBitmap = string2 == null ? new JDRBitmap(string) : new JDRBitmap(string, string2);
        jDRBitmap.transform((double[])objectArray);
        jDRBitmap.latexCommand = string3;
        return jDRBitmap;
    }

    @Override
    public char getAJRid(float f) {
        return 'I';
    }

    @Override
    public void writeAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRBitmap jDRBitmap = (JDRBitmap)jDRObject;
        String string = jDRBitmap.getFilename();
        AJR.writeInt(printWriter, string.length());
        printWriter.println(string);
        AJR.writeBoolean(printWriter, true);
        String string2 = jDRBitmap.getLaTeXLinkName();
        AJR.writeInt(printWriter, string2.length());
        printWriter.println(string2);
        AJR.writeInt(printWriter, jDRBitmap.latexCommand.length());
        printWriter.println(jDRBitmap.latexCommand);
        double[] dArray = new double[6];
        jDRBitmap.getTransformation(dArray);
        for (int i = 0; i < 6; ++i) {
            AJR.writeDouble(printWriter, dArray[i]);
        }
    }

    @Override
    public JDRObject readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        int n = AJR.readInt(bufferedReader);
        if (n <= 0) {
            throw new InvalidFilenameLengthException(n);
        }
        String string = AJR.readString(bufferedReader, n);
        String string2 = null;
        String string3 = "\\pgfimage";
        if (AJR.readBoolean(bufferedReader)) {
            n = AJR.readInt(bufferedReader);
            if (n <= 0) {
                throw new InvalidLatexFilenameLengthException(n);
            }
            string2 = AJR.readString(bufferedReader, n);
            n = AJR.readInt(bufferedReader);
            if (n > 0) {
                string3 = AJR.readString(bufferedReader, n);
            } else if (n < 0) {
                throw new InvalidLatexImagCmdLengthException(n);
            }
        }
        double[] dArray = new double[6];
        for (int i = 0; i < 6; ++i) {
            dArray[i] = AJR.readDouble(bufferedReader);
        }
        if ((string = JDRBitmap.checkFilename(string)) == null) {
            return null;
        }
        JDRBitmap jDRBitmap = string2 == null ? new JDRBitmap(string) : new JDRBitmap(string, string2);
        jDRBitmap.transform(dArray);
        jDRBitmap.latexCommand = string3;
        return jDRBitmap;
    }
}

