/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.BrowseUtil;
import uk.ac.uea.cmp.nlct.jdr.InvalidImageFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidLinkNameException;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmapListener;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPattern;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRSymmetricPath;
import uk.ac.uea.cmp.nlct.jdr.JDRTextual;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class JDRBitmap
extends JDRCompleteObject {
    public String latexCommand = "\\pgfimage";
    private double[] flatmatrix;
    private String filename_;
    private String latexlinkname_;
    private String name_;
    private ImageIcon ic;
    private static BrowseUtil browseUtil_ = null;
    private static JFileChooser bitmapChooser_ = null;
    private static JDRBitmapListener bitmapListener = new JDRBitmapListener();
    private boolean imageLoaded;
    public static Color draftBackgroundColor = new Color(240, 240, 240, 200);

    public JDRBitmap(String string) throws InvalidLinkNameException, InvalidImageFormatException {
        String string2 = JDRBitmap.getLaTeXPath(string);
        this.init(string, string2);
    }

    public JDRBitmap(String string, String string2) throws InvalidLinkNameException, InvalidImageFormatException {
        this.init(string, string2);
    }

    private void init(String string, String string2) throws InvalidLinkNameException, InvalidImageFormatException {
        this.filename_ = string;
        this.latexlinkname_ = string2;
        File file = new File(this.filename_);
        if (!file.exists()) {
            throw new InvalidLinkNameException(file.getAbsolutePath());
        }
        if (JDRBitmap.getImageFormat(file) == null) {
            throw new InvalidImageFormatException(file.getAbsolutePath());
        }
        this.name_ = file.getName();
        this.imageLoaded = true;
        Image image = Toolkit.getDefaultToolkit().createImage(this.filename_);
        this.ic = new ImageIcon(image);
        this.imageLoaded = this.ic.getImageLoadStatus() == 8;
        this.flatmatrix = new double[6];
        this.reset();
    }

    public static String getLaTeXPath(String string) {
        String string2 = string;
        if (File.separator.equals("\\")) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\\");
            string2 = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string2 = string2 + "/" + stringTokenizer.nextToken();
            }
        }
        return string2;
    }

    private static String getImageFormat(File file) {
        try {
            ImageInputStream imageInputStream = ImageIO.createImageInputStream(file);
            Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
            if (!iterator.hasNext()) {
                imageInputStream.close();
                return null;
            }
            ImageReader imageReader = iterator.next();
            imageInputStream.close();
            return imageReader.getFormatName();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isDraft() {
        return !this.imageLoaded;
    }

    public static void setBrowseUtil(BrowseUtil browseUtil) {
        browseUtil_ = browseUtil;
    }

    public static void setFileChooser(JFileChooser jFileChooser) {
        bitmapChooser_ = jFileChooser;
    }

    public static BrowseUtil getBrowseUtil() {
        return browseUtil_;
    }

    public static JFileChooser getFileChooser() {
        return bitmapChooser_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkFilename(String string) {
        int n;
        String string2 = string;
        File file = new File(string2);
        if (!file.exists()) {
            JDR.bitmapReplaced = true;
            n = 1;
            if (browseUtil_ == null || bitmapChooser_ == null) {
                JDR.messageSystem.warning(new InvalidLinkNameException(string2));
                return null;
            }
            n = browseUtil_.getBrowseDialog(string2);
            if (n != 0) return null;
            bitmapChooser_.setSelectedFile(file);
            n = bitmapChooser_.showOpenDialog(null);
            if (n != 0) return null;
            string2 = bitmapChooser_.getSelectedFile().getAbsolutePath();
            file = new File(string2);
            if (!file.exists()) {
                return JDRBitmap.checkFilename(string2);
            }
        }
        if (JDRBitmap.getImageFormat(file) != null) return string2;
        n = 1;
        if (browseUtil_ == null || bitmapChooser_ == null) {
            JDR.messageSystem.warning(new InvalidImageFormatException(string2));
            return null;
        }
        n = browseUtil_.getInvalidFormatDialog(string2);
        if (n != 0) return null;
        bitmapChooser_.setSelectedFile(file);
        n = bitmapChooser_.showOpenDialog(null);
        if (n != 0) return null;
        string2 = bitmapChooser_.getSelectedFile().getAbsolutePath();
        file = new File(string2);
        if (file.exists() && JDRBitmap.getImageFormat(file) != null) return string2;
        return JDRBitmap.checkFilename(string2);
    }

    @Override
    public void reset() {
        this.flatmatrix[0] = 1.0;
        this.flatmatrix[1] = 0.0;
        this.flatmatrix[2] = 0.0;
        this.flatmatrix[3] = 1.0;
        this.flatmatrix[4] = 0.0;
        this.flatmatrix[5] = 0.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean refresh() {
        File file = new File(this.filename_);
        this.name_ = file.getName();
        if (!file.exists()) {
            JDR.bitmapReplaced = true;
            int n = 1;
            if (browseUtil_ == null || bitmapChooser_ == null) {
                JDR.messageSystem.warning(new InvalidLinkNameException(this.name_));
                return false;
            }
            n = browseUtil_.getCantRefreshDialog(this.filename_);
            if (n != 0) return false;
            n = bitmapChooser_.showOpenDialog(null);
            if (n != 0) return false;
            this.filename_ = bitmapChooser_.getSelectedFile().getAbsolutePath();
            file = new File(this.filename_);
            this.name_ = file.getName();
            if (!file.exists()) {
                this.refresh();
            }
            if (File.separator.equals("\\")) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.filename_, "\\");
                this.latexlinkname_ = stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreTokens()) {
                    this.latexlinkname_ = this.latexlinkname_ + File.separator + stringTokenizer.nextToken();
                }
            } else {
                this.latexlinkname_ = this.filename_;
            }
        }
        Image image = this.ic.getImage();
        image.flush();
        image = Toolkit.getDefaultToolkit().createImage(this.filename_);
        this.ic = new ImageIcon(image);
        this.imageLoaded = this.ic.getImageLoadStatus() == 8;
        return true;
    }

    private void saveNoFlowFrame(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(this.filename_.length());
        dataOutputStream.writeChars(this.filename_);
        dataOutputStream.writeBoolean(true);
        dataOutputStream.writeInt(this.latexlinkname_.length());
        dataOutputStream.writeChars(this.latexlinkname_);
        dataOutputStream.writeInt(this.latexCommand.length());
        dataOutputStream.writeChars(this.latexCommand);
        for (int i = 0; i < 6; ++i) {
            dataOutputStream.writeDouble(this.flatmatrix[i]);
        }
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "";
        if (!this.description.equals("")) {
            string2 = "% " + this.description + string;
        }
        AffineTransform affineTransform2 = new AffineTransform();
        affineTransform2.concatenate(affineTransform);
        affineTransform2.concatenate(this.getAffineTransform());
        affineTransform2.concatenate(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f));
        string2 = string2 + "\\begin{pgfscope}" + string;
        string2 = string2 + PGF.transform(affineTransform2) + string;
        string2 = string2 + "\\pgflowlevelsynccm";
        string2 = string2 + "\\pgfputat{\\pgfpoint{0pt}{0pt}}{";
        string2 = string2 + "\\pgftext[top,left]{";
        double d = this.ic.getIconWidth();
        double d2 = this.ic.getIconHeight();
        int n = this.latexlinkname_.lastIndexOf(".");
        string2 = string2 + this.latexCommand + "[width=" + d + "bp,height=" + d2 + "bp]{";
        string2 = n > -1 ? string2 + this.latexlinkname_.substring(0, n) : string2 + this.latexlinkname_;
        string2 = string2 + "}}}" + string;
        string2 = string2 + "\\end{pgfscope}" + string;
        return string2;
    }

    @Override
    public void rotate(double d) {
        BBox bBox = this.getBBox();
        double d2 = bBox.getMinX() + 0.5 * bBox.getWidth();
        double d3 = bBox.getMinY() + 0.5 * bBox.getHeight();
        this.rotate(new Point2D.Double(d2, d3), d);
    }

    @Override
    public void rotate(Point2D point2D, double d) {
        this.flatmatrix[4] = this.flatmatrix[4] - point2D.getX();
        this.flatmatrix[5] = this.flatmatrix[5] - point2D.getY();
        double d2 = Math.cos(-d);
        double d3 = Math.sin(-d);
        double d4 = this.flatmatrix[0];
        double d5 = this.flatmatrix[1];
        double d6 = this.flatmatrix[2];
        double d7 = this.flatmatrix[3];
        double d8 = this.flatmatrix[4];
        double d9 = this.flatmatrix[5];
        this.flatmatrix[0] = d4 * d2 + d5 * d3;
        this.flatmatrix[1] = d5 * d2 - d4 * d3;
        this.flatmatrix[2] = d6 * d2 + d7 * d3;
        this.flatmatrix[3] = d7 * d2 - d6 * d3;
        this.flatmatrix[4] = d8 * d2 + d9 * d3;
        this.flatmatrix[5] = d9 * d2 - d8 * d3;
        this.flatmatrix[4] = this.flatmatrix[4] + point2D.getX();
        this.flatmatrix[5] = this.flatmatrix[5] + point2D.getY();
    }

    @Override
    public void scaleX(Point2D point2D, double d) {
        this.scale(point2D, d, 1.0);
    }

    @Override
    public void scaleY(Point2D point2D, double d) {
        this.scale(point2D, 1.0, d);
    }

    @Override
    public void scale(double d, double d2) {
        BBox bBox = this.getBBox();
        double d3 = bBox.getMinX();
        double d4 = bBox.getMinY();
        this.scale(new Point2D.Double(d3, d4), d, d2);
    }

    @Override
    public void scale(Point2D point2D, double d, double d2) {
        this.flatmatrix[4] = this.flatmatrix[4] - point2D.getX();
        this.flatmatrix[5] = this.flatmatrix[5] - point2D.getY();
        this.flatmatrix[0] = this.flatmatrix[0] * d;
        this.flatmatrix[1] = this.flatmatrix[1] * d2;
        this.flatmatrix[2] = this.flatmatrix[2] * d;
        this.flatmatrix[3] = this.flatmatrix[3] * d2;
        this.flatmatrix[4] = this.flatmatrix[4] * d;
        this.flatmatrix[5] = this.flatmatrix[5] * d2;
        this.flatmatrix[4] = this.flatmatrix[4] + point2D.getX();
        this.flatmatrix[5] = this.flatmatrix[5] + point2D.getY();
    }

    @Override
    public void shear(double d, double d2) {
        BBox bBox = this.getBBox();
        double d3 = bBox.getMinX();
        double d4 = bBox.getMaxY();
        this.shear(new Point2D.Double(d3, d4), d, d2);
    }

    @Override
    public void shear(Point2D point2D, double d) {
        this.shear(point2D, d, d);
    }

    @Override
    public void shear(Point2D point2D, double d, double d2) {
        this.flatmatrix[4] = this.flatmatrix[4] - point2D.getX();
        this.flatmatrix[5] = this.flatmatrix[5] - point2D.getY();
        double d3 = this.flatmatrix[0];
        double d4 = this.flatmatrix[1];
        double d5 = this.flatmatrix[2];
        double d6 = this.flatmatrix[3];
        double d7 = this.flatmatrix[4];
        double d8 = this.flatmatrix[5];
        this.flatmatrix[0] = d3 - d * d4;
        this.flatmatrix[1] = d4 - d2 * d3;
        this.flatmatrix[2] = d5 - d * d6;
        this.flatmatrix[3] = d6 - d2 * d5;
        this.flatmatrix[4] = d7 - d * d8;
        this.flatmatrix[5] = d8 - d2 * d7;
        this.flatmatrix[4] = this.flatmatrix[4] + point2D.getX();
        this.flatmatrix[5] = this.flatmatrix[5] + point2D.getY();
    }

    @Override
    public void translate(double d, double d2) {
        this.flatmatrix[4] = this.flatmatrix[4] + d;
        this.flatmatrix[5] = this.flatmatrix[5] + d2;
    }

    public AffineTransform getAffineTransform() {
        return new AffineTransform(this.flatmatrix);
    }

    @Override
    public void transform(double[] dArray) {
        AffineTransform affineTransform = this.getAffineTransform();
        affineTransform.concatenate(new AffineTransform(dArray));
        affineTransform.getMatrix(this.flatmatrix);
    }

    public void transform(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getAffineTransform();
        affineTransform2.concatenate(affineTransform);
        affineTransform2.getMatrix(this.flatmatrix);
    }

    public void preConcatenate(AffineTransform affineTransform) {
        AffineTransform affineTransform2 = this.getAffineTransform();
        affineTransform2.preConcatenate(affineTransform);
        affineTransform2.getMatrix(this.flatmatrix);
    }

    @Override
    public BBox getBBox() {
        Rectangle2D rectangle2D = this.getBounds();
        BBox bBox = new BBox(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
        return bBox;
    }

    public Shape getOutline() {
        Shape shape = new GeneralPath(new Rectangle2D.Double(0.0, 0.0, this.ic.getIconWidth(), this.ic.getIconHeight()));
        AffineTransform affineTransform = this.getAffineTransform();
        shape = affineTransform.createTransformedShape(shape);
        return shape;
    }

    public Rectangle2D getBounds() {
        return this.getOutline().getBounds2D();
    }

    public JDRPoint getStart() {
        Rectangle2D rectangle2D = this.getBounds();
        return new JDRPoint(rectangle2D.getX(), rectangle2D.getY());
    }

    public JDRPoint getEnd() {
        Rectangle2D rectangle2D = this.getBounds();
        return new JDRPoint(rectangle2D.getX(), rectangle2D.getY());
    }

    public Point2D getCentre() {
        BBox bBox = this.getBBox();
        return new Point2D.Double(bBox.getMidX(), bBox.getMidY());
    }

    public String getFilename() {
        return this.filename_;
    }

    public String getLaTeXLinkName() {
        return this.latexlinkname_;
    }

    public void setProperties(String string, String string2) {
        this.filename_ = string;
        this.latexlinkname_ = string2;
        this.refresh();
    }

    @Override
    public void draw(Graphics graphics) {
    }

    @Override
    public void draw(Graphics graphics, boolean bl, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        AffineTransform affineTransform = this.getAffineTransform();
        if (this.imageLoaded) {
            graphics2D.drawImage(this.ic.getImage(), affineTransform, jComponent);
        } else {
            graphics2D.setPaint(draftBackgroundColor);
            Rectangle2D rectangle2D = this.getBounds();
            graphics2D.fill(rectangle2D);
            graphics2D.setPaint(Color.black);
            Font font = graphics2D.getFont();
            graphics2D.setFont(annoteFont);
            graphics2D.drawString("[" + this.name_ + "]", (int)rectangle2D.getX(), (int)(rectangle2D.getY() + 0.5 * rectangle2D.getHeight()));
            graphics2D.setFont(font);
        }
        this.drawFlowFrame(graphics);
        graphics2D.setPaint(paint);
    }

    @Override
    public Object clone() {
        JDRBitmap jDRBitmap = null;
        try {
            jDRBitmap = new JDRBitmap(this.filename_, this.latexlinkname_);
            jDRBitmap.makeEqual(this);
        }
        catch (InvalidLinkNameException invalidLinkNameException) {
        }
        catch (InvalidImageFormatException invalidImageFormatException) {
            // empty catch block
        }
        return jDRBitmap;
    }

    public void makeEqual(JDRBitmap jDRBitmap) {
        super.makeEqual(jDRBitmap);
        this.ic = jDRBitmap.ic;
        this.filename_ = jDRBitmap.getFilename();
        this.name_ = jDRBitmap.name_;
        this.latexlinkname_ = jDRBitmap.getLaTeXLinkName();
        this.latexCommand = jDRBitmap.latexCommand;
        double[] dArray = new double[6];
        jDRBitmap.getTransformation(dArray);
        this.setTransformation(dArray);
        this.imageLoaded = jDRBitmap.imageLoaded;
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof JDRBitmap)) {
            return false;
        }
        JDRBitmap jDRBitmap = (JDRBitmap)object;
        if (!this.filename_.equals(jDRBitmap.filename_)) {
            return false;
        }
        if (!this.latexlinkname_.equals(jDRBitmap.latexlinkname_)) {
            return false;
        }
        if (!this.latexCommand.equals(jDRBitmap.latexCommand)) {
            return false;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.flatmatrix[i] == jDRBitmap.flatmatrix[i]) continue;
            return false;
        }
        return true;
    }

    public void getTransformation(double[] dArray) {
        for (int i = 0; i < 6; ++i) {
            dArray[i] = this.flatmatrix[i];
        }
    }

    public void setTransformation(double[] dArray) {
        for (int i = 0; i < 6; ++i) {
            this.flatmatrix[i] = dArray[i];
        }
    }

    public void setTransformation(AffineTransform affineTransform) {
        affineTransform.getMatrix(this.flatmatrix);
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        if (this.isDraft()) {
            return;
        }
        Image image = this.ic.getImage();
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = null;
        if (image instanceof BufferedImage) {
            bufferedImage = (BufferedImage)image;
        } else {
            int n3 = this.getColorType(image);
            bufferedImage = new BufferedImage(n, n2, n3);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        int n4 = n;
        int n5 = n2;
        int n6 = 8;
        printWriter.println("gsave");
        printWriter.println("/bitmapmat [" + this.flatmatrix[0] + " " + this.flatmatrix[1] + " " + this.flatmatrix[2] + " " + this.flatmatrix[3] + " " + this.flatmatrix[4] + " " + this.flatmatrix[5] + "]def");
        printWriter.println("/bitmapinv matrix def");
        printWriter.println("/DeviceRGB setcolorspace");
        printWriter.println("<<");
        printWriter.println("  /ImageType 1");
        printWriter.println("  /Width " + n4);
        printWriter.println("  /Height " + n5);
        printWriter.println("  /BitsPerComponent " + n6);
        printWriter.println("  /Decode [0 1 0 1 0 1]");
        printWriter.println("  /ImageMatrix bitmapmat bitmapinv invertmatrix");
        printWriter.println("  /DataSource currentfile /ASCIIHexDecode filter");
        printWriter.println(">>");
        printWriter.println("image");
        int n7 = n * n2;
        int[] nArray = new int[n7];
        bufferedImage.getRGB(0, 0, n, n2, nArray, 0, n);
        for (int i = 0; i < n7; ++i) {
            int n8 = (nArray[i] & 0xFF0000) >> 16;
            int n9 = (nArray[i] & 0xFF00) >> 8;
            int n10 = nArray[i] & 0xFF;
            printWriter.print(this.hexChar(n8 >> 4));
            printWriter.print(this.hexChar(n8 & 0xF));
            printWriter.print(this.hexChar(n9 >> 4));
            printWriter.print(this.hexChar(n9 & 0xF));
            printWriter.print(this.hexChar(n10 >> 4));
            printWriter.print(this.hexChar(n10 & 0xF));
            if (i % 10 == 9) {
                printWriter.println();
                continue;
            }
            printWriter.print(" ");
        }
        printWriter.println(">");
        printWriter.println("grestore");
    }

    @Override
    public int psLevel() {
        return 2;
    }

    private char hexChar(int n) {
        switch (n) {
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'a';
            }
            case 11: {
                return 'b';
            }
            case 12: {
                return 'c';
            }
            case 13: {
                return 'd';
            }
            case 14: {
                return 'e';
            }
            case 15: {
                return 'f';
            }
        }
        return '0';
    }

    private String hexColourString(int n) {
        int n2 = n & 0xFFFFFF;
        String string = Integer.toHexString(n2);
        int n3 = 6 - string.length();
        String string2 = "";
        for (int i = 0; i < n3; ++i) {
            string2 = string2 + "0";
        }
        return string2 + string;
    }

    private int getColorType(Image image) {
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        if (colorModel.hasAlpha()) {
            return 2;
        }
        return 1;
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        printWriter.println("   <image x=\"0\" y=\"0\"");
        printWriter.println("      transform=\"matrix(" + this.flatmatrix[0] + "," + this.flatmatrix[1] + "," + this.flatmatrix[2] + "," + this.flatmatrix[3] + "," + this.flatmatrix[4] + "," + this.flatmatrix[5] + ")\"");
        printWriter.println("      width=\"" + this.ic.getIconWidth() + "\"");
        printWriter.println("      height=\"" + this.ic.getIconHeight() + "\"");
        printWriter.println("      xlink:href=\"" + this.filename_ + "\">");
        printWriter.println("   <desc>");
        printWriter.println(this.filename_);
        printWriter.println("   </desc>");
        printWriter.println("   </image>");
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return bitmapListener;
    }

    @Override
    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "Bitmap:" + string;
        string2 = string2 + "name: " + this.name_ + string;
        string2 = string2 + "filename: " + this.filename_ + string;
        string2 = string2 + "transformation matrix: [[" + this.flatmatrix[0] + "," + this.flatmatrix[2] + "," + this.flatmatrix[4] + "]" + "[" + this.flatmatrix[1] + "," + this.flatmatrix[3] + "," + this.flatmatrix[5] + "]" + "]" + string;
        string2 = string2 + "LaTeX link name: " + this.latexlinkname_ + string;
        string2 = string2 + "LaTeX command: " + this.latexCommand + string;
        string2 = string2 + "image loaded: " + this.imageLoaded + string;
        string2 = string2 + "image icon: " + this.ic + string;
        return string2 + super.info();
    }

    @Override
    public JDRTextual getTextual() {
        return null;
    }

    @Override
    public boolean hasTextual() {
        return false;
    }

    @Override
    public boolean hasShape() {
        return false;
    }

    @Override
    public boolean hasSymmetricPath() {
        return false;
    }

    @Override
    public JDRSymmetricPath getSymmetricPath() {
        return null;
    }

    @Override
    public boolean hasPattern() {
        return false;
    }

    @Override
    public JDRPattern getPattern() {
        return null;
    }

    @Override
    public String[] getDescriptionInfo() {
        return new String[]{this.name_, "" + Math.round(100.0 * this.flatmatrix[4]) / 100L + "," + Math.round(100.0 * this.flatmatrix[5]) / 100L};
    }

    public ImageIcon getImageIcon() {
        return this.ic;
    }

    public Image getImage() {
        return this.ic.getImage();
    }

    public int getWidth() {
        return this.ic.getIconWidth();
    }

    public int getHeight() {
        return this.ic.getIconHeight();
    }

    @Override
    public void fade(double d) {
    }
}

