/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRBezier;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRSegmentLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class JDRBezierLoaderListener
extends JDRSegmentLoaderListener {
    @Override
    public char getJDRid(float f) {
        return 'B';
    }

    @Override
    public void writeJDR(JDRObject jDRObject, DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        JDRBezier jDRBezier = (JDRBezier)jDRObject;
        if (f < 1.3f) {
            dataOutputStream.writeDouble(jDRBezier.start.x);
            dataOutputStream.writeDouble(jDRBezier.start.y);
        }
        dataOutputStream.writeDouble(jDRBezier.control1.x);
        dataOutputStream.writeDouble(jDRBezier.control1.y);
        dataOutputStream.writeDouble(jDRBezier.control2.x);
        dataOutputStream.writeDouble(jDRBezier.control2.y);
        dataOutputStream.writeDouble(jDRBezier.end.x);
        dataOutputStream.writeDouble(jDRBezier.end.y);
    }

    @Override
    public JDRObject readJDR(double d, double d2, DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        double d3;
        double d4;
        if (f < 1.3f) {
            d4 = dataInputStream.readDouble();
            d3 = dataInputStream.readDouble();
        } else {
            d4 = d;
            d3 = d2;
        }
        double d5 = dataInputStream.readDouble();
        double d6 = dataInputStream.readDouble();
        double d7 = dataInputStream.readDouble();
        double d8 = dataInputStream.readDouble();
        double d9 = dataInputStream.readDouble();
        double d10 = dataInputStream.readDouble();
        return new JDRBezier(d4, d3, d5, d6, d7, d8, d9, d10);
    }

    @Override
    public char getAJRid(float f) {
        return 'B';
    }

    @Override
    public void writeAJR(JDRObject jDRObject, PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        JDRBezier jDRBezier = (JDRBezier)jDRObject;
        if (f < 1.3f) {
            AJR.writeDouble(printWriter, jDRBezier.start.x);
            AJR.writeDouble(printWriter, jDRBezier.start.y);
        }
        AJR.writeDouble(printWriter, jDRBezier.control1.x);
        AJR.writeDouble(printWriter, jDRBezier.control1.y);
        AJR.writeDouble(printWriter, jDRBezier.control2.x);
        AJR.writeDouble(printWriter, jDRBezier.control2.y);
        AJR.writeDouble(printWriter, jDRBezier.end.x);
        AJR.writeDouble(printWriter, jDRBezier.end.y);
    }

    @Override
    public JDRObject readAJR(double d, double d2, BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        double d3;
        double d4;
        if (f < 1.3f) {
            d4 = AJR.readDouble(bufferedReader);
            d3 = AJR.readDouble(bufferedReader);
        } else {
            d4 = d;
            d3 = d2;
        }
        double d5 = AJR.readDouble(bufferedReader);
        double d6 = AJR.readDouble(bufferedReader);
        double d7 = AJR.readDouble(bufferedReader);
        double d8 = AJR.readDouble(bufferedReader);
        double d9 = AJR.readDouble(bufferedReader);
        double d10 = AJR.readDouble(bufferedReader);
        return new JDRBezier(d4, d3, d5, d6, d7, d8, d9, d10);
    }
}

