/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.NoSuchElementException;
import uk.ac.uea.cmp.nlct.jdr.JDRBezierLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRLine;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObjectLoaderListener;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;
import uk.ac.uea.cmp.nlct.jdr.JDRSegment;

public class JDRBezier
extends JDRSegment {
    protected JDRPoint control1;
    protected JDRPoint control2;
    private static JDRBezierLoaderListener listener = new JDRBezierLoaderListener();

    public JDRBezier(Point point, Point point2) {
        super(point, point2);
        this.control1 = new JDRPoint();
        this.control2 = new JDRPoint();
        this.flatten();
    }

    public JDRBezier(Point2D point2D, Point2D point2D2) {
        super(point2D, point2D2);
        this.control1 = new JDRPoint();
        this.control2 = new JDRPoint();
        this.flatten();
    }

    public JDRBezier(JDRPoint jDRPoint, JDRPoint jDRPoint2) {
        super(jDRPoint, jDRPoint2);
        this.control1 = new JDRPoint();
        this.control2 = new JDRPoint();
        this.flatten();
    }

    public JDRBezier(Point point, Point point2, Point point3, Point point4) {
        super(point, point4);
        this.control1 = new JDRPoint(point2);
        this.control2 = new JDRPoint(point3);
    }

    public JDRBezier(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        super(point2D, point2D4);
        this.control1 = new JDRPoint(point2D2);
        this.control2 = new JDRPoint(point2D3);
    }

    public JDRBezier(JDRPoint jDRPoint, JDRPoint jDRPoint2, JDRPoint jDRPoint3, JDRPoint jDRPoint4) {
        super(jDRPoint, jDRPoint4);
        this.control1 = jDRPoint2;
        this.control2 = jDRPoint3;
    }

    public JDRBezier(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        super(new JDRPoint(d, d2), new JDRPoint(d7, d8));
        this.control1 = new JDRPoint(d3, d4);
        this.control2 = new JDRPoint(d5, d6);
    }

    public void flatten() {
        Point2D point2D = this.getdP();
        this.setGradients(point2D, point2D);
    }

    @Override
    public JDRBezier reverse() {
        JDRBezier jDRBezier = (JDRBezier)this.clone();
        jDRBezier.start.x = this.end.x;
        jDRBezier.start.y = this.end.y;
        jDRBezier.control1.x = this.control2.x;
        jDRBezier.control1.y = this.control2.y;
        jDRBezier.control2.x = this.control1.x;
        jDRBezier.control2.y = this.control1.y;
        jDRBezier.end.x = this.start.x;
        jDRBezier.end.y = this.start.y;
        return jDRBezier;
    }

    public JDRBezier invert() {
        double d = 2.0 * this.start.x - this.end.x;
        double d2 = 2.0 * this.start.y - this.end.y;
        double d3 = 2.0 * this.start.x - this.control2.x;
        double d4 = 2.0 * this.start.y - this.control2.y;
        double d5 = 2.0 * this.start.x - this.control1.x;
        double d6 = 2.0 * this.start.y - this.control1.y;
        return new JDRBezier(this.start.x, this.start.y, d5, d6, d3, d4, d, d2);
    }

    public static JDRBezier quadToCubic(double d, double d2, double d3, double d4, double d5, double d6) {
        Point2D.Double double_ = new Point2D.Double(d, d2);
        Point2D.Double double_2 = new Point2D.Double((2.0 * d3 + d) / 3.0, (2.0 * d4 + d2) / 3.0);
        Point2D.Double double_3 = new Point2D.Double((d5 + 2.0 * d3) / 3.0, (d6 + 2.0 * d4) / 3.0);
        Point2D.Double double_4 = new Point2D.Double(d5, d6);
        return new JDRBezier(double_, double_2, double_3, double_4);
    }

    public void set(Point point, Point point2, Point point3, Point point4) {
        this.start.x = point.x;
        this.start.y = point.y;
        this.control1.x = point2.x;
        this.control1.y = point2.y;
        this.control2.x = point3.x;
        this.control2.y = point3.y;
        this.end.x = point4.x;
        this.end.y = point4.y;
    }

    public void set(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        this.start.x = point2D.getX();
        this.start.y = point2D.getY();
        this.control1.x = point2D2.getX();
        this.control1.y = point2D2.getY();
        this.control2.x = point2D3.getX();
        this.control2.y = point2D3.getY();
        this.end.x = point2D4.getX();
        this.end.y = point2D4.getY();
    }

    public void setGradients(Point2D point2D, Point2D point2D2) {
        this.control1.set(point2D.getX() / 3.0 + this.start.x, point2D.getY() / 3.0 + this.start.y);
        this.control2.set(this.end.x - point2D2.getX() / 3.0, this.end.y - point2D2.getY() / 3.0);
    }

    public void setStartGradient(JDRPoint jDRPoint) {
        this.setStartGradient(jDRPoint.x, jDRPoint.y);
    }

    public void setStartGradient(Point2D point2D) {
        this.setStartGradient(point2D.getX(), point2D.getY());
    }

    public void setStartGradient(double d, double d2) {
        this.control1.x = d / 3.0 + this.start.x;
        this.control1.y = d2 / 3.0 + this.start.y;
    }

    public void setEndGradient(JDRPoint jDRPoint) {
        this.setEndGradient(jDRPoint.x, jDRPoint.y);
    }

    public void setEndGradient(Point2D point2D) {
        this.setEndGradient(point2D.getX(), point2D.getY());
    }

    public void setEndGradient(double d, double d2) {
        this.control2.x = this.end.x - d / 3.0;
        this.control2.y = this.end.y - d2 / 3.0;
    }

    @Override
    public Point2D getdP0() {
        return new Point2D.Double(3.0 * (this.control1.x - this.start.x), 3.0 * (this.control1.y - this.start.y));
    }

    @Override
    public Point2D getdP1() {
        return new Point2D.Double(3.0 * (this.end.x - this.control2.x), 3.0 * (this.end.y - this.control2.y));
    }

    @Override
    public Point2D getP(double d) {
        double d2 = 1.0 - d;
        double d3 = d2 * d2;
        double d4 = d * d;
        double d5 = d3 * d2;
        double d6 = 3.0 * d * d3;
        double d7 = 3.0 * d4 * d2;
        double d8 = d4 * d;
        double d9 = d5 * this.start.x + d6 * this.control1.x + d7 * this.control2.x + d8 * this.end.x;
        double d10 = d5 * this.start.y + d6 * this.control1.y + d7 * this.control2.y + d8 * this.end.y;
        return new Point2D.Double(d9, d10);
    }

    @Override
    public Point2D getdP(double d) {
        double d2 = -3.0 * (1.0 - d) * (1.0 - d);
        double d3 = 3.0 * (1.0 - d) * (1.0 - 3.0 * d);
        double d4 = 3.0 * d * (2.0 - 3.0 * d);
        double d5 = 3.0 * d * d;
        double d6 = d2 * this.start.x + d3 * this.control1.x + d4 * this.control2.x + d5 * this.end.x;
        double d7 = d2 * this.start.y + d3 * this.control1.y + d4 * this.control2.y + d5 * this.end.y;
        return new Point2D.Double(d6, d7);
    }

    public double getT(double d, double d2, double d3) {
        double d4;
        Point2D point2D;
        double d5;
        double d6;
        double d7 = d;
        double d8 = 100000.0;
        for (int i = 0; i < 100 && !(Math.abs((d6 = (d5 = (point2D = this.getP(d7)).getX() - d2) * d5 + (d4 = point2D.getY() - d3) * d4) - d8) < 1.0E-6); ++i) {
            Point2D point2D2 = this.getdP(d7);
            double d9 = 2.0 * point2D2.getX() * d5 + 2.0 * point2D2.getY() * d4;
            double d10 = 2.0 * (point2D2.getX() * point2D2.getX() + point2D2.getY() * point2D2.getY());
            double d11 = -d9 / d10;
            d7 += d11;
        }
        return d7;
    }

    public double getT(double d, double d2, double d3, double d4, double d5) {
        double d6 = 0.0;
        double d7 = Double.MAX_VALUE;
        double d8 = Double.MAX_VALUE;
        for (double d9 = 0.0; d9 < 1.0; d9 += d5) {
            Point2D point2D = this.getP(d9);
            double d10 = point2D.getX() - d;
            double d11 = point2D.getY() - d2;
            double d12 = d10 * d10 + d11 * d11;
            Point2D point2D2 = this.getdP(d9);
            d10 = point2D2.getX() - d3;
            d11 = point2D2.getY() - d4;
            double d13 = d10 * d10 + d11 * d11;
            if (!(d12 < d7) || !(d13 < d8)) continue;
            d7 = d12;
            d8 = d13;
            d6 = d9;
        }
        return d6;
    }

    @Override
    public void transform(double[] dArray) {
        this.start.transform(dArray);
        this.end.transform(dArray);
        this.control1.transform(dArray);
        this.control2.transform(dArray);
    }

    @Override
    public void translate(double d, double d2) {
        this.start.translate(d, d2);
        this.end.translate(d, d2);
        this.control1.translate(d, d2);
        this.control2.translate(d, d2);
    }

    @Override
    public void translate(double d, double d2, boolean bl) {
        this.start.translate(d, d2);
        this.control1.translate(d, d2);
        this.control2.translate(d, d2);
        if (bl) {
            this.end.translate(d, d2);
        }
    }

    @Override
    public void scale(double d, double d2) {
        this.start.scale(d, d2);
        this.end.scale(d, d2);
        this.control1.scale(d, d2);
        this.control2.scale(d, d2);
    }

    @Override
    public void scale(Point2D point2D, double d, double d2, boolean bl) {
        this.start.scale(point2D, d, d2);
        this.control1.scale(point2D, d, d2);
        this.control2.scale(point2D, d, d2);
        if (bl) {
            this.end.scale(point2D, d, d2);
        }
    }

    @Override
    public void scaleX(double d) {
        this.start.scaleX(d);
        this.end.scaleX(d);
        this.control1.scaleX(d);
        this.control2.scaleX(d);
    }

    @Override
    public void scaleY(double d) {
        this.start.scaleY(d);
        this.end.scaleY(d);
        this.control1.scaleY(d);
        this.control2.scaleY(d);
    }

    @Override
    public void shear(double d, double d2) {
        this.start.shear(d, d2);
        this.end.shear(d, d2);
        this.control1.shear(d, d2);
        this.control2.shear(d, d2);
    }

    @Override
    public void shear(Point2D point2D, double d, double d2, boolean bl) {
        this.start.shear(point2D, d, d2);
        this.control1.shear(point2D, d, d2);
        this.control2.shear(point2D, d, d2);
        if (bl) {
            this.end.shear(point2D, d, d2);
        }
    }

    @Override
    public void rotate(double d) {
        this.start.rotate(d);
        this.end.rotate(d);
        this.control1.rotate(d);
        this.control2.rotate(d);
    }

    @Override
    public void rotate(Point2D point2D, double d, boolean bl) {
        this.start.rotate(point2D, d);
        this.control1.rotate(point2D, d);
        this.control2.rotate(point2D, d);
        if (bl) {
            this.end.rotate(point2D, d);
        }
    }

    @Override
    public void drawControls(Graphics graphics, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setStroke(guideStroke);
        graphics2D.setPaint(draftColor);
        graphics.drawLine((int)this.start.x, (int)this.start.y, (int)this.control1.x, (int)this.control1.y);
        graphics.drawLine((int)this.control1.x, (int)this.control1.y, (int)this.control2.x, (int)this.control2.y);
        graphics.drawLine((int)this.control2.x, (int)this.control2.y, (int)this.end.x, (int)this.end.y);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        this.start.draw(graphics);
        this.control1.draw(graphics);
        this.control2.draw(graphics);
        if (bl) {
            this.end.draw(graphics);
        }
    }

    @Override
    public void drawControls(Graphics graphics, boolean bl, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setStroke(guideStroke);
        graphics2D.setPaint(draftColor);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(this.start.x * d), (float)(this.start.y * d));
        generalPath.lineTo((float)(this.control1.x * d), (float)(this.control1.y * d));
        generalPath.lineTo((float)(this.control2.x * d), (float)(this.control2.y * d));
        generalPath.lineTo((float)(this.end.x * d), (float)(this.end.y * d));
        graphics2D.draw(generalPath);
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
        this.start.draw(graphics, d);
        this.control1.draw(graphics, d);
        this.control2.draw(graphics, d);
        if (bl) {
            this.end.draw(graphics, d);
        }
    }

    @Override
    public void draw(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.draw(new CubicCurve2D.Double(this.start.x, this.start.y, this.control1.x, this.control1.y, this.control2.x, this.control2.y, this.end.x, this.end.y));
    }

    @Override
    public void draw(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.draw(new CubicCurve2D.Double(d * this.start.x, d * this.start.y, d * this.control1.x, d * this.control1.y, d * this.control2.x, d * this.control2.y, d * this.end.x, d * this.end.y));
    }

    @Override
    public void drawSelectedNoControls(Graphics graphics, double d) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(this.start.getSelectedPaint());
        graphics2D.setStroke(guideStroke);
        this.draw(graphics, d);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
    }

    @Override
    public void drawDraft(Graphics graphics, double d, boolean bl) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        graphics2D.setPaint(JDRObject.draftColor);
        this.draw(graphics, d);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)(this.start.x * d), (float)(this.start.y * d));
        generalPath.lineTo((float)(this.control1.x * d), (float)(this.control1.y * d));
        generalPath.lineTo((float)(this.control2.x * d), (float)(this.control2.y * d));
        generalPath.lineTo((float)(this.end.x * d), (float)(this.end.y * d));
        if (this.isSelected()) {
            graphics2D.draw(generalPath);
            graphics2D.setPaint(this.start.getSelectedPaint());
            graphics2D.setStroke(guideStroke);
            this.draw(graphics, d);
            graphics2D.draw(generalPath);
        } else {
            graphics2D.setStroke(guideStroke);
            graphics2D.draw(generalPath);
        }
        graphics2D.setStroke(stroke);
        this.start.draw(graphics, d);
        this.control1.draw(graphics, d);
        this.control2.draw(graphics, d);
        if (bl) {
            this.end.draw(graphics, d);
        }
    }

    public static void makeContinuous(JDRBezier jDRBezier, JDRBezier jDRBezier2) {
        jDRBezier.control2.x = 2.0 * jDRBezier.end.x - jDRBezier2.control1.x;
        jDRBezier.control2.y = 2.0 * jDRBezier.end.y - jDRBezier2.control1.y;
    }

    public static JDRBezier constructBezier(JDRSegment jDRSegment, Point point) {
        return JDRBezier.constructBezier(jDRSegment, new Point2D.Double(point.x, point.y));
    }

    public static JDRBezier constructBezier(JDRSegment jDRSegment, Point2D point2D) {
        JDRBezier jDRBezier = new JDRBezier(jDRSegment.end, new JDRPoint(point2D));
        if (!(jDRSegment instanceof JDRBezier)) {
            Point2D point2D2 = jDRSegment.getdP();
            jDRBezier.control1 = new JDRPoint(point2D2.getX() / 3.0 + jDRBezier.start.x, point2D2.getY() / 3.0 + jDRBezier.start.y);
            return jDRBezier;
        }
        JDRBezier jDRBezier2 = (JDRBezier)jDRSegment;
        double d = jDRBezier2.start.x;
        double d2 = jDRBezier2.start.y;
        double d3 = jDRBezier2.end.x;
        double d4 = jDRBezier2.end.y;
        double d5 = point2D.getX();
        double d6 = point2D.getY();
        double d7 = (d - d3) / 3.0;
        double d8 = (d2 - d4) / 3.0;
        double d9 = (d5 + 5.0 * d3) / 3.0;
        double d10 = (d6 + 5.0 * d4) / 3.0;
        double d11 = -4.0 * d3;
        double d12 = -4.0 * d4;
        double d13 = (3.0 * d9 - d7 + d11) / 2.0;
        double d14 = (3.0 * d10 - d8 + d12) / 2.0;
        double d15 = d9 - d13;
        double d16 = d10 - d14;
        double d17 = d7 + d15;
        double d18 = d8 + d16;
        double d19 = 2.0 * d3 - d15;
        double d20 = 2.0 * d4 - d16;
        jDRBezier2.control1.x = d17;
        jDRBezier2.control1.y = d18;
        jDRBezier2.control2.x = d15;
        jDRBezier2.control2.y = d16;
        jDRBezier.control1.x = d19;
        jDRBezier.control1.y = d20;
        jDRBezier.control2.x = d13;
        jDRBezier.control2.y = d14;
        return jDRBezier;
    }

    @Override
    public JDRPathSegment split() {
        double d = this.start.x;
        double d2 = this.start.y;
        double d3 = this.control1.x;
        double d4 = this.control1.y;
        double d5 = this.control2.x;
        double d6 = this.control2.y;
        double d7 = this.end.x;
        double d8 = this.end.y;
        JDRPoint jDRPoint = new JDRPoint((d7 + 3.0 * d5 + 3.0 * d3 + d) / 8.0, (d8 + 3.0 * d6 + 3.0 * d4 + d2) / 8.0);
        JDRPoint jDRPoint2 = new JDRPoint(0.5 * (d3 + d), 0.5 * (d4 + d2));
        JDRPoint jDRPoint3 = new JDRPoint(0.25 * (d5 + 2.0 * d3 + d), 0.25 * (d6 + 2.0 * d4 + d2));
        JDRPoint jDRPoint4 = new JDRPoint(0.25 * (d7 + 2.0 * d5 + d3), 0.25 * (d8 + 2.0 * d6 + d4));
        JDRPoint jDRPoint5 = new JDRPoint(0.5 * (d7 + d5), 0.5 * (d8 + d6));
        JDRBezier jDRBezier = new JDRBezier(jDRPoint, jDRPoint4, jDRPoint5, this.end);
        this.control1 = jDRPoint2;
        this.control2 = jDRPoint3;
        this.end = jDRPoint;
        return jDRBezier;
    }

    @Override
    public Object clone() {
        JDRBezier jDRBezier = new JDRBezier((JDRPoint)this.start.clone(), (JDRPoint)this.control1.clone(), (JDRPoint)this.control2.clone(), (JDRPoint)this.end.clone());
        return jDRBezier;
    }

    public void makeEqual(JDRBezier jDRBezier) {
        super.makeEqual(jDRBezier);
        this.control1.makeEqual(jDRBezier.control1);
        this.control2.makeEqual(jDRBezier.control2);
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof JDRSegment)) {
            return false;
        }
        JDRBezier jDRBezier = (JDRBezier)object;
        return this.control1.equals(jDRBezier.control1) && this.control2.equals(jDRBezier.control2);
    }

    @Override
    public void setEditedControls(boolean bl) {
        super.setEditedControls(bl);
        this.control1.selected = bl;
        this.control2.selected = bl;
    }

    @Override
    public JDRPoint getEditedControl() {
        if (this.start.selected) {
            return this.start;
        }
        if (this.control1.selected) {
            return this.control1;
        }
        if (this.control2.selected) {
            return this.control2;
        }
        if (this.end.selected) {
            return this.end;
        }
        return null;
    }

    @Override
    public JDRPoint getControl(Point point, boolean bl) {
        if (this.control2.contains(point)) {
            return this.control2;
        }
        if (this.control1.contains(point)) {
            return this.control1;
        }
        if (this.start.contains(point)) {
            return this.start;
        }
        if (bl && this.end.contains(point)) {
            return this.end;
        }
        return null;
    }

    public JDRPoint getControl1() {
        return this.control1;
    }

    public JDRPoint getControl2() {
        return this.control2;
    }

    public void setControl1(double d, double d2) {
        this.control1.x = d;
        this.control1.y = d2;
    }

    public void setControl2(double d, double d2) {
        this.control2.x = d;
        this.control2.y = d2;
    }

    @Override
    public void setSelected(boolean bl) {
        this.selected = bl;
        if (!bl) {
            this.start.selected = false;
            this.control1.selected = false;
            this.control2.selected = false;
            this.end.selected = false;
        }
    }

    @Override
    public void saveSVG(PrintWriter printWriter) throws IOException {
        printWriter.print("C ");
        this.control1.saveSVG(printWriter);
        this.control2.saveSVG(printWriter);
        this.end.saveSVG(printWriter);
    }

    @Override
    public void saveEPS(PrintWriter printWriter) throws IOException {
        this.control1.saveEPS(printWriter);
        this.control2.saveEPS(printWriter);
        this.end.saveEPS(printWriter);
        printWriter.println("curveto");
    }

    @Override
    public String pgf(AffineTransform affineTransform) {
        return "\\pgfpathcurveto{" + this.control1.pgf(affineTransform) + "}{" + this.control2.pgf(affineTransform) + "}{" + this.end.pgf(affineTransform) + "}";
    }

    @Override
    public void appendToGeneralPath(GeneralPath generalPath) {
        generalPath.curveTo((float)this.control1.x, (float)this.control1.y, (float)this.control2.x, (float)this.control2.y, (float)this.end.x, (float)this.end.y);
    }

    @Override
    public void appendReflectionToGeneralPath(GeneralPath generalPath, JDRLine jDRLine) {
        Point2D point2D = this.control1.getReflection(jDRLine);
        Point2D point2D2 = this.control2.getReflection(jDRLine);
        Point2D point2D3 = this.start.getReflection(jDRLine);
        generalPath.curveTo((float)point2D2.getX(), (float)point2D2.getY(), (float)point2D.getX(), (float)point2D.getY(), (float)point2D3.getX(), (float)point2D3.getY());
    }

    @Override
    public JDRPathSegment getReflection(JDRLine jDRLine) {
        Point2D point2D = this.start.getReflection(jDRLine);
        Point2D point2D2 = this.control1.getReflection(jDRLine);
        Point2D point2D3 = this.control2.getReflection(jDRLine);
        Point2D point2D4 = this.end.getReflection(jDRLine);
        return new JDRBezier(point2D, point2D2, point2D3, point2D4);
    }

    @Override
    public String toString() {
        return "JDRBezier:(" + this.start.x + "," + this.start.y + ")(" + this.control1.x + "," + this.control1.y + ")(" + this.control2.x + "," + this.control2.y + ")(" + this.end.x + "," + this.end.y + "),startMarker=" + this.startMarker + ",endMarker=" + this.endMarker;
    }

    @Override
    public JDRObjectLoaderListener getListener() {
        return listener;
    }

    @Override
    public String info() {
        return "bezier[" + this.start.info() + "," + this.control1 + "," + this.control2 + "," + this.end.info() + "]";
    }

    @Override
    public int controlCount() {
        return 3;
    }

    @Override
    public JDRPoint getControl(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return this.start;
        }
        if (n == 1) {
            return this.control1;
        }
        if (n == 2) {
            return this.control2;
        }
        throw new IndexOutOfBoundsException("No control point at index " + n);
    }

    @Override
    public int getControlIndex(JDRPoint jDRPoint) throws NoSuchElementException {
        if (jDRPoint == this.start) {
            return 0;
        }
        if (jDRPoint == this.control1) {
            return 1;
        }
        if (jDRPoint == this.control2) {
            return 2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean isGap() {
        return false;
    }
}

