/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.DashPattern;
import uk.ac.uea.cmp.nlct.jdr.InvalidCapStyleException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidJoinStyleException;
import uk.ac.uea.cmp.nlct.jdr.InvalidMarkerTypeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidMitreLimitException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPenWidthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidRepeatValueException;
import uk.ac.uea.cmp.nlct.jdr.InvalidWindingRuleException;
import uk.ac.uea.cmp.nlct.jdr.JDRBasicPathStyleListener;
import uk.ac.uea.cmp.nlct.jdr.JDRGradient;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaint;
import uk.ac.uea.cmp.nlct.jdr.JDRPathIterator;
import uk.ac.uea.cmp.nlct.jdr.JDRPathSegment;
import uk.ac.uea.cmp.nlct.jdr.JDRPathStyleListener;
import uk.ac.uea.cmp.nlct.jdr.JDRRadial;
import uk.ac.uea.cmp.nlct.jdr.JDRShape;
import uk.ac.uea.cmp.nlct.jdr.JDRStroke;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.marker.JDRMarker;

public class JDRBasicStroke
implements JDRStroke {
    public DashPattern dashPattern;
    protected int capStyle;
    protected int joinStyle;
    protected int windingRule;
    protected double mitreLimit;
    private double penWidth;
    private JDRMarker startMarker;
    private JDRMarker midMarker;
    private JDRMarker endMarker;
    private static JDRPathStyleListener pathStyleListener = new JDRBasicPathStyleListener();

    public JDRBasicStroke() {
        this.capStyle = 2;
        this.joinStyle = 0;
        this.dashPattern = new DashPattern();
        this.penWidth = 1.0;
        this.mitreLimit = 10.0;
        this.windingRule = 0;
        try {
            this.startMarker = new JDRMarker(1.0, 1, false);
            this.midMarker = new JDRMarker(1.0, 1, false);
            this.endMarker = new JDRMarker(1.0, 1, false);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
    }

    public JDRBasicStroke(double d, int n, int n2, double d2, DashPattern dashPattern) throws InvalidMitreLimitException, InvalidJoinStyleException, InvalidCapStyleException, InvalidPenWidthException {
        this.setCapStyle(n);
        this.setJoinStyle(n2);
        this.dashPattern = dashPattern;
        this.setMitreLimit(d2);
        this.windingRule = 0;
        try {
            this.startMarker = new JDRMarker(1.0, 1, false);
            this.midMarker = new JDRMarker(1.0, 1, false);
            this.endMarker = new JDRMarker(1.0, 1, false);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        this.setPenWidth(d);
    }

    public JDRBasicStroke(double d, int n, int n2, double d2, DashPattern dashPattern, int n3) throws InvalidMitreLimitException, InvalidJoinStyleException, InvalidCapStyleException, InvalidPenWidthException, InvalidWindingRuleException {
        this.setCapStyle(n);
        this.setJoinStyle(n2);
        this.dashPattern = dashPattern;
        this.setMitreLimit(d2);
        this.setWindingRule(n3);
        try {
            this.startMarker = new JDRMarker(1.0, 1, false);
            this.midMarker = new JDRMarker(1.0, 1, false);
            this.endMarker = new JDRMarker(1.0, 1, false);
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
        this.setPenWidth(d);
    }

    public void setPenWidth(double d) throws InvalidPenWidthException {
        if (d < 0.0) {
            throw new InvalidPenWidthException(d);
        }
        this.penWidth = d;
        this.startMarker.setPenWidth(d);
        this.midMarker.setPenWidth(d);
        this.endMarker.setPenWidth(d);
    }

    public double getPenWidth() {
        return this.penWidth;
    }

    public void fade(double d) {
        this.startMarker.fade(d);
        this.midMarker.fade(d);
        this.endMarker.fade(d);
    }

    public JDRPaint getStartArrowColour() {
        return this.startMarker.fillPaint;
    }

    public JDRPaint getMidArrowColour() {
        return this.midMarker.fillPaint;
    }

    public JDRPaint getEndArrowColour() {
        return this.endMarker.fillPaint;
    }

    public void setStartArrowColour(JDRPaint jDRPaint) {
        this.startMarker.setFillPaint(jDRPaint);
    }

    public void setMidArrowColour(JDRPaint jDRPaint) {
        this.midMarker.setFillPaint(jDRPaint);
    }

    public void setEndArrowColour(JDRPaint jDRPaint) {
        this.endMarker.setFillPaint(jDRPaint);
    }

    public int getStartArrowType() {
        return this.startMarker.getType();
    }

    public int getMidArrowType() {
        return this.midMarker.getType();
    }

    public int getEndArrowType() {
        return this.endMarker.getType();
    }

    public int getStartArrowRepeated() {
        return this.startMarker.getRepeated();
    }

    public int getMidArrowRepeated() {
        return this.midMarker.getRepeated();
    }

    public int getEndArrowRepeated() {
        return this.endMarker.getRepeated();
    }

    public boolean getStartArrowReverse() {
        return this.startMarker.isReversed();
    }

    public boolean getMidArrowReverse() {
        return this.midMarker.isReversed();
    }

    public boolean getEndArrowReverse() {
        return this.endMarker.isReversed();
    }

    public boolean getStartArrowAutoOrient() {
        return this.startMarker.getAutoOrient();
    }

    public double getStartArrowAngle() {
        return this.startMarker.getAngle();
    }

    public boolean getMidArrowAutoOrient() {
        return this.midMarker.getAutoOrient();
    }

    public double getMidArrowAngle() {
        return this.midMarker.getAngle();
    }

    public boolean getEndArrowAutoOrient() {
        return this.endMarker.getAutoOrient();
    }

    public double getEndArrowAngle() {
        return this.endMarker.getAngle();
    }

    public double getStartArrowSize() {
        return this.startMarker.getSize();
    }

    public double getMidArrowSize() {
        return this.midMarker.getSize();
    }

    public double getEndArrowSize() {
        return this.endMarker.getSize();
    }

    public boolean getStartUserOffsetEnabled() {
        return this.startMarker.isUserOffsetEnabled();
    }

    public boolean getMidUserOffsetEnabled() {
        return this.midMarker.isUserOffsetEnabled();
    }

    public boolean getEndUserOffsetEnabled() {
        return this.endMarker.isUserOffsetEnabled();
    }

    public void setStartUserOffsetEnabled(boolean bl) {
        this.startMarker.enableUserOffset(bl);
    }

    public void setStartOverlay(boolean bl) {
        this.startMarker.setOverlay(bl);
    }

    public void setMidOverlay(boolean bl) {
        this.midMarker.setOverlay(bl);
    }

    public void setEndOverlay(boolean bl) {
        this.endMarker.setOverlay(bl);
    }

    public void setMidUserOffsetEnabled(boolean bl) {
        this.midMarker.enableUserOffset(bl);
    }

    public void setEndUserOffsetEnabled(boolean bl) {
        this.endMarker.enableUserOffset(bl);
    }

    public double getStartOffset() {
        return this.startMarker.getOffset();
    }

    public double getMidOffset() {
        return this.midMarker.getOffset();
    }

    public double getEndOffset() {
        return this.endMarker.getOffset();
    }

    public void setStartOffset(double d) {
        this.startMarker.setOffset(d);
    }

    public void setMidOffset(double d) {
        this.midMarker.setOffset(d);
    }

    public void setEndOffset(double d) {
        this.endMarker.setOffset(d);
    }

    public boolean getStartRepeatOffsetEnabled() {
        return this.startMarker.isUserRepeatOffsetEnabled();
    }

    public boolean getMidRepeatOffsetEnabled() {
        return this.midMarker.isUserRepeatOffsetEnabled();
    }

    public boolean getEndRepeatOffsetEnabled() {
        return this.endMarker.isUserRepeatOffsetEnabled();
    }

    public void setStartRepeatOffsetEnabled(boolean bl) {
        this.startMarker.enableUserRepeatOffset(bl);
    }

    public void setMidRepeatOffsetEnabled(boolean bl) {
        this.midMarker.enableUserRepeatOffset(bl);
    }

    public void setEndRepeatOffsetEnabled(boolean bl) {
        this.endMarker.enableUserRepeatOffset(bl);
    }

    public double getStartRepeatOffset() {
        return this.startMarker.getRepeatOffset();
    }

    public double getMidRepeatOffset() {
        return this.midMarker.getRepeatOffset();
    }

    public double getEndRepeatOffset() {
        return this.endMarker.getOffset();
    }

    public void setStartRepeatOffset(double d) {
        this.startMarker.setRepeatOffset(d);
    }

    public void setMidRepeatOffset(double d) {
        this.midMarker.setRepeatOffset(d);
    }

    public void setEndRepeatOffset(double d) {
        this.endMarker.setRepeatOffset(d);
    }

    public void setStartArrowRepeat(int n) throws InvalidRepeatValueException {
        this.startMarker.setRepeated(n);
    }

    public void setStartArrowReverse(boolean bl) {
        this.startMarker.setReversed(bl);
    }

    public void setStartArrowSize(double d) {
        this.startMarker.setSize(d);
    }

    public void setStartArrowAutoOrient(boolean bl) {
        this.startMarker.setOrient(bl);
    }

    public void setStartArrowAngle(double d) {
        this.startMarker.setAngle(d);
    }

    public void setStartArrow(JDRMarker jDRMarker) {
        this.startMarker = jDRMarker;
        this.startMarker.setPenWidth(this.penWidth);
    }

    public void setStartArrow(int n) throws InvalidMarkerTypeException {
        try {
            this.setStartArrow(n, this.getStartArrowSize(), this.getStartArrowRepeated(), this.getStartArrowReverse());
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
    }

    public void setStartArrow(int n, double d, int n2, boolean bl) throws InvalidMarkerTypeException, InvalidRepeatValueException {
        this.startMarker = JDRMarker.getPredefinedMarker(n, this.penWidth, n2, bl, d);
    }

    public void setMidArrowRepeat(int n) throws InvalidRepeatValueException {
        this.midMarker.setRepeated(n);
    }

    public void setMidArrowReverse(boolean bl) {
        this.midMarker.setReversed(bl);
    }

    public void setMidArrowAutoOrient(boolean bl) {
        this.midMarker.setOrient(bl);
    }

    public void setMidArrowAngle(double d) {
        this.midMarker.setAngle(d);
    }

    public void setMidArrowSize(double d) {
        this.midMarker.setSize(d);
    }

    public void setMidArrow(JDRMarker jDRMarker) {
        this.midMarker = jDRMarker;
        this.midMarker.setPenWidth(this.penWidth);
    }

    public void setMidArrow(int n) throws InvalidMarkerTypeException {
        try {
            this.setMidArrow(n, this.getMidArrowSize(), this.getMidArrowRepeated(), this.getMidArrowReverse());
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
    }

    public void setMidArrow(int n, double d, int n2, boolean bl) throws InvalidMarkerTypeException, InvalidRepeatValueException {
        this.midMarker = JDRMarker.getPredefinedMarker(n, this.penWidth, n2, bl, d);
    }

    public void setEndArrowRepeat(int n) throws InvalidRepeatValueException {
        this.endMarker.setRepeated(n);
    }

    public void setEndArrowReverse(boolean bl) {
        this.endMarker.setReversed(bl);
    }

    public void setEndArrowAutoOrient(boolean bl) {
        this.endMarker.setOrient(bl);
    }

    public void setEndArrowAngle(double d) {
        this.endMarker.setAngle(d);
    }

    public void setEndArrowSize(double d) {
        this.endMarker.setSize(d);
    }

    public void setEndArrow(JDRMarker jDRMarker) {
        this.endMarker = jDRMarker;
        this.endMarker.setPenWidth(this.penWidth);
    }

    public void setEndArrow(int n) throws InvalidMarkerTypeException {
        try {
            this.setEndArrow(n, this.getEndArrowSize(), this.getEndArrowRepeated(), this.getEndArrowReverse());
        }
        catch (InvalidRepeatValueException invalidRepeatValueException) {
            // empty catch block
        }
    }

    public void setEndArrow(int n, double d, int n2, boolean bl) throws InvalidMarkerTypeException, InvalidRepeatValueException {
        this.endMarker = JDRMarker.getPredefinedMarker(n, this.penWidth, n2, bl, d);
    }

    @Override
    public Shape createStrokedShape(Shape shape) {
        BasicStroke basicStroke = new BasicStroke((float)this.penWidth, this.capStyle, this.joinStyle, (float)this.mitreLimit, this.dashPattern.pattern, this.dashPattern.offset);
        Shape shape2 = basicStroke.createStrokedShape(shape);
        return shape2;
    }

    public String pgf() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = new String("\\pgfsetlinewidth{" + this.penWidth + "bp}" + string);
        switch (this.capStyle) {
            case 2: {
                string2 = string2 + "\\pgfsetrectcap ";
                break;
            }
            case 0: {
                string2 = string2 + "\\pgfsetbuttcap ";
                break;
            }
            case 1: {
                string2 = string2 + "\\pgfsetroundcap ";
            }
        }
        string2 = string2 + string;
        switch (this.joinStyle) {
            case 0: {
                string2 = string2 + "\\pgfsetmiterjoin ";
                string2 = string2 + "\\pgfsetmiterlimit{" + this.mitreLimit + "}";
                break;
            }
            case 2: {
                string2 = string2 + "\\pgfsetbeveljoin ";
                break;
            }
            case 1: {
                string2 = string2 + "\\pgfsetroundjoin ";
            }
        }
        if (this.dashPattern.pattern != null) {
            string2 = string2 + string;
            string2 = string2 + "\\pgfsetdash{";
            for (int i = 0; i < this.dashPattern.pattern.length; ++i) {
                string2 = string2 + "{" + this.dashPattern.pattern[i] + "bp}";
            }
            string2 = string2 + "}{" + this.dashPattern.offset + "bp}";
        }
        return string2 + string;
    }

    @Override
    public Object clone() {
        JDRBasicStroke jDRBasicStroke = new JDRBasicStroke();
        jDRBasicStroke.penWidth = this.penWidth;
        jDRBasicStroke.capStyle = this.capStyle;
        jDRBasicStroke.joinStyle = this.joinStyle;
        jDRBasicStroke.mitreLimit = this.mitreLimit;
        jDRBasicStroke.dashPattern = (DashPattern)this.dashPattern.clone();
        jDRBasicStroke.windingRule = this.windingRule;
        jDRBasicStroke.startMarker = (JDRMarker)this.startMarker.clone();
        jDRBasicStroke.midMarker = (JDRMarker)this.midMarker.clone();
        jDRBasicStroke.endMarker = (JDRMarker)this.endMarker.clone();
        return jDRBasicStroke;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof JDRBasicStroke)) {
            return false;
        }
        JDRBasicStroke jDRBasicStroke = (JDRBasicStroke)object;
        if (this.penWidth != jDRBasicStroke.penWidth) {
            return false;
        }
        if (this.capStyle != jDRBasicStroke.capStyle) {
            return false;
        }
        if (this.joinStyle != jDRBasicStroke.joinStyle) {
            return false;
        }
        if (this.mitreLimit != jDRBasicStroke.mitreLimit) {
            return false;
        }
        if (this.windingRule != jDRBasicStroke.windingRule) {
            return false;
        }
        if (!this.dashPattern.equals(jDRBasicStroke.dashPattern)) {
            return false;
        }
        if (!this.startMarker.equals(jDRBasicStroke.startMarker)) {
            return false;
        }
        if (!this.midMarker.equals(jDRBasicStroke.midMarker)) {
            return false;
        }
        return this.endMarker.equals(jDRBasicStroke.endMarker);
    }

    @Override
    public void save(DataOutputStream dataOutputStream, float f) throws IOException {
        dataOutputStream.writeFloat((float)this.penWidth);
        this.dashPattern.save(dataOutputStream, f);
        dataOutputStream.writeByte((byte)this.capStyle);
        dataOutputStream.writeByte((byte)this.joinStyle);
        if (this.joinStyle == 0) {
            dataOutputStream.writeFloat((float)this.mitreLimit);
        }
        dataOutputStream.writeByte((byte)this.windingRule);
        this.startMarker.save(dataOutputStream, f);
        if (f >= 1.1f) {
            this.midMarker.save(dataOutputStream, f);
        }
        this.endMarker.save(dataOutputStream, f);
    }

    public static JDRBasicStroke read(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException, EOFException {
        byte by;
        double d = dataInputStream.readFloat();
        if (d < 0.0) {
            throw new InvalidPenWidthException(d);
        }
        DashPattern dashPattern = DashPattern.read(dataInputStream, f);
        byte by2 = dataInputStream.readByte();
        if (by2 < 0 || by2 > 2) {
            throw new InvalidCapStyleException(by2);
        }
        byte by3 = dataInputStream.readByte();
        if (by3 < 0 || by3 > 2) {
            throw new InvalidJoinStyleException(by3);
        }
        double d2 = 10.0;
        if (by3 == 0) {
            d2 = dataInputStream.readFloat();
        }
        if ((by = dataInputStream.readByte()) < 0 || by > 1) {
            throw new InvalidWindingRuleException(by);
        }
        JDRBasicStroke jDRBasicStroke = new JDRBasicStroke(d, by2, by3, d2, dashPattern, by);
        jDRBasicStroke.startMarker = JDRMarker.read(dataInputStream, f);
        jDRBasicStroke.startMarker.setPenWidth(d);
        if (f >= 1.1f) {
            jDRBasicStroke.midMarker = JDRMarker.read(dataInputStream, f);
            jDRBasicStroke.midMarker.setPenWidth(d);
        }
        jDRBasicStroke.endMarker = JDRMarker.read(dataInputStream, f);
        jDRBasicStroke.endMarker.setPenWidth(d);
        return jDRBasicStroke;
    }

    @Override
    public void saveAJR(PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        AJR.writeFloat(printWriter, (float)this.penWidth);
        this.dashPattern.saveAJR(printWriter, f);
        AJR.writeInt(printWriter, this.capStyle);
        AJR.writeInt(printWriter, this.joinStyle);
        if (this.joinStyle == 0) {
            AJR.writeFloat(printWriter, (float)this.mitreLimit);
        }
        AJR.writeInt(printWriter, this.windingRule);
        this.startMarker.saveAJR(printWriter, f);
        if (f >= 1.1f) {
            this.midMarker.saveAJR(printWriter, f);
        }
        this.endMarker.saveAJR(printWriter, f);
    }

    public static JDRBasicStroke readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        int n;
        double d = AJR.readFloat(bufferedReader);
        if (d < 0.0) {
            throw new InvalidPenWidthException(d, AJR.getLineNum());
        }
        DashPattern dashPattern = DashPattern.readAJR(bufferedReader, f);
        int n2 = AJR.readInt(bufferedReader);
        if (n2 < 0 || n2 > 2) {
            throw new InvalidCapStyleException(n2, AJR.getLineNum());
        }
        int n3 = AJR.readInt(bufferedReader);
        if (n3 < 0 || n3 > 2) {
            throw new InvalidJoinStyleException(n3, AJR.getLineNum());
        }
        double d2 = 10.0;
        if (n3 == 0) {
            d2 = AJR.readFloat(bufferedReader);
        }
        if ((n = AJR.readInt(bufferedReader)) < 0 || n > 1) {
            throw new InvalidWindingRuleException(n, AJR.getLineNum());
        }
        JDRBasicStroke jDRBasicStroke = new JDRBasicStroke(d, n2, n3, d2, dashPattern, n);
        jDRBasicStroke.startMarker = JDRMarker.readAJR(bufferedReader, f);
        jDRBasicStroke.startMarker.setPenWidth(d);
        if (f >= 1.1f) {
            jDRBasicStroke.midMarker = JDRMarker.readAJR(bufferedReader, f);
            jDRBasicStroke.midMarker.setPenWidth(d);
        }
        jDRBasicStroke.endMarker = JDRMarker.readAJR(bufferedReader, f);
        jDRBasicStroke.endMarker.setPenWidth(d);
        return jDRBasicStroke;
    }

    public String svg(JDRPaint jDRPaint) {
        String string = this.windingRule == 0 ? "evenodd" : "nonzero";
        String string2 = "square";
        switch (this.capStyle) {
            case 0: {
                string2 = "butt";
                break;
            }
            case 1: {
                string2 = "round";
            }
        }
        String string3 = "miter";
        switch (this.joinStyle) {
            case 2: {
                string3 = "bevel";
                break;
            }
            case 1: {
                string3 = "round";
            }
        }
        String string4 = System.getProperty("line.separator", "\n");
        return "fill-rule=\"" + string + "\"" + string4 + "      stroke-width=\"" + this.penWidth + "\"" + string4 + "      stroke-linecap=\"" + string2 + "\"" + string4 + "      stroke-linejoin=\"" + string3 + "\"" + string4 + "      stroke-miterlimit=\"" + this.mitreLimit + "\"" + string4 + "      " + this.dashPattern.svg() + string4 + "      " + this.svgStartMarker(jDRPaint) + string4 + "      " + this.svgMidMarker(jDRPaint) + string4 + "      " + this.svgEndMarker(jDRPaint);
    }

    public String svgStartMarker(JDRPaint jDRPaint) {
        return this.startMarker.svgStartMarker(jDRPaint);
    }

    public String svgMidMarker(JDRPaint jDRPaint) {
        return this.midMarker.svgMidMarker(jDRPaint);
    }

    public String svgEndMarker(JDRPaint jDRPaint) {
        return this.endMarker.svgEndMarker(jDRPaint);
    }

    public static void svgDefs(PrintWriter printWriter, JDRGroup jDRGroup) throws IOException {
        JDRMarker.svgDefs(printWriter, jDRGroup);
    }

    public void drawStartArrowShape(JDRPathSegment jDRPathSegment, Graphics graphics) {
        this.getStartArrow().draw(graphics, this.penWidth, jDRPathSegment, true);
    }

    public void drawMidArrowShape(JDRPathSegment jDRPathSegment, Graphics graphics) {
        this.getMidArrow().draw(graphics, this.penWidth, jDRPathSegment, false);
    }

    public void drawEndArrowShape(JDRPathSegment jDRPathSegment, Graphics graphics) {
        this.getEndArrow().draw(graphics, this.penWidth, jDRPathSegment, false);
    }

    public void saveEPSStartArrowShape(JDRPaint jDRPaint, BBox bBox, JDRPathSegment jDRPathSegment, PrintWriter printWriter) throws IOException {
        this.getStartArrow().saveEPS(this.penWidth, jDRPaint, bBox, jDRPathSegment, true, printWriter);
    }

    public void saveEPSMidArrowShape(JDRPaint jDRPaint, BBox bBox, JDRPathSegment jDRPathSegment, PrintWriter printWriter) throws IOException {
        this.getMidArrow().saveEPS(this.penWidth, jDRPaint, bBox, jDRPathSegment, false, printWriter);
    }

    public void saveEPSEndArrowShape(JDRPaint jDRPaint, BBox bBox, JDRPathSegment jDRPathSegment, PrintWriter printWriter) throws IOException {
        this.getEndArrow().saveEPS(this.penWidth, jDRPaint, bBox, jDRPathSegment, false, printWriter);
    }

    @Override
    public void drawPath(JDRShape jDRShape, Graphics graphics) {
        this.drawPath(jDRShape, jDRShape.getGeneralPath(), graphics);
    }

    @Override
    public void drawPath(JDRShape jDRShape, GeneralPath generalPath, Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.fill(this.createStrokedShape(generalPath));
        int n = this.getStartArrowType();
        int n2 = this.getMidArrowType();
        int n3 = this.getEndArrowType();
        if (n == 0 && n2 == 0 && n3 == 0) {
            return;
        }
        JDRPathIterator jDRPathIterator = jDRShape.getIterator();
        while (jDRPathIterator.hasNext()) {
            JDRPathSegment jDRPathSegment = jDRPathIterator.next();
            JDRMarker jDRMarker = jDRPathSegment.getStartMarker();
            if (jDRMarker != null) {
                jDRMarker.draw(graphics, this.penWidth, jDRPathSegment, true);
            }
            if ((jDRMarker = jDRPathSegment.getEndMarker()) == null) continue;
            jDRMarker.draw(graphics, this.penWidth, jDRPathSegment, false);
        }
    }

    public void drawMarkers(JDRShape jDRShape, Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getStartArrowType();
        int n2 = this.getMidArrowType();
        int n3 = this.getEndArrowType();
        if (n == 0 && n2 == 0 && n3 == 0) {
            return;
        }
        JDRPathIterator jDRPathIterator = jDRShape.getIterator();
        while (jDRPathIterator.hasNext()) {
            JDRPathSegment jDRPathSegment = jDRPathIterator.next();
            JDRMarker jDRMarker = jDRPathSegment.getStartMarker();
            if (jDRMarker != null && jDRMarker.getFillPaint() != null) {
                jDRMarker.draw(graphics, this.penWidth, jDRPathSegment, true);
            }
            if ((jDRMarker = jDRPathSegment.getEndMarker()) == null || jDRMarker.getFillPaint() == null) continue;
            jDRMarker.draw(graphics, this.penWidth, jDRPathSegment, false);
        }
    }

    @Override
    public void saveEPS(JDRShape jDRShape, PrintWriter printWriter) throws IOException {
        Object object;
        JDRPaint jDRPaint = jDRShape.getLinePaint();
        BBox bBox = jDRShape.getBBox();
        printWriter.println("gsave");
        if (jDRPaint instanceof JDRGradient || jDRPaint instanceof JDRRadial) {
            object = this.getStrokedArea(jDRShape);
            EPS.fillPath((Shape)object, jDRPaint, printWriter);
        } else {
            printWriter.println("" + this.penWidth + " setlinewidth");
            switch (this.capStyle) {
                case 0: {
                    printWriter.println("0 setlinecap");
                    break;
                }
                case 1: {
                    printWriter.println("1 setlinecap");
                    break;
                }
                case 2: {
                    printWriter.println("2 setlinecap");
                }
            }
            switch (this.joinStyle) {
                case 0: {
                    printWriter.println("0 setlinejoin");
                    break;
                }
                case 1: {
                    printWriter.println("1 setlinejoin");
                    break;
                }
                case 2: {
                    printWriter.println("2 setlinejoin");
                }
            }
            printWriter.println("" + this.mitreLimit + " setmiterlimit");
            this.dashPattern.saveEPS(printWriter);
            EPS.drawPath(jDRShape.getGeneralPath(), jDRPaint, printWriter);
        }
        printWriter.println("grestore");
        if (this.getStartArrowType() == 0 && this.getMidArrowType() == 0 && this.getEndArrowType() == 0) {
            return;
        }
        object = jDRShape.getIterator();
        while (((JDRPathIterator)object).hasNext()) {
            JDRPathSegment jDRPathSegment = ((JDRPathIterator)object).next();
            JDRMarker jDRMarker = jDRPathSegment.getStartMarker();
            if (jDRMarker != null) {
                this.saveEPSStartArrowShape(jDRPaint, bBox, jDRPathSegment, printWriter);
            }
            if ((jDRMarker = jDRPathSegment.getEndMarker()) == null) continue;
            this.saveEPSEndArrowShape(jDRPaint, bBox, jDRPathSegment, printWriter);
        }
    }

    @Override
    public Shape getStrokedPath(JDRShape jDRShape) {
        GeneralPath generalPath = new GeneralPath(this.createStrokedShape(jDRShape.getGeneralPath()));
        int n = this.getStartArrowType();
        int n2 = this.getMidArrowType();
        int n3 = this.getEndArrowType();
        if (n == 0 && n2 == 0 && n3 == 0) {
            return generalPath;
        }
        JDRPathIterator jDRPathIterator = jDRShape.getIterator();
        while (jDRPathIterator.hasNext()) {
            JDRPathSegment jDRPathSegment = jDRPathIterator.next();
            JDRMarker jDRMarker = jDRPathSegment.getStartMarker();
            if (jDRMarker != null) {
                generalPath.append(jDRMarker.getCompleteShape(jDRPathSegment, true), false);
            }
            if ((jDRMarker = jDRPathSegment.getEndMarker()) == null) continue;
            generalPath.append(jDRMarker.getCompleteShape(jDRPathSegment, false), false);
        }
        return generalPath;
    }

    @Override
    public Area getStrokedArea(JDRShape jDRShape) {
        Area area = new Area(this.createStrokedShape(jDRShape.getGeneralPath()));
        int n = this.getStartArrowType();
        int n2 = this.getMidArrowType();
        int n3 = this.getEndArrowType();
        if (n == 0 && n2 == 0 && n3 == 0) {
            return area;
        }
        JDRPathIterator jDRPathIterator = jDRShape.getIterator();
        while (jDRPathIterator.hasNext()) {
            JDRPathSegment jDRPathSegment = jDRPathIterator.next();
            JDRMarker jDRMarker = jDRPathSegment.getStartMarker();
            if (jDRMarker != null) {
                area.add(new Area(jDRMarker.getCompleteShape(jDRPathSegment, true)));
            }
            if ((jDRMarker = jDRPathSegment.getEndMarker()) == null) continue;
            area.add(new Area(jDRMarker.getCompleteShape(jDRPathSegment, false)));
        }
        return area;
    }

    public Shape getStartArrowShape(JDRPathSegment jDRPathSegment) {
        return this.getStartArrow().getCompleteShape(jDRPathSegment, true);
    }

    public Shape getMidArrowShape(JDRPathSegment jDRPathSegment) {
        return this.getMidArrow().getCompleteShape(jDRPathSegment, false);
    }

    public Shape getEndArrowShape(JDRPathSegment jDRPathSegment) {
        return this.getEndArrow().getCompleteShape(jDRPathSegment, false);
    }

    public JDRMarker getStartArrow() {
        return this.startMarker;
    }

    public JDRMarker getMidArrow() {
        return this.midMarker;
    }

    public JDRMarker getEndArrow() {
        return this.endMarker;
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public void setWindingRule(int n) throws InvalidWindingRuleException {
        if (n != 0 && n != 1) {
            throw new InvalidWindingRuleException(n);
        }
        this.windingRule = n;
    }

    public void setMitreLimit(double d) throws InvalidMitreLimitException {
        if (d < 1.0) {
            throw new InvalidMitreLimitException(d);
        }
        this.mitreLimit = d;
    }

    public double getMitreLimit() {
        return this.mitreLimit;
    }

    public int getCapStyle() {
        return this.capStyle;
    }

    public void setCapStyle(int n) throws InvalidCapStyleException {
        if (n != 0 && n != 1 && n != 2) {
            throw new InvalidCapStyleException(n);
        }
        this.capStyle = n;
    }

    public int getJoinStyle() {
        return this.joinStyle;
    }

    public void setJoinStyle(int n) throws InvalidJoinStyleException {
        if (n != 0 && n != 1 && n != 2) {
            throw new InvalidJoinStyleException(n);
        }
        this.joinStyle = n;
    }

    @Override
    public JDRPathStyleListener getPathStyleListener() {
        return pathStyleListener;
    }

    @Override
    public String info() {
        String string = "Basic stroke: dash=" + this.dashPattern;
        string = string + ", cap=" + this.capStyle + ", join=" + this.joinStyle + ", mitre=" + this.mitreLimit + ", winding rule=" + this.windingRule + ", pen width=" + this.penWidth + ", start marker=" + this.startMarker + ", mid marker=" + this.midMarker + ", end marker=" + this.endMarker;
        return string;
    }
}

