/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import java.util.StringTokenizer;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFrameTypeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidIdlLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidPageListLengthException;
import uk.ac.uea.cmp.nlct.jdr.InvalidShapeException;
import uk.ac.uea.cmp.nlct.jdr.InvalidShapeIDException;
import uk.ac.uea.cmp.nlct.jdr.InvalidVAlignException;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRObject;
import uk.ac.uea.cmp.nlct.jdr.JDRPath;
import uk.ac.uea.cmp.nlct.jdr.Parshape;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class FlowFrame
implements Cloneable,
Serializable {
    public static final int STATIC = 0;
    public static final int FLOW = 1;
    public static final int DYNAMIC = 2;
    public static final int TYPEBLOCK = 3;
    public static final int STANDARD = 0;
    public static final int PARSHAPE = 1;
    public static final int SHAPEPAR = 2;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    public boolean border = false;
    private int type;
    public String label;
    public String pages;
    public double top;
    public double bottom;
    public double left;
    public double right;
    private static int maxid = 0;
    private int shape = 0;
    private int valign = 1;

    public FlowFrame(int n, boolean bl, String string, String string2) {
        this.type = n;
        this.border = bl;
        this.label = string;
        this.pages = string2;
        this.top = 0.0;
        this.bottom = 0.0;
        this.left = 0.0;
        this.right = 0.0;
        this.shape = 0;
        int n2 = this.valign = n == 0 ? 1 : 0;
        if (this.label == "") {
            this.label = "" + maxid;
        }
        ++maxid;
    }

    public FlowFrame(int n) {
        this(n, false, "", "all");
    }

    public void draw(Graphics graphics, BBox bBox) {
        double d = bBox.getMinX() + this.left;
        double d2 = bBox.getMinY() + this.top;
        double d3 = bBox.getWidth() - (this.left + this.right);
        double d4 = bBox.getHeight() - (this.top + this.bottom);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d2, d3, d4);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Font font = graphics2D.getFont();
        graphics2D.setStroke(new BasicStroke());
        graphics2D.setFont(JDRCompleteObject.annoteFont);
        graphics2D.draw(double_);
        String string = this.getDisplayLabel();
        graphics2D.drawString(string, (int)d, (int)(d2 + d4));
        graphics2D.setStroke(stroke);
        graphics2D.setFont(font);
    }

    public String getDisplayLabel() {
        String string = "";
        switch (this.type) {
            case 0: {
                string = "static:" + this.label + ":" + this.pages;
                break;
            }
            case 1: {
                string = "flow:" + this.label + ":" + this.pages;
                break;
            }
            case 2: {
                string = "dynamic:" + this.label + ":" + this.pages;
                break;
            }
            case 3: {
                string = "typeblock";
            }
        }
        return string;
    }

    public Rectangle2D getLabelBounds(BBox bBox) {
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);
        TextLayout textLayout = new TextLayout(this.getDisplayLabel(), JDRCompleteObject.annoteFont, fontRenderContext);
        double d = bBox.getMinX() + this.left;
        double d2 = bBox.getMinY() + this.top;
        double d3 = bBox.getHeight() - (this.top + this.bottom);
        Rectangle2D rectangle2D = textLayout.getBounds();
        rectangle2D.setRect(rectangle2D.getX() + d, rectangle2D.getY() + d2 + d3, rectangle2D.getWidth(), rectangle2D.getHeight());
        return rectangle2D;
    }

    public void tex(JDRObject jDRObject, Rectangle2D rectangle2D, PrintWriter printWriter, double d) throws IOException, InvalidShapeException {
        this.tex(jDRObject, rectangle2D, printWriter, "Border command for frame", d);
    }

    public void tex(JDRObject jDRObject, Rectangle2D rectangle2D, PrintWriter printWriter, String string, double d) throws IOException, InvalidShapeException {
        Object object;
        Cloneable cloneable;
        BBox bBox = jDRObject.getBBox();
        switch (this.type) {
            case 0: {
                printWriter.print("\\newstaticframe");
                break;
            }
            case 1: {
                printWriter.print("\\newflowframe");
                break;
            }
            case 2: {
                printWriter.print("\\newdynamicframe");
                break;
            }
            case 3: {
                printWriter.println("\\geometry{lmargin=" + PGF.format(this.left) + "bp,rmargin=" + PGF.format(this.right) + "bp,tmargin=" + PGF.format(this.top) + "bp,bmargin=" + PGF.format(this.bottom) + "bp}");
                return;
            }
        }
        double d2 = rectangle2D.getX();
        double d3 = bBox.getMinX() - d2 + this.left;
        double d4 = rectangle2D.getY();
        double d5 = d4 + rectangle2D.getHeight() - bBox.getMaxY() + this.bottom;
        double d6 = bBox.getWidth() - (this.left + this.right);
        double d7 = bBox.getHeight() - (this.bottom + this.top);
        printWriter.println("[" + this.pages + "]{" + PGF.format(d6) + "bp}{" + PGF.format(d7) + "bp}{" + PGF.format(d3) + "bp}{" + PGF.format(d5) + "bp}[" + this.label + "]");
        printWriter.println();
        if (this.border) {
            printWriter.println("%" + string + " '" + this.label + "'");
            printWriter.println("\\expandafter\\def\\csname @flf@border@" + this.label + "\\endcsname#1{%");
            printWriter.println("\\begin{pgfpicture}{0bp}{0bp}{" + PGF.format(bBox.getWidth()) + "bp}{" + PGF.format(bBox.getHeight()) + "bp}");
            cloneable = new AffineTransform(1.0, 0.0, 0.0, -1.0, -bBox.getMinX(), bBox.getMaxY());
            printWriter.println("\\pgfputat{" + PGF.point(-this.left, -this.bottom) + "}{%");
            object = jDRObject.pgf((AffineTransform)cloneable);
            printWriter.print((String)object);
            printWriter.println("}");
            printWriter.println("\\pgfputat{\\pgfpoint{0bp}{0bp}}{\\pgftext[left,bottom]{#1}}");
            printWriter.println("\\end{pgfpicture}}");
            switch (this.type) {
                case 0: {
                    printWriter.println("\\setstaticframe*");
                    break;
                }
                case 1: {
                    printWriter.println("\\setflowframe*");
                    break;
                }
                case 2: {
                    printWriter.println("\\setdynamicframe*");
                }
            }
            printWriter.println("{" + this.label + "}{offset=0pt,border={@flf@border@" + this.label + "}}");
            printWriter.println();
        }
        if (this.shape != 0 && (this.type == 0 || this.type == 2) && jDRObject instanceof JDRPath) {
            cloneable = (JDRPath)jDRObject;
            object = this.shape == 1 ? cloneable.parshape(null, d, false) : cloneable.shapepar(null, d, false);
            String string2 = ((Parshape)object).string;
            if (this.type == 0) {
                printWriter.println("\\setstaticframe*{" + this.label + "}{shape={" + string2 + "}}");
            } else {
                printWriter.println("\\setdynamicframe*{" + this.label + "}{shape={" + string2 + "}}");
            }
        }
        if (this.type == 0 || this.type == 2) {
            printWriter.print("\\set" + (this.type == 0 ? "static" : "dynamic") + "frame*{" + this.label + "}{valign=");
            switch (this.valign) {
                case 0: {
                    printWriter.print("t");
                    break;
                }
                case 1: {
                    printWriter.print("c");
                    break;
                }
                case 2: {
                    printWriter.print("b");
                }
            }
            printWriter.println("}");
        }
    }

    public void save(DataOutputStream dataOutputStream, float f) throws IOException {
        dataOutputStream.writeByte((byte)this.type);
        if (this.type != 3) {
            dataOutputStream.writeBoolean(this.border);
            dataOutputStream.writeInt(this.label.length());
            dataOutputStream.writeChars(this.label);
            dataOutputStream.writeInt(this.pages.length());
            dataOutputStream.writeChars(this.pages);
        }
        dataOutputStream.writeFloat((float)this.top);
        dataOutputStream.writeFloat((float)this.bottom);
        dataOutputStream.writeFloat((float)this.left);
        dataOutputStream.writeFloat((float)this.right);
        if (f >= 1.2f && (this.type == 0 || this.type == 2)) {
            dataOutputStream.writeByte((byte)this.shape);
            if (f >= 1.3f) {
                dataOutputStream.writeByte((byte)this.valign);
            }
        }
    }

    public static FlowFrame read(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        byte by = dataInputStream.readByte();
        if (by < 0 || by > 3) {
            throw new InvalidFrameTypeException(by);
        }
        boolean bl = false;
        String string = "";
        String string2 = "all";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (by != 3) {
            int n;
            char[] cArray;
            bl = dataInputStream.readBoolean();
            int n2 = dataInputStream.readInt();
            if (n2 > 0) {
                cArray = new char[n2];
                for (n = 0; n < n2; ++n) {
                    cArray[n] = dataInputStream.readChar();
                }
                string = new String(cArray);
            } else if (n2 < 0) {
                throw new InvalidIdlLengthException(n2);
            }
            n2 = dataInputStream.readInt();
            if (n2 > 0) {
                cArray = new char[n2];
                for (n = 0; n < n2; ++n) {
                    cArray[n] = dataInputStream.readChar();
                }
                string2 = new String(cArray);
            } else if (n2 < 0) {
                throw new InvalidPageListLengthException(n2);
            }
        }
        d = dataInputStream.readFloat();
        d2 = dataInputStream.readFloat();
        d3 = dataInputStream.readFloat();
        d4 = dataInputStream.readFloat();
        FlowFrame flowFrame = new FlowFrame(by, bl, string, string2);
        flowFrame.top = d;
        flowFrame.bottom = d2;
        flowFrame.left = d3;
        flowFrame.right = d4;
        if (f >= 1.2f && (flowFrame.getType() == 0 || flowFrame.getType() == 2)) {
            flowFrame.setShape(dataInputStream.readByte());
            if (f >= 1.3f) {
                flowFrame.setVAlign(dataInputStream.readByte());
            }
        }
        return flowFrame;
    }

    public void saveAJR(PrintWriter printWriter, float f) throws IOException {
        AJR.writeInt(printWriter, this.type);
        if (this.type != 3) {
            AJR.writeBoolean(printWriter, this.border);
            AJR.writeInt(printWriter, this.label.length());
            printWriter.print(this.label + " ");
            AJR.writeInt(printWriter, this.pages.length());
            printWriter.print(this.pages + " ");
        }
        AJR.writeFloat(printWriter, (float)this.top);
        AJR.writeFloat(printWriter, (float)this.bottom);
        AJR.writeFloat(printWriter, (float)this.left);
        AJR.writeFloat(printWriter, (float)this.right);
        if (f >= 1.2f && (this.type == 0 || this.type == 2)) {
            AJR.writeInt(printWriter, this.shape);
            if (f >= 1.3f) {
                AJR.writeInt(printWriter, this.valign);
            }
        }
    }

    public static FlowFrame readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        int n = AJR.readInt(bufferedReader);
        if (n < 0 || n > 3) {
            throw new InvalidFrameTypeException(n, AJR.getLineNum());
        }
        boolean bl = false;
        String string = "";
        String string2 = "all";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        if (n != 3) {
            bl = AJR.readBoolean(bufferedReader);
            int n2 = AJR.readInt(bufferedReader);
            if (n2 < 0) {
                throw new InvalidIdlLengthException(n2, AJR.getLineNum());
            }
            if (n2 > 0) {
                string = AJR.readString(bufferedReader, n2);
            }
            if ((n2 = AJR.readInt(bufferedReader)) < 0) {
                throw new InvalidPageListLengthException(n2, AJR.getLineNum());
            }
            if (n2 > 0) {
                string2 = AJR.readString(bufferedReader, n2);
            }
        }
        d = AJR.readFloat(bufferedReader);
        d2 = AJR.readFloat(bufferedReader);
        d3 = AJR.readFloat(bufferedReader);
        d4 = AJR.readFloat(bufferedReader);
        FlowFrame flowFrame = new FlowFrame(n, bl, string, string2);
        flowFrame.top = d;
        flowFrame.bottom = d2;
        flowFrame.left = d3;
        flowFrame.right = d4;
        if (f >= 1.2f && (flowFrame.getType() == 0 || flowFrame.getType() == 2)) {
            int n3 = AJR.readInt(bufferedReader);
            if (n3 < 0 || n3 > 2) {
                throw new InvalidShapeIDException(n3, AJR.getLineNum());
            }
            flowFrame.setShape(n3);
            if (f >= 1.3f) {
                int n4 = AJR.readInt(bufferedReader);
                if (n4 < 0 || n4 > 2) {
                    throw new InvalidVAlignException(n4, AJR.getLineNum());
                }
                flowFrame.setVAlign(n4);
            }
        }
        return flowFrame;
    }

    public Object clone() {
        FlowFrame flowFrame = new FlowFrame(this.type, this.border, this.label, this.pages);
        flowFrame.top = this.top;
        flowFrame.bottom = this.bottom;
        flowFrame.left = this.left;
        flowFrame.right = this.right;
        flowFrame.shape = this.shape;
        return flowFrame;
    }

    public void makeEqual(FlowFrame flowFrame) {
        this.type = flowFrame.type;
        this.border = flowFrame.border;
        this.label = flowFrame.label;
        this.pages = flowFrame.pages;
        this.top = flowFrame.top;
        this.bottom = flowFrame.bottom;
        this.left = flowFrame.left;
        this.right = flowFrame.right;
        this.shape = flowFrame.shape;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof FlowFrame)) {
            return false;
        }
        FlowFrame flowFrame = (FlowFrame)object;
        if (this.type != flowFrame.type) {
            return false;
        }
        if (!this.label.equals(flowFrame.label)) {
            return false;
        }
        if (this.border != flowFrame.border) {
            return false;
        }
        if (!this.pages.equals(flowFrame.pages)) {
            return false;
        }
        if (this.top != flowFrame.top) {
            return false;
        }
        if (this.bottom != flowFrame.bottom) {
            return false;
        }
        if (this.left != flowFrame.left) {
            return false;
        }
        if (this.right != flowFrame.right) {
            return false;
        }
        return this.shape == flowFrame.shape;
    }

    public int getShape() {
        return this.shape;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) throws InvalidFrameTypeException {
        if (n < 0 || n > 3) {
            throw new InvalidFrameTypeException(n);
        }
        this.type = n;
        if (n != 0 && n != 2) {
            this.shape = 0;
        }
    }

    public void setShape(int n) throws InvalidShapeException, InvalidShapeIDException {
        if (n < 0 || n > 2) {
            throw new InvalidShapeIDException(n);
        }
        if (this.type == 0 || this.type == 2) {
            this.shape = n;
        } else if (n == 0) {
            this.shape = 0;
        } else {
            throw new InvalidShapeException("Non standard shape only avaiblable for static or dynamic frames");
        }
    }

    public void setVAlign(int n) throws InvalidShapeException, InvalidVAlignException {
        if (n < 0 || n > 2) {
            throw new InvalidVAlignException(n);
        }
        if (this.type != 0 && this.type != 2) {
            throw new InvalidShapeException("Vertical alignment only avaiblable for static or dynamic frames");
        }
        this.valign = n;
    }

    public int getVAlign() {
        return this.valign;
    }

    public boolean isDefinedOnEvenPages() {
        return this.pages.equals("all") || this.pages.equals("even");
    }

    public boolean isDefinedOnOddPages() {
        return this.pages.equals("all") || this.pages.equals("odd");
    }

    public boolean isDefinedOnPage(int n) {
        boolean bl;
        if (this.pages.equals("none")) {
            return n == 0;
        }
        if (n <= 0) {
            return false;
        }
        if (this.pages.equals("all")) {
            return true;
        }
        boolean bl2 = bl = n % 2 == 0;
        if (this.pages.equals("odd")) {
            return !bl;
        }
        if (this.pages.equals("even")) {
            return bl;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.pages, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n2;
            String string = stringTokenizer.nextToken();
            int n3 = -1;
            int n4 = string.length();
            if (n4 == 0) {
                return false;
            }
            n3 = string.indexOf(60);
            if (n3 != -1) {
                if (n3 == n4 - 1) {
                    return false;
                }
                String string2 = string.substring(n3 + 1);
                try {
                    n2 = Integer.parseInt(string2);
                    if (n >= n2) continue;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            n3 = string.indexOf(62);
            if (n3 != -1) {
                if (n3 == n4 - 1) {
                    return false;
                }
                String string3 = string.substring(n3 + 1);
                try {
                    n2 = Integer.parseInt(string3);
                    if (n <= n2) continue;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            n3 = string.indexOf(45);
            if (n3 != -1) {
                if (n3 == n4 - 1 || n3 == 0) {
                    return false;
                }
                String string4 = string.substring(0, n3);
                String string5 = string.substring(n3 + 1);
                try {
                    int n5 = Integer.parseInt(string4);
                    int n6 = Integer.parseInt(string5);
                    if (n < n5 || n > n6) continue;
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            try {
                int n7 = Integer.parseInt(string);
                if (n7 != n) continue;
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    public static boolean isValidPageList(String string) {
        if (string.equals("all") || string.equals("odd") || string.equals("even") || string.equals("none")) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            int n;
            String string2 = stringTokenizer.nextToken();
            int n2 = -1;
            int n3 = string2.length();
            if (n3 == 0) {
                return false;
            }
            n2 = string2.indexOf(60);
            if (n2 != -1) {
                if (n2 == n3 - 1) {
                    return false;
                }
                String string3 = string2.substring(n2 + 1);
                try {
                    n = Integer.parseInt(string3);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            n2 = string2.indexOf(62);
            if (n2 != -1) {
                if (n2 == n3 - 1) {
                    return false;
                }
                String string4 = string2.substring(n2 + 1);
                try {
                    n = Integer.parseInt(string4);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            n2 = string2.indexOf(45);
            if (n2 != -1) {
                if (n2 == n3 - 1 || n2 == 0) {
                    return false;
                }
                String string5 = string2.substring(0, n2);
                String string6 = string2.substring(n2 + 1);
                try {
                    int n4 = Integer.parseInt(string5);
                    int n5 = Integer.parseInt(string6);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            try {
                int n6 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return "FlowFrame[label=" + this.label + ",border=" + this.border + ",type=" + this.type + ",pages=" + this.pages + ",top=" + this.top + ",bottom=" + this.bottom + ",left=" + this.left + ",right=" + this.right + ",shape=" + this.shape + ",valign=" + this.valign + "]";
    }
}

