/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.NegativeDashException;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;

public class DashPattern
implements Serializable,
Cloneable {
    public float[] pattern;
    public float offset;

    public DashPattern() {
        this.pattern = null;
        this.offset = 0.0f;
    }

    public DashPattern(float[] fArray) {
        this.pattern = fArray;
        this.offset = 0.0f;
    }

    public DashPattern(float[] fArray, float f) {
        this.pattern = fArray;
        this.offset = f;
    }

    public Object clone() {
        if (this.pattern == null) {
            return new DashPattern(null, this.offset);
        }
        float[] fArray = new float[this.pattern.length];
        for (int i = 0; i < this.pattern.length; ++i) {
            fArray[i] = this.pattern[i];
        }
        return new DashPattern(fArray, this.offset);
    }

    public void save(DataOutputStream dataOutputStream, float f) throws IOException {
        int n = this.pattern == null ? 0 : this.pattern.length;
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeFloat(this.pattern[i]);
        }
        if (n > 0) {
            dataOutputStream.writeFloat(this.offset);
        }
    }

    public static DashPattern read(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        int n = dataInputStream.readInt();
        if (n == 0) {
            return new DashPattern(null, 0.0f);
        }
        if (n < 0) {
            throw new NegativeDashException();
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = dataInputStream.readFloat();
        }
        float f2 = dataInputStream.readFloat();
        return new DashPattern(fArray, f2);
    }

    public void saveAJR(PrintWriter printWriter, float f) throws IOException {
        int n = this.pattern == null ? 0 : this.pattern.length;
        AJR.writeInt(printWriter, n);
        for (int i = 0; i < n; ++i) {
            AJR.writeFloat(printWriter, this.pattern[i]);
        }
        if (n > 0) {
            AJR.writeFloat(printWriter, this.offset);
        }
    }

    public static DashPattern readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        int n = AJR.readInt(bufferedReader);
        if (n == 0) {
            return new DashPattern(null, 0.0f);
        }
        if (n < 0) {
            throw new NegativeDashException();
        }
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = AJR.readFloat(bufferedReader);
        }
        float f2 = AJR.readFloat(bufferedReader);
        return new DashPattern(fArray, f2);
    }

    public String svg() {
        if (this.pattern == null) {
            return "stroke-dasharray=\"none\"";
        }
        String string = "stroke-dasharray=\"" + this.pattern[0] + "pt";
        int n = this.pattern.length;
        for (int i = 1; i < n; ++i) {
            string = string + "," + this.pattern[i] + "pt";
        }
        string = string + "\" stroke-dashoffset=\"" + this.offset + "pt\"";
        return string;
    }

    public void saveEPS(PrintWriter printWriter) throws IOException {
        if (this.pattern == null) {
            printWriter.println("[] 0 setdash");
        } else {
            printWriter.print("[");
            for (int i = 0; i < this.pattern.length; ++i) {
                printWriter.print("" + this.pattern[i] + " ");
            }
            printWriter.println("] " + this.offset + " setdash");
        }
    }
}

