/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.BufferOverflowException;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.InvalidToolException;
import uk.ac.uea.cmp.nlct.jdr.InvalidUnitIDException;
import uk.ac.uea.cmp.nlct.jdr.JDRGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRGridLoader;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.JDRRectangularGrid;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class CanvasSettings
implements Cloneable {
    public boolean display_grid;
    public boolean grid_lock;
    public boolean showRulers;
    private int tool;
    public JDRPaper paper;
    public int normalsize = 10;
    private JDRGrid grid;
    public static final int ACTION_SELECT = 0;
    public static final int ACTION_OPEN_LINE = 1;
    public static final int ACTION_CLOSED_LINE = 2;
    public static final int ACTION_OPEN_CURVE = 3;
    public static final int ACTION_CLOSED_CURVE = 4;
    public static final int ACTION_RECTANGLE = 5;
    public static final int ACTION_ELLIPSE = 6;
    public static final int ACTION_TEXT = 7;
    public static final int MAX_TOOLS = 8;

    public CanvasSettings() {
        this.display_grid = false;
        this.grid_lock = false;
        this.tool = 0;
        this.showRulers = true;
        this.paper = JDRPaper.A4;
        this.grid = new JDRRectangularGrid();
    }

    public CanvasSettings(boolean bl) {
        this();
        this.display_grid = bl;
    }

    public CanvasSettings(boolean bl, boolean bl2) {
        this();
        this.display_grid = bl;
        this.grid_lock = bl2;
    }

    public CanvasSettings(boolean bl, boolean bl2, boolean bl3) {
        this();
        this.display_grid = bl;
        this.grid_lock = bl2;
        this.showRulers = bl3;
    }

    public CanvasSettings(int n) throws InvalidToolException {
        this();
        this.setTool(n);
    }

    public CanvasSettings(int n, boolean bl) throws InvalidToolException {
        this(n);
        this.display_grid = bl;
    }

    public CanvasSettings(int n, boolean bl, boolean bl2) throws InvalidToolException {
        this(n);
        this.display_grid = bl;
        this.grid_lock = bl2;
    }

    public CanvasSettings(int n, boolean bl, boolean bl2, boolean bl3, JDRPaper jDRPaper, int n2, JDRGrid jDRGrid) throws InvalidToolException {
        this.setTool(n);
        this.display_grid = bl;
        this.grid_lock = bl2;
        this.showRulers = bl3;
        this.paper = jDRPaper;
        this.normalsize = n2;
        this.grid = jDRGrid;
    }

    private CanvasSettings(boolean bl, boolean bl2, boolean bl3, JDRPaper jDRPaper, int n, int n2, JDRGrid jDRGrid) {
        this.display_grid = bl;
        this.grid_lock = bl2;
        this.showRulers = bl3;
        this.paper = jDRPaper;
        this.normalsize = n;
        this.tool = n2;
        this.grid = jDRGrid;
    }

    public Object clone() {
        CanvasSettings canvasSettings = new CanvasSettings(this.display_grid, this.grid_lock, this.showRulers, this.paper, this.normalsize, this.tool, (JDRGrid)this.grid.clone());
        return canvasSettings;
    }

    public void save(DataOutputStream dataOutputStream, float f) throws IOException, InvalidFormatException {
        dataOutputStream.writeBoolean(this.display_grid);
        dataOutputStream.writeBoolean(this.grid_lock);
        dataOutputStream.writeBoolean(this.showRulers);
        dataOutputStream.writeInt(this.tool);
        dataOutputStream.writeInt(this.normalsize);
        this.paper.save(dataOutputStream, f);
        if (f < 1.6f) {
            this.grid.getListener().writeJDR(this.grid, dataOutputStream, f);
        } else {
            JDRGridLoader jDRGridLoader = JDR.getGridLoader();
            jDRGridLoader.saveJDR(this.grid, dataOutputStream, f);
        }
    }

    public static CanvasSettings read(DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        CanvasSettings canvasSettings = new CanvasSettings();
        CanvasSettings.read(canvasSettings, dataInputStream, f);
        return canvasSettings;
    }

    public static void read(CanvasSettings canvasSettings, DataInputStream dataInputStream, float f) throws IOException, InvalidFormatException {
        canvasSettings.display_grid = dataInputStream.readBoolean();
        canvasSettings.grid_lock = dataInputStream.readBoolean();
        canvasSettings.showRulers = dataInputStream.readBoolean();
        canvasSettings.tool = dataInputStream.readInt();
        if (canvasSettings.tool < 0 || canvasSettings.tool >= 8) {
            throw new InvalidToolException(canvasSettings.tool);
        }
        canvasSettings.normalsize = dataInputStream.readInt();
        canvasSettings.paper = JDRPaper.read(dataInputStream, f);
        if (f < 1.6f) {
            byte by = dataInputStream.readByte();
            JDRUnit jDRUnit = JDRUnit.getUnit(by);
            if (jDRUnit == null) {
                throw new InvalidUnitIDException(by);
            }
            int n = dataInputStream.readInt();
            int n2 = dataInputStream.readInt();
            canvasSettings.grid = new JDRRectangularGrid(jDRUnit, n, n2);
        } else {
            JDRGridLoader jDRGridLoader = JDR.getGridLoader();
            canvasSettings.grid = jDRGridLoader.loadJDR(dataInputStream, f);
        }
    }

    public void saveAJR(PrintWriter printWriter, float f) throws IOException, InvalidFormatException {
        AJR.writeBoolean(printWriter, this.display_grid);
        AJR.writeBoolean(printWriter, this.grid_lock);
        AJR.writeBoolean(printWriter, this.showRulers);
        AJR.writeInt(printWriter, this.tool);
        AJR.writeInt(printWriter, this.normalsize);
        this.paper.saveAJR(printWriter, f);
        if (f < 1.6f) {
            this.grid.getListener().writeAJR(this.grid, printWriter, f);
        } else {
            JDRGridLoader jDRGridLoader = AJR.getGridLoader();
            jDRGridLoader.saveAJR(this.grid, printWriter, f);
        }
    }

    public static CanvasSettings readAJR(BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        CanvasSettings canvasSettings = new CanvasSettings();
        CanvasSettings.readAJR(canvasSettings, bufferedReader, f);
        return canvasSettings;
    }

    public static void readAJR(CanvasSettings canvasSettings, BufferedReader bufferedReader, float f) throws IOException, InvalidFormatException, BufferOverflowException, EOFException {
        canvasSettings.display_grid = AJR.readBoolean(bufferedReader);
        canvasSettings.grid_lock = AJR.readBoolean(bufferedReader);
        canvasSettings.showRulers = AJR.readBoolean(bufferedReader);
        canvasSettings.tool = AJR.readInt(bufferedReader);
        if (canvasSettings.tool < 0 || canvasSettings.tool >= 8) {
            throw new InvalidToolException(canvasSettings.tool, AJR.getLineNum());
        }
        canvasSettings.normalsize = AJR.readInt(bufferedReader);
        canvasSettings.paper = JDRPaper.readAJR(bufferedReader, f);
        if (f < 1.6f) {
            int n = AJR.readInt(bufferedReader);
            JDRUnit jDRUnit = JDRUnit.getUnit(n);
            if (jDRUnit == null) {
                throw new InvalidUnitIDException(n, AJR.getLineNum());
            }
            int n2 = AJR.readInt(bufferedReader);
            int n3 = AJR.readInt(bufferedReader);
            canvasSettings.grid = new JDRRectangularGrid(jDRUnit, n2, n3);
        } else {
            JDRGridLoader jDRGridLoader = AJR.getGridLoader();
            canvasSettings.grid = jDRGridLoader.loadAJR(bufferedReader, f);
        }
    }

    public void setTool(int n) throws InvalidToolException {
        if (n < 0 || n >= 8) {
            throw new InvalidToolException(n);
        }
        this.tool = n;
    }

    public void setTool(String string) throws InvalidToolException {
        if (string.equals("select")) {
            this.tool = 0;
        } else if (string.equals("open_line")) {
            this.tool = 1;
        } else if (string.equals("closed_line")) {
            this.tool = 2;
        } else if (string.equals("open_curve")) {
            this.tool = 3;
        } else if (string.equals("closed_curve")) {
            this.tool = 4;
        } else if (string.equals("rectangle")) {
            this.tool = 5;
        } else if (string.equals("ellipse")) {
            this.tool = 6;
        } else if (string.equals("text")) {
            this.tool = 7;
        } else {
            throw new InvalidToolException(string);
        }
    }

    public int getTool() {
        return this.tool;
    }

    public String getToolString() {
        switch (this.tool) {
            case 0: {
                return "select";
            }
            case 1: {
                return "open_line";
            }
            case 2: {
                return "closed_line";
            }
            case 3: {
                return "open_curve";
            }
            case 4: {
                return "closed_curve";
            }
            case 5: {
                return "rectangle";
            }
            case 6: {
                return "ellipse";
            }
            case 7: {
                return "text";
            }
        }
        return "";
    }

    public void setGrid(JDRGrid jDRGrid) {
        this.grid = jDRGrid;
    }

    public JDRGrid getGrid() {
        return this.grid;
    }

    public boolean isGridDisplayed() {
        return this.display_grid;
    }

    public void setDisplayGrid(boolean bl) {
        this.display_grid = bl;
    }

    public void setGridLock(boolean bl) {
        this.grid_lock = bl;
    }

    public boolean isGridLocked() {
        return this.grid_lock;
    }

    public void setMargins(PageFormat pageFormat) {
        this.paper.setImageableArea(pageFormat);
    }

    public Rectangle2D getImageableArea() {
        return this.paper.getImageableArea();
    }
}

