/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import uk.ac.uea.cmp.nlct.jdr.JDRPoint;

public class BBox
implements Cloneable,
Serializable {
    private double minX_;
    private double minY_;
    private double maxX_;
    private double maxY_;
    public static final int HOTSPOT_NONE = 0;
    public static final int HOTSPOT_E = 1;
    public static final int HOTSPOT_SE = 2;
    public static final int HOTSPOT_S = 3;
    public static final int HOTSPOT_SW = 4;
    public static final int HOTSPOT_W = 5;
    public static final int HOTSPOT_NW = 6;
    public static final int HOTSPOT_N = 7;
    public static final int HOTSPOT_NE = 8;
    private JDRPoint hotspotS;
    private JDRPoint hotspotSE;
    private JDRPoint hotspotE;
    private JDRPoint hotspotNE;
    private JDRPoint hotspotNW;
    private JDRPoint hotspotSW;
    private JDRPoint hotspotN;
    private JDRPoint hotspotW;
    public static final short NORTH = 128;
    public static final short NORTH_EAST = 64;
    public static final short EAST = 32;
    public static final short SOUTH_EAST = 16;
    public static final short SOUTH = 8;
    public static final short SOUTH_WEST = 4;
    public static final short WEST = 2;
    public static final short NORTH_WEST = 1;
    private static Color dashColour = Color.white;
    private static Color outlineColour = new Color(255, 0, 0, 200);

    public BBox(Point point, Point point2) {
        this.minX_ = point.x < point2.x ? (double)point.x : (double)point2.x;
        this.minY_ = point.y < point2.y ? (double)point.y : (double)point2.y;
        this.maxX_ = point.x < point2.x ? (double)point2.x : (double)point.x;
        this.maxY_ = point.y < point2.y ? (double)point2.y : (double)point.y;
        this.initHotspots();
    }

    public BBox(Point2D point2D, Point2D point2D2) {
        this.minX_ = point2D.getX() < point2D2.getX() ? point2D.getX() : point2D2.getX();
        this.minY_ = point2D.getY() < point2D2.getY() ? point2D.getY() : point2D2.getY();
        this.maxX_ = point2D.getX() < point2D2.getX() ? point2D2.getX() : point2D.getX();
        this.maxY_ = point2D.getY() < point2D2.getY() ? point2D2.getY() : point2D.getY();
        this.initHotspots();
    }

    public BBox(JDRPoint jDRPoint, JDRPoint jDRPoint2) {
        this.minX_ = jDRPoint.x < jDRPoint2.x ? jDRPoint.x : jDRPoint2.x;
        this.minY_ = jDRPoint.y < jDRPoint2.y ? jDRPoint.y : jDRPoint2.y;
        this.maxX_ = jDRPoint.x < jDRPoint2.x ? jDRPoint2.x : jDRPoint.x;
        this.maxY_ = jDRPoint.y < jDRPoint2.y ? jDRPoint2.y : jDRPoint.y;
        this.initHotspots();
    }

    public BBox(int n, int n2, int n3, int n4) {
        this.minX_ = n;
        this.minY_ = n2;
        this.maxX_ = n3;
        this.maxY_ = n4;
        this.initHotspots();
    }

    public BBox(double d, double d2, double d3, double d4) {
        this.minX_ = d;
        this.minY_ = d2;
        this.maxX_ = d3;
        this.maxY_ = d4;
        this.initHotspots();
    }

    public BBox(Rectangle2D rectangle2D) {
        this(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getX() + rectangle2D.getWidth(), rectangle2D.getY() + rectangle2D.getHeight());
    }

    private void initHotspots() {
        double d = this.getMidX();
        double d2 = this.getMidY();
        this.hotspotS = new JDRPoint(d, this.maxY_);
        this.hotspotSE = new JDRPoint(this.maxX_, this.maxY_);
        this.hotspotE = new JDRPoint(this.maxX_, d2);
        this.hotspotNE = new JDRPoint(this.maxX_, this.minY_);
        this.hotspotN = new JDRPoint(d, this.minY_);
        this.hotspotNW = new JDRPoint(this.minX_, this.minY_);
        this.hotspotW = new JDRPoint(this.minX_, d2);
        this.hotspotSW = new JDRPoint(this.minX_, this.maxY_);
    }

    private void resetHotspots() {
        double d = this.getMidX();
        double d2 = this.getMidY();
        this.hotspotS.set(d, this.maxY_);
        this.hotspotSE.set(this.maxX_, this.maxY_);
        this.hotspotE.set(this.maxX_, d2);
        this.hotspotNE.set(this.maxX_, this.minY_);
        this.hotspotN.set(d, this.minY_);
        this.hotspotNW.set(this.minX_, this.minY_);
        this.hotspotW.set(this.minX_, d2);
        this.hotspotSW.set(this.minX_, this.maxY_);
    }

    public boolean intersects(Rectangle rectangle) {
        double d = rectangle.getX();
        double d2 = rectangle.getY();
        double d3 = d + rectangle.getWidth();
        double d4 = d2 + rectangle.getHeight();
        if (d3 < this.minX_) {
            return false;
        }
        if (this.maxX_ < d) {
            return false;
        }
        if (d4 < this.minY_) {
            return false;
        }
        return !(this.maxY_ < d2);
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = d + rectangle2D.getWidth();
        double d4 = d2 + rectangle2D.getHeight();
        if (d3 < this.minX_) {
            return false;
        }
        if (this.maxX_ < d) {
            return false;
        }
        if (d4 < this.minY_) {
            return false;
        }
        return !(this.maxY_ < d2);
    }

    public boolean contains(Point point) {
        return (double)point.x >= this.minX_ - 1.0 && (double)point.x <= this.maxX_ && (double)point.y >= this.minY_ - 1.0 && (double)point.y <= this.maxY_;
    }

    public boolean contains(Point2D point2D) {
        return point2D.getX() >= this.minX_ - 1.0 && point2D.getX() <= this.maxX_ && point2D.getY() >= this.minY_ - 1.0 && point2D.getY() <= this.maxY_;
    }

    public double getHeight() {
        return Math.abs(this.maxY_ - this.minY_);
    }

    public double getWidth() {
        return Math.abs(this.maxX_ - this.minX_);
    }

    public double getMinX() {
        return this.minX_;
    }

    public double getMinY() {
        return this.minY_;
    }

    public double getMaxX() {
        return this.maxX_;
    }

    public double getMaxY() {
        return this.maxY_;
    }

    public double getMidX() {
        return this.minX_ + 0.5 * this.getWidth();
    }

    public double getMidY() {
        return this.minY_ + 0.5 * this.getHeight();
    }

    public void translate(double d, double d2) {
        this.minX_ -= d;
        this.maxX_ -= d;
        this.minY_ -= d2;
        this.maxY_ -= d2;
    }

    public void reset(double d, double d2, double d3, double d4) {
        this.minX_ = d;
        this.minY_ = d2;
        this.maxX_ = d3;
        this.maxY_ = d4;
        this.resetHotspots();
    }

    public void encompass(BBox bBox) {
        double d = bBox.getMinX();
        double d2 = bBox.getMinY();
        double d3 = bBox.getMaxX();
        double d4 = bBox.getMaxY();
        double d5 = this.getMinX();
        double d6 = this.getMinY();
        double d7 = this.getMaxX();
        double d8 = this.getMaxY();
        if (d > d5) {
            d = d5;
        }
        if (d2 > d6) {
            d2 = d6;
        }
        if (d3 < d7) {
            d3 = d7;
        }
        if (d4 < d8) {
            d4 = d8;
        }
        this.minX_ = d;
        this.minY_ = d2;
        this.maxX_ = d3;
        this.maxY_ = d4;
    }

    public BBox add(BBox bBox) {
        double d = bBox.getMinX();
        double d2 = bBox.getMinY();
        double d3 = bBox.getMaxX();
        double d4 = bBox.getMaxY();
        double d5 = this.getMinX();
        double d6 = this.getMinY();
        double d7 = this.getMaxX();
        double d8 = this.getMaxY();
        if (d > d5) {
            d = d5;
        }
        if (d2 > d6) {
            d2 = d6;
        }
        if (d3 < d7) {
            d3 = d7;
        }
        if (d4 < d8) {
            d4 = d8;
        }
        return new BBox(d, d2, d3, d4);
    }

    public void merge(BBox bBox) {
        this.merge(bBox.getMinX(), bBox.getMinY(), bBox.getMaxX(), bBox.getMaxY());
    }

    public void merge(double d, double d2, double d3, double d4) {
        double d5 = this.getMinX();
        double d6 = this.getMinY();
        double d7 = this.getMaxX();
        double d8 = this.getMaxY();
        if (d > d5) {
            d = d5;
        }
        if (d2 > d6) {
            d2 = d6;
        }
        if (d3 < d7) {
            d3 = d7;
        }
        if (d4 < d8) {
            d4 = d8;
        }
        this.reset(d, d2, d3, d4);
    }

    public void merge(Rectangle2D rectangle2D) {
        double d = rectangle2D.getX();
        double d2 = rectangle2D.getY();
        double d3 = d + rectangle2D.getWidth();
        double d4 = d2 + rectangle2D.getHeight();
        this.merge(d, d2, d3, d4);
    }

    public void merge(Point2D point2D) {
        this.merge(point2D.getX(), point2D.getY(), point2D.getX(), point2D.getY());
    }

    public Rectangle getRectangle() {
        double d = JDRPoint.pointSize / 2.0 + 1.0;
        return new Rectangle((int)Math.floor(this.getMinX() - d), (int)Math.floor(this.getMinY() - d), (int)Math.ceil(this.getWidth() + 2.0 * d + 2.0), (int)Math.ceil(this.getHeight() + 2.0 * d + 2.0));
    }

    public Rectangle getRectangle(double d) {
        double d2 = JDRPoint.pointSize / 2.0 + 1.0;
        return new Rectangle((int)Math.floor((this.getMinX() - d2 - 1.0) * d), (int)Math.floor((this.getMinY() - d2 - 1.0) * d), (int)Math.ceil((this.getWidth() + 2.0 * d2 + 2.0) * d), (int)Math.ceil((this.getHeight() + 2.0 * d2 + 2.0) * d));
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, (short)0);
    }

    public void draw(Graphics graphics, short s) {
        this.draw(graphics, 1.0, s);
    }

    public void draw(Graphics graphics, double d) {
        this.draw(graphics, d, (short)0);
    }

    public void draw(Graphics graphics, double d, short s) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        graphics2D.setPaint(outlineColour);
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.minX_ * d - 0.5, this.minY_ * d - 0.5, this.getWidth() * d + 1.0, this.getHeight() * d + 1.0);
        graphics2D.draw(double_);
        float[] fArray = new float[]{6.0f, 6.0f};
        graphics2D.setPaint(dashColour);
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 5.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.draw(double_);
        graphics2D.setStroke(stroke);
        if ((s & 8) == 8) {
            this.hotspotS.draw(graphics, d);
        }
        if ((s & 0x10) == 16) {
            this.hotspotSE.draw(graphics, d);
        }
        if ((s & 0x20) == 32) {
            this.hotspotE.draw(graphics, d);
        }
        if ((s & 0x40) == 64) {
            this.hotspotNE.draw(graphics, d);
        }
        if ((s & 0x80) == 128) {
            this.hotspotN.draw(graphics, d);
        }
        if ((s & 1) == 1) {
            this.hotspotNW.draw(graphics, d);
        }
        if ((s & 2) == 2) {
            this.hotspotW.draw(graphics, d);
        }
        if ((s & 4) == 4) {
            this.hotspotSW.draw(graphics, d);
        }
        graphics2D.setPaint(paint);
    }

    public Object clone() {
        return new BBox(this.minX_, this.minY_, this.maxX_, this.maxY_);
    }

    public void makeEqual(BBox bBox) {
        this.minX_ = bBox.getMinX();
        this.minY_ = bBox.getMinY();
        this.maxX_ = bBox.getMaxX();
        this.maxY_ = bBox.getMaxY();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof BBox)) {
            return false;
        }
        BBox bBox = (BBox)object;
        return this.minX_ == bBox.minX_ && this.minY_ == bBox.minY_ && this.maxX_ == bBox.maxX_ && this.maxY_ == bBox.maxY_;
    }

    public JDRPoint getTopLeft() {
        return this.hotspotNW;
    }

    public JDRPoint getBottomLeft() {
        return this.hotspotSW;
    }

    public JDRPoint getBottomRight() {
        return this.hotspotSE;
    }

    public JDRPoint getTopRight() {
        return this.hotspotNE;
    }

    public JDRPoint getCentre() {
        return new JDRPoint(this.getMidX(), this.getMidY());
    }

    public int getHotspot(Point2D point2D) {
        if (this.hotspotSE.contains(point2D)) {
            return 2;
        }
        if (this.hotspotSW.contains(point2D)) {
            return 4;
        }
        if (this.hotspotNE.contains(point2D)) {
            return 8;
        }
        if (this.hotspotNW.contains(point2D)) {
            return 6;
        }
        if (this.hotspotNW.contains(point2D)) {
            return 4;
        }
        if (this.hotspotE.contains(point2D)) {
            return 1;
        }
        if (this.hotspotS.contains(point2D)) {
            return 3;
        }
        return 0;
    }

    public String toString() {
        return new String("BBox:[" + this.minX_ + " " + this.minY_ + " " + this.maxX_ + " " + this.maxY_ + "]");
    }

    public String info() {
        return new String("minX=" + this.minX_ + ", minY=" + this.minY_ + ", maxX=" + this.maxX_ + ", maxY=" + this.maxY_);
    }
}

