/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrview;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdrview.JDRView;

public class JDRViewPanel
extends JPanel {
    private JDRView app;

    public JDRViewPanel(JDRView jDRView) {
        this.app = jDRView;
        this.setBackground(Color.lightGray);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        toolTipManager.registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent mouseEvent) {
        JDRGroup jDRGroup = this.app.getImage();
        if (jDRGroup == null) {
            return null;
        }
        Point point = mouseEvent.getPoint();
        double d = this.app.getCurrentMagnification();
        Point2D.Double double_ = new Point2D.Double((double)point.x / d, (double)point.y / d);
        String string = jDRGroup.description;
        for (int i = jDRGroup.size() - 1; i >= 0; --i) {
            JDRCompleteObject jDRCompleteObject = jDRGroup.get(i);
            BBox bBox = jDRCompleteObject.getBBox();
            if (jDRCompleteObject.contains(double_) && (string = jDRCompleteObject.description) != null) break;
        }
        if (string == "") {
            return null;
        }
        return string;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        JDRGroup jDRGroup = this.app.getImage();
        if (jDRGroup == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = graphics2D.getTransform();
        Stroke stroke = graphics2D.getStroke();
        double d = this.app.getCurrentMagnification();
        graphics2D.scale(d, d);
        graphics2D.setPaint(Color.white);
        JDRPaper jDRPaper = this.app.getPaper();
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, jDRPaper.getWidth(), jDRPaper.getHeight()));
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        graphics2D.setRenderingHints(this.app.getRenderingHints());
        graphics2D.setPaint(Color.lightGray);
        if (jDRGroup.flowframe != null) {
            jDRGroup.flowframe.draw(graphics, new BBox(0.0, 0.0, this.app.getPaperWidth(), this.app.getPaperHeight()));
        }
        int n = jDRGroup.size();
        for (int i = 0; i < n; ++i) {
            JDRCompleteObject jDRCompleteObject = jDRGroup.get(i);
            jDRCompleteObject.draw(graphics, false, this);
        }
        graphics2D.setRenderingHints(renderingHints);
        graphics2D.setTransform(affineTransform);
    }
}

