/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrview;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import javax.print.PrintService;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.BrowseUtil;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRBitmap;
import uk.ac.uea.cmp.nlct.jdr.JDRCompleteObject;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdrresources.AboutDialog;
import uk.ac.uea.cmp.nlct.jdrresources.JDRApp;
import uk.ac.uea.cmp.nlct.jdrresources.JDRFileChooser;
import uk.ac.uea.cmp.nlct.jdrresources.JDRGuiMessage;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.LicenceDialog;
import uk.ac.uea.cmp.nlct.jdrresources.ZoomSettings;
import uk.ac.uea.cmp.nlct.jdrresources.filter.JdrAjrFileFilter;
import uk.ac.uea.cmp.nlct.jdrview.JDRPropertiesDialog;
import uk.ac.uea.cmp.nlct.jdrview.JDRViewPanel;

public class JDRView
extends JFrame
implements ActionListener,
JDRApp,
Printable {
    private File currentFile = null;
    private String currentFormat = "";
    private JDRGroup image = null;
    private CanvasSettings settings;
    private int settingsFlag = 0;
    private double magnification = 1.0;
    private JScrollPane scrollPane;
    private JDRViewPanel panel;
    private static final String version = "1.3";
    private static final String appName = "JDRView";
    private JMenu fileM;
    private JMenu settingsM;
    private JMenu zoomM;
    private JMenu helpM;
    private JMenuItem openItem;
    private JMenuItem reloadItem;
    private JMenuItem quitItem;
    private JMenuItem zoomWidthItem;
    private JMenuItem zoomHeightItem;
    private JMenuItem zoomPageItem;
    private JMenuItem aboutItem;
    private JMenuItem licenceItem;
    private JMenuItem propertiesItem;
    private JMenuItem printItem;
    private JCheckBoxMenuItem antiAliasItem;
    private JRadioButtonMenuItem zoomSettingsItem;
    private JRadioButtonMenuItem zoom25Item;
    private JRadioButtonMenuItem zoom50Item;
    private JRadioButtonMenuItem zoom75Item;
    private JRadioButtonMenuItem zoom100Item;
    private JRadioButtonMenuItem zoom200Item;
    private JRadioButtonMenuItem zoom400Item;
    private JRadioButtonMenuItem zoom800Item;
    private JDRPropertiesDialog propertiesDialog;
    private ZoomSettings zoomSettingsChooserBox;
    private AboutDialog aboutDialog;
    private LicenceDialog licenceDialog;
    private RenderingHints renderHints = null;
    private JDRFileChooser openjdrFC;
    private JDRFileChooser bitmapFC;
    private JdrAjrFileFilter fileFilter;
    private HashPrintRequestAttributeSet printRequestAttributeSet;

    public JDRView(String string) {
        this(string, true);
    }

    public JDRView(String string, boolean bl) {
        this(string, bl, null);
    }

    public JDRView(String string, boolean bl, File file) {
        super(appName);
        this.setDefaultCloseOperation(3);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n = dimension.height;
        int n2 = dimension.width;
        int n3 = 3 * n / 4;
        int n4 = n2 / 2;
        this.setSize(n3, n4);
        this.setLocation((n2 - n3) / 2, (n - n4) / 2);
        this.setIconImage(JDRResources.appIcon("jdrlogosmall.png").getImage());
        try {
            JDRCompleteObject.annoteFont = new Font(JDRResources.getString("font.annote.name"), 0, JDRResources.getInt("font.annote.size"));
        }
        catch (NumberFormatException numberFormatException) {
            JDRResources.internalError((Component)this, JDRResources.getStringWithValue("internal_error.integer_key", "font.annote.size"));
        }
        JDRView.initializeHelp(this);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        this.fileM = new JMenu(JDRResources.getString("file.label"));
        this.fileM.setMnemonic(JDRResources.getChar("file.mnemonic"));
        jMenuBar.add(this.fileM);
        this.openItem = new JMenuItem(JDRResources.getString("file.open"), JDRResources.getChar("file.open.mnemonic"));
        this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.openItem.addActionListener(this);
        this.fileM.add(this.openItem);
        this.openjdrFC = new JDRFileChooser();
        this.fileFilter = new JdrAjrFileFilter(JDRResources.getString("filter.jdrajr"));
        this.openjdrFC.addChoosableFileFilter(this.fileFilter);
        this.openjdrFC.setFileFilter(this.fileFilter);
        if (file != null) {
            this.openjdrFC.setCurrentDirectory(file);
        }
        this.reloadItem = new JMenuItem(JDRResources.getString("file.reload"), JDRResources.getChar("file.reload.mnemonic"));
        this.reloadItem.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.reloadItem.addActionListener(this);
        this.fileM.add(this.reloadItem);
        this.propertiesItem = new JMenuItem(JDRResources.getString("file.properties"), JDRResources.getChar("file.properties.mnemonic"));
        this.propertiesItem.addActionListener(this);
        this.fileM.add(this.propertiesItem);
        this.propertiesDialog = new JDRPropertiesDialog(this);
        this.printItem = new JMenuItem(JDRResources.getString("file.print"), JDRResources.getChar("file.print.mnemonic"));
        this.printItem.addActionListener(this);
        this.fileM.add(this.printItem);
        this.quitItem = new JMenuItem(JDRResources.getString("file.quit"), JDRResources.getChar("file.quit.mnemonic"));
        this.quitItem.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        this.quitItem.addActionListener(this);
        this.fileM.add(this.quitItem);
        this.settingsM = new JMenu(JDRResources.getString("settings.label"));
        this.settingsM.setMnemonic(JDRResources.getChar("settings.mnemonic"));
        jMenuBar.add(this.settingsM);
        this.antiAliasItem = new JCheckBoxMenuItem(JDRResources.getString("settings.antialias"), bl);
        this.antiAliasItem.setMnemonic(JDRResources.getChar("settings.antialias.mnemonic"));
        this.antiAliasItem.addActionListener(this);
        this.settingsM.add(this.antiAliasItem);
        this.setAntiAlias(bl);
        this.zoomM = new JMenu(JDRResources.getString("settings.zoom"));
        this.zoomM.setMnemonic(JDRResources.getChar("settings.zoom.mnemonic"));
        this.settingsM.add(this.zoomM);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.zoomWidthItem = new JMenuItem(JDRResources.getString("settings.zoom.width"), JDRResources.getChar("settings.zoom.width.mnemonic"));
        this.zoomWidthItem.addActionListener(this);
        this.zoomM.add(this.zoomWidthItem);
        this.zoomHeightItem = new JMenuItem(JDRResources.getString("settings.zoom.height"), JDRResources.getChar("settings.zoom.height.mnemonic"));
        this.zoomHeightItem.addActionListener(this);
        this.zoomM.add(this.zoomHeightItem);
        this.zoomPageItem = new JMenuItem(JDRResources.getString("settings.zoom.page"), JDRResources.getChar("settings.zoom.page.mnemonic"));
        this.zoomPageItem.addActionListener(this);
        this.zoomM.add(this.zoomPageItem);
        this.zoomM.addSeparator();
        this.zoomSettingsItem = new JRadioButtonMenuItem(JDRResources.getString("settings.zoom.user"), false);
        this.zoomSettingsItem.setMnemonic(JDRResources.getChar("settings.zoom.user.mnemonic"));
        this.zoomSettingsChooserBox = new ZoomSettings(this, this);
        this.zoomSettingsItem.addActionListener(this);
        this.zoomM.add(this.zoomSettingsItem);
        buttonGroup.add(this.zoomSettingsItem);
        this.zoom25Item = new JRadioButtonMenuItem(JDRResources.getString("settings.zoom.25"), false);
        this.zoom25Item.setMnemonic(JDRResources.getChar("settings.zoom.25.mnemonic"));
        this.zoom25Item.addActionListener(this);
        this.zoomM.add(this.zoom25Item);
        buttonGroup.add(this.zoom25Item);
        this.zoom50Item = new JRadioButtonMenuItem(JDRResources.getString("settings.zoom.50"), false);
        this.zoom50Item.setMnemonic(JDRResources.getChar("settings.zoom.50.mnemonic"));
        this.zoom50Item.addActionListener(this);
        this.zoomM.add(this.zoom50Item);
        buttonGroup.add(this.zoom50Item);
        this.zoom75Item = new JRadioButtonMenuItem(JDRResources.getString("settings.zoom.75"), false);
        this.zoom75Item.setMnemonic(JDRResources.getChar("settings.zoom.75.mnemonic"));
        this.zoom75Item.addActionListener(this);
        this.zoomM.add(this.zoom75Item);
        buttonGroup.add(this.zoom75Item);
        this.zoom100Item = new JRadioButtonMenuItem(JDRResources.getString("settings.zoom.100"), true);
        this.zoom100Item.setMnemonic(JDRResources.getChar("settings.zoom.100.mnemonic"));
        this.zoom100Item.addActionListener(this);
        this.zoomM.add(this.zoom100Item);
        buttonGroup.add(this.zoom100Item);
        this.zoom200Item = new JRadioButtonMenuItem(JDRResources.getString("settings.zoom.200"), false);
        this.zoom200Item.setMnemonic(JDRResources.getChar("settings.zoom.200.mnemonic"));
        this.zoom200Item.addActionListener(this);
        this.zoomM.add(this.zoom200Item);
        buttonGroup.add(this.zoom200Item);
        this.zoom400Item = new JRadioButtonMenuItem(JDRResources.getString("settings.zoom.400"), false);
        this.zoom400Item.setMnemonic(JDRResources.getChar("settings.zoom.400.mnemonic"));
        this.zoom400Item.addActionListener(this);
        this.zoomM.add(this.zoom400Item);
        buttonGroup.add(this.zoom400Item);
        this.zoom800Item = new JRadioButtonMenuItem(JDRResources.getString("settings.zoom.800"), false);
        this.zoom800Item.setMnemonic(JDRResources.getChar("settings.zoom.800.mnemonic"));
        this.zoom800Item.addActionListener(this);
        this.zoomM.add(this.zoom800Item);
        buttonGroup.add(this.zoom800Item);
        JMenu jMenu = new JMenu(JDRResources.getString("help.label"));
        jMenu.setMnemonic(JDRResources.getChar("help.mnemonic"));
        jMenuBar.add(jMenu);
        JDRView.addHelpItem(jMenu);
        this.licenceDialog = new LicenceDialog(this);
        this.licenceItem = new JMenuItem(JDRResources.getString("help.licence"), JDRResources.getChar("help.licence.mnemonic"));
        this.licenceItem.addActionListener(this);
        jMenu.add(this.licenceItem);
        this.aboutDialog = new AboutDialog(this, "jdrview", version);
        this.aboutItem = new JMenuItem(JDRResources.getString("help.about"), JDRResources.getChar("help.about.mnemonic"));
        this.aboutItem.addActionListener(this);
        jMenu.add(this.aboutItem);
        JDRBitmap.setBrowseUtil(new BrowseUtil(JDRResources.getString("browse.label"), JDRResources.getString("browse.not_found"), JDRResources.getString("browse.invalid_format"), JDRResources.getString("browse.cant_refresh"), JDRResources.getString("browse.title"), JDRResources.getString("browse.invalid_title"), JDRResources.getString("browse.discard")));
        JDRBitmap.setFileChooser(this.bitmapFC);
        this.printRequestAttributeSet = new HashPrintRequestAttributeSet();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        JDRUnit.setNormalizingFactor(graphicsConfiguration);
        this.panel = new JDRViewPanel(this);
        this.scrollPane = new JScrollPane(this.panel);
        this.getContentPane().add(this.scrollPane);
        this.scrollPane.getInputMap().put(KeyStroke.getKeyStroke("PAGE_UP"), "blockScrollUp");
        this.scrollPane.getActionMap().put("blockScrollUp", new BlockScrollUpAction());
        this.scrollPane.getInputMap().put(KeyStroke.getKeyStroke("PAGE_DOWN"), "blockScrollDown");
        this.scrollPane.getActionMap().put("blockScrollDown", new BlockScrollDownAction());
        this.scrollPane.getInputMap().put(KeyStroke.getKeyStroke("shift PAGE_UP"), "blockScrollLeft");
        this.scrollPane.getActionMap().put("blockScrollLeft", new BlockScrollLeftAction());
        this.scrollPane.getInputMap().put(KeyStroke.getKeyStroke("shift PAGE_DOWN"), "blockScrollRight");
        this.scrollPane.getActionMap().put("blockScrollRight", new BlockScrollRightAction());
        this.settings = new CanvasSettings();
        if (string != null) {
            this.loadImage(string);
        } else {
            this.image = null;
            this.propertiesItem.setEnabled(false);
            this.reloadItem.setEnabled(false);
        }
        this.printItem.setEnabled(this.image != null);
        this.setVisible(true);
    }

    public void blockScrollUp() {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        int n = jScrollBar.getBlockIncrement(-1);
        int n2 = jScrollBar.getValue() - n;
        if (n2 > jScrollBar.getMinimum()) {
            n2 = jScrollBar.getMinimum();
        }
        jScrollBar.setValue(n2);
    }

    public void blockScrollDown() {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        int n = jScrollBar.getBlockIncrement(1);
        int n2 = jScrollBar.getValue() + n;
        if (n2 > jScrollBar.getMaximum()) {
            n2 = jScrollBar.getMaximum();
        }
        jScrollBar.setValue(n2);
    }

    public void blockScrollLeft() {
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        int n = jScrollBar.getBlockIncrement(-1);
        int n2 = jScrollBar.getValue() - n;
        if (n2 < jScrollBar.getMinimum()) {
            n2 = jScrollBar.getMinimum();
        }
        jScrollBar.setValue(n2);
    }

    public void blockScrollRight() {
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        int n = jScrollBar.getBlockIncrement(1);
        int n2 = jScrollBar.getValue() + n;
        if (n2 > jScrollBar.getMaximum()) {
            n2 = jScrollBar.getMaximum();
        }
        jScrollBar.setValue(n2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.openItem) {
            int n = this.openjdrFC.showOpenDialog(this);
            if (n == 0) {
                this.loadImage(this.openjdrFC.getSelectedFile().getAbsolutePath());
                this.panel.repaint();
            }
        } else if (object == this.reloadItem) {
            if (this.currentFile != null) {
                this.loadImage(this.currentFile.getAbsolutePath());
                this.repaint();
            }
        } else if (object == this.propertiesItem) {
            if (this.currentFile != null) {
                this.propertiesDialog.display(this.currentFile, this.currentFormat, this.image, this.settingsFlag == 0 ? null : this.getPaper());
            }
        } else if (object == this.printItem) {
            this.print();
        } else if (object == this.quitItem) {
            System.exit(0);
        } else if (object == this.antiAliasItem) {
            this.setAntiAlias(this.antiAliasItem.isSelected());
            this.panel.repaint();
        } else if (object == this.zoomSettingsItem) {
            this.zoomSettingsChooserBox.setMag(this.magnification);
            this.zoomSettingsChooserBox.display();
        } else if (object == this.zoomWidthItem) {
            this.zoomWidth();
            this.zoomSettingsItem.setSelected(true);
        } else if (object == this.zoomHeightItem) {
            this.zoomHeight();
            this.zoomSettingsItem.setSelected(true);
        } else if (object == this.zoomPageItem) {
            this.zoomPage();
            this.zoomSettingsItem.setSelected(true);
        } else if (object == this.zoom25Item) {
            this.setCurrentMagnification(0.25);
        } else if (object == this.zoom50Item) {
            this.setCurrentMagnification(0.5);
        } else if (object == this.zoom75Item) {
            this.setCurrentMagnification(0.75);
        } else if (object == this.zoom100Item) {
            this.setCurrentMagnification(1.0);
        } else if (object == this.zoom200Item) {
            this.setCurrentMagnification(2.0);
        } else if (object == this.zoom400Item) {
            this.setCurrentMagnification(4.0);
        } else if (object == this.zoom800Item) {
            this.setCurrentMagnification(8.0);
        } else if (object == this.licenceItem) {
            this.licenceDialog.setVisible(true);
        } else if (object == this.aboutItem) {
            this.aboutDialog.setVisible(true);
        }
    }

    public PrintService getPrintService() {
        if (this.image != null) {
            JDRPaper jDRPaper = this.settings.paper;
            this.printRequestAttributeSet.add(jDRPaper.isPortrait() ? OrientationRequested.PORTRAIT : OrientationRequested.LANDSCAPE);
            this.printRequestAttributeSet.add(jDRPaper.getMediaSizeName());
            PrintService[] printServiceArray = PrinterJob.lookupPrintServices();
            if (printServiceArray.length > 0) {
                MediaPrintableArea[] mediaPrintableAreaArray = (MediaPrintableArea[])printServiceArray[0].getSupportedAttributeValues(MediaPrintableArea.class, null, this.printRequestAttributeSet);
                if (mediaPrintableAreaArray != null && mediaPrintableAreaArray.length > 0) {
                    this.printRequestAttributeSet.add(mediaPrintableAreaArray[0]);
                }
                return printServiceArray[0];
            }
        }
        return null;
    }

    public void print() {
        PrintService printService = this.getPrintService();
        if (printService != null) {
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            printerJob.setPrintable(this);
            try {
                printerJob.setPrintService(printService);
                if (printerJob.printDialog(this.printRequestAttributeSet)) {
                    printerJob.print(this.printRequestAttributeSet);
                }
            }
            catch (PrinterException printerException) {
                JDRResources.error((Component)this, new String[]{JDRResources.getString("error.printing"), printerException.getMessage()});
            }
            catch (Exception exception) {
                JDRResources.internalError((Component)this, exception);
            }
        } else {
            JDRResources.error((Component)this, JDRResources.getString("error.printing.no_service"));
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        repaintManager.setDoubleBufferingEnabled(false);
        AffineTransform affineTransform = graphics2D.getTransform();
        int n2 = this.image.size();
        for (int i = 0; i < n2; ++i) {
            this.image.get(i).draw(graphics, false);
        }
        graphics2D.setTransform(affineTransform);
        repaintManager.setDoubleBufferingEnabled(true);
        return 0;
    }

    public void zoomWidth() {
        double d = JDRUnit.getNormalizingFactor() * this.settings.paper.getWidth();
        double d2 = JDRUnit.getNormalizingFactor() * this.settings.paper.getHeight();
        Dimension dimension = this.scrollPane.getViewport().getExtentSize();
        int n = dimension.width;
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        if (!jScrollBar.isVisible()) {
            int n2 = dimension.height;
            dimension = jScrollBar.getSize();
            if (d2 * (double)(n - dimension.width) / d > (double)n2) {
                n -= dimension.width;
            }
        } else if (this.scrollPane.getVerticalScrollBarPolicy() == 20) {
            int n3 = dimension.height;
            dimension = jScrollBar.getSize();
            if (d2 * (double)(n + dimension.width) / d < (double)n3) {
                n += dimension.width;
            }
        }
        this.setCurrentMagnification((double)n / d);
    }

    public void zoomHeight() {
        double d = JDRUnit.getNormalizingFactor() * this.settings.paper.getWidth();
        double d2 = JDRUnit.getNormalizingFactor() * this.settings.paper.getHeight();
        Dimension dimension = this.scrollPane.getViewport().getExtentSize();
        int n = dimension.width;
        int n2 = dimension.height;
        JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
        if (!jScrollBar.isVisible()) {
            dimension = jScrollBar.getSize();
            if (d * (double)(n2 - dimension.height) / d2 > (double)n) {
                n2 -= dimension.height;
            }
        } else if (this.scrollPane.getHorizontalScrollBarPolicy() == 30) {
            dimension = jScrollBar.getSize();
            if (d * (double)(n2 + dimension.height) / d2 < (double)n) {
                n2 += dimension.height;
            }
        }
        this.setCurrentMagnification((double)n2 / d2);
    }

    public void zoomPage() {
        double d = JDRUnit.getNormalizingFactor() * this.settings.paper.getWidth();
        double d2 = JDRUnit.getNormalizingFactor() * this.settings.paper.getHeight();
        Dimension dimension = this.scrollPane.getViewport().getExtentSize();
        int n = dimension.width;
        double d3 = (double)n / d;
        int n2 = dimension.height;
        double d4 = (double)n2 / d2;
        if (d3 < d4) {
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            if (jScrollBar.isVisible() && this.scrollPane.getVerticalScrollBarPolicy() == 20) {
                dimension = jScrollBar.getSize();
                if (d2 * (double)(n + dimension.width) / d < (double)n2) {
                    d3 = (double)(n += dimension.width) / d;
                }
            }
        } else {
            JScrollBar jScrollBar = this.scrollPane.getHorizontalScrollBar();
            if (jScrollBar.isVisible() && this.scrollPane.getHorizontalScrollBarPolicy() == 30) {
                dimension = jScrollBar.getSize();
                if (d * (double)(n2 + dimension.height) / d2 < (double)n) {
                    d4 = (double)(n2 += dimension.height) / d2;
                }
            }
        }
        this.setCurrentMagnification(d3 < d4 ? d3 : d4);
    }

    public JDRPaper getPaper() {
        return this.settings.paper;
    }

    public double getPaperWidth() {
        return this.settings.paper.getWidth();
    }

    public double getPaperHeight() {
        return this.settings.paper.getHeight();
    }

    public RenderingHints getRenderingHints() {
        return this.renderHints;
    }

    public void setAntiAlias(boolean bl) {
        if (this.renderHints == null) {
            this.renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, bl ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            return;
        }
        if (bl) {
            this.renderHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            this.renderHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
    }

    @Override
    public double getCurrentMagnification() {
        return this.magnification;
    }

    @Override
    public void setCurrentMagnification(double d) {
        if (d <= 0.0) {
            return;
        }
        this.magnification = d;
        Dimension dimension = new Dimension((int)(this.magnification * JDRUnit.getNormalizingFactor() * this.settings.paper.getWidth()), (int)(this.magnification * JDRUnit.getNormalizingFactor() * this.settings.paper.getHeight()));
        this.setPreferredSize(dimension);
        if (this.panel != null) {
            this.panel.setPreferredSize(dimension);
            this.panel.revalidate();
            this.panel.repaint();
        }
        if (this.scrollPane != null) {
            this.scrollPane.setPreferredSize(dimension);
            this.scrollPane.revalidate();
        }
    }

    public JDRGroup getImage() {
        return this.image;
    }

    public static JMenuItem addHelpItem(JMenu jMenu) {
        return JDRResources.addHelpItem(jMenu, appName);
    }

    public static void initializeHelp(JFrame jFrame) {
        JDRResources.initialiseHelp(jFrame, appName.toLowerCase());
    }

    public static void appVersion() {
        System.err.println(appName.toLowerCase() + " " + version);
        System.err.println("Copyright (C) 2007 Nicola L C Talbot");
        System.err.println("This is free software distributed under the GNU General Public License.");
        System.err.println("There is NO WARRANTY. See accompanying licence file for details.");
    }

    public static void syntax() {
        System.err.println("Syntax: jdrview [options] [<jdr/ajr file>]");
        System.err.println();
        System.err.println("Options:");
        System.err.println();
        System.err.println("-antialias\t: Switch on anti-aliasing (default)");
        System.err.println("-noantialias\t: Switch off anti-aliasing");
        System.err.println("-cwd <path>\t: Set the current working directory to <path>");
        System.err.println("-version\t: Print version number and exit");
        System.err.println("-help\t: Print this help message");
        System.exit(0);
    }

    public void loadImage(String string) {
        if (string.toLowerCase().endsWith(".jdr")) {
            this.loadJDRImage(string);
        } else if (string.toLowerCase().endsWith(".ajr")) {
            this.loadAJRImage(string);
        } else {
            BufferedReader bufferedReader;
            try {
                bufferedReader = new BufferedReader(new FileReader(string));
            }
            catch (IOException iOException) {
                JDRResources.error((Component)this, new String[]{JDRResources.getStringWithValue("error.io.open", string), iOException.getMessage()});
                return;
            }
            catch (Exception exception) {
                JDRResources.error((Component)this, exception);
                return;
            }
            boolean bl = false;
            try {
                String string2 = AJR.readString(bufferedReader, 3);
                bl = string2.equals("AJR");
            }
            catch (Exception exception) {
                JDRResources.error((Component)this, exception);
            }
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                JDRResources.error((Component)this, iOException);
                return;
            }
            if (bl) {
                this.loadAJRImage(string);
            } else {
                this.loadJDRImage(string);
            }
        }
    }

    public void loadJDRImage(String string) {
        this.currentFile = new File(string);
        this.currentFormat = "?";
        this.setTitle("JDRView - " + string);
        this.propertiesItem.setEnabled(true);
        this.reloadItem.setEnabled(true);
        this.printItem.setEnabled(true);
        this.image = null;
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(this.currentFile));
        }
        catch (IOException iOException) {
            JDRResources.error(this, JDRResources.getStringWithValue("error.io.open", string), iOException);
            return;
        }
        try {
            this.image = JDR.load(dataInputStream, this.settings);
            this.currentFormat = "JDR " + JDR.getLastLoadedVersion();
            this.settingsFlag = JDR.getLastLoadedSettingsID();
            if (this.settingsFlag == 0) {
                BBox bBox = this.image.getBBox();
                double d = Math.max(100.0, bBox.getMaxX());
                double d2 = Math.max(100.0, bBox.getMaxY());
                this.settings.paper = JDRPaper.getClosestEnclosingPredefinedPaper(d, d2, 1.6f);
                if (this.settings.paper == null) {
                    this.settings.paper = new JDRPaper(d, d2);
                }
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            JDRResources.error((Component)this, invalidFormatException.getMessage());
            try {
                dataInputStream.close();
            }
            catch (IOException iOException) {
                JDRResources.error((Component)this, iOException);
            }
            return;
        }
        catch (EOFException eOFException) {
            JDRResources.error((Component)this, new String[]{JDRResources.getString("error.io.load"), JDRResources.getString("error.eof"), eOFException.getMessage()});
            return;
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this, new String[]{JDRResources.getString("error.io.load"), iOException.getMessage()});
            return;
        }
        try {
            dataInputStream.close();
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this, iOException);
        }
        this.setCurrentMagnification(this.magnification);
    }

    public void loadAJRImage(String string) {
        this.currentFile = new File(string);
        this.currentFormat = "?";
        this.setTitle("JDRView - " + string);
        this.propertiesItem.setEnabled(true);
        this.reloadItem.setEnabled(true);
        this.printItem.setEnabled(true);
        this.image = null;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(this.currentFile));
        }
        catch (IOException iOException) {
            JDRResources.error(this, JDRResources.getStringWithValue("error.io.open", string), iOException);
            return;
        }
        try {
            this.image = AJR.load(bufferedReader, this.settings);
            this.currentFormat = "AJR " + AJR.getLastLoadedVersion();
            this.settingsFlag = AJR.getLastLoadedSettingsID();
            if (this.settingsFlag == 0) {
                BBox bBox = this.image.getBBox();
                double d = Math.max(100.0, bBox.getMaxX());
                double d2 = Math.max(100.0, bBox.getMinX());
                this.settings.paper = JDRPaper.getClosestPredefinedPaper(d, d2, 1.6f);
                if (this.settings.paper == null) {
                    this.settings.paper = new JDRPaper(d, d2);
                }
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            JDRResources.error((Component)this, invalidFormatException.getMessage());
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                JDRResources.error((Component)this, iOException);
            }
            return;
        }
        catch (EOFException eOFException) {
            JDRResources.error((Component)this, new String[]{JDRResources.getString("error.io.load"), JDRResources.getString("error.eof"), eOFException.getMessage()});
            return;
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this, new String[]{JDRResources.getString("error.io.load"), iOException.getMessage()});
            return;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            JDRResources.error((Component)this, iOException);
        }
        this.setCurrentMagnification(this.magnification);
    }

    public static void enableHelpOnButton(AbstractButton abstractButton, String string) {
        JDRResources.enableHelpOnButton(abstractButton, string);
    }

    public static void main(String[] stringArray) {
        JDR.messageSystem = new JDRGuiMessage();
        try {
            JDRResources.initialiseDictionary();
        }
        catch (IOException iOException) {
            JDRResources.internalError(null, iOException);
        }
        String string = null;
        boolean bl = true;
        String string2 = ".";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-version") || stringArray[i].equals("--version")) {
                JDRView.appVersion();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-help") || stringArray[i].equals("--help") || stringArray[i].equals("-h")) {
                JDRView.appVersion();
                JDRView.syntax();
                continue;
            }
            if (stringArray[i].equals("-antialias")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-noantialias")) {
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-cwd")) {
                if (stringArray.length == i + 1) {
                    JDRResources.error(JDRResources.getString("error.missing_cwd"));
                    continue;
                }
                string2 = stringArray[++i];
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                JDRResources.error(JDRResources.getStringWithValue("error.unknown_option", stringArray[i]));
                JDRView.syntax();
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                continue;
            }
            JDRResources.error(JDRResources.getString("error.one_filename"));
            JDRView.syntax();
        }
        File file = new File(string2);
        if (!file.exists()) {
            JDRResources.warning(JDRResources.getStringWithValue("error.io.dir_not_exists", string2));
            file = null;
        } else if (!file.isDirectory()) {
            JDRResources.warning(JDRResources.getStringWithValue("error.io.not_directory", string2));
            file = null;
        }
        try {
            JDRView jDRView = new JDRView(string, bl, file);
        }
        catch (Exception exception) {
            JDRResources.internalError((Component)null, exception);
        }
    }

    class BlockScrollRightAction
    extends AbstractAction {
        public BlockScrollRightAction() {
            super("blockScrollRight");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDRView.this.blockScrollRight();
        }
    }

    class BlockScrollLeftAction
    extends AbstractAction {
        public BlockScrollLeftAction() {
            super("blockScrollLeft");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDRView.this.blockScrollLeft();
        }
    }

    class BlockScrollDownAction
    extends AbstractAction {
        public BlockScrollDownAction() {
            super("blockScrollDown");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDRView.this.blockScrollDown();
        }
    }

    class BlockScrollUpAction
    extends AbstractAction {
        public BlockScrollUpAction() {
            super("blockScrollUp");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JDRView.this.blockScrollUp();
        }
    }
}

