/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrview;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrview.JDRView;

public class JDRPropertiesDialog
extends JDialog
implements KeyListener {
    private JDRView app;
    private JButton okayButton;
    private JLabel nameLabel;
    private JLabel sizeLabel;
    private JLabel formatLabel;
    private JLabel boundsLabel;
    private JLabel descriptionLabel;
    private JLabel modifiedLabel;
    private JLabel paperLabel;
    private JLabel nameField;
    private JLabel sizeField;
    private JLabel formatField;
    private JLabel boundsField;
    private JLabel descriptionField;
    private JLabel modifiedField;
    private JLabel paperField;
    private static DecimalFormat df = new DecimalFormat("0.##");

    public JDRPropertiesDialog(JDRView jDRView) {
        super((Frame)jDRView, JDRResources.getString("fileproperties.title"));
        this.setLayout(new BorderLayout());
        this.app = jDRView;
        this.addKeyListener(this);
        Box box = Box.createVerticalBox();
        JPanel jPanel = new JPanel(new FlowLayout(3));
        this.nameLabel = new JLabel(JDRResources.getString("fileproperties.filename"), 4);
        Dimension dimension = this.nameLabel.getPreferredSize();
        int n = dimension.width;
        int n2 = dimension.height;
        jPanel.add(this.nameLabel);
        this.nameField = new JLabel();
        jPanel.add(this.nameField);
        box.add(jPanel);
        jPanel = new JPanel(new FlowLayout(3));
        this.sizeLabel = new JLabel(JDRResources.getString("fileproperties.filesize"), 4);
        dimension = this.sizeLabel.getPreferredSize();
        if (dimension.width > n) {
            n = dimension.width;
        }
        if (dimension.height > n2) {
            n2 = dimension.height;
        }
        jPanel.add(this.sizeLabel);
        this.sizeField = new JLabel();
        jPanel.add(this.sizeField);
        box.add(jPanel);
        jPanel = new JPanel(new FlowLayout(3));
        this.formatLabel = new JLabel(JDRResources.getString("fileproperties.fileformat"), 4);
        dimension = this.formatLabel.getPreferredSize();
        if (dimension.width > n) {
            n = dimension.width;
        }
        if (dimension.height > n2) {
            n2 = dimension.height;
        }
        jPanel.add(this.formatLabel);
        this.formatField = new JLabel();
        jPanel.add(this.formatField);
        box.add(jPanel);
        jPanel = new JPanel(new FlowLayout(3));
        this.boundsLabel = new JLabel(JDRResources.getString("fileproperties.bounds"), 4);
        dimension = this.boundsLabel.getPreferredSize();
        if (dimension.width > n) {
            n = dimension.width;
        }
        if (dimension.height > n2) {
            n2 = dimension.height;
        }
        jPanel.add(this.boundsLabel);
        this.boundsField = new JLabel();
        jPanel.add(this.boundsField);
        box.add(jPanel);
        jPanel = new JPanel(new FlowLayout(3));
        this.paperLabel = new JLabel(JDRResources.getString("fileproperties.paper"), 4);
        dimension = this.paperLabel.getPreferredSize();
        if (dimension.width > n) {
            n = dimension.width;
        }
        if (dimension.height > n2) {
            n2 = dimension.height;
        }
        jPanel.add(this.paperLabel);
        this.paperField = new JLabel();
        jPanel.add(this.paperField);
        box.add(jPanel);
        jPanel = new JPanel(new FlowLayout(3));
        this.descriptionLabel = new JLabel(JDRResources.getString("fileproperties.description"), 4);
        dimension = this.descriptionLabel.getPreferredSize();
        if (dimension.width > n) {
            n = dimension.width;
        }
        if (dimension.height > n2) {
            n2 = dimension.height;
        }
        jPanel.add(this.descriptionLabel);
        this.descriptionField = new JLabel();
        jPanel.add(this.descriptionField);
        box.add(jPanel);
        jPanel = new JPanel(new FlowLayout(3));
        this.modifiedLabel = new JLabel(JDRResources.getString("fileproperties.modified"), 4);
        dimension = this.modifiedLabel.getPreferredSize();
        if (dimension.width > n) {
            n = dimension.width;
        }
        if (dimension.height > n2) {
            n2 = dimension.height;
        }
        jPanel.add(this.modifiedLabel);
        this.modifiedField = new JLabel();
        jPanel.add(this.modifiedField);
        box.add(jPanel);
        dimension = new Dimension(n, n2);
        this.nameLabel.setPreferredSize(dimension);
        this.sizeLabel.setPreferredSize(dimension);
        this.formatLabel.setPreferredSize(dimension);
        this.boundsLabel.setPreferredSize(dimension);
        this.paperLabel.setPreferredSize(dimension);
        this.descriptionLabel.setPreferredSize(dimension);
        this.modifiedLabel.setPreferredSize(dimension);
        this.getContentPane().add((Component)box, "Center");
        this.okayButton = new JButton(JDRResources.getString("label.okay"));
        this.okayButton.setMnemonic(JDRResources.getChar("label.okay.mnemonic"));
        this.okayButton.addKeyListener(this);
        this.okayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JDRPropertiesDialog.this.setVisible(false);
            }
        });
        jPanel = new JPanel();
        jPanel.add(this.okayButton);
        this.getContentPane().add((Component)jPanel, "South");
        this.pack();
        this.setLocationRelativeTo(jDRView);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10) {
            this.setVisible(false);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void display(File file, String string, JDRGroup jDRGroup, JDRPaper jDRPaper) {
        this.nameField.setText(file.getName());
        long l = file.length();
        if (l > 1000000L) {
            this.sizeField.setText(JDRResources.getStringWithValue("fileproperties.mbytes", df.format((double)l / 1000000.0)));
        } else if (l > 1000L) {
            this.sizeField.setText(JDRResources.getStringWithValue("fileproperties.kbytes", (double)l / 1000.0));
        } else {
            this.sizeField.setText(JDRResources.getStringWithValue("fileproperties.bytes", l));
        }
        this.formatField.setText(string);
        if (jDRGroup == null || jDRGroup.description == null) {
            this.descriptionField.setText("");
        } else {
            this.descriptionField.setText(jDRGroup.description);
        }
        this.modifiedField.setText(DateFormat.getDateInstance().format(new Date(file.lastModified())));
        if (jDRGroup == null) {
            this.boundsField.setText(JDRResources.getString("fileproperties.empty"));
        } else {
            BBox bBox = jDRGroup.getBBox();
            if (bBox == null) {
                this.boundsField.setText(JDRResources.getString("fileproperties.empty"));
            } else {
                this.boundsField.setText("" + df.format(bBox.getMinX()) + " " + df.format(bBox.getMinY()) + " " + df.format(bBox.getMaxX()) + " " + df.format(bBox.getMaxY()));
            }
        }
        if (jDRPaper == null) {
            this.paperField.setText(JDRResources.getString("fileproperties.nonesupplied"));
        } else {
            this.paperField.setText(jDRPaper.toString());
        }
        this.pack();
        this.setVisible(true);
    }
}

