/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr2tex;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFontBase;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdr.io.PGF;

public class Jdr2Tex {
    public static void appVersion() {
        System.err.println("jdr2tex 1.5");
        System.err.println("Copyright (C) 2007 Nicola L C Talbot");
        System.err.println("This is free software distributed under the GNU General Public License.");
        System.err.println("There is NO WARRANTY. See accompanying licence file for details.");
    }

    public static void syntax(int n) {
        System.err.println("Syntax: jdr2tex [-version] [-doc] <jdr file> <tex file>");
        System.exit(n);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        boolean bl = false;
        JDR.messageSystem.suspend();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-version")) {
                Jdr2Tex.appVersion();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-doc")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-help")) {
                Jdr2Tex.syntax(0);
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                System.err.println("Unknown switch '" + stringArray[i] + "'");
                Jdr2Tex.syntax(1);
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            System.err.println("Too many file names specified");
            Jdr2Tex.syntax(1);
        }
        if (string == null) {
            System.err.println("Missing input file");
            Jdr2Tex.syntax(1);
        } else if (string2 == null) {
            System.err.println("Missing output file");
            Jdr2Tex.syntax(1);
        }
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(string));
        }
        catch (IOException iOException) {
            System.err.println("Unable to open " + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        String string3 = "";
        CanvasSettings canvasSettings = new CanvasSettings();
        JDRGroup jDRGroup = null;
        try {
            jDRGroup = JDR.load(dataInputStream, canvasSettings);
        }
        catch (InvalidFormatException invalidFormatException) {
            System.err.println(invalidFormatException.getMessage());
            System.exit(1);
        }
        catch (EOFException eOFException) {
            System.err.println("Unexpected EOF. (File corrupt?)");
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new File(string2));
        }
        catch (IOException iOException) {
            System.err.println("Unable to open " + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            if (bl) {
                PGF.saveDoc(jDRGroup, canvasSettings.paper, new LaTeXFontBase(canvasSettings.normalsize), "", printWriter, "jdr2tex");
            } else {
                PGF.save(jDRGroup, printWriter, "jdr2tex");
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
    }
}

