/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdr2ajr;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class Jdr2Ajr {
    public static void appVersion() {
        System.err.println("jdr2ajr 1.5");
        System.err.println("Copyright (C) 2007 Nicola L C Talbot");
        System.err.println("This is free software distributed under the GNU General Public License.");
        System.err.println("There is NO WARRANTY. See accompanying licence file for details.");
    }

    public static void syntax() {
        System.err.println("Syntax: jdr2ajr [options] <jdr file> <ajr file>");
        System.err.println("Options:");
        System.err.println("-v1.0\tSave as AJR version 1.0");
        System.err.println("-v1.1\tSave as AJR version 1.1");
        System.err.println("-v1.2\tSave as AJR version 1.2");
        System.err.println("-v1.3\tSave as AJR version 1.3");
        System.err.println("-v1.4\tSave as AJR version 1.4");
        System.err.println("-v1.4\tSave as AJR version 1.5 (default)");
        System.err.println("-settings [<n>]\tControls how settings are saved in AJR file. Optionally followed by integer <n> (if omitted, <n>=1):");
        System.err.println("\t0 : don't save settings");
        System.err.println("\t1 : save all settings");
        System.err.println("\t2 : only save paper size (v1.3 and above, for earlier versions equivalent to 0)");
        System.err.println("-nosettings\tEquivalent to -settings 0");
        System.err.println("-settings_as_input\tOnly save settings if they were given in the input file (Default)");
        System.exit(0);
    }

    public static void syntaxError(String string) {
        System.err.println(string);
        System.err.println("Use '-help' for help");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 1;
        float f = 1.6f;
        boolean bl = true;
        JDR.messageSystem.suspend();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-nosettings")) {
                n = 0;
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-settings")) {
                if (i == stringArray.length - 1) {
                    n = 1;
                } else {
                    try {
                        n = Integer.parseInt(stringArray[i + 1]);
                        ++i;
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 1;
                    }
                }
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-settings_as_input")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-v1.0")) {
                f = 1.0f;
                continue;
            }
            if (stringArray[i].equals("-v1.1")) {
                f = 1.1f;
                continue;
            }
            if (stringArray[i].equals("-v1.2")) {
                f = 1.2f;
                continue;
            }
            if (stringArray[i].equals("-v1.3")) {
                f = 1.3f;
                continue;
            }
            if (stringArray[i].equals("-v1.4")) {
                f = 1.4f;
                continue;
            }
            if (stringArray[i].equals("-v1.5")) {
                f = 1.5f;
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                Jdr2Ajr.syntaxError("Unknown switch '" + stringArray[i] + "'");
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            Jdr2Ajr.syntaxError("Too many file names specified");
        }
        if (string == null) {
            Jdr2Ajr.syntaxError("Missing input file");
        } else if (string2 == null) {
            Jdr2Ajr.syntaxError("Missing output file");
        }
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(string));
        }
        catch (IOException iOException) {
            System.err.println("Unable to open " + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        String string3 = "";
        CanvasSettings canvasSettings = new CanvasSettings();
        JDRGroup jDRGroup = null;
        try {
            jDRGroup = JDR.load(dataInputStream, canvasSettings);
        }
        catch (InvalidFormatException invalidFormatException) {
            System.err.println(invalidFormatException.getMessage());
            System.exit(1);
        }
        catch (EOFException eOFException) {
            System.err.println("Unexpected EOF. (File corrupt?)");
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        int n2 = JDR.getLastLoadedSettingsID();
        if (bl && (n = n2) == 2 && f < 1.3f) {
            System.err.println("Warning: paper only settings not available for versions prior to 1.3 - defaulting to -settings 1");
            n = 1;
        }
        if (n2 == 0 && n != 0) {
            canvasSettings.paper = JDRPaper.getClosestPredefinedPaper(jDRGroup.getBBox().getWidth(), jDRGroup.getBBox().getHeight(), f);
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new File(string2));
        }
        catch (IOException iOException) {
            System.err.println("Unable to open " + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            AJR.save(jDRGroup, canvasSettings, printWriter, f, n);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            printWriter.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
    }
}

