/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.eps2jdr;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import uk.ac.uea.cmp.nlct.jdr.BBox;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.LaTeXFont;
import uk.ac.uea.cmp.nlct.jdr.io.EPS;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;

public class Eps2Jdr {
    public static void appVersion() {
        System.err.println("eps2jdr 1.5");
        System.err.println("Copyright (C) 2007 Nicola L C Talbot");
        System.err.println("This is free software distributed under the GNU General Public License.");
        System.err.println("There is NO WARRANTY. See accompanying licence file for details.");
    }

    public static void syntax() {
        System.err.println("Syntax: eps2jdr [options] <eps file> <jdr file>");
        System.err.println("Options:");
        System.err.println("-v1.0\tSave as JDR version 1.0");
        System.err.println("-v1.1\tSave as JDR version 1.1");
        System.err.println("-v1.2\tSave as JDR version 1.2");
        System.err.println("-v1.3\tSave as JDR version 1.3");
        System.err.println("-v1.4\tSave as JDR version 1.4");
        System.err.println("-v1.4\tSave as JDR version 1.5 (default)");
        System.err.println("-bitmap <basename>\tExtracted bitmaps to be saved as <basename><n>.png\n");
        System.err.println("-normalsize <n>\tSet normal LaTeX font size to <n>\n");
        System.err.println("-verbose\tVerbose output");
        System.err.println("-version\tPrint current version and exit");
        System.exit(0);
    }

    public static void syntaxError(String string) {
        System.err.println(string);
        System.err.println("Use '-help' for help");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        Serializable serializable;
        Object object;
        String string;
        int n;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        int n2 = 0;
        float f = 1.6f;
        int n3 = 10;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-v1.0")) {
                f = 1.0f;
                continue;
            }
            if (stringArray[n].equals("-v1.1")) {
                f = 1.1f;
                continue;
            }
            if (stringArray[n].equals("-v1.2")) {
                f = 1.2f;
                continue;
            }
            if (stringArray[n].equals("-v1.3")) {
                f = 1.3f;
                continue;
            }
            if (stringArray[n].equals("-v1.4")) {
                f = 1.4f;
                continue;
            }
            if (stringArray[n].equals("-v1.5")) {
                f = 1.5f;
                continue;
            }
            if (stringArray[n].equals("-version")) {
                Eps2Jdr.appVersion();
                System.exit(0);
                continue;
            }
            if (stringArray[n].equals("-help")) {
                Eps2Jdr.syntax();
                continue;
            }
            if (stringArray[n].equals("-bitmap")) {
                if (++n >= stringArray.length) {
                    Eps2Jdr.syntaxError("missing -bitmap basename");
                }
                string4 = stringArray[n];
                continue;
            }
            if (stringArray[n].equals("-normalsize")) {
                if (++n >= stringArray.length) {
                    Eps2Jdr.syntaxError("missing -normalsize value");
                }
                try {
                    n3 = Integer.parseInt(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    System.err.println("Integer expected for -normalsize, '" + stringArray[n] + "' found");
                    System.exit(1);
                }
                continue;
            }
            if (stringArray[n].equals("-verbose")) {
                n2 = 1;
                continue;
            }
            if (stringArray[n].startsWith("-")) {
                Eps2Jdr.syntaxError("Unknown switch '" + stringArray[n] + "'");
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[n];
                continue;
            }
            if (string3 == null) {
                string3 = stringArray[n];
                continue;
            }
            Eps2Jdr.syntaxError("Too many file names specified");
        }
        if (n2 == 0) {
            JDR.messageSystem.suspend();
        } else {
            JDR.messageSystem.displayMessages();
        }
        if (string2 == null) {
            Eps2Jdr.syntaxError("Missing input file");
        } else if (string3 == null) {
            Eps2Jdr.syntaxError("Missing output file");
        }
        if (string4 == null) {
            n = string3.lastIndexOf(".jdr");
            string4 = n == -1 ? string3 : string3.substring(0, n);
        }
        if ((string = JDRResources.getUserConfigDir()) != null) {
            object = null;
            serializable = new File(string, "psfontmap");
            try {
                object = ((File)serializable).getCanonicalPath();
                if (object != null && ((File)serializable).exists() && ((File)serializable).isFile()) {
                    try {
                        LaTeXFont.loadPostScriptMappings((File)serializable);
                    }
                    catch (InvalidFormatException invalidFormatException) {
                        JDRResources.error(new String[]{"'" + (String)object + "':", invalidFormatException.getMessage()});
                    }
                }
            }
            catch (IOException iOException) {
                JDRResources.error(new String[]{"'" + (String)object + "':", iOException.getMessage()});
            }
        }
        object = null;
        try {
            object = new BufferedReader(new FileReader(string2));
        }
        catch (IOException iOException) {
            System.err.println("Unable to open '" + string2 + "' " + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        JDR.messageSystem.messageln("Reading '" + string2 + "'");
        serializable = null;
        try {
            serializable = EPS.load((BufferedReader)object, string4, n2, n3);
        }
        catch (InvalidFormatException invalidFormatException) {
            System.err.println(invalidFormatException.getMessage());
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            exception.printStackTrace();
        }
        try {
            ((BufferedReader)object).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        if (serializable == null || ((JDRGroup)serializable).size() == 0) {
            System.err.println("no image created: nothing to save");
            System.exit(1);
        }
        CanvasSettings canvasSettings = new CanvasSettings();
        canvasSettings.normalsize = n3;
        BBox bBox = ((JDRGroup)serializable).getBBox();
        canvasSettings.paper = JDRPaper.getClosestEnclosingPredefinedPaper(bBox.getWidth(), bBox.getHeight(), f);
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(new FileOutputStream(string3));
        }
        catch (IOException iOException) {
            System.err.println("Unable to open '" + string3 + "' " + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        JDR.messageSystem.messageln("");
        JDR.messageSystem.messageln("writing '" + string3 + "'");
        try {
            JDR.save((JDRGroup)serializable, canvasSettings, dataOutputStream, f, 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        JDR.messageSystem.messageln("");
    }
}

