/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.ajr2jdr;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.jdr.CanvasSettings;
import uk.ac.uea.cmp.nlct.jdr.InvalidFormatException;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdr.JDRPaper;
import uk.ac.uea.cmp.nlct.jdr.io.AJR;
import uk.ac.uea.cmp.nlct.jdr.io.JDR;

public class Ajr2Jdr {
    public static void appVersion() {
        System.err.println("ajr2jdr 1.5");
        System.err.println("Copyright (C) 2007 Nicola L C Talbot");
        System.err.println("This is free software distributed under the GNU General Public License.");
        System.err.println("There is NO WARRANTY. See accompanying licence file for details.");
    }

    public static void syntax() {
        System.err.println("Syntax: ajr2jdr [options] <ajr file> <jdr file>");
        System.err.println("Options:");
        System.err.println("-v1.0\tSave as JDR version 1.0");
        System.err.println("-v1.1\tSave as JDR version 1.1");
        System.err.println("-v1.2\tSave as JDR version 1.2");
        System.err.println("-v1.3\tSave as JDR version 1.3");
        System.err.println("-v1.4\tSave as JDR version 1.4");
        System.err.println("-v1.5\tSave as JDR version 1.5 (default)");
        System.err.println("-settings [<n>]\tControls how settings are saved in JDR file. Optionally followed by integer <n> (if omitted, <n>=1):");
        System.err.println("\t0 : don't save settings");
        System.err.println("\t1 : save all settings");
        System.err.println("\t2 : only save paper size (v1.3 and above, for earlier versions equivalent to 0)");
        System.err.println("-nosettings\tEquivalent to -settings 0");
        System.err.println("-settings_as_input\tOnly save settings if they were given in the input file (Default)");
        System.exit(0);
    }

    public static void main(String[] stringArray) {
        String string = null;
        String string2 = null;
        int n = 1;
        float f = 1.6f;
        boolean bl = true;
        JDR.messageSystem.suspend();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-nosettings")) {
                n = 0;
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-settings")) {
                if (i == stringArray.length - 1) {
                    n = 1;
                } else {
                    try {
                        n = Integer.parseInt(stringArray[i + 1]);
                        ++i;
                    }
                    catch (NumberFormatException numberFormatException) {
                        n = 1;
                    }
                }
                bl = false;
                continue;
            }
            if (stringArray[i].equals("-settings_as_input")) {
                bl = true;
                continue;
            }
            if (stringArray[i].equals("-v1.0")) {
                f = 1.0f;
                continue;
            }
            if (stringArray[i].equals("-v1.1")) {
                f = 1.1f;
                continue;
            }
            if (stringArray[i].equals("-v1.2")) {
                f = 1.2f;
                continue;
            }
            if (stringArray[i].equals("-v1.3")) {
                f = 1.3f;
                continue;
            }
            if (stringArray[i].equals("-v1.4")) {
                f = 1.4f;
                continue;
            }
            if (stringArray[i].equals("-v1.5")) {
                f = 1.5f;
                continue;
            }
            if (stringArray[i].equals("-version")) {
                Ajr2Jdr.appVersion();
                System.exit(0);
                continue;
            }
            if (stringArray[i].equals("-help")) {
                Ajr2Jdr.syntax();
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                System.err.println("Unknown switch '" + stringArray[i] + "'");
                System.err.println("Use '-help' for help");
                System.exit(1);
                continue;
            }
            if (string == null) {
                string = stringArray[i];
                continue;
            }
            if (string2 == null) {
                string2 = stringArray[i];
                continue;
            }
            System.err.println("Too many file names specified");
            System.err.println("Use '-help' for help");
            System.exit(1);
        }
        if (string == null) {
            System.err.println("Missing input file");
            System.err.println("Use '-help' for help");
            System.exit(1);
        } else if (string2 == null) {
            System.err.println("Missing output file");
            System.err.println("Use '-help' for help");
            System.exit(1);
        }
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
        }
        catch (IOException iOException) {
            System.err.println("Unable to open '" + string + "' " + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        String string3 = "";
        CanvasSettings canvasSettings = new CanvasSettings();
        JDRGroup jDRGroup = null;
        try {
            jDRGroup = AJR.load(bufferedReader, canvasSettings);
        }
        catch (InvalidFormatException invalidFormatException) {
            System.err.println(invalidFormatException.getMessage());
            System.exit(1);
        }
        catch (EOFException eOFException) {
            System.err.println("Unexpected EOF. (File corrupt?)");
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        int n2 = AJR.getLastLoadedSettingsID();
        if (bl && (n = n2) == 2 && f < 1.3f) {
            System.err.println("Warning: paper only settings not available for versions prior to 1.3 - defaulting to -settings 1");
            n = 1;
        }
        if (n2 == 0 && n != 0) {
            canvasSettings.paper = JDRPaper.getClosestPredefinedPaper(jDRGroup.getBBox().getWidth(), jDRGroup.getBBox().getHeight(), f);
        }
        DataOutputStream dataOutputStream = null;
        try {
            dataOutputStream = new DataOutputStream(new FileOutputStream(string2));
        }
        catch (IOException iOException) {
            System.err.println("Unable to open '" + string2 + "' " + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            JDR.save(jDRGroup, canvasSettings, dataOutputStream, f, n);
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
        try {
            dataOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println(exception);
            System.exit(1);
        }
    }
}

