/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrresources.numfield;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.Document;
import uk.ac.uea.cmp.nlct.jdr.JDRUnit;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.DoubleField;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.SamplePanel;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.TextFieldSampleListener;

public class LengthPanel
extends JPanel
implements ItemListener {
    private JLabel sizeLabel;
    private JComboBox unitBox;
    private DoubleField text;
    public static final int PT = 0;
    public static final int IN = 1;
    public static final int CM = 2;
    public static final int BP = 3;
    private int currentUnit = 0;

    public LengthPanel(String string) {
        this.setLayout(new BoxLayout(this, 0));
        this.sizeLabel = new JLabel(string);
        this.text = new DoubleField(0.0);
        this.text.setColumns(4);
        this.sizeLabel.setLabelFor(this.text);
        this.unitBox = new JComboBox<String>(new String[]{"pt", "in", "cm", "bp"});
        this.unitBox.addItemListener(this);
        this.currentUnit = 3;
        this.setUnit(JDRUnit.bp);
        this.add(this.sizeLabel);
        this.add(this.text);
        this.add(this.unitBox);
    }

    public LengthPanel(String string, char c) {
        this(string);
        this.sizeLabel.setDisplayedMnemonic(c);
    }

    public LengthPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.sizeLabel = null;
        this.text = new DoubleField(0.0);
        this.text.setColumns(4);
        this.unitBox = new JComboBox<String>(new String[]{"pt", "in", "cm", "bp"});
        this.unitBox.addItemListener(this);
        this.currentUnit = 3;
        this.setUnit(JDRUnit.bp);
        this.add(this.text);
        this.add(this.unitBox);
    }

    public LengthPanel(String string, SamplePanel samplePanel) {
        this(string);
        this.text.getDocument().addDocumentListener(new TextFieldSampleListener(samplePanel));
    }

    public LengthPanel(String string, char c, SamplePanel samplePanel) {
        this(string, samplePanel);
        this.sizeLabel.setDisplayedMnemonic(c);
    }

    public LengthPanel(SamplePanel samplePanel) {
        this();
        this.text.getDocument().addDocumentListener(new TextFieldSampleListener(samplePanel));
    }

    public DoubleField getTextField() {
        return this.text;
    }

    public Document getDocument() {
        return this.text.getDocument();
    }

    public double getValue() {
        JDRUnit jDRUnit = this.getUnit();
        return jDRUnit.toBp(this.text.getValue());
    }

    public void setBpValue(double d) {
        JDRUnit jDRUnit = this.getUnit();
        if (jDRUnit == JDRUnit.bp) {
            this.text.setValue(d);
        } else {
            this.text.setValue(jDRUnit.fromBp(d));
        }
    }

    public void setValue(double d) {
        JDRUnit jDRUnit = this.getUnit();
        this.currentUnit = jDRUnit == JDRUnit.in ? 1 : (jDRUnit == JDRUnit.cm ? 2 : (jDRUnit == JDRUnit.bp ? 3 : 0));
        DecimalFormat decimalFormat = new DecimalFormat("0.##");
        this.text.setText(decimalFormat.format(jDRUnit.fromBp(d)));
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.text.addKeyListener(keyListener);
        this.unitBox.addKeyListener(keyListener);
    }

    public void setUnit(JDRUnit jDRUnit) {
        this.currentUnit = jDRUnit == JDRUnit.in ? 1 : (jDRUnit == JDRUnit.cm ? 2 : (jDRUnit == JDRUnit.bp ? 3 : 0));
        this.unitBox.setSelectedIndex(this.currentUnit);
    }

    public JDRUnit getUnit() {
        switch (this.unitBox.getSelectedIndex()) {
            case 0: {
                return JDRUnit.pt;
            }
            case 1: {
                return JDRUnit.in;
            }
            case 2: {
                return JDRUnit.cm;
            }
            case 3: {
                return JDRUnit.bp;
            }
        }
        return JDRUnit.pt;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (itemEvent.getStateChange() == 1 && object == this.unitBox) {
            JDRUnit jDRUnit = JDRUnit.pt;
            switch (this.currentUnit) {
                case 1: {
                    jDRUnit = JDRUnit.in;
                    break;
                }
                case 2: {
                    jDRUnit = JDRUnit.cm;
                    break;
                }
                case 3: {
                    jDRUnit = JDRUnit.bp;
                }
            }
            this.currentUnit = this.unitBox.getSelectedIndex();
            JDRUnit jDRUnit2 = this.getUnit();
            double d = this.text.getValue();
            DecimalFormat decimalFormat = new DecimalFormat("0.##");
            double d2 = jDRUnit2.fromUnit(d, jDRUnit);
            this.text.setText(decimalFormat.format(d2));
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.sizeLabel != null) {
            this.sizeLabel.setEnabled(bl);
        }
        this.unitBox.setEnabled(bl);
        this.text.setEnabled(bl);
    }

    public String info() {
        String string = System.getProperty("line.separator", "\n");
        String string2 = "LengthPanel:" + string;
        string2 = string2 + "   unit box:" + string;
        string2 = string2 + "      value: " + this.unitBox.getSelectedItem() + string;
        string2 = string2 + "      has focus: " + this.unitBox.hasFocus() + string;
        string2 = string2 + "   value box:" + string;
        string2 = string2 + "      value: " + this.text.getValue() + string;
        string2 = string2 + "      has focus: " + this.text.hasFocus() + string;
        return string2;
    }
}

