/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdrresources.JDRApp;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.numfield.NonNegativeDoubleField;

public class ZoomSettings
extends JDialog
implements ActionListener {
    private JDRApp application_;
    private NonNegativeDoubleField magBox;

    public ZoomSettings(JDRApp jDRApp, Frame frame) {
        super(frame, JDRResources.getString("zoom.title"), true);
        this.setSize(300, 100);
        this.setLocationRelativeTo(frame);
        this.application_ = jDRApp;
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(JDRResources.getString("zoom.magnification"));
        jLabel.setDisplayedMnemonic(JDRResources.getChar("zoom.magnification.mnemonic"));
        jPanel.add(jLabel);
        this.magBox = new NonNegativeDoubleField(100.0);
        jLabel.setLabelFor(this.magBox);
        jPanel.add(this.magBox);
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.add(JDRResources.createOkayButton(this));
        jPanel2.add(JDRResources.createCancelButton(this));
        jPanel2.add(JDRResources.createHelpButton("sec:zoom"));
        this.getContentPane().add((Component)jPanel2, "South");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                ZoomSettings.this.magBox.requestFocusInWindow();
            }
        });
    }

    public void display() {
        this.setMag(this.application_.getCurrentMagnification());
        this.setVisible(true);
    }

    public void okay() {
        this.application_.setCurrentMagnification(this.getMag());
        this.setVisible(false);
    }

    public void setMag(double d) {
        this.magBox.setValue(d);
        this.magBox.setCaretPosition(0);
    }

    public double getMag() {
        double d = this.magBox.getValue();
        if (d == 0.0) {
            d = 1.0;
        }
        return d;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("okay")) {
            this.okay();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        }
    }
}

