/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;
import uk.ac.uea.cmp.nlct.jdrresources.SlidingToolControl;

class SlidingToolControlButton
extends JButton {
    protected SlidingToolControl control;
    protected static ImageIcon vScrollBlockDown;
    protected static ImageIcon vScrollBlockUp;
    protected static ImageIcon vScrollEndDown;
    protected static ImageIcon vScrollEndUp;
    protected static ImageIcon vScrollUnitDown;
    protected static ImageIcon vScrollUnitUp;
    protected static ImageIcon hScrollBlockLeft;
    protected static ImageIcon hScrollBlockRight;
    protected static ImageIcon hScrollEndLeft;
    protected static ImageIcon hScrollEndRight;
    protected static ImageIcon hScrollUnitLeft;
    protected static ImageIcon hScrollUnitRight;
    protected static ImageIcon vScrollBlockDownPressed;
    protected static ImageIcon vScrollBlockUpPressed;
    protected static ImageIcon vScrollEndDownPressed;
    protected static ImageIcon vScrollEndUpPressed;
    protected static ImageIcon vScrollUnitDownPressed;
    protected static ImageIcon vScrollUnitUpPressed;
    protected static ImageIcon hScrollBlockLeftPressed;
    protected static ImageIcon hScrollBlockRightPressed;
    protected static ImageIcon hScrollEndLeftPressed;
    protected static ImageIcon hScrollEndRightPressed;
    protected static ImageIcon hScrollUnitLeftPressed;
    protected static ImageIcon hScrollUnitRightPressed;
    protected static String vScrollBlockDownTT;
    protected static String vScrollBlockUpTT;
    protected static String vScrollEndDownTT;
    protected static String vScrollEndUpTT;
    protected static String vScrollUnitDownTT;
    protected static String vScrollUnitUpTT;
    protected static String hScrollBlockLeftTT;
    protected static String hScrollBlockRightTT;
    protected static String hScrollEndLeftTT;
    protected static String hScrollEndRightTT;
    protected static String hScrollUnitLeftTT;
    protected static String hScrollUnitRightTT;
    private static boolean imagesLoaded;
    private int type;
    public static final int UNIT = 0;
    public static final int BLOCK = 1;
    public static final int END = 2;

    private SlidingToolControlButton() {
        this(null, 0);
    }

    public SlidingToolControlButton(SlidingToolControl slidingToolControl, int n) {
        this.control = slidingToolControl;
        this.setType(n);
        if (!imagesLoaded) {
            SlidingToolControlButton.loadImages();
        }
        this.setBorderPainted(false);
        this.setContentAreaFilled(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.updateToolTipText();
    }

    public static SlidingToolControlButton createBlock(SlidingToolControl slidingToolControl) {
        return new SlidingToolControlButton(slidingToolControl, 1);
    }

    public static SlidingToolControlButton createUnit(SlidingToolControl slidingToolControl) {
        return new SlidingToolControlButton(slidingToolControl, 0);
    }

    public static SlidingToolControlButton createEnd(SlidingToolControl slidingToolControl) {
        return new SlidingToolControlButton(slidingToolControl, 2);
    }

    private static void loadImages() {
        vScrollBlockDown = JDRResources.appIcon("vScrollBlockDown.png");
        vScrollBlockUp = JDRResources.appIcon("vScrollBlockUp.png");
        vScrollEndDown = JDRResources.appIcon("vScrollEndDown.png");
        vScrollEndUp = JDRResources.appIcon("vScrollEndUp.png");
        vScrollUnitDown = JDRResources.appIcon("vScrollUnitDown.png");
        vScrollUnitUp = JDRResources.appIcon("vScrollUnitUp.png");
        hScrollBlockLeft = JDRResources.appIcon("hScrollBlockLeft.png");
        hScrollBlockRight = JDRResources.appIcon("hScrollBlockRight.png");
        hScrollEndLeft = JDRResources.appIcon("hScrollEndLeft.png");
        hScrollEndRight = JDRResources.appIcon("hScrollEndRight.png");
        hScrollUnitLeft = JDRResources.appIcon("hScrollUnitLeft.png");
        hScrollUnitRight = JDRResources.appIcon("hScrollUnitRight.png");
        vScrollBlockDownPressed = JDRResources.appIcon("vScrollBlockDownPressed.png");
        vScrollBlockUpPressed = JDRResources.appIcon("vScrollBlockUpPressed.png");
        vScrollEndDownPressed = JDRResources.appIcon("vScrollEndDownPressed.png");
        vScrollEndUpPressed = JDRResources.appIcon("vScrollEndUpPressed.png");
        vScrollUnitDownPressed = JDRResources.appIcon("vScrollUnitDownPressed.png");
        vScrollUnitUpPressed = JDRResources.appIcon("vScrollUnitUpPressed.png");
        hScrollBlockLeftPressed = JDRResources.appIcon("hScrollBlockLeftPressed.png");
        hScrollBlockRightPressed = JDRResources.appIcon("hScrollBlockRightPressed.png");
        hScrollEndLeftPressed = JDRResources.appIcon("hScrollEndLeftPressed.png");
        hScrollEndRightPressed = JDRResources.appIcon("hScrollEndRightPressed.png");
        hScrollUnitLeftPressed = JDRResources.appIcon("hScrollUnitLeftPressed.png");
        hScrollUnitRightPressed = JDRResources.appIcon("hScrollUnitRightPressed.png");
        vScrollBlockDownTT = JDRResources.getString("tooltip.vScrollBlockDown");
        vScrollBlockUpTT = JDRResources.getString("tooltip.vScrollBlockUp");
        vScrollEndDownTT = JDRResources.getString("tooltip.vScrollEndDown");
        vScrollEndUpTT = JDRResources.getString("tooltip.vScrollEndUp");
        vScrollUnitDownTT = JDRResources.getString("tooltip.vScrollUnitDown");
        vScrollUnitUpTT = JDRResources.getString("tooltip.vScrollUnitUp");
        hScrollBlockLeftTT = JDRResources.getString("tooltip.hScrollBlockLeft");
        hScrollBlockRightTT = JDRResources.getString("tooltip.hScrollBlockRight");
        hScrollEndLeftTT = JDRResources.getString("tooltip.hScrollEndLeft");
        hScrollEndRightTT = JDRResources.getString("tooltip.hScrollEndRight");
        hScrollUnitLeftTT = JDRResources.getString("tooltip.hScrollUnitLeft");
        hScrollUnitRightTT = JDRResources.getString("tooltip.hScrollUnitRight");
        imagesLoaded = true;
    }

    public void setType(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Control type must be one of: UNIT, BLOCK, END");
            }
        }
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public String getControlLabel() {
        String string;
        String string2;
        if (this.control == null || this.control.getSlidingToolBar() == null) {
            return null;
        }
        if (this.control.getSlidingToolBar().getOrientation() == 0) {
            string2 = this.control.getDirection() == 0 ? "Left" : "Right";
            string = "h";
        } else {
            string2 = this.control.getDirection() == 0 ? "Up" : "Down";
            string = "v";
        }
        String string3 = "";
        switch (this.type) {
            case 0: {
                string3 = "Unit";
                break;
            }
            case 1: {
                string3 = "Block";
                break;
            }
            case 2: {
                string3 = "End";
            }
        }
        return string + "Scroll" + string3 + string2;
    }

    public void updateToolTipText() {
        String string = this.getControlLabel();
        String string2 = null;
        if (string == null) {
            return;
        }
        if (string.equals("vScrollBlockDown")) {
            string2 = vScrollBlockDownTT;
        } else if (string.equals("vScrollBlockUp")) {
            string2 = vScrollBlockUpTT;
        } else if (string.equals("vScrollUnitDown")) {
            string2 = vScrollUnitDownTT;
        } else if (string.equals("vScrollUnitUp")) {
            string2 = vScrollUnitUpTT;
        } else if (string.equals("vScrollEndUp")) {
            string2 = vScrollEndUpTT;
        } else if (string.equals("vScrollEndDown")) {
            string2 = vScrollEndDownTT;
        } else if (string.equals("hScrollBlockLeft")) {
            string2 = hScrollBlockLeftTT;
        } else if (string.equals("hScrollBlockRight")) {
            string2 = hScrollBlockRightTT;
        } else if (string.equals("hScrollUnitLeft")) {
            string2 = hScrollUnitLeftTT;
        } else if (string.equals("hScrollUnitRight")) {
            string2 = hScrollUnitRightTT;
        } else if (string.equals("hScrollEndLeft")) {
            string2 = hScrollEndLeftTT;
        } else if (string.equals("hScrollEndRight")) {
            string2 = hScrollEndRightTT;
        }
        this.setToolTipText(string2);
    }

    @Override
    public Icon getIcon() {
        String string = this.getControlLabel();
        if (string == null) {
            return null;
        }
        if (string.equals("vScrollBlockDown")) {
            return vScrollBlockDown;
        }
        if (string.equals("vScrollBlockUp")) {
            return vScrollBlockUp;
        }
        if (string.equals("vScrollUnitDown")) {
            return vScrollUnitDown;
        }
        if (string.equals("vScrollUnitUp")) {
            return vScrollUnitUp;
        }
        if (string.equals("vScrollEndUp")) {
            return vScrollEndUp;
        }
        if (string.equals("vScrollEndDown")) {
            return vScrollEndDown;
        }
        if (string.equals("hScrollBlockLeft")) {
            return hScrollBlockLeft;
        }
        if (string.equals("hScrollBlockRight")) {
            return hScrollBlockRight;
        }
        if (string.equals("hScrollUnitLeft")) {
            return hScrollUnitLeft;
        }
        if (string.equals("hScrollUnitRight")) {
            return hScrollUnitRight;
        }
        if (string.equals("hScrollEndLeft")) {
            return hScrollEndLeft;
        }
        if (string.equals("hScrollEndRight")) {
            return hScrollEndRight;
        }
        return null;
    }

    @Override
    public Icon getPressedIcon() {
        String string = this.getControlLabel();
        if (string == null) {
            return null;
        }
        if (string.equals("vScrollBlockDown")) {
            return vScrollBlockDownPressed;
        }
        if (string.equals("vScrollBlockUp")) {
            return vScrollBlockUpPressed;
        }
        if (string.equals("vScrollUnitDown")) {
            return vScrollUnitDownPressed;
        }
        if (string.equals("vScrollUnitUp")) {
            return vScrollUnitUpPressed;
        }
        if (string.equals("vScrollEndUp")) {
            return vScrollEndUpPressed;
        }
        if (string.equals("vScrollEndDown")) {
            return vScrollEndDownPressed;
        }
        if (string.equals("hScrollBlockLeft")) {
            return hScrollBlockLeftPressed;
        }
        if (string.equals("hScrollBlockRight")) {
            return hScrollBlockRightPressed;
        }
        if (string.equals("hScrollUnitLeft")) {
            return hScrollUnitLeftPressed;
        }
        if (string.equals("hScrollUnitRight")) {
            return hScrollUnitRightPressed;
        }
        if (string.equals("hScrollEndLeft")) {
            return hScrollEndLeftPressed;
        }
        if (string.equals("hScrollEndRight")) {
            return hScrollEndRightPressed;
        }
        return null;
    }

    static {
        imagesLoaded = false;
    }
}

