/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import uk.ac.uea.cmp.nlct.jdrresources.SlidingToolBar;
import uk.ac.uea.cmp.nlct.jdrresources.SlidingToolControlButton;

public class SlidingToolControl
extends JComponent {
    protected AbstractButton block;
    protected AbstractButton unit;
    protected AbstractButton endPoint;
    protected SlidingToolBar slidingToolBar;
    protected int direction = 0;
    public static final int UP = 0;
    public static final int DOWN = 1;
    protected BoxLayout boxLayout;

    public SlidingToolControl(SlidingToolBar slidingToolBar, int n) {
        this.setSlidingToolBar(slidingToolBar);
        this.setDirection(n);
        this.setUnitControl(this.createUnitControl());
        this.setBlockControl(this.createBlockControl());
        this.setEndControl(this.createEndControl());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    public void removeSlidingToolBar() {
        if (this.slidingToolBar != null) {
            if (this.block != null) {
                this.block.removeActionListener(this.slidingToolBar);
            }
            if (this.unit != null) {
                this.unit.removeActionListener(this.slidingToolBar);
            }
            if (this.endPoint != null) {
                this.endPoint.removeActionListener(this.slidingToolBar);
            }
        }
        this.slidingToolBar = null;
    }

    public void setSlidingToolBar(SlidingToolBar slidingToolBar) {
        SlidingToolBar slidingToolBar2 = this.slidingToolBar;
        if (this.slidingToolBar != null) {
            if (this.block != null) {
                this.block.removeActionListener(this.slidingToolBar);
            }
            if (this.unit != null) {
                this.unit.removeActionListener(this.slidingToolBar);
            }
            if (this.endPoint != null) {
                this.endPoint.removeActionListener(this.slidingToolBar);
            }
        }
        this.slidingToolBar = slidingToolBar;
        if (this.slidingToolBar != null) {
            if (this.block != null) {
                this.block.addActionListener(this.slidingToolBar);
            }
            if (this.unit != null) {
                this.unit.addActionListener(this.slidingToolBar);
            }
            if (this.endPoint != null) {
                this.endPoint.addActionListener(this.slidingToolBar);
            }
        }
        if (slidingToolBar2 != null && this.slidingToolBar != null && slidingToolBar2.getOrientation() != this.slidingToolBar.getOrientation() || this.boxLayout == null || slidingToolBar2 == null && this.slidingToolBar != null) {
            this.setLayout(this.createLayout());
        }
    }

    public SlidingToolBar getSlidingToolBar() {
        return this.slidingToolBar;
    }

    public void setDirection(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Direction must be one of: UP, DOWN");
            }
        }
        this.direction = n;
        if (this.unit != null) {
            this.setUnitActionCommand();
        }
        if (this.block != null) {
            this.setBlockActionCommand();
        }
        if (this.endPoint != null) {
            this.setEndActionCommand();
        }
    }

    public int getDirection() {
        return this.direction;
    }

    public void setUnitControl(AbstractButton abstractButton) {
        if (this.unit != null) {
            this.remove(this.unit);
            if (this.slidingToolBar != null) {
                this.unit.removeActionListener(this.slidingToolBar);
                this.unit.setActionCommand(null);
            }
        }
        this.unit = abstractButton;
        if (this.unit != null) {
            this.add(this.unit);
            if (this.slidingToolBar != null) {
                this.unit.addActionListener(this.slidingToolBar);
                this.setUnitActionCommand();
            }
        }
    }

    private void setUnitActionCommand() {
        this.unit.setActionCommand(this.direction == 0 ? "scrollUnitUp" : "scrollUnitDown");
        if (this.unit instanceof SlidingToolControlButton) {
            ((SlidingToolControlButton)this.unit).updateToolTipText();
        }
    }

    private void setBlockActionCommand() {
        this.block.setActionCommand(this.direction == 0 ? "scrollBlockUp" : "scrollBlockDown");
        if (this.block instanceof SlidingToolControlButton) {
            ((SlidingToolControlButton)this.block).updateToolTipText();
        }
    }

    private void setEndActionCommand() {
        this.endPoint.setActionCommand(this.direction == 0 ? "scrollEndUp" : "scrollEndDown");
        if (this.endPoint instanceof SlidingToolControlButton) {
            ((SlidingToolControlButton)this.endPoint).updateToolTipText();
        }
    }

    public void setBlockControl(AbstractButton abstractButton) {
        if (this.block != null) {
            this.remove(this.block);
            if (this.slidingToolBar != null) {
                this.block.removeActionListener(this.slidingToolBar);
                this.block.setActionCommand(null);
            }
        }
        this.block = abstractButton;
        if (this.block != null) {
            this.add(this.block);
            if (this.slidingToolBar != null) {
                this.block.addActionListener(this.slidingToolBar);
                this.setBlockActionCommand();
            }
        }
    }

    public void setEndControl(AbstractButton abstractButton) {
        if (this.endPoint != null) {
            this.remove(this.endPoint);
            if (this.slidingToolBar != null) {
                this.endPoint.removeActionListener(this.slidingToolBar);
                this.endPoint.setActionCommand(null);
            }
        }
        this.endPoint = abstractButton;
        if (this.endPoint != null) {
            this.add(this.endPoint);
            if (this.slidingToolBar != null) {
                this.endPoint.addActionListener(this.slidingToolBar);
                this.setEndActionCommand();
            }
        }
    }

    public AbstractButton getUnitControl() {
        return this.unit;
    }

    public AbstractButton getBlockControl() {
        return this.block;
    }

    public AbstractButton getEndControl() {
        return this.endPoint;
    }

    protected BoxLayout createLayout() {
        return new BoxLayout(this, this.slidingToolBar == null ? 1 : (this.slidingToolBar.getOrientation() == 0 ? 1 : 0));
    }

    protected AbstractButton createUnitControl() {
        return SlidingToolControlButton.createUnit(this);
    }

    protected AbstractButton createBlockControl() {
        return SlidingToolControlButton.createBlock(this);
    }

    protected AbstractButton createEndControl() {
        return SlidingToolControlButton.createEnd(this);
    }

    @Override
    public void setLayout(LayoutManager layoutManager) {
        if (layoutManager == null) {
            throw new NullPointerException();
        }
        if (!(layoutManager instanceof BoxLayout)) {
            throw new ClassCastException();
        }
        this.boxLayout = (BoxLayout)layoutManager;
        super.setLayout(this.boxLayout);
    }
}

