/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.uea.cmp.nlct.jdrresources.SlidingToolControl;

public class SlidingToolBar
extends JComponent
implements ActionListener,
ChangeListener {
    private Border viewportBorder;
    protected int unitIncrement = 10;
    protected int policy = 0;
    protected int orientation = 0;
    protected JViewport viewport;
    protected SlidingToolControl upComponent;
    protected SlidingToolControl downComponent;
    public static final int AS_NEEDED = 0;
    public static final int ALWAYS = 1;
    public static final int NEVER = 2;
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    public SlidingToolBar(Component component, int n, int n2) {
        this.setLayout(new BorderLayout());
        this.setOrientation(n2);
        this.setPolicy(n);
        this.setViewport(this.createViewport());
        this.setUpComponent(this.createUpComponent());
        this.setDownComponent(this.createDownComponent());
        if (component != null) {
            this.setViewportView(component);
        }
    }

    public SlidingToolBar(Component component) {
        this(component, 0, 0);
    }

    public SlidingToolBar(Component component, int n) {
        this(component, 0, n);
    }

    public void setOrientation(int n) {
        switch (n) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
        this.orientation = n;
        if (this.upComponent != null) {
            this.remove(this.upComponent);
            this.add((Component)this.upComponent, n == 0 ? "East" : "North");
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setPolicy(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("policy must be one of: AS_NEEDED, ALWAYS, NEVER");
            }
        }
        this.policy = n;
        this.revalidate();
    }

    public void setViewport(JViewport jViewport) {
        if (this.viewport != null) {
            this.remove(this.viewport);
            this.viewport.removeChangeListener(this);
        }
        this.viewport = jViewport;
        if (jViewport != null) {
            this.add((Component)jViewport, "Center");
            jViewport.addChangeListener(this);
        }
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public void setViewportView(Component component) {
        this.viewport.setView(component);
    }

    public Component getViewportView() {
        if (this.viewport == null) {
            return null;
        }
        return this.viewport.getView();
    }

    public void setUpComponent(SlidingToolControl slidingToolControl) {
        if (this.upComponent != null) {
            this.remove(this.upComponent);
            this.upComponent.removeSlidingToolBar();
        }
        this.upComponent = slidingToolControl;
        if (slidingToolControl != null) {
            this.add((Component)slidingToolControl, this.orientation == 0 ? "West" : "North");
            slidingToolControl.setSlidingToolBar(this);
        }
        this.checkControls();
    }

    public SlidingToolControl getUpComponent() {
        return this.upComponent;
    }

    public void setDownComponent(SlidingToolControl slidingToolControl) {
        if (this.downComponent != null) {
            this.remove(this.downComponent);
            this.downComponent.removeSlidingToolBar();
        }
        this.downComponent = slidingToolControl;
        if (slidingToolControl != null) {
            this.add((Component)slidingToolControl, this.orientation == 0 ? "East" : "South");
            slidingToolControl.setSlidingToolBar(this);
        }
        this.checkControls();
    }

    public SlidingToolControl getDownComponent() {
        return this.downComponent;
    }

    protected JViewport createViewport() {
        return new JViewport();
    }

    protected SlidingToolControl createUpComponent() {
        return new SlidingToolControl(this, 0);
    }

    protected SlidingToolControl createDownComponent() {
        return new SlidingToolControl(this, 1);
    }

    protected void checkControls() {
        boolean bl;
        boolean bl2;
        Dimension dimension;
        if (this.policy == 1 || this.policy == 2 || this.getViewportView() == null) {
            if (this.upComponent != null) {
                this.upComponent.setVisible(this.policy == 1);
            }
            if (this.downComponent != null) {
                this.downComponent.setVisible(this.policy == 1);
            }
            return;
        }
        Dimension dimension2 = this.viewport.getExtentSize();
        Point point = this.viewport.getViewPosition();
        Dimension dimension3 = this.getViewportView().getPreferredSize();
        Dimension dimension4 = this.upComponent == null ? new Dimension(0, 0) : this.upComponent.getPreferredSize();
        Dimension dimension5 = dimension = this.downComponent == null ? new Dimension(0, 0) : this.downComponent.getPreferredSize();
        if (this.orientation == 0) {
            bl = bl2 = dimension2.width < dimension3.width;
            if (point.x == 0) {
                bl2 = false;
            }
            if (point.x + dimension2.width >= dimension3.width) {
                bl = false;
            }
        } else {
            bl = bl2 = dimension2.height < dimension3.height;
            if (point.y == 0) {
                bl2 = false;
            }
            if (point.y + dimension2.height >= dimension3.height) {
                bl = false;
            }
        }
        if (this.upComponent != null) {
            this.upComponent.setVisible(bl2);
        }
        if (this.downComponent != null) {
            this.downComponent.setVisible(bl);
        }
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public void setUnitIncrement(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Unit increment must be > 0");
        }
        this.unitIncrement = n;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string == null || this.viewport == null) {
            return;
        }
        Rectangle rectangle = this.viewport.getViewRect();
        Dimension dimension = this.getViewportView().getPreferredSize();
        int n = 0;
        if (string.equals("scrollUnitUp")) {
            n = -this.unitIncrement;
        } else if (string.equals("scrollUnitDown")) {
            n = this.unitIncrement;
        } else if (string.equals("scrollBlockUp")) {
            n = -(this.orientation == 0 ? rectangle.width : rectangle.height);
        } else if (string.equals("scrollBlockDown")) {
            n = this.orientation == 0 ? rectangle.width : rectangle.height;
        } else if (string.equals("scrollEndUp")) {
            n = -(this.orientation == 0 ? dimension.width : dimension.height);
        } else if (string.equals("scrollEndDown")) {
            int n2 = n = this.orientation == 0 ? dimension.width : dimension.height;
        }
        if (this.orientation == 0) {
            rectangle.x += n;
            if (rectangle.x + rectangle.width > dimension.width) {
                rectangle.x = dimension.width - rectangle.width;
            }
            if (rectangle.x < 0) {
                rectangle.x = 0;
            }
        } else {
            rectangle.y += n;
            if (rectangle.y + rectangle.height > dimension.height) {
                rectangle.y = dimension.height - rectangle.height;
            }
            if (rectangle.y < 0) {
                rectangle.y = 0;
            }
        }
        this.viewport.setViewPosition(new Point(rectangle.x, rectangle.y));
        this.checkControls();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.getViewport()) {
            this.checkControls();
        }
    }
}

