/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.NotSerializableException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import uk.ac.uea.cmp.nlct.jdr.JDRGroup;
import uk.ac.uea.cmp.nlct.jdrresources.JDRImage;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;

public class JDRTransferHandler
extends TransferHandler
implements Transferable {
    private DataFlavor[] flavors = new DataFlavor[1];
    private JDRImage source;
    private JDRGroup group;

    public JDRTransferHandler() {
        this.flavors[0] = new DataFlavor(new JDRGroup().getClass(), "JDRGroup");
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (!(jComponent instanceof JDRImage)) {
            return false;
        }
        int n = dataFlavorArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.flavors.length;
            for (int j = 0; j < n2; ++j) {
                if (!dataFlavorArray[i].equals(this.flavors[j])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Transferable createTransferable(JComponent jComponent) {
        this.source = null;
        this.group = null;
        if (jComponent instanceof JDRImage) {
            JDRGroup jDRGroup;
            JDRImage jDRImage = (JDRImage)((Object)jComponent);
            this.group = jDRGroup = jDRImage.getSelection();
            this.source = jDRImage;
            return this;
        }
        return null;
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        if (jComponent instanceof JDRImage) {
            JDRImage jDRImage = (JDRImage)((Object)jComponent);
            if (transferable.isDataFlavorSupported(this.flavors[0])) {
                try {
                    this.group = (JDRGroup)transferable.getTransferData(this.flavors[0]);
                    jDRImage.copySelection(this.group);
                    return true;
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                }
                catch (NotSerializableException notSerializableException) {
                    JDRResources.internalError(null, notSerializableException);
                }
                catch (Exception exception) {
                    JDRResources.error(null, exception);
                }
            }
        }
        return false;
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) {
        if (this.isDataFlavorSupported(dataFlavor)) {
            return this.group;
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.isMimeTypeEqual("application/x-java-serialized-object");
    }
}

