/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Locale;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import uk.ac.uea.cmp.nlct.jdrresources.CopyAction;
import uk.ac.uea.cmp.nlct.jdrresources.DictionaryFilter;
import uk.ac.uea.cmp.nlct.jdrresources.DirectoryFilter;
import uk.ac.uea.cmp.nlct.jdrresources.JDRButton;
import uk.ac.uea.cmp.nlct.jdrresources.JDRDictionary;
import uk.ac.uea.cmp.nlct.jdrresources.JDRToggleButton;
import uk.ac.uea.cmp.nlct.jdrresources.JDRToolButton;

public class JDRResources {
    private static JDRDictionary dictionary;
    private static HelpBroker mainHelpBroker;
    private static CSH.DisplayHelpFromSource csh;
    public static String dictLocaleId;
    public static String helpLocaleId;
    public static boolean debugMode;
    private static DirectoryFilter directoryFilter;
    private static DictionaryFilter dictionaryFilter;

    public static ImageIcon appIcon(String string) {
        URL uRL = JDRResources.class.getResource("icons/" + string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        JDRResources.error(JDRResources.getString("error.file_not_found") + ": icons/" + string);
        return null;
    }

    public static Image getImage(String string) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        return toolkit.getImage("icons/" + string);
    }

    public static void displayStackTrace(Component component, String string, Exception exception) {
        JDRResources.displayStackTrace(component, string, "" + exception, exception);
    }

    public static void displayStackTrace(Component component, String string, String string2, Exception exception) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        String string3 = JDRResources.getString("stacktrace.message", "Error Message");
        JTextArea jTextArea = new JTextArea(10, 10);
        jTextArea.setEditable(false);
        jTextArea.setText(string2);
        jTabbedPane.addTab(string3, null, jTextArea, string3);
        JPanel jPanel = new JPanel();
        JTextArea jTextArea2 = new JTextArea(10, 20);
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        String string4 = "";
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n; ++i) {
            string4 = string4 + stackTraceElementArray[i] + "\n";
        }
        jTextArea2.setText(string4);
        jTextArea2.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea2);
        jPanel.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton(JDRResources.getString("stacktrace.copy", "Copy"));
        jButton.setMnemonic(JDRResources.getChar("stacktrace.copy.mnemonic", 'C'));
        jButton.addActionListener(new CopyAction(jTextArea2));
        jPanel.add((Component)jButton, "South");
        string3 = JDRResources.getString("stacktrace.details", "Details");
        jTabbedPane.addTab(string3, null, jPanel, string3);
        String string5 = JDRResources.getString("label.okay", "Okay");
        String string6 = JDRResources.getString("label.quit_without_saving", "Quit Without Saving");
        int n2 = JOptionPane.showOptionDialog(component, jTabbedPane, string, 0, 0, null, new String[]{string5, string6}, string5);
        if (n2 == 1) {
            System.exit(0);
        }
    }

    public static void internalError(Component component, Exception exception) {
        JDRResources.displayStackTrace(component, JDRResources.getString("internal_error.title", "Internal Error"), exception);
    }

    public static void internalError(Component component, String string, Exception exception) {
        JDRResources.displayStackTrace(component, JDRResources.getString("internal_error.title", "Internal Error"), string, exception);
    }

    public static void internalError(Component component, String string) {
        String string2 = JDRResources.getString("label.okay", "Okay");
        String string3 = JDRResources.getString("label.quit_without_saving", "Quit Without Saving");
        int n = JOptionPane.showOptionDialog(component, string, JDRResources.getString("internal_error.title", "Internal Error"), 0, 0, null, new String[]{string2, string3}, string2);
        if (n == 1) {
            System.exit(0);
        }
    }

    public static void internalError(Component component, String[] stringArray) {
        String string = JDRResources.getString("label.okay", "Okay");
        String string2 = JDRResources.getString("label.quit_without_saving", "Quit Without Saving");
        int n = JOptionPane.showOptionDialog(component, stringArray, JDRResources.getString("internal_error.title", "Internal Error"), 0, 0, null, new String[]{string, string2}, string);
        if (n == 1) {
            System.exit(0);
        }
    }

    public static void internalError(String string) {
        System.err.println(string);
        JDRResources.internalError(null, string);
    }

    public static void error(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, JDRResources.getString("error.title", "Error"), 0);
    }

    public static void error(Component component, String[] stringArray) {
        JOptionPane.showMessageDialog(component, stringArray, JDRResources.getString("error.title", "Error"), 0);
    }

    public static void error(String string) {
        System.err.println(string);
        JDRResources.error(null, string);
    }

    public static void error(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.err.println(stringArray[i]);
        }
        JDRResources.error(null, stringArray);
    }

    public static void error(Component component, Exception exception) {
        JDRResources.displayStackTrace(component, JDRResources.getString("error.title", "Error"), exception);
    }

    public static void error(Component component, String string, Exception exception) {
        JDRResources.displayStackTrace(component, JDRResources.getString("error.title", "Error"), string, exception);
    }

    public static void fatalError(String string, Exception exception) {
        JTabbedPane jTabbedPane = new JTabbedPane();
        String string2 = JDRResources.getString("stacktrace.message", "Error Message");
        JTextArea jTextArea = new JTextArea(10, 10);
        jTextArea.setEditable(false);
        jTextArea.setText(string);
        jTabbedPane.addTab(string2, null, jTextArea, string2);
        JPanel jPanel = new JPanel();
        JTextArea jTextArea2 = new JTextArea(10, 20);
        StackTraceElement[] stackTraceElementArray = exception.getStackTrace();
        String string3 = "";
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n; ++i) {
            string3 = string3 + stackTraceElementArray[i] + "\n";
        }
        jTextArea2.setText(string3);
        jTextArea2.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea2);
        jPanel.add((Component)jScrollPane, "Center");
        JButton jButton = new JButton(JDRResources.getString("stacktrace.copy", "Copy"));
        jButton.setMnemonic(JDRResources.getChar("stacktrace.copy.mnemonic", 'C'));
        jButton.addActionListener(new CopyAction(jTextArea2));
        jPanel.add((Component)jButton, "South");
        string2 = JDRResources.getString("stacktrace.details", "Details");
        jTabbedPane.addTab(string2, null, jPanel, string2);
        JOptionPane.showMessageDialog(null, jTabbedPane, JDRResources.getString("error.fatal", "Fatal Error"), 0);
        System.exit(0);
    }

    public static void warning(Component component, String[] stringArray) {
        JOptionPane.showMessageDialog(component, stringArray, JDRResources.getString("warning.title"), 2);
    }

    public static void warning(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, JDRResources.getString("warning.title"), 2);
    }

    public static void warning(String string) {
        JDRResources.warning(null, string);
    }

    public static int getInt(String string) throws NumberFormatException {
        if (dictionary == null) {
            return -1;
        }
        return Integer.parseInt(dictionary.getString(string));
    }

    public static String getStringWithValue(String string, String[] stringArray, String string2) {
        if (dictionary == null) {
            return string2;
        }
        String string3 = dictionary.getString(string);
        if (string3 == null) {
            return string2;
        }
        for (int i = 0; i < stringArray.length && i < 9; ++i) {
            char c = new String("" + (i + 1)).charAt(0);
            string3 = JDRResources.getReplacementString(string3, c, stringArray[i]);
        }
        return string3.replace("\\\\", "\\");
    }

    public static String getStringWithValue(String string, String[] stringArray) {
        String string2 = JDRResources.getString(string);
        for (int i = 0; i < stringArray.length && i < 9; ++i) {
            char c = new String("" + (i + 1)).charAt(0);
            string2 = JDRResources.getReplacementString(string2, c, stringArray[i]);
        }
        return string2.replace("\\\\", "\\");
    }

    public static String getStringWithValue(String string, String string2) {
        String string3 = JDRResources.getString(string);
        string3 = JDRResources.getReplacementString(string3, '1', string2);
        return string3.replace("\\\\", "\\");
    }

    public static String getStringWithValue(String string, int n) {
        return JDRResources.getStringWithValue(string, "" + n);
    }

    public static String getStringWithValue(String string, long l) {
        return JDRResources.getStringWithValue(string, "" + l);
    }

    public static String getStringWithValue(String string, double d) {
        return JDRResources.getStringWithValue(string, "" + d);
    }

    private static String getReplacementString(String string, char c, String string2) {
        String string3 = "";
        while (!string.equals("")) {
            int n = string.indexOf(92);
            if (n == -1 || n == string.length() - 1) {
                return string3 + string;
            }
            while (string.charAt(n + 1) == '\\') {
                if (++n != string.length()) continue;
                return string3 + string;
            }
            if (string.charAt(n + 1) == c) {
                string3 = string3 + string.substring(0, n) + string2;
                if (n + 2 == string.length()) {
                    return string3;
                }
                string = string.substring(n + 2);
                continue;
            }
            if ((n = string.indexOf(92, n + 1)) == -1) {
                return string3 + string;
            }
            string3 = string3 + string.substring(0, n);
            string = string.substring(n);
        }
        return string3;
    }

    public static String getString(String string, String string2) {
        if (dictionary == null) {
            return string2;
        }
        return dictionary.getString(string, string2);
    }

    public static String getString(String string) {
        if (dictionary == null) {
            return string;
        }
        return dictionary.getString(string);
    }

    public static char getChar(String string, char c) {
        if (dictionary == null) {
            return c;
        }
        return dictionary.getChar(string, c);
    }

    public static char getChar(String string) {
        return JDRResources.getChar(string, string.charAt(0));
    }

    public static boolean isDictInitialised() {
        return dictionary != null;
    }

    public static void initialiseDictionary(Class<? extends Object> clazz) throws IOException {
        dictionary = new JDRDictionary(clazz);
    }

    public static void initialiseDictionary() throws IOException {
        dictionary = new JDRDictionary();
    }

    public static void initialiseDictionary(InputStream inputStream, InputStream inputStream2) throws IOException {
        dictionary = new JDRDictionary(inputStream, inputStream2);
    }

    public static String getUserConfigDir() {
        String string;
        String string2 = System.getenv("JDRSETTINGS");
        String string3 = null;
        File file = null;
        if (string2 != null && (file = new File(string2)).exists() && file.isDirectory()) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string4 = ".jpgfdraw";
        if (System.getProperty("os.name").contains("Win")) {
            string4 = "jpgfdraw-settings";
        }
        if ((string = System.getProperty("user.home")) != null && (file = new File(string)).exists() && file.isDirectory()) {
            file = new File(string, ".jpgfdraw");
            if (file.exists() && file.isDirectory()) {
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((file = new File(string, "jpgfdraw-settings")).exists() && file.isDirectory()) {
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            file = new File(string, string4);
            file.mkdir();
            if (file.exists() && file.isDirectory()) {
                try {
                    return file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        String string5 = "settings";
        String string6 = System.getenv("USER");
        if (string6 == null) {
            string6 = System.getenv("USERNAME");
        }
        if (string6 != null) {
            string5 = string5 + "/" + string6;
        }
        try {
            URL uRL = JDRResources.class.getResource(string5);
            if (uRL != null) {
                String string7 = uRL.toURI().getPath();
                file = new File(string7);
                if (file.isDirectory()) {
                    string3 = string7;
                } else if (file.exists()) {
                    if (dictionary == null) {
                        JDRResources.error("'" + file.getCanonicalPath() + "' is not a directory");
                    } else {
                        JDRResources.error(JDRResources.getStringWithValue("error.not_a_directory", file.getCanonicalPath()));
                    }
                }
            } else {
                uRL = JDRResources.class.getResource(".");
                if (uRL != null) {
                    file = new File(uRL.toURI().getPath(), string5);
                    if (file.exists() && file.isDirectory() || file.mkdirs()) {
                        uRL = JDRResources.class.getResource(string5);
                        if (uRL != null) {
                            string3 = uRL.toURI().getPath();
                        }
                    } else if (dictionary == null) {
                        JDRResources.error("Can't create config directory '" + file.getCanonicalPath() + "'");
                    } else {
                        JDRResources.error(JDRResources.getStringWithValue("error.config_cant_create", file.getCanonicalPath()));
                    }
                }
            }
        }
        catch (IOException iOException) {
            JDRResources.error(null, iOException);
            iOException.printStackTrace();
        }
        catch (URISyntaxException uRISyntaxException) {
            JDRResources.error(null, uRISyntaxException);
            uRISyntaxException.printStackTrace();
        }
        return string3;
    }

    public static void debugMessage(String string) {
        if (debugMode) {
            System.err.println("debug message: " + string);
        }
    }

    private static URL getHelpSetLocation(String string) throws IOException {
        String string2;
        String string3 = "/resources/helpsets/";
        if (helpLocaleId != null) {
            String string4 = string3 + string + "/" + helpLocaleId + "/" + string + "-" + helpLocaleId + ".hs";
            URL uRL = JDRResources.class.getResource(string4);
            if (uRL == null) {
                JDRResources.warning("Can't find helpset for language '" + helpLocaleId + "'");
                helpLocaleId = null;
            }
            return uRL;
        }
        Locale locale = Locale.getDefault();
        helpLocaleId = string2 = locale.getLanguage() + "-" + locale.getCountry();
        String string5 = string3 + string + "/" + string2 + "/" + string + "-" + string2 + ".hs";
        URL uRL = JDRResources.class.getResource(string5);
        if (uRL == null) {
            String string6 = string5;
            helpLocaleId = locale.getLanguage();
            string5 = string3 + string + "/" + helpLocaleId + "/" + string + "-" + helpLocaleId + ".hs";
            uRL = JDRResources.class.getResource(string5);
            if (uRL == null) {
                string6 = string6 + "\n" + string5;
                if (!string2.equals("en-GB")) {
                    helpLocaleId = "en-GB";
                    string5 = string3 + string + "/" + helpLocaleId + "/" + string + "-" + helpLocaleId + ".hs";
                    uRL = JDRResources.class.getResource(string5);
                    if (uRL == null) {
                        string6 = string6 + "\n" + string5;
                    }
                }
                if (uRL == null) {
                    throw new IOException("Can't find helpset. Tried:\n" + string6);
                }
            }
        }
        return uRL;
    }

    public static String[] getAvailableDictLanguages() {
        File file;
        URL uRL = JDRResources.class.getResource("/resources/dictionaries/");
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return new String[]{"en-GB"};
        }
        File[] fileArray = file.listFiles(dictionaryFilter);
        if (fileArray == null) {
            JDRResources.debugMessage("no dictionaries found");
            return new String[]{"en-GB"};
        }
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            String string = fileArray[i].getName();
            stringArray[i] = string.substring(string.indexOf("-") + 1, string.lastIndexOf("."));
        }
        return stringArray;
    }

    public static String[] getAvailableHelpLanguages(String string) {
        File file;
        URL uRL = JDRResources.class.getResource("/resources/helpsets/" + string);
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            return new String[]{"en-GB"};
        }
        File[] fileArray = file.listFiles(directoryFilter);
        if (fileArray == null) {
            JDRResources.debugMessage("no dictionaries found");
            return new String[]{"en-GB"};
        }
        String[] stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            stringArray[i] = fileArray[i].getName();
        }
        return stringArray;
    }

    public static void initialiseHelp(JFrame jFrame, String string) {
        if (mainHelpBroker == null) {
            HelpSet helpSet = null;
            try {
                URL uRL = JDRResources.getHelpSetLocation(string);
                helpSet = new HelpSet(null, uRL);
            }
            catch (Exception exception) {
                JDRResources.error((Component)jFrame, exception);
            }
            if (helpSet != null) {
                mainHelpBroker = helpSet.createHelpBroker();
            }
            if (mainHelpBroker != null) {
                csh = new CSH.DisplayHelpFromSource(mainHelpBroker);
            }
        }
    }

    public static void enableHelpOnButton(AbstractButton abstractButton, String string) {
        if (mainHelpBroker != null) {
            try {
                mainHelpBroker.enableHelpOnButton((Component)abstractButton, string, mainHelpBroker.getHelpSet());
                csh = new CSH.DisplayHelpFromSource(mainHelpBroker);
                abstractButton.registerKeyboardAction((ActionListener)csh, abstractButton.getActionCommand(), KeyStroke.getKeyStroke(112, 0), 2);
            }
            catch (BadIDException badIDException) {
                JDRResources.internalError(null, (Exception)((Object)badIDException));
            }
        } else {
            JDRResources.internalError(JDRResources.getString("internal_error.no_helpset"));
        }
    }

    public static JMenuItem addHelpItem(JMenu jMenu, String string) {
        JMenuItem jMenuItem = new JMenuItem(JDRResources.getStringWithValue("help.handbook", string));
        jMenu.add(jMenuItem);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        jMenuItem.setMnemonic(JDRResources.getChar("help.handbook.mnemonic"));
        if (csh != null) {
            jMenuItem.addActionListener((ActionListener)csh);
        } else {
            JDRResources.internalError(JDRResources.getString("internal_error.no_helpset"));
        }
        return jMenuItem;
    }

    public static JDRButton createMainHelpButton() {
        return JDRResources.createMainHelpButton(JDRResources.getString("help.label"));
    }

    public static JDRButton createMainHelpButton(String string) {
        JDRButton jDRButton = JDRResources.createAppButton("help", (ActionListener)csh, null, string);
        return jDRButton;
    }

    public static JDRButton createHelpButton(String string) {
        return JDRResources.createHelpButton(string, JDRResources.getString("help.label"));
    }

    public static JDRButton createHelpButton(String string, String string2) {
        JDRButton jDRButton = JDRResources.createAppButton("help", null, null, string2);
        JDRResources.enableHelpOnButton(jDRButton, string);
        return jDRButton;
    }

    public static JDRButton createAppButton(String string, ActionListener actionListener, KeyStroke keyStroke, String string2) {
        JDRButton jDRButton = new JDRButton(JDRResources.appIcon(string + "up.png"), JDRResources.appIcon(string + ".png"), JDRResources.appIcon(string + "r.png"), actionListener, string2);
        URL uRL = JDRResources.class.getResource("icons/" + string + "dis.png");
        if (uRL != null) {
            jDRButton.setDisabledIcon(new ImageIcon(uRL));
        }
        jDRButton.setActionCommand(string);
        if (keyStroke != null) {
            jDRButton.registerKeyboardAction(actionListener, string, keyStroke, 2);
        }
        return jDRButton;
    }

    public static JDRToggleButton createToggleButton(String string, ActionListener actionListener, KeyStroke keyStroke, String string2) {
        JDRToggleButton jDRToggleButton = new JDRToggleButton(JDRResources.appIcon(string + "up.png"), JDRResources.appIcon(string + ".png"), JDRResources.appIcon(string + "r.png"), actionListener, string2);
        URL uRL = JDRResources.class.getResource("icons/" + string + "dis.png");
        if (uRL != null) {
            jDRToggleButton.setDisabledIcon(new ImageIcon(uRL));
        }
        jDRToggleButton.setActionCommand(string);
        if (keyStroke != null) {
            jDRToggleButton.registerKeyboardAction(actionListener, string, keyStroke, 2);
        }
        return jDRToggleButton;
    }

    public static JDRToolButton createToolButton(String string, ActionListener actionListener, KeyStroke keyStroke, ButtonGroup buttonGroup, boolean bl, String string2) {
        JDRToolButton jDRToolButton = new JDRToolButton(JDRResources.appIcon(string + "up.png"), JDRResources.appIcon(string + ".png"), JDRResources.appIcon(string + "r.png"), actionListener, buttonGroup, bl, string2);
        buttonGroup.add(jDRToolButton);
        URL uRL = JDRResources.class.getResource("icons/" + string + "dis.png");
        if (uRL != null) {
            jDRToolButton.setDisabledIcon(new ImageIcon(uRL));
        }
        jDRToolButton.setActionCommand(string);
        if (keyStroke != null) {
            jDRToolButton.registerKeyboardAction(actionListener, string, keyStroke, 2);
        }
        return jDRToolButton;
    }

    public static JDRButton createOkayButton(ActionListener actionListener) {
        return JDRResources.createOkayButton(actionListener, JDRResources.getString("label.okay"));
    }

    public static JDRButton createOkayButton(ActionListener actionListener, String string) {
        JDRButton jDRButton = JDRResources.createAppButton("okay", actionListener, KeyStroke.getKeyStroke(10, 0), string);
        jDRButton.registerKeyboardAction(actionListener, "okay", KeyStroke.getKeyStroke(10, 1), 2);
        return jDRButton;
    }

    public static JDRButton createCancelButton(ActionListener actionListener) {
        return JDRResources.createCancelButton(actionListener, JDRResources.getString("label.cancel"));
    }

    public static JDRButton createCancelButton(ActionListener actionListener, String string) {
        return JDRResources.createAppButton("cancel", actionListener, KeyStroke.getKeyStroke(27, 0), string);
    }

    public static JDRButton createCloseButton(ActionListener actionListener) {
        return JDRResources.createCloseButton(actionListener, JDRResources.getString("label.close"));
    }

    public static JDRButton createCloseButton(ActionListener actionListener, String string) {
        JDRButton jDRButton = new JDRButton(JDRResources.appIcon("cancelup.png"), JDRResources.appIcon("cancel.png"), JDRResources.appIcon("cancelr.png"), actionListener, string);
        jDRButton.setActionCommand("close");
        jDRButton.registerKeyboardAction(actionListener, "close", KeyStroke.getKeyStroke(10, 0), 2);
        return jDRButton;
    }

    public static JMenuItem createAppMenuItem(String string, String string2, KeyStroke keyStroke, ActionListener actionListener, String string3) {
        JMenuItem jMenuItem = new JMenuItem(JDRResources.getString(string), JDRResources.getChar(string + ".mnemonic"));
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        if (actionListener != null) {
            jMenuItem.addActionListener(actionListener);
        }
        if (string2 != null) {
            jMenuItem.setActionCommand(string2);
        }
        if (string3 != null) {
            jMenuItem.setToolTipText(string3);
        }
        return jMenuItem;
    }

    public static JCheckBoxMenuItem createToggleMenuItem(String string, String string2, KeyStroke keyStroke, ActionListener actionListener, String string3) {
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(JDRResources.getString(string));
        jCheckBoxMenuItem.setMnemonic(JDRResources.getChar(string + ".mnemonic"));
        if (keyStroke != null) {
            jCheckBoxMenuItem.setAccelerator(keyStroke);
        }
        if (actionListener != null) {
            jCheckBoxMenuItem.addActionListener(actionListener);
        }
        if (string2 != null) {
            jCheckBoxMenuItem.setActionCommand(string2);
        }
        if (string3 != null) {
            jCheckBoxMenuItem.setToolTipText(string3);
        }
        return jCheckBoxMenuItem;
    }

    public static JRadioButtonMenuItem createToolMenuItem(String string, String string2, KeyStroke keyStroke, ButtonGroup buttonGroup, boolean bl, ActionListener actionListener, String string3) {
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(JDRResources.getString(string), bl);
        buttonGroup.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setMnemonic(JDRResources.getChar(string + ".mnemonic"));
        if (keyStroke != null) {
            jRadioButtonMenuItem.setAccelerator(keyStroke);
        }
        if (actionListener != null) {
            jRadioButtonMenuItem.addActionListener(actionListener);
        }
        if (string2 != null) {
            jRadioButtonMenuItem.setActionCommand(string2);
        }
        if (string3 != null) {
            jRadioButtonMenuItem.setToolTipText(string3);
        }
        return jRadioButtonMenuItem;
    }

    static {
        mainHelpBroker = null;
        csh = null;
        debugMode = false;
        directoryFilter = new DirectoryFilter();
        dictionaryFilter = new DictionaryFilter();
    }
}

