/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import uk.ac.uea.cmp.nlct.jdr.io.JDRMessage;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;

public class JDRGuiMessage
extends Thread
implements JDRMessage,
ActionListener {
    private JProgressBar progressBar;
    private JDialog messageDialog = new JDialog();
    private JTextArea messageArea;
    private JScrollPane messageScrollPane;
    private boolean suspended;
    private int state;
    private static final int IDLE = 0;
    private static final int SHOW = 1;
    private static final int HIDE = 2;

    public JDRGuiMessage() {
        this.messageDialog.setTitle(JDRResources.getString("message.title", "Messages"));
        this.messageArea = new JTextArea();
        this.messageArea.setText("");
        this.messageArea.setEditable(false);
        this.messageArea.setBackground(Color.white);
        this.messageScrollPane = new JScrollPane(this.messageArea);
        this.messageDialog.getContentPane().add((Component)this.messageScrollPane, "Center");
        this.progressBar = new JProgressBar();
        this.messageDialog.getContentPane().add((Component)this.progressBar, "North");
        JPanel jPanel = new JPanel();
        jPanel.add(JDRResources.createCloseButton(this));
        this.messageArea.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "close");
        this.messageDialog.getContentPane().add((Component)jPanel, "South");
        int n = 400;
        int n2 = 200;
        this.messageDialog.setSize(n, n2);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        int n3 = dimension.height;
        int n4 = dimension.width;
        int n5 = (n4 - n) / 2;
        int n6 = (n3 - n2) / 2;
        this.messageDialog.setLocation(n5, n6);
        this.state = 0;
        this.start();
    }

    @Override
    public void run() {
        try {
            while (true) {
                JDRGuiMessage.sleep(100L);
                switch (this.state) {
                    case 1: {
                        this.messageDialog.setVisible(true);
                        this.state = 0;
                        break;
                    }
                    case 2: {
                        this.messageDialog.setVisible(false);
                        this.state = 0;
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("close")) {
            this.state = 2;
        }
    }

    public void displayMessages() {
        this.state = 2;
    }

    public void hideMessages() {
        this.state = 2;
    }

    public void setIndeterminate(boolean bl) {
        this.progressBar.setIndeterminate(bl);
    }

    public boolean isIndeterminate() {
        return this.progressBar.isIndeterminate();
    }

    public void incrementProgress() {
        this.setProgress(this.progressBar.getValue() + 1);
    }

    public void setMaxProgress(int n) {
        this.progressBar.setMaximum(n);
    }

    public int getMaxProgress() {
        return this.progressBar.getMaximum();
    }

    public void resetProgress(int n) {
        this.progressBar.setValue(0);
        this.progressBar.setMaximum(n);
    }

    public void resetProgress() {
        this.progressBar.setValue(0);
    }

    public int getProgress() {
        return this.progressBar.getValue();
    }

    public void setProgress(int n) {
        this.progressBar.setValue(n);
    }

    public void message(String string) {
        this.messageArea.append(string);
    }

    public void message(Exception exception) {
        this.messageArea.append(exception.getMessage());
    }

    public void messageln(String string) {
        this.messageArea.append(string + "\n");
    }

    public void messageln(Exception exception) {
        this.messageArea.append(exception.getMessage() + "\n");
    }

    public void warning(String string) {
        JDRResources.warning(string);
    }

    public void warning(Exception exception) {
        JDRResources.warning(exception.getMessage());
    }

    public void error(String string) {
        JDRResources.error(null, string);
    }

    public void error(Exception exception) {
        JDRResources.error(null, exception);
    }

    public void internalerror(String string) {
        JDRResources.internalError(null, string);
    }

    public void internalerror(Exception exception) {
        JDRResources.internalError(null, exception);
    }

    public void fatalerror(String string) {
        JDRResources.error(null, string);
        System.exit(0);
    }

    public void fatalerror(Exception exception) {
        JDRResources.fatalError(exception.getMessage(), exception);
    }
}

