/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrresources;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;

public class JDRDictionary {
    private Hashtable<String, String> dictionary;

    public JDRDictionary(Class<? extends Object> clazz) throws IOException {
        InputStream inputStream = JDRDictionary.getDictionaryInputStream(clazz);
        InputStream inputStream2 = clazz.getResourceAsStream("/resources/LICENSE");
        if (inputStream2 == null) {
            throw new IOException("Unable to open 'resources/LICENSE'");
        }
        this.loadInputStreams(inputStream, inputStream2);
    }

    private static InputStream getDictionaryInputStream(Class<? extends Object> clazz) throws IOException {
        String string = "/resources/dictionaries/jpgfdraw";
        if (JDRResources.dictLocaleId != null) {
            String string2 = string + "-" + JDRResources.dictLocaleId + ".prop";
            InputStream inputStream = clazz.getResourceAsStream(string2);
            if (inputStream == null) {
                JDRResources.warning("No dictionary available for language '" + JDRResources.dictLocaleId + "'");
                JDRResources.dictLocaleId = null;
            }
            return inputStream;
        }
        Locale locale = Locale.getDefault();
        String string3 = locale.getLanguage() + "-" + locale.getCountry();
        String string4 = string + "-" + string3 + ".prop";
        JDRResources.dictLocaleId = string3;
        InputStream inputStream = clazz.getResourceAsStream(string4);
        if (inputStream == null) {
            String string5 = string4;
            JDRResources.dictLocaleId = locale.getLanguage();
            string4 = string + "-" + JDRResources.dictLocaleId + ".prop";
            inputStream = clazz.getResourceAsStream(string4);
            if (inputStream == null) {
                string5 = string5 + "\n" + string4;
                if (!string3.equals("en-GB")) {
                    JDRResources.dictLocaleId = "en-GB";
                    string4 = string + "-" + JDRResources.dictLocaleId + ".prop";
                    inputStream = clazz.getResourceAsStream(string4);
                    if (inputStream == null) {
                        string5 = string5 + "\n" + string4;
                    }
                }
                if (inputStream == null) {
                    throw new IOException("Unable to open dictionary file. Tried: \n" + string5);
                }
            }
        }
        return inputStream;
    }

    public JDRDictionary() throws IOException {
        this(JDRResources.class);
    }

    public JDRDictionary(InputStream inputStream, InputStream inputStream2) throws IOException {
        this.loadInputStreams(inputStream, inputStream2);
    }

    private void loadInputStreams(InputStream inputStream, InputStream inputStream2) throws IOException {
        this.dictionary = null;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        this.initDictionary(bufferedReader);
        bufferedReader.close();
        bufferedReader = new BufferedReader(new InputStreamReader(inputStream2));
        this.initLicence(bufferedReader);
        bufferedReader.close();
    }

    private void initDictionary(BufferedReader bufferedReader) throws IOException {
        String string;
        this.dictionary = new Hashtable(1024);
        while ((string = bufferedReader.readLine()) != null) {
            int n;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "#");
            if (!stringTokenizer.hasMoreTokens() || !(stringTokenizer = new StringTokenizer(string = stringTokenizer.nextToken(), "=")).hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken();
            String string3 = "";
            if (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
            }
            int n2 = 0;
            while ((n = string3.indexOf("\\n", n2)) != -1) {
                string = n == 0 ? string3.substring(2) : string3.substring(0, n) + "\n" + string3.substring(n + 2);
                string3 = string;
                n2 = n;
            }
            this.dictionary.put(string2, string3);
        }
    }

    private void initLicence(BufferedReader bufferedReader) throws IOException {
        String string;
        String string2 = "";
        while ((string = bufferedReader.readLine()) != null) {
            string2 = string2 + string + "\n";
        }
        if (this.dictionary != null) {
            this.dictionary.put("licence", string2);
        }
    }

    public String getString(String string) {
        if (this.dictionary == null) {
            return string;
        }
        String string2 = this.dictionary.get(string);
        if (string2 == null) {
            string2 = string;
            System.err.println("Unknown key '" + string + "'");
        }
        return string2;
    }

    public String getString(String string, String string2) {
        if (this.dictionary == null) {
            return string2;
        }
        String string3 = this.dictionary.get(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public char getChar(String string) {
        String string2 = this.getString(string);
        return string2.charAt(0);
    }

    public char getChar(String string, char c) {
        if (this.dictionary == null) {
            return c;
        }
        String string2 = this.getString(string);
        if (string2 == null) {
            return c;
        }
        return string2.charAt(0);
    }

    public boolean containsKey(String string) {
        if (this.dictionary == null) {
            return false;
        }
        return this.dictionary.containsKey(string);
    }
}

