/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.jdrresources;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import uk.ac.uea.cmp.nlct.jdrresources.JDRResources;

public class ImagePreview
extends JComponent
implements PropertyChangeListener,
ActionListener {
    private JCheckBox previewBox;
    private ImageIcon thumbnail = null;
    private File file = null;
    private JPanel imagePanel;

    public ImagePreview(JFileChooser jFileChooser) {
        this.setLayout(new BorderLayout());
        this.imagePanel = new JPanel(){

            @Override
            public void paintComponent(Graphics graphics) {
                super.paintComponent(graphics);
                if (ImagePreview.this.thumbnail == null) {
                    ImagePreview.this.loadImage();
                }
                if (ImagePreview.this.thumbnail != null) {
                    int n = this.getWidth() / 2 - ImagePreview.this.thumbnail.getIconWidth() / 2;
                    int n2 = this.getHeight() / 2 - ImagePreview.this.thumbnail.getIconHeight() / 2;
                    if (n2 < 0) {
                        n2 = 0;
                    }
                    if (n < 5) {
                        n = 5;
                    }
                    ImagePreview.this.thumbnail.paintIcon(this, graphics, n, n2);
                }
            }
        };
        this.add((Component)this.imagePanel, "Center");
        this.previewBox = new JCheckBox(JDRResources.getString("image.preview"));
        this.previewBox.setMnemonic(JDRResources.getChar("image.preview.mnemonic"));
        this.previewBox.addActionListener(this);
        this.add((Component)this.previewBox, "South");
        this.setPreferredSize(new Dimension(100, 50));
        jFileChooser.addPropertyChangeListener(this);
    }

    public void loadImage() {
        if (this.file == null || !this.previewBox.isSelected()) {
            this.thumbnail = null;
            return;
        }
        ImageIcon imageIcon = new ImageIcon(this.file.getPath());
        if (imageIcon != null) {
            this.thumbnail = imageIcon.getIconWidth() > 90 ? new ImageIcon(imageIcon.getImage().getScaledInstance(90, -1, 1)) : imageIcon;
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        String string = propertyChangeEvent.getPropertyName();
        if ("directoryChanged".equals(string)) {
            this.file = null;
            bl = true;
        } else if ("SelectedFileChangedProperty".equals(string)) {
            this.file = (File)propertyChangeEvent.getNewValue();
            bl = true;
        }
        if (bl) {
            this.thumbnail = null;
            if (this.imagePanel.isShowing()) {
                this.loadImage();
                this.imagePanel.repaint();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.previewBox) {
            this.loadImage();
            this.imagePanel.repaint();
        }
    }

    public void addPreviewBoxActionListener(ActionListener actionListener) {
        this.previewBox.addActionListener(actionListener);
    }

    public boolean isPreviewSelected() {
        return this.previewBox.isSelected();
    }

    public void setPreviewSelected(boolean bl) {
        this.previewBox.setSelected(bl);
    }
}

