/* ps2mfutl.c */

#include <stdio.h>
#ifndef AIX
#include <stdlib.h>
#endif
#include <string.h>
#include "defines.h"
#include "mymalloc.h"
#include "ps2mf.h"
#include "ps2mfutl.h"
#if (defined (MSDOS) || defined (__ATARIST__))
#include <float.h>
#endif


#ifdef __STDC__
void error (char * s)
#else
void error (s)
char * s;
#endif
{
	fprintf (stderr, "\n%s%s.\n", (* s == '!') ? "error" : "warning: ", s);
	if (obuffer [0])
	{
		fprintf (stderr, "%s\n", obuffer);
		while (param > buffer)
		{
			fprintf (stderr, " ");
			param --;
		}
		fprintf (stderr, "^n\n");
	}
	if (* s == '!') exit (UNSUCCESSFUL);
}

#ifdef __STDC__
int transform (int x, int y)
#else
int transform (x, y)
int x, y;
#endif
{
	double acc;

	acc = 1.0 * x + 0.0 * y;
	/*    ^=efactor ^=slant */
	return ((int) (acc >= 0.0 ? acc + 0.5 : acc - 0.5));
}

#ifdef __STDC
int get_line (FILE * in_file)
#else
int get_line (in_file)
FILE * in_file;
#endif
{
	char * p;
	int c;

	param = buffer;
	do c = getc (in_file);
	while (c == ' ' || c == '\r' || c == '\n');
	ungetc (c, in_file);
	for (p = buffer; (c = getc (in_file)) != EOF && c != '\n'
	     && c != '\r'; /* skip */) * p ++ = c;
	if (buffer [0] == '%') return (get_line (in_file));
	* p = 0;
	strcpy (obuffer, buffer);
	if (p == buffer && c == EOF) return (0);
	return (1);
}

#ifdef __STDC__
int get_token (FILE * in_file)
#else
int get_token (in_file)
FILE * in_file;
#endif
{
	if (! * param) if (! get_line (in_file)) return (0);
	return (1);
}

/* Routines for input parsing: param_new_string, param_string, param_num,
   param_float, expect */

#ifdef __STDC__
bool is_in_delimiters (char c)
#   else
bool is_in_delimiters (c)
char c;
#	endif
{
	if (c == '{' || c == '[' || c == '('
	    || c == ')' || c == ']' || c == '}') return (TRUE);
	return (FALSE);
}

char * param_new_string ()
{
	char * p, * q;

	p = param;
	if (is_in_delimiters (* p)) p ++;
	else while (* p > ' ' && ! is_in_delimiters (* p)) p ++;
	q = my_malloc ((int) (p - param + 1));
	if (* p != 0) * p ++ = 0;
	strcpy (q, param);
	while (* p && * p <= ' ') p ++;
	param = p;
	return (q);
}
 
char * param_string ()
{
	char * p, * q;

	p = param;
	if (is_in_delimiters (* p)) p ++;
	else while (* p > ' ' && ! is_in_delimiters (* p)) p ++;
	q = param;
	if (* p != 0) * p ++ = 0;
	while (* p && * p <= ' ') p ++;
	param = p;
	return (q);
}

int param_oct ()
{
	char * p;
	int i;

	p = param_string ();
	if (sscanf (p, "%o", & i) != 1) error ("! octal number expected");
	return (i);
}

int param_hex ()
{
	char * p;
	int i;

	p = param_string ();
	if (sscanf (p, "%x", & i) != 1) error ("! hexadecimal number expected");
	return (i);
}

int param_num ()
{
	char * p;
	int i;

	p = param_string ();
	if (sscanf (p, "%d", & i) != 1) error ("! integer expected");
	return (i);
}

float param_float ()
{
	char * p;
	float f;

	p = param_string ();
	if (sscanf (p, "%f", & f) != 1) error ("! number expected");
	return (f);
}

#ifdef __STDC__
void expect (char * s)
#else
void expect (s)
char * s;
#endif
{
	if (! strequ (param_string (), s))
	{
		fprintf (stderr, "%s expected.", s);
		error ("! syntax error");
	}
}

#ifdef __STDC__
AFM_info_tp * find_AFM_info_for (char * p)
#else
AFM_info_tp * find_AFM_info_for (p)
char * p;
#endif
{
	AFM_info_tp * ai;

	for (ai = AFM_chars; ai; ai = ai -> next)
	{
		if (strequ (p, ai -> AFM_name)) return (ai);
	}
	return (NULL);
}

#ifdef __STDC__
AFM_info_tp * find_AFM_info_for_number (int p)
#else
AFM_info_tp * find_AFM_info_for_number (p)
int p;
#endif
{
	AFM_info_tp * ai;

	for (ai = AFM_chars; ai; ai = ai -> next)
	{
		if (p == ai -> AFM_num) return (ai);
	}
	return (NULL);
}


