/* This file is mactypes.h
 *
 * Copyright (C) 1993 by Norman Walsh
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 ************************************************************************/

#ifndef MACTYPES_H
#define MACTYPES_H

#ifndef SKIPTYPES
typedef unsigned short int USHORT;
typedef unsigned char      BYTE;
typedef unsigned long int  ULONG;
typedef short int          SHORT;
typedef int                LONG;
#endif /* not SKIPTYPES */

typedef struct _RsrcHdrStruct {
  ULONG  DataOffset;
  ULONG  MapOffset;
  ULONG  DataLen;
  ULONG  MapLen;
  BYTE   OSReserved[96];
  BYTE   AppReserved[128];
} RsrcHdrStruct;

typedef struct _RsrcMapStruct {
  ULONG   MapCopy[4];
  ULONG   NextMap;
  USHORT  FileRef;
  USHORT  FileAttr;
  USHORT  TypeOffset;
  USHORT  NameOffset;
} RsrcMapStruct;

typedef struct _RsrcTypeStruct {
  char    Name[4];
  USHORT  Count;
  USHORT  RefOffset;
} RsrcTypeStruct;

typedef struct _RsrcRefStruct {
  USHORT Ident;
  USHORT NameOffset;
  BYTE   Attr;
  ULONG  DataOffset;
  ULONG  Unknown;
} RsrcRefStruct;

typedef struct _MacDataStruct {
  ULONG size;
  BYTE  *map;
} MacDataStruct;

typedef struct _FontEntryFormat {
  USHORT PointSize;
  USHORT StyleCode;
  USHORT ResourceNumber;
} FontEntryFormat;

typedef struct _RsrcFondStruct {
  USHORT Flag;
  USHORT FamilyId;
  USHORT FirstChar;
  USHORT LastChar;
  SHORT  Ascent;
  SHORT  Descent;
  SHORT  Leading;
  SHORT  WidMax;
  ULONG  WidTblOfs;
  ULONG  KrnTblOfs;
  ULONG  StyTblOfs;
  USHORT FamStyProp[9];
  ULONG  Intrnatnl;
  USHORT FontVers;
  int    NumFonts;
  FontEntryFormat *AssocTable;
} RsrcFondStruct;

typedef struct _RsrcNfntStruct {
  USHORT FontType;
  USHORT FirstChar;
  USHORT LastChar;
  SHORT  WidMax;
  SHORT  KernMax;
  SHORT  NDescent;
  SHORT  FRectWidth;
  SHORT  FRectHeight;
  USHORT OWTLoc;
  SHORT  Ascent;
  SHORT  Descent;
  SHORT  Leading;
  SHORT  RowWords;
} RsrcNfntStruct;

typedef struct _NfntCharInfoStruct {
  BYTE ofs;
  BYTE width;
} NfntCharInfoStruct;

#endif /* not MACTYPES_H */

