#ifndef EditMask_included
#define EditMask_included
class EditMask;
class ApplicationWindow;
#include <unistd.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qcombo.h>
#include <qlabel.h>
#include <qlined.h>
#include <qmultilinedit.h>
#include <qlistview.h>
#include <qstring.h>
#include "BrowseList.h"
#include "entry.h"

/*!
  \class EditMask EditMask.h
  \brief Edit Dialog

*/

class EditMask: public QDialog
{
  Q_OBJECT
  public:
    QMultiLineEdit *auth_edit;
    QMultiLineEdit *ed_edit;
    QLineEdit *fields[NFIELD];
    Record ee;
    EditMask(ApplicationWindow *parent, const char *name, Record e);
    ~EditMask();
  private:
    QString getfield(int f);
    bool is_changed;
    QListView al;
    QListView el;
    QLabel *labels[NFIELD];
  private:
    QPushButton *ok;
    QPushButton *cancel;
    QPushButton *browse;
    QPushButton *abstract;
    QLabel *auth_lab;
    QLabel *key_lab;
    QLabel *editor_lab;
    QLabel *ref_label;
    QComboBox *reftype;
    QLineEdit *id_edit;
    void name_insert(const char *, QMultiLineEdit*);
public slots:
    void typechanged(int newtype);
    void aname_insert(const char*);
    void ename_insert(const char*);
    void JBrowseList();
    void ABrowseList();
    void EBrowseList();
    void update();
    void view_abstract();
};

#endif
