/* http://adsabs.harvard.edu/abs_doc/journals1.html
 * download URL source then parse with
 * fgrep setfields journals1.html | awk -F ';' '{printf "%s\n",$2}'
 * | cut -c 7-12,24- | sed 's/"//g' | awk '{printf "\"%s\",\n",$0}'
 *
 */
static const char *journals[] = {
"AASHS AAS Hist. Ser.",
"AAN.. AAVSO Alert Notice",
"AAVSC AAVSO Circular",
"AAVSN AAVSO Newsletter",
"AbaOB Abastumanskaia Astrofizicheskaia Observatoriia Biulleten",
"AbbOO Abbadia Observatory Observations",
"ABWG. Abh. Braunschweigische Wissenschaftliche Ges.",
"AbhP. Abh. der Preu&szlig",
"AbhKP Abh. Konigl. Preuss. Akad. Wissenschaften Jahre 1906,92, Berlin,1907",
"AbhBr Abh. naturwiss. Verein Bremen",
"AADDR Abhandlungen Akad. Wiss. DDR",
"AAGot Abhandlungen Akad. Wiss. G&ouml",
"AbhHS Abhandlungen aus der Hamburger Sternwarte",
"ASFAS Academia Scientiarum Fennica Annales Series Physica",
"AOIJ. Academic Open Internet Journal",
"CRASB Academie des Science Paris Comptes Rendus Serie B Sciences Physiques",
"CR2.. Academie des Sciences Comptes Rendus Serie Mecanique Physique Chimie Sciences de la Terre et de l Univers",
"CRAS. Academie des Sciences Paris Comptes Rendus",
"CRASG Academie des Sciences Paris Comptes Rendus Serie Generale La Vie des Sciences",
"CRASP Academie des Sciences Paris Comptes Rendus Serie Physique Astrophysique",
"CRASM Academie des Sciences Paris Comptes Rendus Serie Sciences Mathematiques",
"CRASA Academie des Sciences Paris Comptes Rendus Vie Academique Semester Supplement",
"MeARB Academie Royale de Belgique Classe des Sciences Memoires",
"ASSAB Academie Serbe des Sciences et des Arts Bulletin Classe des Sciences Techniques",
"ASLLR Accademia di Scienze e Lettere Istituto Lombardo Rendiconti Serie della Classe di Scienze Matematiche e Naturali Sezione Scienze Matematiche Fisiche Chimiche e Geologiche",
"ANLAM Accademia Nazionale dei Lincei Atti Rendiconti Classe di Matematica e Applicazioni",
"ANLAF Accademia Nazionale dei Lincei Atti Rendiconti Classe di Scienze Fisiche e Naturali",
"ANLAR Accademia Nazionale dei Lincei Atti Rendiconti Classe di Scienze Fisiche Matematiche e Naturali",
"AcChR Accounts Chem. Res.",
"AcBu. Acoust. Bull.",
"AIH.. Acoustical Imaging and Holography",
"APhy. Acoustical Physics",
"ASAJ. Acoustical Society of America Journal",
"AcouL Acoustics Letters",
"AcAcu Acta Acustica",
"AcAer Acta Aerodynamica Sinica",
"AcAAS Acta Aeronautica et Astronautica Sinica",
"AcAM. Acta Applicandae Mathematicae",
"AcAri Acta Arithmetica",
"AcArm Acta Armamentarii",
"AcAau Acta Astronautica",
"AcA.. Acta Astronomica",
"AcASn Acta Astronomica Sinica",
"AcAS. Acta Astronomica Supplementa",
"AcApS Acta Astrophysica Sinica",
"AcAuS Acta Automatica Sinica",
"AcBAS Acta Biochimica and Biophysica Academiae Scientarium Hungarica",
"AcBBH Acta Biochimica et Biophysica Hungarica",
"AcBBS Acta Biochimica et Biophysica Sinica",
"AcBio Acta Biotheoretica",
"AcCS. Acta Chemica Scandinavica Series A",
"ACIP. Acta Cienc. Indica Phys.",
"AcC.. Acta Cosmologica",
"AcCrA Acta Crystallographica Section A",
"AcCrB Acta Crystallographica Section B",
"AcCrC Acta Crystallographica Section C",
"AcElc Acta Electrochimica",
"AcESn Acta Electron. Sinica",
"AcEle Acta Electronica",
"AcElS Acta Electronica Sinica",
"AcFre Acta Frequenza",
"AcGG. Acta Geod. Geophys.",
"AcGSn Acta Geophys. Sinica",
"AcGeo Acta Geophysica",
"AcGeP Acta Geophysica Polonica",
"AcHA. Acta Historica Astronomiae",
"AcMCS Acta Materiae Compositae Sinica",
"AcMat Acta Materialia",
"AcMaS Acta Math. Sinica",
"AcMa. Acta Mathematica",
"AcMaH Acta Mathematica Hungarica",
"AcMec Acta Mechanica",
"AcMSn Acta Mechanica Sinica",
"AcMSS Acta Mechanica Solida Sinica",
"AcMet Acta Metallurgica",
"AcM&M Acta Metallurgica et Materialia",
"AcMMS Acta Metallurgica et Materialia Supplement",
"AcMeS Acta Meteorologica Sinica",
"AcNum Acta Numerica",
"AcOSi Acta Oceanica Sinica",
"AcOdS Acta Odontologica Scandinavica",
"AcO.. Acta Oecologica",
"AcOpS Acta Optica Sinica",
"AcOrS Acta Orthopaedica Scandinavica",
"AcPhy Acta Physica",
"APASH Acta Physica Academiae Scientiarum Hungaricae",
"AcPhA Acta Physica Austriaca",
"AcPAS Acta Physica Austriaca Supplement",
"AcPhC Acta Physica et Chemica",
"AcPhH Acta Physica Hungarica",
"APHHI Acta Physica Hungarica Heavy Ion Physics",
"AcPPA Acta Physica Polonica A",
"AcPPB Acta Physica Polonica B",
"AcPSn Acta Physica Sinica",
"AcPSl Acta Physica Slovaca",
"AcPhS Acta Physiologica Scandinavica",
"AcPSc Acta Polytechnica Scandinavica Applied Physics Series",
"AcPSP Acta Polytechnica Scandinavica Physics",
"AcSSn Acta Seismologica Sinica",
"ASSF. Acta Societatis Scientarum Fennicae",
"ASSFA Acta Societatis Scientarum Fennicae Series A",
"AcTec Acta Technica",
"AcMPh Acta Universitatis Caroliae. Mathematica et Physica",
"AcMPS Acta Universitatis Caroliae. Mathematica et Physica Supplement",
"APEC. Active and Passive Electronic Components",
"Acu.. Acustica",
"AdAs. Ad Astra",
"AdBeh Adaptive Behaviour",
"ARPM. Adgeziia Rasplavov i Paika Materialov",
"Adsor Adsorption",
"AAMS. Adv. Appl. Mech. Suppl.",
"AdCM. Advanced Ceramic Materials",
"AdCoL Advanced Composites Letters",
"AMP.. Advanced Materials and Processes",
"APM.. Advanced Performance Materials",
"AdSAC Advanced Series in Astrophysics and Cosmology",
"AdSMP Advanced Series in Mathematical Physics",
"ASDHE Advanced Series on Directions in High Energy Physics",
"AdTPh Advanced Texts in Physics",
"AdAeS Advances in Aeronautical Sciences",
"AdApM Advances in Applied Mathematics",
"AdAst Advances in Astronomy",
"AdA&A Advances in Astronomy and Astrophysics",
"AdAtS Advances in Atmospheric Sciences",
"AdAMP Advances in Atomic and Molecular Physics",
"AAMOP Advances in Atomic Molecular and Optical Physics",
"AdBMP Advances in Biological and Medical Physics",
"AdBio Advances in Biophysics",
"AdCP. Advances in Cardiovascular Physics",
"AdChP Advances in Chemical Physics",
"AdCoM Advances in Computational Mathematics",
"AdEPS Advances in Earth and Planetary Sciences",
"AdEOA Advances in Earth Oriented Applications and Space Technology",
"AdEEP Advances in Electronics and Electron Physics",
"AEEPS Advances in Electronics and Electron Physics Supplement",
"AdExG Advances in Exploration Geophysics",
"AdGDP Advances in Geophysical Data Processing",
"AdGR. Advances in Geophysical Research",
"AdGeo Advances in Geophysics",
"AdGeS Advances in Geophysics Supplement",
"AdG.. Advances in Geosciences",
"AdHEP Advances in High Energy Physics",
"ADIEP Advances in Imaging and Electron Physics",
"AdMat Advances in Mathematics",
"AdMPS Advances in Mechanics and Physics of Surfaces",
"AdMUM Advances in Mechanics Uspekhi Mekhaniki",
"AdNuP Advances in Nuclear Physics",
"AdPhG Advances in Physical Geochemistry",
"AdPhy Advances in Physics",
"AdPlP Advances in Plasma Physics",
"AdPPR Advances in Plasma Physics Research",
"AdPoS Advances in Polymer Science",
"AdQC. Advances in Quantum Chemistry",
"AdRS. Advances in Radio Science",
"AdSR. Advances in Science and Research",
"AdSSP Advances in Solid State Physics",
"AdSpR Advances in Space Research",
"AdTMP Advances in Theoretical and Mathematical Physics",
"AdWR. Advances in Water Resources",
"ATTM. AEG Telefunken Technische Mitteilungen",
"Aekv. Aerodinamika kanalov i ventiliatorov",
"AeRaG Aerodinamika Razrezhennykh Gazov",
"AerTe Aerojet Technology",
"AeIBu Aerokosmicheski Izsledvaniia B lgariia",
"AeJ.. Aeronautical Journal",
"AeQ.. Aeronautical Quarterly",
"AeSIJ Aeronautical Society India Journal",
"AS&T. Aerosol Science & Technology",
"AerST Aerosol Science Technology",
"AeAm. Aerospace America",
"AeCh. Aerospace China",
"AeCM. Aerospace Composites Materials",
"AeDy. Aerospace Dynamics",
"AeEn. Aerospace Engineering",
"AeMat Aerospace Materials",
"AeMed Aerospace Medicine",
"ARBl. Aerospace Research in Bulgaria",
"Aero. Aerospace UK",
"AFGL. AFGL-TR-0208 Environemental Research papers",
"AfrSk African Skies",
"AGUFM AGU Fall Meeting Abstracts",
"AGUSM AGU Spring Meeting Abstracts",
"EDAM. AI EDAM",
"AIAAJ AIAA Journal",
"AIASJ AIAA Student Journal",
"AIChE AIChE Journal",
"AirSp Air and Space",
"AirCo Air et Cosmos",
"AFMa. Air Force Magazine",
"AiInt Air International",
"APCAJ Air Pollution Control Association Journal",
"AirE. Aircraft Engineering",
"AE&AT Aircraft Engineering & Aerospace Technology",
"AkAtP Akademia Athenon Praktika",
"DoArm Akademiia Nauk Armianskoi SSR Doklady",
"DoAze Akademiia Nauk Azerbaidzhanskoi SSR Doklady",
"IzAze Akademiia Nauk Azerbaidzhanskoi SSR Izvestiia Seriia Fiziko Tekhnicheskikh i Matematicheskikh Nauk",
"IFBel Akademiia Nauk Belorusskoi SSR Institut Fiziki Nauchnaia Sessiia Minsk Belorussian SSR Zhurnal Prikladnoi Spektroskopii",
"DoBel Akademiia Nauk BSSR Doklady",
"SoGru Akademiia Nauk Gruzii Soobshcheniia",
"VeKaz Akademiia Nauk Kazakhskoi SSR Vestnik",
"IzLat Akademiia Nauk Latviiskoi SSR Izvestiia Seriia Fizicheskikh i Tekhnicheskikh Nauk",
"IzMol Akademiia Nauk Moldavskoi SSR Izvestiia Seriia Fiziko Tekhnicheskikh i Matematicheskikh Nauk",
"DoSSR Akademiia Nauk SSSR Doklady",
"FizAO Akademiia Nauk SSSR Fizika Atmosfery i Okeana",
"InSSR Akademiia Nauk SSSR Investiia Mekhanika Zhidkosti i Gaza",
"IzFZ. Akademiia Nauk SSSR, Izvestiia, Fizika Zemli",
"IzSSR Akademiia Nauk SSSR Izvestiia Seriia Fizicheskaia",
"MeSSR Akademiia Nauk SSSR Mekhanika Zhidkosti i Gaza",
"FiMos Akademiia Nauk SSSR Otdelenie Obshchei Fiziki i Astronomii Nauchnaia Sessiia Moscow USSR Uspekhi Fizicheskikh Nauk",
"IzSib Akademiia Nauk SSSR Sibirskoe Otdelenie Izvestiia",
"SiSSR Akademiia Nauk SSSR Sibirskoe Otdelenie Izvestiia Seriia Tekhnicheskie Nauki",
"KzSib Akademiia Nauk SSSR Sibirskoi Otdelenie Izvestiia Seriia Tekhnicheskikh Nauk",
"VeSSR Akademiia Nauk SSSR Vestnik",
"DoTad Akademiia Nauk Tadzhikskoi SSR Doklady",
"FiSSR Akademiia Nauk Tadzhikskoi SSR Fiziko Tekhnicheskii Institut Dyushambe Tadzhik SSR Akademiia Nauk Tadzhikskoi SSR Doklady",
"ABTad Akademiia Nauk Tadzhikskoi SSR Institut Astrofiziki Biulleten",
"IzTur Akademiia Nauk Turkmenskoi SSR Izvestiia Seriia Fiziko Tekhnicheskikh Khimicheskikh i Geologicheskikh Nauk",
"FiUkr Akademiia Nauk Ukrain skoi RSR Dopovidi Seriia Fiziko Matematichni ta Tekhnichni Nauki",
"IzUkr Akademiia Nauk Ukrainian SSSR Izvestiia Seriia Fizicheskaia",
"PrUkr Akademiia Nauk Ukrains koi RSR Dopovidi Matematika Prirodoznavstvo Tekhnichni Nauki",
"DoUkr Akademiia Nauk Ukrains koi RSR Dopovidi Seriia Fiziko Matematichni ta Tekhnichni Nauki",
"ViUkr Akademiia Nauk Ukrains koi RSR Visnik",
"MGUkr Akademiia Nauk Ukrainskoi SSR Morskie Gidrofizicheskie Issledovaniia",
"DoUzb Akademiia Nauk Uzbekskoi SSR Doklady",
"IzUzb Akademiia Nauk Uzbekskoi SSR Izvestiia Seriia Fiziko Matematicheskikh Nauk",
"VeNav Akademiia Navuk BSSR Vestsi Seryia Fizika Tekhnichnykh Navuk",
"AkZh. Akusticheskii Zhurnal",
"AkTek Akustika i Ul trazvukovaia Tekhnika",
"AAIzN Alma Ata Izdatel Nauka",
"AlFr. Alta Frequenza",
"AFRE. Alta Frequenza Rivista di Elettronica",
"Ambio Ambio",
"AVSOA American Association of Variable Stars Observers Abstracts",
"AVSOM American Association of Variable Stars Observers Monographs",
"AVSOQ American Association of Variable Stars Observers Quarterly Reports",
"AVSOR American Association of Variable Stars Observers Reports",
"ACSB. American Ceramic Society Bulletin",
"ACSC. American Ceramic Society Communications",
"ACSJ. American Ceramic Society Journal",
"AHSJ. American Helicopter Society Journal",
"AmJC. American Journal of Cardiology",
"AmJM. American Journal of Mathematics",
"AmJPh American Journal of Physics",
"AmJS. American Journal of Science",
"AmJSA American Journal of Science and Arts",
"AMSBu American Meteorological Society Bulletin",
"AmMin American Mineralogist",
"AmSci American Scientist",
"ASME. American Society of Mechanical Engineers",
"AnCoi Anais do Observatorio Astronomico da Universidade de Coimbra",
"AICSP Analog Integrated Circuits and Signal Processing",
"Ana.. The Analyst",
"AnBio Analytical Biochemistry",
"AnaCh Analytical Chemistry",
"AnaIn Analytical Instrumentation",
"AAONw Anglo-Australian Observatory Epping Newsletter",
"AAOPr Anglo-Australian Observatory Epping Preprint",
"CSMPA Ankara Universite Faculte des Sciences Communications Serie Mathematiques Physique et Astronomie",
"AASF. Ann. Acad. Sci. Fennicae",
"AnRev Ann Rev",
"AnMun Annalen der Koeniglichen Sternwarte bei Muenchen",
"AnP.. Annalen der Physik",
"AnWie Annalen der Universitaets-Sternwarte Wien",
"AnWiD Annalen der Universitaets-Sternwarte Wien, Dritter Folge",
"AnMet Annalen Meteorologie",
"AnLei Annalen van de Sterrewacht te Leiden",
"AnAp. Annales d'Astrophysique",
"AFLB. Annales de la Fondation Louis de Broglie",
"ASSB. Annales de la Societe Scietifique de Bruxelles",
"AnG.. Annales de Geophysique",
"AnIHP Annales de L'Institut Henri Poincare Section Physique Theorique",
"AnTou Annales de l'Observatoire Astron. et Meteo. de Toulouse",
"AOTok Annales de l'Observatoire astronomique de Tokyo",
"AnBes Annales de l'Observatoire de Besancon",
"AnBor Annales de l'Observatoire de Bordeaux",
"AnNic Annales de l'Observatoire de Nice",
"AnPar Annales de l'Observatoire de Paris",
"AnPOb Annales de l'Observatoire de Paris. Observations",
"AnStr Annales de l'Observatoire de Strasbourg",
"AnRio Annales de l'Observatoire Imperial de Rio de Janeiro",
"AnAth Annales de l'Observatoire national d'Ath&egrave",
"AnOB. Annales de l'Observatoire Royal de Belgique",
"AnOBN Annales de l'Observatoire Royal de Belgique Nouvelle serie",
"AnBru Annales de l'Observatoire Royal de Bruxelles",
"AnPh. Annales de Physique",
"AnPBM Annales de Physique Biologique et Medicale",
"AnPCS Annales de Physique Colloque Supplement",
"AnTel Annales des Telecommunications",
"AnGVP Annales du Bureau des Longitudes, Gauthier-Villars, Paris",
"AnGeo Annales Geophysicae",
"AnGeA Annales Geophysicae Series A Upper Atmosphere and Space Sciences",
"AnGeB Annales Geophysicae Series B Terrestrial and Planetary Physics",
"AnTec Annales Tectonicae",
"AnSAO Annals of the Astrophysical Observatory of the Smithsonian Institution",
"AnBos Annals of the Bosscha Observatory Lembang (Java) Indonesia",
"AnCap Annals of the Cape Observatory",
"AnDea Annals of the Dearborn Observatory",
"AnDud Annals of the Dudley Observatory",
"AnISM Annals of the Institute of Statistical Mathematics",
"AnIPS Annals of the Israel Physical Society",
"AnLow Annals of the Lowell Observatory",
"AnLL. Annals of the Observatory of Lucien Libert",
"AnLun Annals of the Observatory of Lund",
"AnOLL Annals of the Private Observatory of Lucien Libert",
"AnEdi Annals of the Royal Observatory, Edinburgh",
"AnTok Annals of the Tokyo Astronomical Observatory",
"AGp.. Annals of Geophysics",
"AnGla Annals of Glaciology",
"AnGAG Annals of Global Analysis Geometry",
"AnHar Annals of Harvard College Observatory",
"AnMat Annals of Mathematics",
"AnMAI Annals of Mathematics and Artificial Intelligence",
"AnOR. Annals of Operations Research",
"AnPhy Annals of Physics",
"AnREE Annals of Research on Engineering Education",
"AnCGH Annals of Royal Observatory, Cape of Good Hope",
"AnSci Annals of Science",
"AnBSJ Annual Bulletin of the Societe Jersiaise",
"YalAR Annual report of the Astronomer of the Winchester Observatory of Yale College",
"ARKod Annual Report of the Kodaikanal Observatory",
"MMAAR Annual Report of the Maria Mitchell Association",
"WinAR Annual Report of the Windsor Observatory, New South Wales",
"ARA&A Annual Review of Astronomy and Astrophysics",
"AREPS Annual Review of Earth and Planetary Sciences",
"AnRE. Annual Review of Energy",
"AnRFM Annual Review of Fluid Mechanics",
"AnRMS Annual Review of Materials Science",
"ARNPS Annual Review of Nuclear and Particle Science",
"ARPC. Annual Review of Physical Chemistry",
"ARCP. Annual Reviews of Computational Physics",
"AnMN. Antarctic Meteorite Newsletter",
"AMR.. Antarctic Meteorite Research",
"Antk. Antarktika",
"Anten Antenny",
"IORA. Anuario publicado pelo Imperial Observatorio do Rio de Janeiro",
"IORAS Anuario publicado pelo Imperial Observatorio do Rio de Janeiro Suplemento",
"ApAN. Apatity Akademiia Nauk SSSR",
"ApKF. Apatity Kol skii Filial AN SSSR",
"Apei. Apeiron",
"AppAn Applicable Analysis",
"ApMa. Applications of Mathematics",
"ApAc. Applied Acoustics",
"ApAI. Applied Artificial Intelligence",
"ApCM. Applied Composite Materials",
"ACESJ Applied Computational Electromagnetics Society Journal",
"ApEn. Applied Energy",
"ApEnM Applied Environmental Microbiology",
"ApGeo Applied Geophysics",
"ApMF. Applied Mathematical Finance",
"ApMat Applied Mathematics",
"ApMaC Applied Mathematics Computation",
"ApMaL Applied Mathematics Letters",
"ApMaM Applied Mathematics Mechanics English Edition",
"ApMaO Applied Mathematics Optimization",
"ApMRv Applied Mechanics Reviews",
"ApMic Applied Microbiology",
"ApMT. Applied Microgravity Technology",
"ApNM. Applied Numerical Mathematics",
"ApOpt Applied Optics",
"ApPhy Applied Physics",
"ApPhA Applied Physics A: Materials Science & Processing",
"ApPhB Applied Physics B: Lasers and Optics",
"ApPPL Applied Physics B Photophysics Laser Chemistry",
"ApPhC Applied Physics Communications",
"APExp Applied Physics Express",
"ApPhL Applied Physics Letters",
"ApScR Applied Scientific Research",
"ApSpe Applied Spectroscopy",
"ApSRv Applied Spectroscopy Reviews",
"ApSup Applied Superconductivity",
"ApSS. Applied Surface Science",
"APS.. APS Meeting Abstracts",
"ACMFE Aquatic Conservation: Marine and Freshwater Ecosystems",
"AJSE. Arabian Journal of Science Engineering",
"Arch. Archaeoastronomy",
"ArchS Archaeoastronomy Supplement",
"Archa Archaeometry",
"ArElU Archiv Elektronik und Uebertragungstechnik",
"AMGBK Archiv Meteorologie Geophysik und Bioklimatologie Serie B Klimatologie und Umweltmeteorologie Strahlungsforschung",
"AMGBS Archiv Meteorologie Geophysik und Bioklimatologie Serie Meteorologie und Geophysik",
"ArApM Archive Applied Mechanics",
"AHES. Archive for History of Exact Sciences",
"ArRMA Archive for Rational Mechanics and Analysis",
"ArBB. Archive of Biochemistry and Biophysics",
"ArAco Archives Acoustics",
"ArS.. Archives des Sciences",
"AMGBA Archives for Meteorology Geophysics and Bioclimatology Series A Meteorology and Atmopsheric Physics",
"AMGBB Archives for Meteorology Geophysics and Bioclimatology Series B Theoretical and Applied Climatology",
"AIPBB Archives Internationales de Physiologie de Biochimie et de Biophysique",
"ArMAM Archives Mechanics Archiwum Mechaniki Stosowanej",
"ArCom Archivum Combustionis",
"ArAku Archiwum Akustyki",
"ArAuT Archiwum Automatyki i Telemechaniki",
"ArBuM Archiwum Budowy Maszyn",
"ArEle Archiwum Elektrotechniki",
"ArMeS Archiwum Mechaniki Stosowanej",
"ArPSp Archiwum Procesow Spalania",
"ArTSp Archiwum Termodynamiki i Spalania",
"AAAR. Arctic, Antarctic and Alpine Research",
"ArMAF Ark. Mat. Astr. Fys.",
"ArA.. Arkiv for Astronomi",
"ArM.. Arkiv fur Matematik",
"ArmOL Armagh Observatory Leaflet",
"ArtSa Artificial Satellites",
"astro.ArXiv Astrophysics e-prints",
"cs... ArXiv Computer Science e-prints",
"cond.mArXiv Condensed Matter e-prints",
"arXiv ArXiv e-prints",
"gr.qc ArXiv General Relativity and Quantum Cosmology e-prints",
"hep.exArXiv High Energy Physics - Experiment e-prints",
"hep.laArXiv High Energy Physics - Lattice e-prints",
"hep.phArXiv High Energy Physics - Phenomenology e-prints",
"hep.thArXiv High Energy Physics - Theory e-prints",
"math.pArXiv Mathematical Physics e-prints",
"math. ArXiv Mathematics e-prints",
"nlin. ArXiv Nonlinear Sciences e-prints",
"nucl.eArXiv Nuclear Experiment e-prints",
"nucl.tArXiv Nuclear Theory e-prints",
"physicArXiv Physics e-prints",
"quant.ArXiv Quantum Physics e-prints",
"ASHRA ASHRAE Journal",
"Aslib Aslib Proceedings: new information perspectives",
"ATJEM ASME Transactions Journal Engineering Materials and Technology",
"ATJDS ASME Transactions Journal of Dynamic Systems and Measurement Control B",
"ATJEl ASME Transactions Journal of Electronic Packaging",
"ATJEG ASME Transactions Journal of Engineering Gas Turbines and Power",
"ATJEn ASME Transactions Journal of Engineering Power",
"ATJFE ASME Transactions Journal of Fluids Engineering",
"ATJHT ASME Transactions Journal of Heat Transfer",
"ATJLT ASME Transactions Journal of Lubrication Technology",
"ATJSE ASME Transactions Journal of Solar Energy and Engineering",
"ATJTr ASME Transactions Journal of Tribology",
"ATJTu ASME Transactions Journal of Turbomachinery",
"ATJVA ASME Transactions Journal of Vibration Acoustics",
"ATJAM ASME Transactions Series E Journal of Applied Mechanics",
"ATJEP ASME Transactions Series Journal of Engineering Power",
"AsAut Assembly Automation",
"ATMAB Association Technique Maritime et Aeronautique Bulletin",
"ATMAS Association Technique Maritime et Aeronautique Session Paris France ONERA TP",
"AVSVB Associazione Veneta Osservatori di Stelle Variabili Bulletin",
"Aster Aster",
"StNws ASTM Standardization News",
"AsBio Astrobiology",
"AISAO Astrofizicheskie Issledovaniia Izvestiya Spetsial'noj Astrofizicheskoj Observatorii",
"AISof Astrofizicheskie Issledovaniya Sofia",
"Afz.. Astrofizika",
"AAfz. Astrometriia i Astrofizika",
"AUBas Astron. Inst. Univ. Basel",
"AsAc. Astronautica Acta",
"AsAcS Astronautica Acta Supplement",
"AsAer Astronautics Aeronautics",
"Asnau Astronautik",
"ATel. The Astronomer's Telegram",
"A&AT. Astronomical and Astrophysical Transactions",
"USNOM Astronomical and Meteorological Observations made at the U.S. Naval Observatory",
"ACiCh Astronomical Circular",
"ACMan Astronomical Contributions from the University of Manchester",
"TamCo Astronomical Contributions from the University of South Florida Tampa",
"adass Astronomical Data Analysis Software and Systems",
"ADCBu Astronomical Data Center Bulletin",
"AstHe Astronomical Herald",
"AJ... Astronomical Journal",
"ANote Astronomical Notes University of Gothenburg Sweden Section of Astronomy",
"USNOA Astronomical Observations made at the U.S. Naval Observatory",
"UCLAP Astronomical Papers University of California Los Angeles",
"AReg. Astronomical register",
"ASSA. Astronomical Society of South Africa, Cape Centre",
"AVest Astronomicheskii Vestnik",
"AVISS Astronomicheskii Vestnik Issledovaniia Solnechnoi Sistemy",
"AZh.. Astronomicheskii Zhurnal",
"ATsir Astronomicheskij Tsirkulyar",
"KazOB Astronomicheskoj Observatorii Kazan Byulleten",
"A&R.. Astronomie und Raumfahrt",
"AAHam Astronomische Abhandlungen der Hamburger Sternwarte",
"ABMun Astronomische Beobachtungen angestellt auf der K. Sternwarte zu Bogenhausen bei Muenchen",
"ABSBe Astronomische Beobachtungen auf der Koniglichen Sternwarte zu Berlin",
"ABKie Astronomische Beobachtungen auf der Sternwarte der Koeniglichen Christian-Albrechts-Universitaet zu Kiel",
"MiZur Astronomische Mitteilungen der Eidenssischen Sternwarte Zrich",
"MiBre Astronomische Mitteilungen der Koeniglichen Universitaets-Sternwarte zu Breslau",
"MiGoe Astronomische Mitteilungen der Universitaets-Sternwarte zu Goettingen",
"AN... Astronomische Nachrichten",
"ANS.. Astronomische Nachrichten Supplement",
"AJB.. Astronomischer Jahresbericht",
"MiARI Astronomisches Rechen-Institut Heidelberg Mitteilungen Serie A",
"MiARB Astronomisches Rechen-Institut Heidelberg Mitteilungen Serie B",
"ATi.. Astronomisk Tidsskrift",
"Ast.. Astronomy",
"Astro Astronomy",
"A&A.. Astronomy and Astrophysics",
"AstAp Astronomy and Astro-Physics",
"A&AA. Astronomy and Astrophysics Abstracts Heidelberg",
"A&ARv Astronomy and Astrophysics Review",
"A&AS. Astronomy and Astrophysics Supplement Series",
"A&G.. Astronomy and Geophysics",
"ADIL. Astronomy Data Image Library",
"AEdRv Astronomy Education Review",
"AExpr Astronomy Express",
"AstL. Astronomy Letters",
"AstNw Astronomy Now",
"AstQ. Astronomy Quarterly",
"ARep. Astronomy Reports",
"AASPP Astrononomy and Astrophysics Series",
"APh.. Astroparticle Physics",
"ApNr. Astrophysica Norvegica",
"AstBu Astrophysical Bulletin",
"ApInv Astrophysical Investigations",
"ApJ.. Astrophysical Journal",
"ApJS. Astrophysical Journal Supplement Series",
"ApL.. Astrophysical Letters",
"ApL&C Astrophysical Letters Communications",
"Ap... Astrophysics",
"ASPRv Astrophysics and Space Physics Reviews",
"Ap&SS Astrophysics and Space Science",
"ApSSS Astrophysics and Space Science Supplement",
"ASTRA Astrophysics and Space Sciences Transactions",
"MKAtl Astrophysics monographs University of Chicago Press",
"ArBei Astrophysics Reports Publications of the Beijing Astronomical Observatory",
"asd..sAstrophysics Software Database",
"AsAna Asymptotic Analysis",
"ATTTJ AT T Technical Journal",
"AtlVS Atlas Poiskovykh Kart Peremennykh Zvezd",
"Atmos Atmosphere",
"AtO.. Atmosphere Ocean",
"ACP.. Atmospheric Chemistry & Physics",
"ACPD. Atmospheric Chemistry & Physics Discussions",
"AtmEn Atmospheric Environment",
"AtmRe Atmospheric Research",
"AtSc. Atmospheric Science",
"AtScL Atmospheric Science Letters",
"AtmTe Atmospheric Technology",
"ADNDT Atomic Data and Nuclear Data Tables",
"AtERv Atomic Energy Review",
"AMOP. Atomic Molecular and Optical Physics",
"AtPhy Atomic Physics",
"AtST. Atomisation Spray Technology",
"AtEn. Atomnaia Energiia",
"AVET. Atomno Vodorodnaia Energetika i Tekhnologiia",
"ATR.. ATR Australian Telecommunication Research",
"AALST Atti Accad. Ligure Sci. Lett.",
"AAPon Atti Accad. Pontaniana",
"AAST. Atti Accad. Sco. Torino I",
"AurPh Auroral physics",
"AuJAR Aust. J. Agric. Res.",
"AuJCE Australian Journal of Chemical Education",
"AJCh. Australian Journal of Chemistry",
"AuJPh Australian Journal of Physics",
"AuJPA Australian Journal of Physics Astrophysical Supplement",
"AuSRA Australian Journal of Scientific Research A Physical Sciences",
"AJSR. Australian Journal of Soil Research",
"AuMSJ Australian Mathematical Society Journal Series B -- Applied Mathematics",
"AuMM. Australian Meteorological Magazine",
"ACTAp Automatic Control Theory Applications",
"Autom Automatica",
"AuRob Autonomous Robots",
"AvSeM Aviation Space and Environmental Medicine",
"AvWST Aviation Week Space Technology",
"AvKos Aviatsiia i Kosmonavtika",
"AvTek Aviatsionnaia Tekhnika",
"AvTel Avtomatika i Telemekhanika",
"AvPE. Avtomatizatsiia Proektirovaniia Elektronike",
"Avtme Avtometriia",
"BBUSS Babes Bolyai Universitas Studia Series Mathematica",
"BBUSM Babes Bolyai Universitas Studia Series Physica",
"BaltA Baltic Astronomy",
"BamKV Bamberg Kleine Veroeffentlichungen der Remeis-Sternwarte",
"BAVRu BAV Rundbrief",
"BAVSR BAV Rundbrief - Mitteilungsblatt der Berliner Arbeits-gemeinschaft fuer Veraenderliche Sterne",
"BAWMN Bayerische Akademie Wissenschaften mathematisch naturwissenschaftliche Klasse Sitzungsberichte",
"BBCEn BBC Engineering",
"BeSN. Be Star Newsletter",
"BRMIC Behavior Research Methods Instruments and Computers",
"BIT.. Behaviour & Information Technology",
"BUAAJ Beijing University Aeronautics and Astronautics Journal",
"BePl. Beitraege Plasmaphysik",
"BeiGe Beitraege zur Geophysik",
"BeiMP Beitraege zur Mineralogie und Petrographie",
"BROGS Belgian Royal Observatory Communications Series Geophysics Series",
"BLabR Bell Laboratories Record",
"BESBe Beobachtungs-Ergebnisse der Koniglichen Sternwarte zu Berlin",
"ANZi. Beobachtungs-Zirkular der Astronomischen Nachrichten",
"BBGPC Berichte der Bunsen-Gesellschaft Physical Chemistry Chemical Physics Berichte",
"BADPG Berlin East Germany Akademie Verlag GmbH Ergebnisse Plasmaphysik und Gaselektronik",
"BAVMM Berlin East Germany Akademie Verlag GmbH Shriftenreihe des Zentralinstituts Mathematik und Mechanik",
"BGBGM Berlin Gebrueder Borntraeger Geoexploration Monographs Series",
"BAVSM Berliner Arbeitsgemeinschaft fuer Veraenderliche Sterne - Mitteilungen",
"Bern. Bernoulli",
"BeElM Beskontaktnye Elektricheskie Mashiny",
"BGIBI BGI Bulletin d'Information",
"AstBa Biblioteca Astrei Basarabene",
"BEPM. Bielefeld Encounters in Physics and Mathematics",
"BiLuf Bildmessung und Luftbildwessen",
"BBRC. Biochemical and Biophysical Research Communications",
"BioJ. Biochemical Journal",
"BCB.. Biochemistry and Cell Biology",
"AcBB. Biochimica et Biophysica Acta",
"BGeo. Biogeosciences",
"BGD.. Biogeosciences Discussions",
"BMNAS Biographical Memoirs National Academy of Sciences",
"BMFRS Biographical Memoirs of Fellows of the Royal Society",
"BiBi. Bioinspiration and Biomimetics",
"BMP.. Biological and Medical Physics",
"BPS.. Biological Physics Series",
"BRCPS Biological Reviews of the Cambridge Philosophical Society",
"BioMa Biomedical Materials",
"BioMi Biomedical Microdevices",
"Biome Biometrika",
"Bion. Bionika",
"BioCh Biophysical Chemistry",
"BpJ.. Biophysical Journal",
"BpBeS Biophysics and Bioengineering Series",
"BioSM Biophysics of Structure and Mechanism",
"Bioph Biophysics USSR",
"Biopk Biophysik",
"Biorh Biorheology",
"BioSc BioScience",
"BiotL Biotechnology Letters",
"BOTor Biuletyn Obserwatoium Astronomicznego Uniwersytetu M. Kopernika w Toruniu",
"BIAst Bjull. Inst. Astrofizikii",
"BlazD BLAZAR Data",
"BAAA. Boletin de la Asociacion Argentina de Astronomia La Plata Argentina",
"BOTT. Boletin de los Observatorios Tonantzintla y Tacubaya",
"BIMAF Boletin del Instituto de Matematica Astronomica y Fisica Universidad Nacional de Cordoba Argentina",
"BITon Boletin del Instituto de Tonantzintla",
"BMOE. Boletin mensual del Observatorio del Ebro",
"BlDok Bolgarska Akademiia Nauk Doklady",
"BSVit Bolletino della Societa dei Variabilisti Italiani",
"BonD. Bonner Durchmusterung",
"BoLMe Boundary-Layer Meteorology",
"Brain Brain",
"BVVSA Bratislava Veda Vydavatelstvo Slovenskej Akademie Vied",
"BFWSG Braunschweig Friedr Vieweg und Sohn GmbH",
"BTUM. Braunschweig Technische Universitaet Mitteilungen",
"BrJPh Brazilian Journal of Physics",
"BrWK. Brennstoff Waerme Kraft",
"BJHS. The British Journal for the History of Science",
"BJPS. The British Journal for the Philosophy of Science",
"BJAP. British Journal of Applied Physics",
"BJET. British Journal of Educational Technology",
"BJMSP British Journal of Mathematical and Statistical Psychology",
"BJP.. British Journal of Psychology",
"BTE.. British Telecommunications Engineering",
"BIRM. Brussels Institute Royal Meteorologique de Belgique",
"BSSR. AN BSSR Institut Teplo i Massoobmena Vsesoiuznaia Konferentsiia Teplomassoobmenu Minsk Belorussian SSR Preprint",
"BuAkK Budapest Akademiai Kiado",
"BlGJ. Bulgarian Geophysical Journal",
"BlJMH Bulgarian Journal of Meteorology and Hydrology",
"BlJPh Bulgarian Journal of Physics",
"BlGeo Bulgarska Akademiia Naukite Geofizichni Institut Izvestiia",
"BlTek Bulgarska Akademiia Naukite Institut Tekhnicheska Kibernetika Izvestiia",
"BlMat Bulgarska Akademiia Naukite Matematicheski Institut Izvestiia",
"BlSpi Bulgarska Akademiia Naukite Spisanie",
"BlTse Bulgarska Akademiia Naukite Tsentralna Laboratoriia Geodeziia Izvestiia",
"BlGSp Bulgarsko Geofizichno Spisanie",
"BSAO. Bull. Special Astrophys. Obs.",
"BAFOE Bulletin Association Fran. Obs. Etoiles Variables",
"BuAst Bulletin Astronomique",
"BABel Bulletin Astronomique de Belgrade",
"BuAsR Bulletin Astronomique, Revue Generale des Travaux Astronomiques",
"BuAsI Bulletin Astronomique, Serie I",
"BCrAO Bulletin Crimean Astrophysical Observatory",
"BSAF. Bulletin de la Societe Astronomique de France",
"BSAFR<etin de la Societe Astronomique de France et Revue Mensuelle d'Astronomie, de Meteorologie et de Physique du Globe",
"BSBA. Bulletin de la Societe Belge d'Astronomie",
"BSRSL Bulletin de la Societe Royale des Sciences de Liege",
"BMai. Bulletin de la Station Astrophotographique de Mainterne",
"BAPSS Bulletin de l'Academie Polonaise des Sciences Series des Sciences Mathematiques Astronomiques et Physiques",
"BARB. Bulletin de l'Academie Royale de Belgique",
"AFOEV Bulletin de l'Association Francaise d'Observateurs d'Etoiles Variables",
"BOBeo Bulletin de l'Observatoire Astronomique de Belgrade",
"BuLyo Bulletin de l'Observatoire de Lyon",
"BBSAG Bulletin der Bedeckungsveraenderlichen-Beobachter der Schweizerischen Astronomischen Gesellschaft",
"BIM.. Bulletin d'Information des Marees Terrestres",
"BIBGI Bulletin d'Information du Bureau Gravimetrique International",
"BICDS Bulletin d'Information du Centre de Donnees Stellaires",
"BCFHT Bulletin d'information du telescope Canada-France-Hawaii",
"BGeod Bulletin Geodesique",
"BuBIH Bulletin Horaire du Bureau International de l'Heure",
"BOPul Bulletin (Izvestiya) de l'Observatoire Central a Poulkovo",
"BuMat Bulletin Mathematique",
"BAAPG Bulletin of the American Association of Petroleum Geologists",
"BAVSO Bulletin of the American Association of Variable Stars Observers",
"BAMS. Bulletin of the American Meteorological Society",
"BAPS. Bulletin of the American Physical Society",
"BAN.. Bulletin of the Astronomical Institutes of the Netherlands",
"BANS. Bulletin of the Astronomical Institutes of the Netherlands Supplement Series",
"BAICz Bulletin of the Astronomical Institutes of Czechoslovakia",
"BAORB Bulletin of the Astronomical Observatoire Royale de Belgique",
"IllOB Bulletin of the Astronomical Observatory of the University of Illinois",
"BASBr Bulletin of the Astronomical Society of Brazil",
"BASI. Bulletin of the Astronomical Society of India",
"BuIPS Bulletin of the Israel Physical Society",
"BKobO Bulletin of the Kobe Marine Observatory Kobe Japan",
"BuLMS Bulletin of the London Mathematical Society",
"BRASP Bulletin of the Russian Academy of Science, Phys.",
"BSAst Bulletin of the Section of Astronomy",
"BuSSA The Bulletin of the Seismological Society of America",
"BSAE. Bulletin of the Soviet Antarctic Expedition",
"BTok. Bulletin of the Tokyo Astronomical Observatory",
"BToIT Bulletin of the Tokyo Institute of Technology",
"BUBes Bulletin of the University of Besancon Observatory",
"BYam. Bulletin of the Yamagata University Yamagata Japan",
"YerOB Bulletin of the Yerkes Observatory of the University of Chicago",
"BKoAS Bulletin of Korean Astronomical Society",
"BMBio Bulletin of Mathematical Biology",
"BMBp. Bulletin of Mathematical Biophysics",
"BPAS. Bulletin of Pure and Applied Science (Physics)",
"BVol. Bulletin of Volcanology",
"BCNRS Bulletin Signaletique - Centre National de la Recherche Scientifique",
"BDus. Byulleten' Instituta Astrofiziki Dushanbe Akademiya Nauk Tadzhikskoj SSR",
"BITA. Byulleten' Instituta Teoreticheskoj Astronomii (Leningrad)",
"BStaO Byulleten' Stalinabadskoj Astronomicheskoj Observatorii Akademiya Nauk Tadzhikskoj SSR",
"ByuRe Byurakan Astrophysical Observatory Armenia USSR Reprints",
"ByuPr Byurakanskaya Astrofizicheskaya Observatoriya Preprint",
"CAS.. Cambridge Astrophysics Series",
"CCA.. Cambridge Contemporary Astrophysics",
"CamRe Cambridge Observatories Reprints",
"CSLPT Cambridge Studies in Low Temperature Physics",
"CTMPC Cambridge Topics in Mineral Physics and Chemistry",
"BCNRC Canada National Research Council Division Mechanical Engineering National Aeronautical Establishment Quarterly Bulletin",
"CASJ. Canadian Aeronautics and Space Journal",
"CASJQ Canadian Aeronautics and Space Journal Quarter",
"CEEJ. Canadian Electrical Engineering Journal",
"CaGeJ Canadian Geotechnical Journal",
"CIPSG Canadian Information Processing Society Graphics Interface",
"CJChE Canadian Journal of Chemical Engineering",
"CaJCh Canadian Journal of Chemistry",
"CaJCE Canadian Journal of Civil Engineering",
"CaJES Canadian Journal of Earth Sciences",
"CJECE Canadian Journal of Electrical Computer Engineering",
"CJMat Canadian Journal of Mathematics",
"CaJPh Canadian Journal of Physics",
"CaJRS Canadian Journal of Remote Sensing",
"CJRA. Canadian Journal of Research Section A",
"CaJSS Canadian Journal of Soil Science",
"CPhD. Cape Photographic Durchmusterung",
"CarR. Caries Research",
"GCRV. Carnegie Institute Washington D.C. Publication",
"CarOB Carter Observatory Wellington New Zealand Astronomical Bulletins",
"CarRe Carter Observatory Wellington New Zealand Reprints",
"CasRe Case Western Reserve University Warner and Swasey Observatory Cleveland Ohio Reprints",
"CASI. CASI Transactions",
"CSVS. Catalogue of suspected variable stars. Acad. of Sciences USSR Shternberg.",
"CatL. Catalysis Letters",
"CarRv Catalysis Reviews",
"Catt. CATTECH",
"CCDA. CCD Astronomy",
"CEGB. CEGB Research",
"CeMec Celestial Mechanics",
"CeMDA Celestial Mechanics and Dynamical Astronomy",
"Cell. Cell",
"Cellu Cellulose",
"Cent. Centaurus",
"CfAPr Center for Astrophysics Cambridge Mass Preprint Series",
"CBET. Central Bureau Electronic Telegrams",
"CEAB. Central European Astrophysical Bulletin",
"CEJPh Central European Journal of Physics",
"CPH.. Centre de Physique des Houches",
"CCpFS Ceskoslovensky Casopis pro Fyziku Sekce",
"CFDAA CFD Advances Applications",
"ChNew Chandra News",
"Chaos Chaos",
"CSF.. Chaos Solitons and Fractals",
"ChCom Chemical Communications",
"ChEdu Chemical Educator",
"ChEnC Chemical Engineering Communications",
"ChEnN Chemical Engineering News",
"CERDA Chemical Engineering Research & Design. Part A, Transactions of the Institution of Chemical Engineers",
"ChEnS Chemical Engineering Science",
"ChGeo Chemical Geology",
"CP... Chemical Physics",
"CPL.. Chemical Physics Letters",
"CPSS. Chemical Physics of Solid Surfaces",
"CPSSH Chemical Physics of Solid Surfaces and Heterogeneous Catalysis",
"CPR.. Chemical Physics Reports",
"ChSRv Chemical Society Reviews",
"ChEG. Chemie der Erde / Geochemistry",
"CEJ.. Chemistry A European Journal",
"CPCar Chemistry and Physics of Carbon",
"CPLip Chemistry and Physics of Lipids",
"ChUDA Chile Universidad Departamento de Astronomia Publicaciones",
"ChRST China Rept Sci Technol JPRS CST",
"ChA.. Chinese Astronomy",
"ChA&A Chinese Astronomy and Astrophysics",
"ChIEJ Chinese Institute of Engineers Journal",
"ChJA. Chinese Journal of Aeronautics",
"ChJAA Chinese Journal of Astronomy and Astrophysics",
"ChJAS Chinese Journal of Astronomy and Astrophysics Supplement",
"ChJCP Chinese Journal of Chemical Physics",
"ChJG. Chinese Journal of Geophysics",
"ChJIR Chinese Journal of Infrared Research",
"ChJL. Chinese Journal of Lasers",
"CJLTP Chinese Journal of Low Temperature Physics",
"ChJNP Chinese Journal of Nuclear Physics",
"ChJPh Chinese Journal of Physics",
"ChJPR Chinese Journal of Polar Research",
"ChJS. Chinese Journal of Semiconductors",
"ChJSS Chinese Journal of Space Science",
"ChOpL Chinese Optics Letters",
"ChPhy Chinese Physics",
"ChPhB Chinese Physics B",
"ChPhL Chinese Physics Letters",
"ChSBu Chinese Science Bulletin",
"ChSAJ Chinese Society of Astronautics Journal",
"ChSMJ Chinese Society of Mechanical Engineers Journal",
"ChSST Chinese Space Science Technology",
"CMDRG Chislennye Metody Dinamike Razrezhennykh Gazov",
"CHOCS CHOCS",
"CITM. Chubu Institute Technology Memoirs",
"CIDA. CIDA",
"Ciel. Le Ciel",
"C&E.. Ciel et Espace",
"C&T.. Ciel et Terre",
"CTE.. Ciencias de la Tierra y del Espacio",
"CiSSV Circolare Interna della Sezione Stelle Variabili dell'Unione Astrofili Italiani",
"CirW. Circuit World",
"CSSP. Circuits Systems and Signal Processing",
"CAFOE Circulaire de l'Association Francaise d'Observateurs d'Etoiles Variables",
"CiBAA Circular of the British Astronomical Association",
"CiUO. Circular of the Union Observatory Johannesburg",
"CiPoJ Circumpolar Journal",
"CQGra Classical and Quantum Gravity",
"CQGrS Classical and Quantum Gravity Supplement",
"CRMMP Classical Reviews in Mathematics and Mathematical Physics",
"CTPhy Classical Theoretical Physics",
"ClDy. Climate Dynamics",
"CliPa Climate of the Past",
"CliPD Climate of the Past Discussions",
"ClCh. Climatic Change",
"COIR. Clinical Oral Implants Research",
"CPPM. Clinical Physics and Physiological Measurement",
"CNRAe CNR Aeritalia S",
"CODAB CODATA Bulletin",
"Coel. Coelum Periodico Bimestrale per la Divulgazione dell'Astronomia",
"AeSc. Collection of Papers on Aerospace Science",
"ColJ. Colloid Journal",
"ColSu Colloids and Surfaces",
"CPC.. Combinatorics, Probability and Computing",
"CoFl. Combustion and Flame",
"CST.. Combustion Science and Technology",
"CTM.. Combustion Theory Modelling",
"CPMCM Commentationes Physico-Mathematicae et Chemico-Medicae",
"ComMP Comments in Modern Physics",
"ComAp Comments on Astrophysics",
"CoASP Comments on Astrophysics and Space Physics",
"ComSp Commercial Space",
"CoKon Commmunications of the Konkoly Observatory Hungary",
"CAPJ. Communication Astronomy with the Public Journal",
"ComBr Communication Broadcasting",
"CoSSC Communication in Statistics - Simulation and Computation",
"CoSTM Communication in Statistics - Theory and Methods",
"ComRv The Communication Review",
"CoORB Communications de l'Observatoire Royal de Belgique",
"MonAP Communications du Departement d'Astrophysique de la Faculte des Sciences de Mons Mons Astrophysical Papers",
"CoDDO Communications from the David Dunlap Observatory",
"CoRad Communications from the Radcliffe Observatory Pretoria South Africa",
"CoROE Communications from the Royal Observatory Edinburgh",
"CoOxf Communications from the University Observatory Oxford",
"CoStA Communications from the University Observatory St Andrews Scotland",
"CEST. Communications Gillies Inc Electronic Systems in Transportation",
"CoAlg Communications in Algebra",
"CANM. Communications in Applied Numerical Methods",
"CoAst Communications in Asteroseismology",
"CMaPh Communications in Mathematical Physics",
"CNSNS Communications in Nonlinear Science and Numerical Simulations",
"CNME. Communications in Numerical Methods in Engineering",
"CoPDE Communications in Partial Differential Equations",
"CPAM. Communications in Pure Applied Mathematics",
"CoTPh Communications in Theoretical Physics",
"CoAnk Communications of the Department of Astronomy of Ankara University",
"CoLPL Communications of the Lunar and Planetary Laboratory",
"CoLon Communications of the University of London Observatory",
"CPhy. Communications on Physics",
"CRLJ. Communications Research Laboratory Journal",
"CRLRv Communications Research Laboratory Review",
"ComSo Communications Society",
"Compe COMPEL: The International Journal for Computation and Mathematics in Electrical and Electronic Engineering",
"CoVar Complex Variables",
"CmpSt Composite Structures",
"Compo Composites",
"CmpEn Composites Engineering",
"CmpMa Composites Manufacturing",
"ComST Composites Science Technology",
"CoMat Compositio Mathematica",
"CRSPH Compte Rendu des Seances de la Societe de Physique et d'Histoire Naturelle de Genere",
"CR... Comptes Rendus Academie des Sciences (serie non specifiee)",
"CRABS Comptes Rendus de l'Academie Bulgare des Sciences",
"CRPhy Comptes Rendus Physique",
"CAMP. Computational and Applied Mathematical Physics",
"CMMPh Computational Mathematics and Mathematical Physics",
"CompM Computational Mechanics",
"COA.. Computational Optimization and Applications",
"CS&D. Computational Science and Discovery",
"CSMA. Computational Structural Mechanics and Applications",
"Comp. Computer",
"CGIP. Computer Graphics Image Processing",
"CompJ The Computer Journal",
"CMAME Computer Methods in Applied Mechanics and Engineering",
"CoPhC Computer Physics Communications",
"CoPhR Computer Physics Reports",
"CSEd. Computer Science Education",
"CS&L. Computer Speech & Language",
"CVIU. Computer Vision and Image Understanding",
"CVGIP Computer Vision Graphics and Image Processing",
"CAD.. Computer-Aided Design",
"CBR.. Computers and Biomedical Research",
"CEE.. Computers and Electrical Engineering",
"CF... Computers and Fluids",
"CG... Computers and Geosciences",
"CMwA. Computers and Mathematics with Applications",
"CoStr Computers and Structures",
"ComPh Computers in Physics",
"Compu Computing",
"CSE.. Computing in Science and Engineering",
"ComSE Computing Systems in Engineering",
"COMTR COMSAT Technical Review",
"CoCoi Comunicacoes do Observatonio Astronomico da Universidade de Coimbra",
"CGDAM Conformal Geometry and Dynamics of the American Mathematical Society",
"CDT.. Connaissance des Temps",
"ConSc Connection Science",
"CoFra Consiglio Nazionale delle Ricerche Italia. Laboratorio di Astrofisica Frascati Roma Contributi",
"ConCP Contemporary Concepts in Physics",
"ConFP Contemporary Fundamental Physics",
"ConPh Contemporary Physics",
"CSR.. Continental Shelf Research",
"CMT.. Continuum Mechanics and Thermodynamics",
"CoIAP Contributions de l'Institut d'Astrophysique de Paris Serie A",
"CoIAB Contributions de l'Institut d'Astrophysique de Paris Serie B",
"CoAsi Contributions dell'Osservatorio Astrofisica dell'Universita di Padova in Asiago",
"CoMil Contributions dell'Osservatorio Astrononia di Milano-Merate",
"CoArm Contributions from the Armagh Observatory",
"CoThe Contributions from the Astronomical Department of the University of Thessaloniki",
"CoBos Contributions from the Bosscha Observervatory",
"CoCam Contributions from the Cambridge Observatory England",
"CoTol Contributions from the Cerro Tololo Inter-American Observatory",
"CoTok Contributions from the Department of Astronomy University of Tokyo",
"CoDAO Contributions from the Dominion Astrophysical Observatory in Victoria",
"CoDun Contributions from the Dunsink Observatory Dublin Ireland",
"CoKyo Contributions from the Institute of Astrophysics and Kwasan Observatory Kyoto",
"CoKit Contributions from the Kitt Peak National Observatory",
"CoKwa Contributions from the Kwasan and Hida Observatories University of Kyoto",
"CoIoa Contributions from the Laboratory of Astronomy - University of Ioannina Greece",
"CoMcD Contributions from the McDonald Observatory University of Texas Fort Davis",
"CMWCI Contributions from the Mount Wilson Observatory / Carnegie Institution of Washington",
"CoPri Contributions from the Princeton University Observatory",
"CoAth Contributions from the Research and Computing Center Academy of Sciences of Athens Series I Astronomy",
"CoRut Contributions from the Rutherford Observatory of Columbia University New York",
"CoWas Contributions from the Washburn Observatory of the University of Wisconsin",
"CoWro Contributions from the Wroclaw Astronomical Observatory",
"CoSka Contributions of the Astronomical Observatory Skalnate Pleso",
"CoSkL Contributions of the Astronomical Observatory Skalnate Pleso Letters",
"CoSkS Contributions of the Astronomical Observatory Skalnate Pleso Supplement",
"CoLou Contributions of the Louisiana State University Observatory Baton Rouge Louisiana",
"CoNMx Contributions of the Observatory of New Mexico State University Las Cruces New Mexico",
"CoBrn Contributions of the Public Observatory and Planetarium in Brno",
"CSASG Contributions of the Slovak Academy Sciences Geophysical Institute",
"CoWat Contributions of the University of Waterloo Observatory",
"CoVVO Contributions of the Van Vleck Observatory",
"CoLic Contributions of Lick Observatory",
"CLic2 Contributions of Lick Observatory, Series II",
"CoPer Contributions of Perkins Observatory",
"ConAP Contributions to Atmospheric Physics/Beitraege zur Physik Atmosphaere",
"CoMP. Contributions to Mineralogy and Petrology",
"CoPP. Contributions to Plasma Physics",
"CoUCL Contributions Universite Catholique de Louvain",
"CoSte Contributions University of Arizona Steward Observatory Tucson Arizona",
"CoRHO Contributions University of Florida Rosemary Hill Observatory Gainesville",
"CoCom Control and Computers",
"CopRe Copenhagen University Observatory Reprints",
"CorRe Coral Reefs",
"CorD. Cordoba Durchmusterung",
"CosRe Cosmic Research",
"CosSe Cosmic Search Summer",
"CTP.. Course of Theoretical Physics",
"CRB.. C.R. Acad. Sci. Ser. B1",
"CraRe Cracow Observatory Reprints",
"CRSSM Critical Reviews in Solid State & Materials Sciences",
"Cryo. Cryogenics",
"TCD.. The Cryosphere Discussions",
"CryRp Crystallography Reports",
"CuCo. Culture and Cosmos",
"CAP.. Current Applied Physics",
"CCPCE Current Contents Physical Chemical and Earth Sciences",
"CEyeR Current Eye Research",
"CSci. Current Science",
"CySys Cybernetics and Systems",
"CzJPh Czechoslovak Journal of Physics",
"CzJPB Czechoslovak Journal of Physics B",
"CzMJ. Czechoslovak Mathematical Journal",
"DTr.. Dalton Transactions",
"DMKD. Data Mining and Knowledge Discovery",
"DDORe David Dunlap Observatory Richmond Hill Reprints",
"DeaCo Dearborn Observatory Contributions",
"DSRI. Deep Sea Research Part I: Oceanographic Research",
"DSR.. Deep Sea Research Part II: Topical Studies in Oceanography",
"DSNPR Deep Space Network Progress Report",
"Defek Defektoskopiia",
"DefEl Defense Electronics",
"DMJ.. Defense Management Journal",
"DeScE Defense Science Electronics",
"DSJ.. Defense Science Journal",
"DSRMC Defense Systems Review Military Communications",
"DSSN. Delta Scuti Star Newsletter",
"Sterb Der Sternenbote Monatsschrift fuer Oesterreichs Amateur-astronomen",
"DGKBA Deutsche Geodaetische Kommission Bayer. Akad. Wiss.",
"DGKGN Deutsche Geodaetische Kommission Gravity Network West Germany DSGN Data Adjustment",
"DeHyZ Deutsche Hydrographische Zeitschrift",
"DPhyG Deutsche Physikalische Gesellschaft",
"DSEG. Developments in Solid Earth Geophysics",
"DFVLR DFVLR",
"DRM.. Diamond And Related Materials",
"DnU.. Differentsial nye Uravneniia",
"DSP.. Digital Signal Processing",
"Dimen Dimensions",
"DiSis Dinamicheskie Sistemy",
"DPM.. Dinamika i Prochnost Mashin",
"DiRaG Dinamika razrezhennykh gazov",
"DIO.. DIO",
"DCMP. Directions in Condensed Matter Physics",
"DISA. DISA Information",
"Disc. Discover",
"DImTe Display Imaging Technology",
"Displ Displays",
"DSE.. Distributed Systems Engineering",
"DLGRM DLGR Magnetofluiddyn",
"Dlib. D-Lib Magazine",
"DLRNa DLR Nachrichten",
"DOCi. Documentation des Observateurs Circulaire",
"DOIAP Documentation des Observateurs Institut d'Astrophysique de Paris",
"DokAN Doklady Akad Nauk Minerologia USSR",
"DokES Doklady Earth Sciences",
"DokPC Doklady Physical Chemistry",
"DAOAR Dominion Astrophysical Observatory Annual Report",
"DorPo Dornier Post",
"DSO.. Double Star Observer",
"DudOR Dudley Observatory Reports",
"PODE. Dun Echt Observatory Publications",
"DunOP Dunsink Observatory Publications",
"DunRe Dunsink Observatory Reprints",
"DurOO Durham Observatory Observations",
"IzDus Dushanbe Izdatel Donish",
"DyeRe Dyer Observatory Reprints",
"DySys Dynamical Systems: An International Journal",
"DynCo Dynamics and Control",
"DSSys Dynamics and Stability of Systems",
"DyAtO Dynamics of Atmospheres and Oceans",
"EESC. Earth and Environmental Science Conference Series",
"EaEvS Earth and Evolution Sciences",
"EExSc Earth and Extraterrestrial Sciences",
"E&PSL Earth and Planetary Science Letters",
"E&S.. Earth and Space",
"EaInt Earth Interactions",
"EM&P. Earth Moon and Planets",
"EP&S. Earth, Planets, and Space",
"ESRv. Earth Science Reviews",
"ESPL. Earth Surface Processes and Landforms",
"EOAST Earth-Oriented Applications and Space Technology",
"EEEV. Earthquake Engineering and Engineering Vibration",
"EERSA East Europe Rept Sci Affairs JPRS",
"EERST East European Rept Sci. Technol. JPRS ESA",
"EBCi. Eclipsing Binaries Circulars",
"EcGH. Eclogae geologae Helvetii",
"Earth eEarth",
"EartD eEarth Discussions",
"ETATF Eesti NSV Teaduste Akadeemia Toimetised Fuusika Matemaatika",
"IzmP. Ege University Izmir Publications of the Department of Astronomy",
"Elast Elastic",
"EMPS. Electric Machines and Power Systems",
"ECLRv Electrical Communication Laboratories Review",
"JElEn Electrical Engineering of Japan",
"EOSD. Electro Optical Systems Design",
"Elecm Electromagnetics",
"EJSEd Electronic Journal of Science Education",
"EJTP. Electronic Journal of Theoretical Physics",
"ElPro Electronic Progress",
"JElCo Electronics Communications of Japan",
"ElL.. Electronics Letters",
"ElP.. Electronics Power",
"ElLC. Electrotechnical Laboratory Circulars",
"ElLR. Electrotechnical Laboratory Researches",
"ElBah Elektrische Bahnen",
"E&E.. Elektromashinostroenie i Elektrooborudovanie",
"Elem. Elektromekhanika",
"Elek. Elektronika",
"ElTA. Elektronnaia Tekhnika Avtomatike",
"ElMod Elektronnoe Modelirovanie",
"ETRE. Elektrosviaz Telecommunications Radio Engineering Telecommunications",
"E&M.. Elektrotechnik und Maschinenbau",
"EVest Elektrotehniski Vestnik",
"EMBO. The EMBO Journal",
"EMCT. EMC Technology",
"EBBT. Emerging Biochemical and Biophysical Techniques",
"EAA.. Encyclopedia of Astronomy and Astrophysics",
"Endvr Endeavour",
"Energ Energetika",
"EnAt. Energia es Atomtechnika",
"EnC.. Energy Conversion",
"ECM.. Energy Conversion Management",
"EnS.. Energy Sources",
"EnTR. Energy Technology Review",
"EnUK. Energy UK",
"EngAn Engineering Analysis",
"EngCo Engineering Computations",
"EnFM. Engineering Fracture Mechanics",
"EnOp. Engineering Optimization",
"CEnTp Engineering Thermophysics China",
"Entro Entropie",
"EnAPC Environmental Analytical and Physical Chemistry Series",
"EES.. Environmental Earth Sciences",
"EnEng Environmental Engineering",
"EFM.. Environmental Fluid Mechanics",
"EnGeo Environmental Geology",
"EnMan Environmental Management",
"EnP.. Environmental Pollution Series B Chemical and Physical",
"ER... Environmental Research",
"ERL.. Environmental Research Letters",
"EnST. Environmental Science Technology",
"EnTox Environmental Toxicology",
"ETWQ. Environmental Toxicology and Water Quality",
"Env.. Environmentrics",
"EOSTr EOS Transactions",
"EPRIJ EPRI Journal",
"AnErg Ergaenzungshefte zu den Astronomischen Nachrichten",
"ErNW. Ergebnisse der exakten Naturwissenschaften",
"ETDS. Ergodic Theory and Dynamical Systems",
"Ergo. Ergonomics",
"ESABu ESA Bulletin",
"ESAJ. ESA Journal",
"ESAST ESA Scientific Technical Review",
"EssPh Essays in Physics",
"ECSS. Estuarine Coastal and Shelf Science",
"EurSS Eurasian Soil Science",
"ERST. Europe Report Science Technology",
"EBioJ European Biophysics Journal",
"EJAM. European Journal of Applied Mathematics",
"EJBio European Journal of Biochemistry",
"EJC.. European Journal of Combinatorics",
"EJEE. European Journal of Engineering Education",
"EJMF. European Journal of Mechanics B Fluids",
"EJMS. European Journal of Mechanics Solids",
"EJPh. European Journal of Physics",
"EPJA. European Physical Journal A",
"EPJAS European Physical Journal A Supplement",
"EPJAP European Physical Journal Applied Physics",
"EPJB. European Physical Journal B",
"EPJC. European Physical Journal C",
"EPJCS European Physical Journal C Supplement",
"EPJD. European Physical Journal D",
"EPJE. European Physical Journal E",
"EuRv. European Review",
"ESN.. European Science Notes",
"ESOAR European Southern Observatory Annual Reports",
"ESOB. European Southern Observatory ESO Bulletin",
"ESOSP European Southern Observatory Scientific Preprints",
"ESOSR European Southern Observatory Scientific Report",
"ETTRT European Transactions Telecommunications Related Technologies",
"EL... Europhysics Letters",
"ENews Europhysics News",
"EXOSA EXOSAT Express",
"ExA.. Experimental Astronomy",
"EEyeR Experimental Eye Research",
"ExHT. Experimental Heat Transfer",
"ExM.. Experimental Mechanics",
"ExMPS Experimental Methods in the Physical Sciences",
"ExT.. Experimental Techniques",
"ExTFS Experimental Thermal Fluid Science",
"ExFl. Experiments in Fluids",
"Extr. Extraction",
"PMtv. Facultad de Humanidades y Ciencias Universidad de la Republica Montevideo",
"FaTr. Faraday Transactions",
"FFEMS Fatigue and Fracture of Engineering Materials and Structures",
"F&M.. Feinwerktechnik und Messtechnik",
"Fer.. Ferroelectrics",
"FerLS Ferroelectrics Letters Section",
"FBS.. Few-Body Systems",
"FiIO. Fiber and Integrated Optics",
"FIOpt Fiber Integrated Optics",
"FeMik Finommechanika Mikrotechnika",
"FiBr. First Break",
"FizEl Fizicheskaia Elektronika",
"FiMek Fizicheskaia Mekhanika",
"Fiz.. Fizika",
"FizA. Fizika A",
"FizAS Fizika Aerodispersnykh Sistem",
"FizB. Fizika B",
"FizGV Fizika Goreniia i Vzryva",
"FizKO Fizika i Khimiia Obrabotki Materialov",
"FizTV Fizika i Tekhnika Vysokikh Davlenii",
"FizMM Fizika Metallov i Metallovedenie",
"FizMS Fizika Mnogochastichnykh Sistem",
"FizNT Fizika Nizkikh Temperatur",
"FizPl Fizika Plazmy",
"FizTT Fizika Tverdogo Tela",
"FizZS Fizika Zhidkogo Sostoianiia",
"FizAt Fiziki Atmosfery",
"FizKM Fiziko Khimicheskaia Mekhanika Materialov",
"FizCh Fizyki i Chemii Seria Fizyka",
"FliIn Flight International",
"F&CRe Flower and Cook Observatory Reprints",
"FNL.. Fluctuation and Noise Letters",
"FRFI. Flug Revue Flugwelt International",
"FlDy. Fluid Dynamics",
"FlDyR Fluid Dynamics Research",
"FlDyT Fluid Dynamics Transactions",
"FMAG. Fluid Mechanics of Astrophysics and Geophysics",
"FlMSR Fluid Mechanics Soviet Research",
"Fluid Fluidika",
"FluQ. Fluids Quarterly",
"FBP.. Food and Bioproducts Processing. Part C, Transactions of the Institution of Chemical Engineers",
"F&I.. Forschung im Ingenieurwesen",
"F&IER Forschung im Ingenieurwesen Engineering Research",
"ForPh Fortschritte der Physik",
"FoGeo Fotointerpretacja w Geografii",
"FoPh. Foundations of Physics",
"FPhL. Foundations of Physics Letters",
"FrInJ Franklin Institute Journal",
"Freq. Frequenz",
"FrPhy Frontiers in Physics",
"FrPhC Frontiers of Physics in China",
"IzFru Frunze Izdatel Ilim",
"FSTJ. Fujitsu Scientific Technical Journal",
"FST.. Fullerene Science and Technology",
"FAAp. Functional Analysis and Its Applications",
"FACM. Functiones et Approximatio Commentarii Mathematici",
"FInfo Fundamenta Informaticae",
"FANP. Fundamental and Applied Nuclear Physics Series",
"OOPS. Fundamental nye Osnovy Opticheskoi Pamiati i Sredy",
"FTP.. Fundamental Theories of Physics",
"FCPh. Fundamentals of Cosmic Physics",
"Futur Future Spring",
"GCNew Galactic Center Newsletter",
"GalEl Galilean Electrodynamics",
"GEB.. Games and Economic Behavior",
"GGMit Gauss-Gesellschaft e.V. G&ouml",
"GVPOO Gauthier-Villars Paris Observatory Observations",
"GazT. Gazodinamika i Teploobmen",
"GECJR GEC Journal Research",
"Gelio Geliotekhnika",
"Gemin GEMINI Newsletter Royal Greenwich Observatory",
"GHA.. General History of Astronomy",
"GPB.. General Physiology AND Biophysics",
"GReGr General Relativity and Gravitation",
"Gen.. Genetica",
"GeoIn Geocarto International",
"GeocJ Geochemical Journal",
"Geoch Geochemistry",
"GGG.. Geochemistry, Geophysics, Geosystems",
"GeocI Geochemistry International",
"GeCoA Geochimica et Cosmochimica Acta",
"GeCAS Geochimica et Cosmochimica Acta Supplement",
"GeAer Geodeziia i Aerofotos",
"GeKar Geodeziia i Kartografiia",
"GeKaA Geodeziia Kartografiia i Aerofotos",
"GeoK. Geodezja i Kartografia",
"GeoAc Geodinamica Acta",
"GeofI Geofisica Internacional",
"GeoPA Geofisica Pura e Applicata",
"GeoSb Geofizicheskii Sbornik",
"GeoZh Geofizicheskii Zhurnal",
"GeoAA Geografiska Annaler, Series A: Physical Geography",
"GeoAB Geografiska Annaler, Series B: Human Geography",
"Geokh Geokhimiia",
"GeolJ Geological Journal",
"GeoM. Geological Magazine",
"GeoSJ Geological Society Journal",
"GSAMB Geological Society of America Bulletin",
"GSAMm Geological Society of America Memoir",
"GSASP Geological Society of America Special Papers",
"GeoRu Geologische Rundschau",
"Geo.. Geology",
"GeoOD Geology of Ore Deposits",
"Ge&Ae Geomagnetism and Aeronomy/Geomagnetizm i Aeronomiia",
"GeoIs Geomagnitnye Issledovaniia",
"GML.. Geo-Marine Letters",
"GeoD. Geometriae Dedicata",
"GeomJ Geomicrobiology Journal",
"Geomo Geomorphology",
"Geoph Geophysica",
"GeGe. Geophysica et Geodaetica",
"GeoNr Geophysica Norvegica",
"GApFD Geophysical and Astrophysical Fluid Dynamics",
"GDS.. Geophysical Developments Series",
"GeoJ. Geophysical Journal",
"GeoJI Geophysical Journal International",
"GeopP Geophysical Prospecting",
"GeopR Geophysical References",
"GeoRL Geophysical Research Letters",
"GeoSu Geophysical Surveys",
"Geop. Geophysics",
"GAM.. Geophysics and Astrophysics Monographs",
"GeoOM Georgetown Observatory Monogram",
"GeoRe Georgetown Observatory Reprints",
"GEOCE GEOS Circular on Eclipsing Binaries",
"GEOCR GEOS Circular on RR Lyr Type Variables",
"GEOCA GEOS Circular on Small-Amplitude Variables",
"GEOSN GEOS Note Circulaire",
"Geote Geotectonics",
"TrGRC Geothermal Resources Council Transactions",
"Geoth Geothermics",
"Geot. Geotimes",
"GBzG. Gerlands Beitraege zur Geophysik",
"GUL.. Geschichte und Lichtwechsel der Veraenderlichen Sterne (Potsdam)",
"GATAN Gesellschaft Aerosolforschung Tagung ueber Aerosole Naturwissenschaft Medizin und Technik Messtechnik und technische Anwendung",
"GMMWJ Gesellschaft angewandte Mathematik und Mechanik Jahrestagung Goettingen West Germany Zeitschrift Flugwissenschaften",
"GaMuM Gesellschaft Angewandte Mathematik und Mechanik Workshop Paris France",
"GMuD. Gesellschaft Mathematik und Datenverarbeitung mbH Multigrid Methods Special Topics Applications",
"GVMK. Gibridnye Vychislitel nye Mashiny i Kompleksy",
"Gidro Gidromekhanika",
"GiGi. Gidroprivod i Gidropnevmoavtomatika",
"GiSan Gigiena i Sanitariia",
"GTPZ. Gigiena Truda i Professional nye Zabolevaniia",
"GlMaJ Glasgow Mathematical Journal",
"GPC.. Global and Planetary Change",
"GBioC Global Biogeochemical Cycles",
"GLORe Goethe Link Observatory Reprints",
"GPSW. GPS World",
"GMIP. Graphical Models and Image Processing",
"GrCo. Gravitation and Cosmology",
"GrCoS Gravitation and Cosmology Supplement",
"GrTOn Gravitatsiia i Teoriia Otnositel nosti",
"GCN.. GRB Coordinates Network",
"GriO. Griffith Observer",
"GrAeH Grumman Aerospace Horizons",
"GICi. Gruppo Italiano RV Tauri Circolare",
"HalRe Hale Observatories Reprints",
"LS... Hamburger Sternw. Warner & Swasey Obs.",
"BSD.. Hamburger Sternwarte Bergedorf",
"HamS. Hamburger Sternwarte Sonderdrucke",
"HAAG. Handbook of Astronomy Astrophysics and Geophysics",
"HBP.. Handbook of Biological Physics",
"HGE.. Handbook of Geophysical Exploration",
"HPlPh Handbook of Plasma Physics",
"HPCRE Handbook on the Physics and Chemistry of Rare Earths",
"HDA.. Handbuch der Astrophysik",
"HDP.. Handbuch der Physik",
"HarZi Harthaer Beobachtungs-Zirkular",
"HarAC Harvard College Observatory Announcement Card",
"HarAR Harvard College Observatory Annual Report",
"BHarO Harvard College Observatory Bulletin",
"HarCi Harvard College Observatory Circular",
"HarPa Harvard College Observatory Papers",
"HarRe Harvard College Observatory Reprints",
"HeaPh Health Physics",
"HMT.. Heat and Mass Transfer",
"HTrEn Heat Transfer Engineering",
"HTJR. Heat Transfer Japanese Research",
"HTSR. Heat Transfer Soviet Research",
"Heavn Heavens",
"HMR.. Helgoland Marine Research",
"HWM.. Helgol&auml",
"AcHCh Helvetica Chimica Acta",
"AcHPh Helvetica Physica Acta",
"HelOB Helwan Institute of Astronomy and Geophysics Bulletins",
"HemD. Hemel en Dampkring",
"HECh. High Energy Chemistry",
"HEPNP High Energy Physics and Nuclear Physics",
"HPP.. High Performance Polymers",
"HPR.. High Pressure Research",
"HiTec High Technology",
"HTemS High Temperature Science",
"HTHP. High Temperatures and High Pressures",
"HiA.. Highlights of Astronomy",
"HARSB Histoire de l'Academie Royale des Sciences et des Belles-Lettres de Berlin",
"HSPBS Historical Studies in the Physical and Biological Sciences",
"HGeo. History of Geophysics",
"HisSc History of Science",
"HUFEB Hokkaido University Faculty Engineering Bulletin",
"HUFEM Hokkaido University Faculty Engineering Memoirs",
"Holz. Holzforschung",
"HBB.. Horizons in Biochemistry and Biophysics",
"HWP.. Horizons in World Physics",
"LHBl. La Houille Blanche",
"HCHy. Hovering Craft and Hydrofoil",
"HGT.. Human Gene Therapy",
"HvaOB Hvar Observatory Bulletin",
"HyBio Hydrobiologia",
"HydJ. Hydrogeology Journal",
"HyPr. Hydrological Processes",
"HESS. Hydrology and Earth System Sciences",
"HESSD Hydrology and Earth System Sciences Discussions",
"HyInt Hyperfine Interactions",
"IadEn Iadernaia Energiia",
"IAGBu IAGA Bulletin",
"IaIaF Iakutsk Iakutskii Filial SO AN SSSR",
"BSEEA Iasi Institutul Politehnic Buletinul Sectia Electrotehnica Electronica Automatizari",
"BSMMT Iasi Institutul Politehnic Buletinul Sectia Matematica Mecanica Teoretica Fizica",
"BSMT. Iasi Institutul Politehnic Buletinul Sectia Mecanica Tehnica",
"IAUCB IAU Commission on Close Binary Stars",
"IAUDS IAU Commission on Double Stars",
"IAUIn IAU Commission on Instruments",
"IBMJ. IBM Journal Research Development",
"ICAOB ICAO Bulletin",
"Icar. Icarus",
"JMOA. IEE Journal of Microwaves Optics and Acoustics",
"JSSED IEE Journal of Solid-State Electron Devices",
"IPEPA IEE Proceedings B: Electric Power Applications",
"IPGTD IEE Proceedings C: Generation Transmission Distribution",
"IPCSV IEE Proceedings: Communications Speech and Vision",
"IPCTA IEE Proceedings D: Control Theory Applications",
"IPCDT IEE Proceedings E: Computers and Digital Techniques",
"IPCRP IEE Proceedings F: Communications and Radar Processing",
"IPCRS IEE Proceedings F: Communications Radar and Signal Processing",
"IPRSP IEE Proceedings F: Radar and Signal Processing",
"IPMAP IEE Proceedings H: Microwaves Antennas and Propagation",
"IPMOA IEE Proceedings H: Microwaves Optics and Antennas",
"IPOpt IEE Proceedings J: Optoelectronics",
"IPPSM IEE Proceedings: Physical Science Measurement and Instrumentation Management and Education Reviews",
"IPSSE IEE Proceedings: Solid-State Electron Devices",
"IEERv IEE Reviews",
"IAESM IEEE Aerospace Electronic Systems Magazine",
"IAPM. IEEE Antennas Propagation Magazine",
"IASSP IEEE ASSP Magazine",
"ICiSM IEEE Circuits Systems Magazine",
"IComM IEEE Communications Magazine",
"ICGA. IEEE Computer Graphics Applications",
"ICSM. IEEE Computer Systems Magazine",
"IDTC. IEEE Design Test Computers",
"IEDL. IEEE Electron Device Letters",
"IExp. IEEE Expert",
"IJOE. IEEE Journal of Oceanic Engineering",
"IJQE. IEEE Journal of Quantum Electronics",
"IJRA. IEEE Journal of Robotics Automation",
"IJSSC IEEE Journal of Solid-State Circuits",
"IJSAC IEEE Journal on Selected Areas in Communications",
"ILCSM IEEE LCS Magazine",
"ILTS. IEEE LTS",
"IMGWL IEEE Microwave and Guided Wave Letters",
"IEEEN IEEE Network",
"IPTL. IEEE Photonics Technology Letters",
"IEEEP IEEE Proceedings",
"ISPL. IEEE Signal Processing Letters",
"ISPM. IEEE Signal Processing Magazine",
"IEEES IEEE Spectrum",
"ITASS IEEE Transactions on Acoustics Speech and Signal Processing",
"ITAES IEEE Transactions on Aerospace Electronic Systems",
"ITAP. IEEE Transactions on Antennas and Propagation",
"ITAS. IEEE Transactions on Applied Superconductivity",
"ITAC. IEEE Transactions on Automatic Control",
"ITBE. IEEE Transactions on Biomedical Engineering",
"ITB.. IEEE Transactions on Broadcasting",
"ITCS. IEEE Transactions on Circuits Systems",
"ITCom IEEE Transactions on Communications",
"ITCHM IEEE Transactions on Components Hybrids and Manufacturing Technology",
"ITCAD IEEE Transactions on Computer Aided Design",
"ITCmp IEEE Transactions on Computers",
"ITDEI IEEE Transactions on Dielectrics and Electrical Insulation",
"ITEdu IEEE Transactions on Education",
"ITEI. IEEE Transactions on Electrical Insulation",
"ITElC IEEE Transactions on Electromagnetic Compatibility",
"ITED. IEEE Transactions on Electron Devices",
"ITEnC IEEE Transactions on Energy Conversion",
"ITEM. IEEE Transactions on Engineering Management",
"ITGRS IEEE Transactions on Geoscience and Remote Sensing",
"ITGE. IEEE Transactions on Geoscience Electronics",
"ITIP. IEEE Transactions on Image Processing",
"ITIE. IEEE Transactions on Industrial Electronics",
"ITIEC IEEE Transactions on Industrial Electronics and Control Instrumentation",
"ITIA. IEEE Transactions on Industry Applications",
"ITIT. IEEE Transactions on Information Theory",
"ITIM. IEEE Transactions on Instrumentation Measurement",
"ITM.. IEEE Transactions on Magnetics",
"ITMI. IEEE Transactions on Medical Imaging",
"ITMTT IEEE Transactions on Microwave Theory Techniques",
"ITNN. IEEE Transactions on Neural Networks",
"ITNS. IEEE Transactions on Nuclear Science",
"ITPHP IEEE Transactions on Parts Hybrids and Packaging",
"ITPAM IEEE Transactions on Pattern Analysis and Machine Intelligence",
"ITPS. IEEE Transactions on Plasma Science",
"ITPAS IEEE Transactions on Power Apparatus Systems",
"ITPD. IEEE Transactions on Power Delivery",
"ITPE. IEEE Transactions on Power Electronics",
"ITR.. IEEE Transactions on Reliability",
"ITRA. IEEE Transactions on Robotics Automation",
"ITSTQ IEEE Transactions on Selected Topics in Quantum Electronics",
"ITSM. IEEE Transactions on Semiconduct M",
"ITSP. IEEE Transactions on Signal Processing",
"ITSE. IEEE Transactions on Software Engineering",
"ITSU. IEEE Transactions on Sonics Ultrasonics",
"ITSMC IEEE Transactions on Systems Man and Cybernetics",
"ITUFF IEEE Transactions on Ultrasonics Ferroelectrics and Frequency Control",
"ITVT. IEEE Transactions on Vehicular Technology",
"IEIEE IEICE Electronics Express",
"IEITC IEICE Transactions on Communications",
"IEITE IEICE Transactions on Electronics",
"IEITF IEICE Transactions on Fundamentals of Electronics Communications and Computer Sciences",
"IEITI IEICE Transactions on Information and Systems",
"IESJ. IES Journal",
"JApMa IMA Journal of Applied Mathematics",
"IJNA. IMA Journal of Numerical Analysis",
"IVMA. IMA Volumes in Mathematics and its Applications",
"IMEPA IME Proceedings. Part A: Journal of Power and Energy",
"IMEPB IME Proceedings. Part B: Journal of Engineering Manufacture",
"IMEPC IME Proceedings. Part C: Journal of Mechanical Engineering Science",
"IMEPD IME Proceedings. Part D: Journal of Automobile Engineering",
"IMEPE IME Proceedings. Part E: Journal of Process Mechanical Engineering",
"IMEPG IME Proceedings. Part G: Journal of Aerospace Engineering",
"IMEPH IME Proceedings. Part H: Journal of Engineering in Medicine",
"IMEPI IME Proceedings. Part I: Journal of Systems and Control Engineering",
"IMEPK IME Proceedings. Part K: Journal of Multibody Dynamics",
"ICSE. Impact of Computing in Science and Engineering",
"IASAP Indian Academy of Science Aryabhata Proj",
"InEPS Indian Academy of Sciences Proceedings: Earth and Planetary Sciences",
"InMS. Indian Academy of Sciences Proceedings Mathematical Sciences",
"InASP Indian Academy of Sciences Proceedings Section",
"InES. Indian Academy of Sciences Proceedings: Section C Engineering Sciences",
"IIApN Indian Institute of Astrophysics Newsletter",
"InISJ Indian Institute of Science Journal",
"InISA Indian Institute of Science Journal of Aeronomical Society of India",
"InSST Indian Institute of Science Space Science Technology Applications: An Overview",
"ITJSE Indian Institute of Technology Journal on Section Engineering Technology",
"InJAE Indian Journal of Aerospace Engineering Division",
"InJBB Indian Journal of Biochemistry and Biophysics",
"InJET Indian Journal of Electronics Telecommunication Engineering Division",
"InJME Indian Journal of Mechanical Engineering Division",
"IJMHG Indian Journal of Meteorology Hydrology and Geophysics",
"InJP. Indian Journal of Physics and Proceedings of the Indian Assocatiation for the Cultivation of Science",
"InJPA Indian Journal of Physics Section A",
"InJPB Indian Journal of Physics Section B",
"InJPS Indian Journal of Physics Section B B",
"IJPAM Indian Journal of Pure and Applied Mathematics",
"IJPAP Indian Journal of Pure and Applied Physics",
"IJRSP Indian Journal of Radio and Space Physics",
"InJTP Indian Journal of Theoretical Physics",
"INSAP Indian National Science Academy Proceedings Supplement",
"IUMJ. Indiana University Mathematics Journal",
"IDAQP Infinite Dimensional Analysis, Quantum Probability and Related Topics",
"InCo. Information and Computation",
"IBVS. Information Bulletin on Variable Stars",
"InfCo Information Control",
"InfD. Information Display",
"IPM.. Information Processing and Management",
"IPL.. Information Processing Letters",
"IBSH. Informational Bulletin of the Southern Hemisphere",
"IRA.. Infrared Astronomy",
"InfPh Infrared Physics",
"InPhT Infrared Physics and Technology",
"Ingeg Ingegneria",
"IA&A. Ingenieria Aeronautica y Astronautica",
"IngAr Ingenieur Archiv",
"InCh. Inorganic Chemistry",
"IAL1K Institut d'Astronomie de Lausanne",
"IRMBP Institut Royal Meteorologique de Belgique Publications Serie",
"ITAB. Institut Teoreticheskoi Astronomii Biulleten",
"TrITA Institut Teoreticheskoi Astronomii Trudy",
"IMA.. Institute for Mathematics and Its Applications",
"InFuJ Institute Fuel Journal",
"JIECE Institute of Electronics Communication Engineers of Japan Transactions Section E English",
"IPASA Institute of Physics Academia Sinica Annual Report",
"OslR. Institute of Theoretical Astrophysics Blindern Oslo Reports",
"IEAEE Institution Engineers Australia Electrical Engineering Transactions",
"IEEP. Institution of Electrical Engineers Proceedings",
"IEREJ Institution of Electronic Radio Engineers Journal",
"IETE. Institution of Electronics Telecommunication Engineers",
"IAFET Instituto de Astronomia y Fisica del Espacio Buenos Aires",
"MerRe Instituto Venezolano de Astronomia Merida Venezuela",
"IET.. Instruments and Experimental Techniques",
"InLoP Instytut Lotnictwa Prace",
"InMP. Instytut Maszyn Przeplywowych",
"InMPP Instytut Maszyn Przeplywowych Prace",
"IntaC Inta Conie",
"ITSF. Integral Transforms and Special Functions",
"ICAE. Integrated Computer-Aided Engineering",
"InFer Integrated Ferroelectrics",
"Inter Interavia",
"IntSM Interavia Space Markets",
"ARIJ. An Interdisciplinary Journal of Physical and Engineering Sciences",
"ISRv. Interdisciplinary Science Reviews",
"IFB.. Interfaces and Free Boundaries",
"IPAUC INTERKOSMOS Prague Astronomicky Ustav Ceskoslovenske Akademie Ved",
"IANT. International Advances in Nondestructive Testing",
"IAPPP International Amateur-Professional Photoelectric Photometry Communications",
"IAUC. International Astronomical Union Circular",
"ICQ.. International Comet Quarterly",
"ICHMT International Communications in Heat and Mass Transfer",
"IrPh. International Conference Infrared Physics Zurich Switzerland",
"ICML. International Conference on Machine Learning",
"InGeo International Geophysics Series",
"IJCEM International Journal for Computational Methods in Engineering Science and Mechanics",
"IJNAM International Journal for Numerical and Analytical Methods in Geomechanics",
"IJNME International Journal for Numerical Methods in Engineering",
"IJNMF International Journal for Numerical Methods in Fluids",
"IJRPC International Journal for Radiation Physics and Chemistry",
"IJACS International Journal of Adaptive Control and Signal Processing",
"IJAA. International Journal of Adhesion Adhesives",
"IJAEM International Journal of Analytical and Experimental Modal Analysis",
"IJAEO International Journal of Applied Earth Observation and Geoinformation",
"IJApE International Journal of Applied Electromagnetics and Mechanics",
"IJAsB International Journal of Astrobiology",
"IJAP. International Journal of Aviation Psychology",
"IJBC. International Journal of Bifurcation and Chaos",
"IJBB. International Journal of Bioclimatology Biometeorology",
"IJBm. International Journal of Biometeorology",
"IJCli International Journal of Climatology",
"IJCES International Journal of Computational Engineering Science",
"IJCFD International Journal of Computational Fluid Dynamics",
"IJCMS International Journal of Computer Mathematics Section B",
"IJCV. International Journal of Computer Vision",
"IJC.. International Journal of Control",
"IJDM. International Journal of Damage Mechanics",
"IJDF. International Journal of Dynamics of Fluids",
"IJEaS International Journal of Earth Sciences",
"IJE.. International Journal of Electronics",
"IJER. International Journal of Energy Research",
"IJEFM International Journal of Engineering and Fluid Mechanics Spring",
"IJES. International Journal of Engineering Science",
"IJFa. International Journal of Fatigue",
"IJFD. International Journal of Fluid Dynamics",
"IJFr. International Journal of Fracture",
"IJFE. International Journal of Fusion Energy",
"IJGS. International Journal of General Systems",
"IJGA. International Journal of Geomagnetism and Aeronomy",
"IJHFF International Journal of Heat and Fluid Flow",
"IJHMT International Journal of Heat and Mass Transfer",
"IJHSC International Journal of High Speed Computing",
"IJHSE International Journal of High Speed Electronics and Systems",
"IJHM. International Journal of Hybrid Microelectronics Fall",
"IJHE. International Journal of Hydrogen Energy",
"IJHy. International Journal of Hyperthermia",
"IJIG. International Journal of Image and Graphics",
"IJIST International Journal of Imaging Systems Technology",
"IJIE. International Journal of Impact Engineering",
"IJIMW International Journal of Infrared and Millimeter Waves",
"IJICS International Journal of Intelligent Control and Systems",
"IJMSI International Journal of Mass Spectrometry and Ion Processes",
"IJMES International Journal of Mathematical Education in Science and Technology",
"IJM.. International Journal of Mathematics",
"IJMS. International Journal of Mechanical Sciences",
"IJMW. International Journal of Mine Water",
"IJMM. International Journal of Mini Microcomputers",
"IJMoS International Journal of Modelling and Simulation",
"IJMPA International Journal of Modern Physics A",
"IJMPB International Journal of Modern Physics B",
"IJMPC International Journal of Modern Physics C",
"IJMPD International Journal of Modern Physics D",
"IJMPE International Journal of Modern Physics E",
"IJMF. International Journal of Multiphase Flow",
"IJN.. International Journal of Nanoscience",
"IJNS. International Journal of Neural Systems",
"IJNLM International Journal of Non Linear Mechanics",
"IJNOP International Journal of Nonlinear Optical Physics",
"IJNMH International Journal of Numerical Methods for Heat & Fluid Flow",
"IJOMS International Journal of Oral and Maxillofacial Surgery",
"IJPRS International Journal of Photogrammetry and Remote Sensing",
"IJPES International Journal of Physical and Engineering Sciences",
"IJP.. International Journal of Plasticity",
"IJPM. International Journal of Polymeric Materials",
"IJPG. International Journal of Population Geography",
"IJPR. International Journal of Production Research",
"IJQC. International Journal of Quantum Chemistry",
"IJRAI International Journal of Radiation Applications and Instrumentation D Nuclear Tracks and Radiation Measurements",
"IJRB. International Journal of Radiation Biology",
"IJRQS International Journal of Reliability, Quality and Safety Engineering",
"IJRS. International Journal of Remote Sensing",
"IJRR. International Journal of Robotics Research",
"IJSC. International Journal of Satellite Communications",
"IJSEd International Journal of Science Education",
"IJSE. International Journal of Solar Energy",
"IJSS. International Journal of Solids and Structures",
"IJSSD International Journal of Structural Stability and Dynamics",
"IJScA International Journal of Supercomputer Applications",
"IJSyS International Journal of Systems Science",
"IJTP. International Journal of Theoretical Physics",
"IJT.. International Journal of Thermophysics",
"IJTJE International Journal of Turbo Jet Engines",
"IMRv. International Materials Reviews",
"IMeRv International Metals Reviews",
"IRH.. International Review of Hydrobiology",
"IRNP. International Review of Nuclear Physics",
"IRPC. International Reviews in Physical Chemistry",
"ISBRv International Space Business Review",
"IER.. Internationale Elektronische Rundschau",
"IPNPR Interplanetary Network Progress Report",
"InMat Inventiones Mathematicae",
"InvPr Inverse Problems",
"IGeo. Investigations in Geophysics",
"InFiZ Inzhenerno Fizicheskii Zhurnal",
"IonIs Ionosfernye Issledovaniia",
"Iono. Ionosphere",
"E&ES. IOP Conference Series: Earth and Environmental Science",
"IrJST Iranian Journal of Science Technology",
"IrAJ. Irish Astronomical Journal",
"IrAJS Irish Astronomical Journal Supplement",
"ISAP. ISA Proceedings",
"ISAT. ISA Transactions",
"IHERv Ishikawajima Harima Engineering Review",
"Isis. Isis. Journal of the History of Science Society",
"IPBS. Isotopes in the Physical and Biomedical Sciences",
"IsJT. Israel Journal of Technology",
"IsSRT Israel Space Research and Technology Information Bulletin",
"ISCJS ISRO Satellite Centre Journal of Spacecraft Technology",
"IssZK Issledovanie Zemli iz Kosmosa",
"IGAFS Issledovaniia Geomagnetizmu Aeronomii i Fizike Solntsa",
"IsMTD Issledovaniia Mekhanike i Teploobmenu Dvukhfaznykh Sred",
"IssUP Issledovaniia Uprugosti i Plastichnosti",
"ISKZ. Issledovaniya Solntsa i Krasnykh Zvezd",
"IST.. Issues in Science and Technology",
"IsJAP Istanbul University Faculty of Science Journal of Astronomy Physics",
"IsRvC Istanbul University Faculty Science Review Serie C",
"IINA. Istituto Italiano di Navigazione Atti",
"IAIss Istoriko-Astronomicheskie Issledovaniya",
"ITCJ. ITC Journal",
"INTSA Itogi Nauki i Tekhniki Seriia Astronomiia",
"INTSF Itogi Nauki i Tekhniki Seriia Fizika Plazmy",
"INTSI Itogi Nauki i Tekhniki Seriia Issledovanie Kosmicheskogo Prostranstva",
"INTMK Itogi Nauki i Tekhniki Seriia Meteorologiia i Klimatologiia",
"INTSO Itogi Nauki i Tekhniki Seriia Okeanologiia",
"INTSR Itogi Nauki i Tekhniki Seriia Radiotekhnika",
"INTSS Itogi Nauki i Tekhniki Seriia Sovremennye Problemy Matematiki",
"INTSV Itogi Nauki i Tekhniki Seriia Vozdushnyi Transport",
"ITUTJ ITU Telecommunication Journal",
"IUEEN IUE ESA Newsletter",
"IUENN IUE NASA Newsletter",
"IzSF. Izvestiia Akademii Nauk Seriya Fizicheskaya",
"IzGla Izvestiia Glavnoi rossiiskoi astronomicheskoi observatorii",
"IzAsh Izvestiya Akademii Nauk Turkmenskoj SSR Ashkhabad",
"IzArm Izvestiya Akademiya Nauk Armyanskoi",
"IzAlm Izvestiya Astrofizicheskogo Instituta Alma-Ata",
"IzKaz Izvestiya Astronomicheskoj Engel'gardt obskoj Observatorii Kazan",
"IzAOP Izvestiya Atmospheric and Oceanic Physics",
"IzKie Izvestiya Glavnoj Astronomicheskoj Observatorii Kiev",
"IzPul Izvestiya Glavnoj Astronomicheskoj Observatorii v Pulkove",
"IzMat Izvestiya: Mathematics",
"IzAne Izvestiya na Fizicheskiya Institut s Aneb",
"IzKry Izvestiya Ordena Trudovogo Krasnogo Znameni Krymskoj Astrofizicheskoj Observatorii",
"IzPSE Izvestiya Physics of the Solid Earth",
"IzAvT Izvestiya VUZ Aviatsionnaya Tekhnika",
"IzRad Izvestiya VUZ Radiofizika",
"IzNic Izviestiia Nikolaevskoi glavnoi astronomicheskoi observatorii",
"JWUDF Jahns W&ouml",
"JRE.. Jahrbuch der Radioaktivit&auml",
"JASAC Japan Astronomical Study Association Circulars",
"JaIMJ Japan Institute of Metals Journal",
"JSASS Japan Society of Aeronautical Space Sciences",
"JSAST Japan Society of Aeronautical Space Sciences Transactions",
"JSAPJ Japan Society of Air Pollution Journal",
"JSCMJ Japan Society of Composite Materials Journal",
"JSLEJ Japan Society of Lubrication Engineers Journal",
"JSMSJ Japan Society of Materials Science Journal",
"JSPS. Japan Society of Promotion Science",
"JaJAP Japanese Journal of Applied Physics",
"JJAPL Japanese Journal of Applied Physics Letters B",
"JJAPR Japanese Journal of Applied Physics Regular Papers Short Notes and Review Papers",
"JJAPS Japanese Journal of Applied Physics Supplement",
"JaJAG Japanese Journal of Astronomy and Geophysics",
"JSMAJ JASMA Japan Society of Microgravity Application Journal",
"JMeOp Jemna Mechanika Optika",
"JenRv Jena Review",
"JBASP Jodrell Bank Ann Ser Pt",
"JBAn. Jodrell Bank Annals",
"JBRe. Jodrell Bank Reprints",
"JHATD Johns Hopkins APL Technical Digest",
"JOM.. JOM",
"RSNSW Journal and Proceedings of the Royal Society of New South Wales",
"JAco. Journal d'Acoustique",
"JCP.. Journal de Chimie Physique",
"JCPPC Journal de Chimie Physique et de Physico-Chimie Biologique",
"JMec. Journal de Mecanique",
"JMecA Journal de Mecanique Appliquee",
"JMecT Journal de Mecanique Theorique et Appliquee",
"JMTAS Journal de Mecanique Theorique et Appliquee Supplement",
"JPhys Journal de Physique",
"JPR.. Journal de Physique et le Radium",
"JPhy1 Journal de Physique I",
"JPhy2 Journal de Physique II",
"JPhy3 Journal de Physique III",
"JPhy4 Journal de Physique IV",
"JPhyL Journal de Physique Lettres",
"JReAt Journal de Recherches Atmospheriques",
"JAF.. Journal des Astronomes Francais",
"JO... Journal des Observateurs",
"JOp.. Journal d'Optique",
"JHA.. Journal for the History of Astronomy",
"JHAS. Journal for the History of Astronomy Supplement",
"JRAM. Journal fur die reine und angewandte Mathematik",
"JNanU Journal Nanjing Univ",
"JNIRE Journal NIRE",
"JASJa Journal of the Acoustical Society of Japan",
"JAVSO Journal of the American Association of Variable Star Observers (JAAVSO)",
"JAChS Journal of the American Chemical Society",
"JAMS. Journal of the American Mathematical Society",
"JASIS Journal of the American Society for Information Science and Technology",
"JASCE Journal of the American Society of Civil Engineers",
"JAWRA Journal of the American Water Resources Association",
"JALPO Journal of the Association of Lunar and Planetary Observers, the Strolling Astronomer",
"JAnSc Journal of the Astronautical Sciences",
"JASEg Journal of the Astronomical Society of Egypt",
"JASV. Journal of the Astronomical Society of Victoria Melbourne",
"JBAA. Journal of the British Astronomical Association",
"JBAS. Journal of the British Astronomical Society",
"JBIS. Journal of the British Interplanetary Society",
"JCSS. Journal of the Chinese Silicate Society",
"JElS. Journal of the Electrochemical Society",
"JIISB Journal of the Indian Institute of Science Section B Physical and Chemical Series",
"JIMIA Journal of the Institute of Mathematics and Its Applications",
"JIETE Journal of the Institution of Electronics and Telecommunication Engineers",
"JLMS. Journal of the London Mathematical Society",
"JORS. Journal of the Operational Research Society",
"JOSAA Journal of the Optical Society of America A",
"JOSA. Journal of the Optical Society of America (1917-1983)",
"JOSAB Journal of the Optical Society of America B Optical Physics",
"JPSJ. Journal of the Physical Society of Japan",
"JPSJS Journal of the Physical Society of Japan Supplement",
"JRASA Journal of the Royal Aeronautical Society of London",
"JRASC Journal of the Royal Astronomical Society of Canada",
"JRASN Journal of the Royal Astronomical Society of New Zealand",
"JRCSE Journal of the Royal College of Surgeons of Edinburgh",
"JRSSD Journal of the Royal Statistical Society: Series D (The Statistician)",
"JSRP. Journal of the Society for Radiological Protection",
"JWasA Journal of the Washington Academy of Sciences",
"JAE.. Journal of Acoustic Emission",
"JAerS Journal of Aerosol Science",
"JAerE Journal of Aerospace Engineering",
"JAerP Journal of Aerospace Power",
"JAfES Journal of African Earth Sciences",
"JAER. Journal of Agricultural Engineering Research",
"JAS.. The Journal of Agricultural Science",
"JAir. Journal of Aircraft",
"JAlg. Journal of Algebra",
"JAlgC Journal of Algebraic Combinatorics",
"JAlgo Journal of Algorithms",
"JAllC Journal of Alloys and Compounds",
"JACS. Journal of American Ceramic Society",
"JAAS. Journal of Analytical Atomic Spectrometry",
"JApCr Journal of Applied Crystallography",
"JApEl Journal of Applied Electrochemistry",
"JAG.. Journal of Applied Geophysics",
"JAMTP Journal of Applied Mechanics and Technical Physics",
"JApMw Journal of Applied Metalworking",
"JApMe Journal of Applied Meteorology",
"JApMC Journal of Applied Meteorology and Climatology",
"JAPE. Journal of Applied Photographic Engineering",
"JAP.. Journal of Applied Physics",
"JAPh. Journal of Applied Physiology",
"JASE. Journal of Applied Science and Engineering Section on Electrical Power and Information Systems",
"JApSc Journal of Applied Sciences",
"JApSp Journal of Applied Spectroscopy",
"JApS. Journal of Applied Statistics",
"JApT. Journal of Approximation Theory",
"JAESc Journal of Asian Earth Sciences",
"JAD.. Journal of Astronomical Data",
"JAHH. Journal of Astronomical History and Heritage",
"JAsPh Journal of Astronomy and Physics (Turkey)",
"JASS. Journal of Astronomy and Space Sciences",
"JApA. Journal of Astrophysics and Astronomy",
"JApAS Journal of Astrophysics and Astronomy Supplement",
"JAtOT Journal of Atmospheric and Oceanic Technology",
"JASTP Journal of Atmospheric and Solar-Terrestrial Physics",
"JATP. Journal of Atmospheric and Terrestrial Physics",
"JAtC. Journal of Atmospheric Chemistry",
"JAtS. Journal of Atmospheric Sciences",
"JAES. Journal of Audio Engineering Society",
"JAuGG Journal of Australian Geology and Geophysics",
"JAuR. Journal of Automated Reasoning",
"JBall Journal of Ballistics",
"JBBM. Journal of Biochemical and Biophysical Methods",
"JBB.. Journal of Bioenergetics and Biomembranes",
"JBC.. Journal of Biological Chemistry",
"JBP.. Journal of Biological Physics",
"JBiom Journal of Biomechanics",
"JBO.. Journal of Biomedical Optics",
"JBNMR Journal of Biomolecular NMR",
"JBBC. Journal of Biophysical and Biochemical Cytology",
"JBiBi Journal of Biophysique et de Biomecanique",
"JBMN. Journal of Biophysique et Medecine Nucleaire",
"JBR.. Journal of Breath Research",
"JCat. Journal of Catalysis",
"JChEd Journal of Chemical Education",
"JChPh Journal of Chemical Physics",
"JChTh The Journal of Chemical Thermodynamics",
"JChS. Journal of Chromatographic Science",
"JCh.. Journal of Chromatography",
"JCSC. Journal of Circuits, Systems and Computers",
"JCli. Journal of Climate",
"JCAM. Journal of Climate and Applied Meteorology",
"JClim Journal of Climatology",
"JClP. Journal of Clinical Pharmacology",
"JCS.. Journal of Cluster Science",
"JCScT Journal of College Science Teaching",
"JCIS. Journal of Colloid and Interface Science",
"JCTA. Journal of Combinatorial Theory, Series A",
"JCTB. Journal of Combinatorial Theory, Series B",
"JCom. Journal of Communications",
"JComp Journal of Complexity",
"JCoMa Journal of Composite Materials",
"JCTR. Journal of Composites and Technology Research",
"JCA.. Journal of Computational Acoustics",
"JCoAM Journal of Computational and Applied Mathematics",
"JCoB. Journal of Computational Biology",
"JCoCh Journal of Computational Chemistry",
"JCM.. Journal of Computational Mathematics",
"JCoN. Journal of Computational Neuroscience",
"JCoPh Journal of Computational Physics",
"JCoSS Journal of Computer and System Sciences",
"JCAMD Journal of Computer-Aided Materials Design",
"JCHyd Journal of Contaminant Hydrology",
"JCAP. Journal of Cosmology and Astro-Particle Physics",
"JCrGr Journal of Crystal Growth",
"JDR.. Journal of Dairy Research",
"JDE.. Journal of Differential Equations",
"JoDI. Journal of Digital Information",
"JDST. Journal of Dispersion Science and Technology",
"JDisT Journal of Display Technology",
"JDSO. Journal of Double Star Observations",
"JDCS. Journal of Dynamical and Control Systems",
"JDDE. Journal of Dynamics and Differential Equations",
"JElas Journal of Elasticity",
"JEEEA Journal of Electrical and Electronics Engineering Australia",
"JElec Journal of Electroceramics",
"JEWA. Journal of Electromagnetic Waves and Applications",
"JEMT. Journal of Electron Microscopy Technique",
"JESRP Journal of Electron Spectroscopy and Related Phenomena",
"JECS. Journal of Electronic Circuits and Systems",
"JEI.. Journal of Electronic Imaging",
"JEMat Journal of Electronic Materials",
"JEPub Journal of Electronic Publishing",
"JElM. Journal of Electronics Manufacturing",
"JEner Journal of Energy",
"JEAS. Journal of Engineering and Applied Sciences",
"JEnMa Journal of Engineering and Mathematics",
"JEngM Journal of Engineering and Mechanics",
"JETh. Journal of Engineering and Thermophysics",
"JEER. Journal of Engineering Education Research",
"JEP.. Journal of Engineering Physics",
"JEPT. Journal of Engineering Physics and Thermophysics",
"JEngS Journal of Engineering Sciences",
"JEEM. Journal of Environmental and Economics Management",
"JEnvS Journal of Environmental Sciences",
"JExB. Journal of Experimental Botany",
"JFin. The Journal of Finance",
"JFF.. Journal of Fire Flammability",
"JFC.. Journal of Fluid Control",
"JFM.. Journal of Fluid Mechanics",
"JFS.. Journal of Fluids and Structures",
"JFlu. Journal of Fluorescence",
"JFAA. Journal of Fourier Analysis and Applications",
"JFuA. Journal of Functional Analysis",
"JGeod Journal of Geodesy",
"JGeo. Journal of Geodynamics",
"JGS.. Journal of Geographical Systems",
"JG... Journal of Geology",
"JGG.. Journal of Geomagnetism and Geoelectricity",
"JGGS. Journal of Geomagnetism and Geoelectricity Supplement",
"JGP.. Journal of Geometry and Physics",
"JGR.. Journal of Geophysical Research",
"JGRD. Journal of Geophysical Research (Atmospheres)",
"JGRF. Journal of Geophysical Research (Earth Surface)",
"JGRC. Journal of Geophysical Research (Oceans)",
"JGRE. Journal of Geophysical Research (Planets)",
"JGRB. Journal of Geophysical Research (Solid Earth)",
"JGRA. Journal of Geophysical Research (Space Physics)",
"JGRS. Journal of Geophysical Research Supplement",
"JGE.. Journal of Geophysics and Engineering",
"JGZG. Journal of Geophysics Zeitschrift Geophysik",
"JGeEd Journal of Geoscience Education",
"JGlac Journal of Glaciology",
"JGO.. Journal of Global Optimization",
"JGuC. Journal of Guidance Control",
"JGCD. Journal of Guidance Control Dynamics",
"JHeu. Journal of Heuristics",
"JHENP Journal of High Energy and Nuclear Physics",
"JHEP. Journal of High Energy Physics",
"JHEPC Journal of High Energy Physics Conference Proceedings",
"JHSN. Journal of High Speed Networks",
"JHyd. Journal of Hydrology",
"JHyMe Journal of Hydrometeorology",
"JHyn. Journal of Hydronautics",
"JIST. Journal of Imaging Science and Technology",
"JIMW. Journal of Infrared and Millimeter Waves",
"JInst Journal of Instrumentation",
"JIntS Journal of Integer Sequences",
"JIEq. Journal of Integral Equations",
"JIRS. Journal of Intelligent and Robotic Systems",
"JIMSS Journal of Intelligent Material Systems and Structures",
"JKTR. Journal of Knot Theory and its Ramifications",
"JKAS. Journal of Korean Astronomical Society",
"JKASS Journal of Korean Astronomical Society Supplement",
"JKPS. Journal of Korean Physical Society",
"JLCMe Journal of Laboratory and Clinical Medicine",
"JLasA Journal of Laser Applications",
"JLCM. Journal of Less Common Metals",
"JLVEn Journal of Light & Visual Environment",
"JLwT. Journal of Lightwave Technology",
"JLTP. Journal of Low Temperature Physics",
"JLum. Journal of Luminescence",
"JMSB. Journal of Macromolecular Science, Part B: Physics",
"JMSC. Journal of Macromolecular Science, Part C: Reviews in Macromolecular Chemistry and Physics",
"JMmSP Journal of Macromolecular Science Physics",
"JMmSR Journal of Macromolecular Science Reviews in Macromolecular Chemistry and Physics",
"JMagR Journal of Magnetic Resonance",
"JMMM. Journal of Magnetism and Magnetic Materials",
"JMS.. Journal of Marine Systems",
"JMarA Journal of Maritime Archaeology",
"JMES. Journal of Materials and Energy Systems",
"JMCh. Journal of Materials Chemistry",
"JMEP. Journal of Materials Engineering and Performance",
"JMPMS Journal of Materials Processing and Manufacturing Science",
"JMatR Journal of Materials Research",
"JMatS Journal of Materials Science",
"JMSME Journal of Materials Science and Materials Electronics",
"JMSL. Journal of Materials Science Letters",
"JMSMM Journal of Materials Science: Materials in Medicine",
"JMSP. Journal of Materials Synthesis and Processing",
"JMAA. Journal of Mathematical Analysis and Applications",
"JMPS. Journal of Mathematical and Physical Sciences",
"JMaCh Journal of Mathematical Chemistry",
"JMFM. Journal of Mathematical Fluid Mechanics",
"JMIV. Journal of Mathematical Imaging and Vision",
"JMP.. Journal of Mathematical Physics",
"JMPsy Journal of Mathematical Psychology",
"JMaSc Journal of Mathematical Sciences",
"JMSo. Journal of Mathematical Sociology",
"JMaPh Journal of Mathematics and Physics",
"JMecE Journal of Mechanical and Engineering Science",
"JMBM. Journal of Mechanical Behavior and Materials",
"JMPSo Journal of Mechanics Physics of Solids",
"JMNB. Journal of Medecine Nucleaire et Biophysique",
"JME&T Journal of Medical Engineering & Technology",
"JMet. Journal of Metals",
"JMemS Journal of Microelectromechanical Systems",
"JMM&M Journal of Microlithography, Microfabrication, and Microsystems",
"JMiMi Journal of Micromechanics and Microengineering",
"JMic. Journal of Microscopy",
"JMOp. Journal of Modern Optics",
"JMBio Journal of Molecular Biology",
"JMoEl Journal of Molecular Electronics",
"JMolE Journal of Molecular Evolution",
"JMoSp Journal of Molecular Spectroscopy",
"JMoSt Journal of Molecular Structure",
"JMA.. Journal of Multivariate Analysis",
"JNUNS Journal of Nanjing University (Natural Sciences)",
"JNR.. Journal of Nanoparticle Research",
"JNav. Journal of Navigation",
"JNEng Journal of Neural Engineering",
"JNeur Journal of Neurochemistry",
"JNO.. Journal of Neuro-Oncology",
"JNCS. Journal of Non Crystalline Solids",
"JNET. Journal of Non Equilibrium Thermodynamics",
"JNLM. Journal of Non Linear Mechanics",
"JNE.. Journal of Nondestructive Evaluation",
"JNMP. Journal of Nonlinear Mathematical Physics",
"JNOPM Journal of Nonlinear Optical Physics and Materials",
"JNS.. Journal of NonLinear Science",
"JNuE. Journal of Nuclear Energy",
"JNuM. Journal of Nuclear Materials",
"JNT.. Journal of Number Theory",
"JOUC. Journal of Ocean University of China",
"JOC.. Journal of Optical Communications",
"JON.. Journal of Optical Networking",
"JOptT Journal of Optical Technology",
"JOpt. Journal of Optics",
"JOptA Journal of Optics A: Pure and Applied Optics",
"JOptB Journal of Optics B: Quantum and Semiclassical Optics",
"JOTA. Journal of Optimization Theory Applications",
"JOMS. Journal of Oral and Maxillofacial Surgery",
"JOR.. Journal of Oral Rehabilitation",
"JPal. Journal of Paleontology",
"JPDC. Journal of Parallel and Distributed Computing",
"JPet. Journal of Petrology",
"JPhPh Journal of Pharmacy and Pharmacology",
"JPCRD Journal of Physical and Chemical Reference Data",
"JPCC. Journal of Physical and Colloid Chemistry",
"JPCA. Journal of Physical Chemistry A",
"JPhCh Journal of Physical Chemistry",
"JPCB. Journal of Physical Chemistry B",
"JPO.. Journal of Physical Oceanography",
"JPhSt Journal of Physical Studies",
"JPhA. Journal of Physics A Mathematical General",
"JPCS. Journal of Physics and Chemistry of Solids",
"JPhB. Journal of Physics B Atomic Molecular Physics",
"JPhC. Journal of Physics C Solid State Physics",
"JPCM. Journal of Physics Condensed Matter",
"JPhCS Journal of Physics Conference Series",
"JPhD. Journal of Physics D Applied Physics",
"JPhE. Journal of Physics E Scientific Instruments",
"JPhF. Journal of Physics F Metal Physics",
"JPhG. Journal of Physics G Nuclear Physics",
"JPhGS Journal of Physics G Nuclear Physics Supplement",
"JPE.. Journal of Physics of the Earth",
"JPTEO Journal of Physics Teacher Education Online",
"JPhsg Journal of Physiology",
"JPFR. Journal of Plasma and Fusion Research",
"JPlPh Journal of Plasma Physics",
"JPoSA Journal of Polymer Science A Polymer Physics",
"JPoSB Journal of Polymer Science B Polymer Letters",
"JPMat Journal of Porous Materials",
"JPS.. Journal of Power Sources",
"JPAS. Journal of Practical Applications in Space",
"JPP.. Journal of Propulsion Power",
"JPT.. Journal of Propulsion Technology",
"JPrCh Journal of Protein Chemistry",
"JPApS Journal of Pure Applied Sciences",
"JQT.. Journal of Quality Technology",
"JQSRT Journal of Quantitative Spectroscopy and Radiative Transfer",
"JQS.. Journal of Quaternary Science",
"JRNC. Journal of Radioanalytical and Nuclear Chemistry",
"JRAC. Journal of Radioanalytical Chemistry",
"JRP.. Journal of Radiological Protection",
"JRSp. Journal of Raman Spectroscopy",
"JRPC. Journal of Reinforced Plastics and Composites",
"JRes. Journal of Research",
"JRScT Journal of Research in Science Teaching",
"JRNBS Journal of Research of the National Bureau of Standards",
"JRTEd Journal of Research on Technology in Education",
"JResB Journal of Research Section B Mathematical Sciences B",
"JRheo Journal of Rheology",
"JRoS. Journal of Robotic Systems",
"JRLR. Journal of Russian Laser Research",
"JSEdT Journal of Science Education and Technology",
"JSTEd Journal of Science Teacher Education",
"JSCom Journal of Scientific Computing",
"JScI. Journal of Scientific Instruments",
"JSIPI Journal of Scientific Instruments and of Physics in Industry",
"JSR.. Journal of Sea Research",
"JSeis Journal of Seismology",
"JSGeo Journal of Series Geophysics",
"JShR. Journal of Ship Research",
"JSGST Journal of Sol-Gel Science and Technology",
"JSSCh Journal of Solid State Chemistry France",
"JSCh. Journal of Solution Chemistry",
"JSV.. Journal of Sound Vibration",
"JSAES Journal of South American Earth Sciences",
"JSLR. Journal of Soviet Laser Research",
"JSAR. Journal of Space Astronomy Research",
"JSpRo Journal of Spacecraft and Rockets",
"JSpT. Journal of Spacecraft Technology",
"JSCS. Journal of Statistical Computation and Simulation",
"JSMTE Journal of Statistical Mechanics: Theory and Experiment",
"JSP.. Journal of Statistical Physics",
"JStA. Journal of Strain Analysis and Engineering Design",
"JSAED Journal of Strain Analysis for Engineering Design",
"JSG.. Journal of Structural Geology",
"JSM.. Journal of Structural Mechanics",
"JSup. Journal of Superconductivity",
"JSymC Journal of Symbolic Computation",
"JTePh Journal of Technical Physics",
"JTech Journal of Technology",
"JTeEv Journal of Testing Evaluation",
"JTBio Journal of Theoretical Biology",
"JTAC. Journal of Thermal Analysis and Calorimetry",
"JThSc Journal of Thermal Science",
"JTST. Journal of Thermal Spray Technology",
"JThSt Journal of Thermal Stresses",
"JTHT. Journal of Thermophysics and Heat Transfer",
"JThCM Journal of Thermoplastic Composite Materials",
"JTF.. Journal of Time and Frequency",
"JTurb Journal of Turbulence",
"JVST. Journal of Vacuum Science Technology",
"JVSTB Journal of Vacuum Science Technology B: Microelectronics and Nanometer Structures",
"JVC.. Journal of Vibration and Control",
"JVE.. Journal of Vibration Engineering",
"JVCIR Journal of Visual Communication and Image Representation",
"JVGR. Journal of Volcanology and Geothermal Research",
"JWMSE Journal of Women and Minorities in Science and Engineering",
"JXST. Journal of X-Ray Science and Technology",
"RpScT JPRS Report Science Technology USSR Space",
"JSMEB JSME Bulletin",
"JSMEJ JSME International Journal",
"JSMET JSME Transactions",
"KKR.. Kagaku Kogaku Ronbunshu",
"MmKMO Kakioka Magnetic Observatory Memoirs",
"GroR. Kapteyn Astronomical Laboratory Groningen Reports",
"KIzKU Kazan Izdatel Kazanskogo Universiteta",
"MeeRe Kenneth Mees Observatory Reprints",
"KernR Kernforschungsanlage Rept Res Results Solid State Nucl Phys",
"KexT. Kexue Tongbao",
"Khago Khagol",
"KharI Kharkov Izdanie IRE AN USSR",
"KTTM. Khimiia i Tekhnologiia Topliv i Masel",
"KhPl. Khimiia Plazmy",
"KVnT. Kibernetika i Vychislitel naia Tekhnika",
"KiInF Kiev Institut Fiziki AN USSR",
"KiInM Kiev Institut Matematiki AN USSR",
"KIPME Kiev Institut Problem Modelirovaniia Energetike AN USSR",
"KIzIM Kiev Izdanie Instituta Matematiki AN USSR",
"KiIND Kiev Izdatel Naukova Dumka",
"KiIzT Kiev Izdatel Tekhnika",
"KIzVS Kiev Izdatel Vishcha Shkola",
"KiePr Kievskij Ordena Lenina Gosudarstvennyj Universitet Shevchenko Astronomicheskaya Observatoriya - Preprint",
"KPCB. Kinematics and Physics of Celestial Bodies",
"KPCBS Kinematics and Physics of Celestial Bodies, Supplement",
"KFNT. Kinematika i Fizika Nebesnykh Tel",
"KFNTS Kinematika i Fizika Nebesnykh Tel Supplement",
"KiCat Kinetics and Catalysis",
"KIzS. Kishinev Izdatel Shtiintsa",
"KVeBB Kleine Veroeffentlichungen der Universitaetssternwarte zu Berlin Babelsberg",
"KlBer Kleinheubacher Berichte",
"KodOB Kodaikanal Observatory Bulletins",
"KodRe Kodaikanal Observatory Reprints",
"KomMe Komety i Meteory",
"KNAB. Koninklijke Nederlandse Akademie van Weteschappen Proceedings Series B Physical Sciences",
"KIMMJ Korean Institute of Metals and Materials Journal",
"KNT.. Kosmicheskaia Nauka i Tekhnika",
"KosIs Kosmicheskie Issledovaniia",
"KosIU Kosmicheskie Issledovaniia Ukraine",
"KosLu Kosmicheskie Luchi",
"KosNT Kosmichna Nauka i Tekhnologiya",
"Kozmo Kozmos",
"KT... K-Theory",
"KSVH. Kungl. Svenska Vetenskapsakademiens Handlingar",
"KvanE Kvantovaia Elektronika Moscow",
"Kyb.. Kybernetes",
"KyoMe Kyoto University Faculty Engineering Memoirs",
"KyITB Kyushu Institute Technology Bulletin",
"KUFEM Kyushu University Faculty Engineering Memoirs",
"KyUAM Kyushu University Research Institute Applied Mechanics Reports",
"KyUSR Kyushu University Research Institute Industrial Science Reports",
"KyUTR Kyushu University Technology Reports",
"LChip Lab on a Chip",
"AerAs L'Aeronautique et L'Astronautique",
"AerMS L'Aerotecnica Missili e Spazio",
"LDD.. Land Degradation & Development",
"Langm Langmuir",
"LaJ.. Lapidary Journal",
"LPB.. Laser and Particle Beams",
"LaEO. Laser Elektro Optik",
"LaFoc Laser Focus",
"LasJ. Laser Journal",
"LaPhy Laser Physics",
"Astrf L'Astrofilo Bolletino Trimestral del Gruppo Astrofili Villaggio Sereno Brescia",
"LAstr L'Astronomie",
"LatME Latviiskii Matematicheskii Ezhegodnik",
"LawOB Laws Observatory Bulletin, University of Missouri",
"LBLRR LBL Research Review",
"ASPL. Leaflet of the Astronomical Society of the Pacific",
"ASPLS Leaflet of the Astronomical Society of the Pacific (Supplement)",
"LePub Learned Publishing",
"LERec L'Echo des Recherches",
"LNSP. Lecture Notes and Supplements in Physics",
"LNCS. Lecture Notes in Computer Science",
"LNES. Lecture Notes in Earth Sciences, Berlin Springer Verlag",
"LNEn. Lecture Notes in Engineering, Berlin Springer Verlag",
"LNM.. Lecture Notes in Mathematics, Berlin Springer Verlag",
"LNP.. Lecture Notes in Physics, Berlin Springer Verlag",
"LNPAM Lecture Notes in Pure and Applied Mathematics",
"LeBAN Leningrad Biblioteka Akademii Nauk SSSR",
"LeEne Leningrad Energoizdat",
"LeGid Leningrad Gidrometeoizdat",
"PrAtO Leningrad Gidrometeoizdat Sovremennye Problemy Atmosfernoi Optiki",
"LeIzE Leningrad Izdatel Energiia",
"LeIzG Leningrad Izdatel Gidrometeoizdat",
"LeIzK Leningrad Izdatel Khimiia",
"LeIzU Leningrad Izdatel Leningradskogo Universiteta",
"LeIzM Leningrad Izdatel Mashinostroenie",
"LeIzN Leningrad Izdatel Nauka",
"LIzNe Leningrad Izdatel Nedra",
"LeIzS Leningrad Izdatel Sudostroenie",
"IzLen Leningrad, Izdatel'stvo Nauka",
"LeLen Leningrad Lenizdat",
"LGUPM Leningradskii Gosudarstvennyi Universitet Problemy Matematicheskoi Fiziki",
"VeLen Leningradskii Universitet Vestnik Matematika Mekhanika Astronomiia",
"Leo.. Leonardo",
"LHMT. Letters Heat Mass Transfer",
"LAES. Letters in Applied and Engineering Sciences",
"LMaPh Letters in Mathematical Physics",
"LicOB Lick Observatory Bulletin",
"LFR.. Lietuvos Fizikos Rinkinys",
"LDA.. Lifetime Data Analysis",
"LLabJ Lincoln Laboratory Journal",
"LiCr. Liquid Crystals",
"Litho Lithos",
"LRR.. Living Reviews in Relativity",
"LRSP. Living Reviews in Solar Physics",
"LockH Lockheed Horizons",
"LOEle L'Onde Electrique",
"LTP.. Low Temperature Physics",
"LowOB Lowell Observatory Bulletin",
"LPICo LPI Contributions",
"LubEn Lubrication Engineering",
"LR... Luft und Raumfahrt",
"LuRaQ Luft und Raumfahrt Quarter",
"LCEC. Luxembourg Commission European Communities",
"LIVS. Lvov Izdatel Vishcha Shkola",
"LvoTs L'vovskij Ordena Lenina Gosudarstvennyj Universitet Tsirkulyar",
"MaDes Machine Design",
"MLear Machine Learning",
"MmCP. Macromolecular Chemistry and Physics",
"MadOO Madras Observatory Astronomical Observations",
"MadOb Madras Observatory Observations",
"MagFE Magnetic Fusion Energy",
"MRMPB Magnetic Resonance Materials in Physics Biology and Medicine",
"MagGi Magnitnaia Gidrodinamika",
"MagIs Magnitosfernye Issledovaniia",
"MTACI Magyar Tudomanyos Akademia Csillagvizsgalo Intezetenek koezlemenyei",
"MAWMN Mainz Akademie Wissenschaften Mathematisch Naturwissenschaftliche Klasse",
"Lapa. Majalah LAPAN",
"MWGBI Mannheim West Germany Bibliographisches Institut AG",
"MaTeJ ManTech Journal",
"ManGe Manuscripta Geodaetica",
"MarRQ Marconi Review Quarter",
"MarGe Marine Geodesy",
"MarGR Marine Geophysical Researches",
"MarPG Marine Petroleum Geology",
"Mars. Mars",
"Mashi Mashinostroenie",
"MsT.. Masters Thesis",
"MaFiz Matematicheskaia Fizika",
"MFiNM Matematicheskaia Fizika i Nelineinaia Mekhanika",
"MatIs Matematicheskie Issledovaniia",
"MMFMP Matematicheskie Metody i Fiziko Mekhanicheskie Polia",
"MISTr Matematicheskii Institut imeni Steklova Trudy",
"MMTET Matematicheskoe Modelirovanie i Teoriia Elektricheskikh Tsepei",
"MatVe Matematichki Vesnik",
"Mater Materialpruefung",
"MMP.. Materials and Manufacturing Processes",
"MCP.. Materials Chemistry and Physics",
"MatEv Materials Evaluation",
"MatL. Materials Letters",
"MaRBu Materials Research Bulletin",
"MSEng Materials Science and Engineering",
"MSEnR Materials Science and Engineering R Reports",
"MSTec Materials Science and Technology",
"MSF.. Materials Science Forum",
"MatST Materials Science Technology",
"MatTr Materials Transactions JIM",
"MatTe Materiaux et Techniques",
"MComM Mathematical and Computer Modelling",
"MEI.. Mathematical Engineering Industry",
"MaFi. Mathematical Finance",
"MatG. Mathematical Geology",
"MMAS. Mathematical Methods in the Applied Sciences",
"MatM. Mathematical Modelling",
"MMNA. Mathematical Modelling Numerical Analysis",
"M3AS. Mathematical Models and Methods in Applied Sciences",
"MPAG. Mathematical Physics, Analysis and Geometry",
"MPAM. Mathematical Physics and Applied Mathematics",
"MaPhS Mathematical Physics Studies",
"MaPr. Mathematical Proceedings",
"MPCPS Mathematical Proceedings of the Cambridge Philosophical Society",
"MatRv Mathematical Reviews",
"MMS.. Mathematics and Mechanics of Solids",
"MaCom Mathematics of Computation",
"Mat.. Mathematika",
"MitAe Max Planck Institut Aeronomie Mitteilungen",
"MeScT Measurement Science and Technology",
"Meas. Measurements",
"Mecc. Meccanica",
"MecEn Mechanical Engineering",
"MSSP. Mechanical Systems and Signal Processing",
"MPDS. Mechanics and Physics of Discrete Systems",
"MCMS. Mechanics of Composite Materials & Structures",
"MSM.. Mechanics of Structures and Machines",
"MTDM. Mechanics of Time-Dependent Materials",
"MeReC Mechanics Research Communications",
"MeTeS Mechanika Teoretyczna i Stosowana",
"MeMaT Mechanism and Machine Theory",
"MeUpp Meddelanden fran Astronomiska Observatorium Uppsala",
"MeLu1 Meddelanden fran Lunds Astronomiska Observatorium Serie I",
"MeLu2 Meddelanden fran Lunds Astronomiska Observatorium Serie II",
"MeAar Meddelser fra Ole Romer Observatoriet Aarhus",
"MeGen Mededelingen Universiteit te Gent Sterrenkundig Instituut",
"MeLeu Mededelingen van het Astronomisch Instituut van de Katholieke Universiteit Leuven",
"MedPh Medical Physics",
"MekGS Mekhanika Giroskopicheskikh Sistem",
"MekKM Mekhanika Kompozitnykh Materialov",
"MekP. Mekhanika Polimerov",
"MekTT Mekhanika Tverdogo Tela",
"MelAR Melbourne Observatory Annual Report",
"MelOO Melbourne Observatory Observations",
"MmEbr Memoires de l'Observatoire de l'Ebre",
"MmARB Memoires of the Academie Royale de Belgique",
"MmMtS Memoires of the Mount Stromlo Observervatory",
"MSRSL Memoires of the Societe Royale des Sciences de Liege",
"MeSRM Memoires Scientifiques de la Revue de Metallurgie",
"MmKyo Memoirs Faculty of Sciences University of Kyoto",
"MmASI Memoirs of the Astronomical Society of India",
"MmBAA Memoirs of the British Astronomical Association",
"MmRAS Memoirs of the Royal Astronomical Society",
"MmNap Memorie del R. Osservatorio di Capodimonte in Napoli",
"MmSAI Memorie della Societa Astronomica Italiana",
"MSAIS Memorie della Societa Astronomica Italiana Supplement",
"MmSSI Memorie della Societa Degli Spettroscopisti Italiani",
"MmSS. Memorie della Societa Degli Spettroscopisti Italiani, serie 2",
"MeCom Mendeleev Communications",
"Mercu Mercury",
"MeAut Meres es Automatika",
"Msngr The Messenger",
"MeRAu Mesures Regulation Automatisme",
"Metal Metallofizika",
"MTObM Metallovedenie i Termicheskaia Obrabotka Metallov",
"MMTA. Metallurgical and Materials Transactions A",
"MMTB. Metallurgical and Materials Transactions B",
"MT... Metallurgical Transactions",
"MTA.. Metallurgical Transactions A",
"MTB.. Metallurgical Transactions B",
"MTPMM Metallurgical Transactions Physical Metallurgy Materials Science",
"MetaM Metamaterials",
"MTRMA Meteor Forschungsergebnisse Reihe B Meteorologie und Aeronomie",
"Met.. Meteorite - The International Quarterly of Meteorites and Meteorite Science",
"Metit Meteorites",
"Metic Meteoritics",
"M&PS. Meteoritics and Planetary Science",
"Metik Meteoritika",
"MetRR Meteornoe Rasprostranenie Radiovoln",
"MetIs Meteornye Issledovaniia",
"MeApp Meteorological Applications",
"MetMa Meteorological Magazine",
"MetMo Meteorological Monographs",
"MSCTN Meteorological Satellite Center Technical Note",
"MeSJJ Meteorological Society of Japan Journal",
"MetZp Meteorologicke Zpravy",
"Meteo La Meteorologie",
"MeGid Meteorologiia i Gidrologiia",
"MetRu Meteorologische Rundschau",
"MetZe Meteorologische Zeitschrift",
"MAP.. Meteorology and Atmospheric Physics",
"MetAP Meteorology Atmospheric Physics",
"MetHy Meteorology Hydrology JPRS",
"MVMP. Methoden und Verfahren der Mathematischen Physik",
"MCME. Methods: A Companion to Methods in Enzymology",
"MComP Methods in Computational Physics",
"MGG.. Methods in Geochemistry and Geophysics",
"MSB.. Methods in Subnuclear Physics",
"MExP. Methods of Experimental Physics",
"MetVy Metody Vychislenii",
"Metro Metrologia",
"MicEc Microbial Ecology",
"MPFD. Microdevices: Physics and Fabrication Technologies",
"MiEng Microelectronic Engineering",
"MiI.. Microelectronics International",
"MiRe. Microelectronics Reliability",
"MicgQ Microgravity Quarterly",
"MiST. Microgravity Science and Technology",
"MTEng Microscale Thermophysical Engineering",
"MiMic Microscopy and Microanalysis",
"MiOTL Microwave and Optical Technology Letters",
"MiJo. Microwave Journal",
"MicWa Microwaves",
"AcMik Mikrochimica Acta",
"Mikro Mikroelektronika",
"MikSb Mikroelektronika Sbornik",
"MAIMT Milan Associazione Italiana di Meccanica Teorica ed Applicata",
"MSMFR Milano Seminario Matematico e Fisico Rendiconti",
"MiElC Military Electronics Countermeasures",
"MiLa. Mind and Language",
"MWE.. Mine Water and The Environment",
"MinPh Mineral Physics",
"MinDe Mineralium Deposita",
"MinM. Mineralogical Magazine",
"MinPe Mineralogy and Petrology",
"MPBu. Minor Planet Bulletin",
"MPC.. Minor Planet Circulars",
"MPEC. Minor Planet Electronic Circulars",
"IzMin Minsk Izdatel BGU",
"MiINT Minsk Izdatel Nauka i Tekhnika",
"MisSp Missiles Spacecraft",
"MAPSE Mission Analysis Program Solar Electric Propulsion MAPSEP",
"MHITR Mitsubishi Heavy Industries Technical Review",
"MitAG Mitteilungen der Astronomischen Gesellschaft Hamburg",
"MiBon Mitteilungen der Astronomischen Institute der Universitaet Bonn",
"MiBas Mitteilungen der Astronomisch-Meteorologischen Anstalt der Universitaet Basel Astronomische Reihe",
"MiHar Mitteilungen der Bruno-H.-Buergel-Sternwarte Hartha DDR",
"MiHam Mitteilungen der Hamburger Sternwarte in Bergedorf",
"MiKon Mitteilungen der Konkoly Sternwarte Budapest-Szabadsaghegy",
"MiPul Mitteilungen der Nikolai-Hauptsternwarte zu Pulkowo",
"MiBud Mitteilungen der Sternwarte der Ungarischen Akademie der Wissenschaften Budapest",
"MiInn Mitteilungen der Sternwarte Innsbruck",
"MiMun Mitteilungen der Sternwarte Munchen",
"MiSon Mitteilungen der Sternwarte zu Sonneberg",
"MiGra Mitteilungen der Universitaets-Sternwarte Graz",
"MiWie Mitteilungen der Universitaets-Sternwarte Wien",
"MiJen Mitteilungen der Universitaets-Sternwarte zu Jena",
"MiTue Mitteilungen des Astronomischen Instituts der Universitaet Tuebingen",
"MiMue Mitteilungen des Astronomischen Instituts des Universitaet Munster",
"MiPot Mitteilungen des Astrophysikalischen Observatoriums Potsdam",
"MSMSE Modelling Simul. Mater. Sci. Eng.",
"MAG.. Modern Approaches in Geophysics",
"ModGe Modern Geology",
"MIMPE Modern Instrumentation and Measurements in Physics and Engineering",
"MPLA. Modern Physics Letters A",
"MPLB. Modern Physics Letters B",
"MJPS. Moldavian Journal of the Physical Sciences",
"MBB.. Molecular Biology and Biophysics",
"MBBB. Molecular Biology Biochemistry and Biophysics",
"MCLC. Molecular Crystals and Liquid Crystals",
"MGM.. Molecular Genetics and Metabolism",
"MolPh Molecular Physics",
"MoPhR Molecular Physics Reports",
"MoSim Molecular Simulation",
"MNSSA Monthly Notes of the Astronomical Society of South Africa",
"MNSSJ Monthly notes of the Astronomical Society of South Africa",
"MNRAS Monthly Notices of the Royal Astronomical Society",
"MWRv. Monthly Weather Review",
"Moon. Moon",
"M&P.. Moon and Planets",
"MorGI Morskie Gidrofizicheskie Issledovaniia",
"MAtom Moscow Atomizdat",
"MoEBA Moscow Energoatomizdat Biblioteka Automatike",
"MEner Moscow Energoizdat",
"MoGid Moscow Gidrometeoizdat",
"MoIKI Moscow Institut Kosmicheskikh Issledovanii AN SSSR",
"MoIPM Moscow Institut Prikladnoi Matematiki AN SSSR",
"MoIzA Moscow Izdatel Atomizdat",
"MoIzE Moscow Izdatel Energiia",
"MIEBA Moscow Izdatel Energiia Biblioteka Avtomatike",
"MIEBR Moscow Izdatel Energiia Biblioteka Radioelektronike",
"MoIzK Moscow Izdatel Khimiia",
"MIzLI Moscow Izdatel Legkaia Industriia",
"MIzMa Moscow Izdatel Mashinostroenie",
"MIzMe Moscow Izdatel Metallurgiia",
"MoIzM Moscow Izdatel Moskovskogo Universiteta",
"MIzMU Moscow Izdatel Moskovskogo Universiteta Pt",
"MoIzN Moscow Izdatel Nauka",
"MINFI Moscow Izdatel Nauka AN SSR Fizicheskii Institut Trudy",
"MINCV Moscow Izdatel Nauka AN SSSR Chteniia imeni Vernadskogo",
"MoINA Moscow Izdatel Nauka AN SSSR Fizicheskii Institut Trudy",
"MINGI Moscow Izdatel Nauka AN SSSR Geologicheskoi Institut Trudy",
"MINMI Moscow Izdatel Nauka AN SSSR Matematicheskii Institut Trudy",
"MoINI Moscow Izdatel Nauka Issledovaniia Geomagnetizmu Aeronomii i Fizike Solntsa",
"MINTF Moscow Izdatel Nauka Teoreticheskaia Fizika",
"MINVS Moscow Izdatel Nauka Vychislitel naia Seismologiia",
"MIzNe Moscow Izdatel Nedra",
"MIzRS Moscow Izdatel Radio Sviaz",
"MIzSR Moscow Izdatel Sovetskoe Radio",
"MISRI Moscow Izdatel Sovetskoe Radio Ionosfernye Issledovaniia",
"MoIzS Moscow Izdatel Sviaz",
"MISST Moscow Izdatel Sviaz Statisticheskaia Teoriia sviazi",
"MoIzT Moscow Izdatel Transport",
"MoIzV Moscow Izdatel VINITI",
"MIzVS Moscow Izdatel Vysshaia Shkola",
"MoIzZ Moscow Izdatel Znanie",
"MIZNZ Moscow Izdatel Znanie Novoe Zhizni Nauke Tekhnike Seriia Fizika",
"MosIZ Moscow IZMIRAN",
"MoMTN Moscow Mezhdunarodnyi Tsentr Nauchnoi i Tekhnicheskoi Informatsii",
"MoMGK Moscow Mezhduvedomstvennyi Geofizicheskii Komitet",
"MoVIN Moscow VINITI",
"MosVo Moscow Voenizdat",
"MosVI Moscow Voennoe Izdatel",
"MoVNT Moscow Vychislitel nyi Tsentr AN SSSR",
"MoVyS Moscow Vysshaia Shkola",
"MoLLP Moshchnye lazery i lazernaia plazma",
"MoEIT Moskovskii Energeticheskii Institut Trudy",
"MGUMN Moskovskii Gosudarstvennyi Universitet Institut Mekhaniki Nauchnye Trudy",
"MGIMO Moskovskii Gosudarstvennyi Universitet Institut Mekhaniki Otchet",
"MVSFA Moskovskii Universitet Vestnik Seriia Fizika Astronomiia",
"MUVSK Moskovskii Universitet Vestnik Seriia Khimiia",
"MVSMM Moskovskii Universitet Vestnik Seriia Matematika Mekhanika",
"MGTVM Moskovskij Gosudarstvennyj Tekhnicheskij Universitet Vestnik Seriya Mashinostroenie",
"MGTVP Moskovskij Gosudarstvennyj Tekhnicheskij Universitet Vestnik Seriya Priborostroenie",
"MotZe Motortechnische Zeitschrift",
"MtSOM Mount Stromlo Observatory Mimeographs",
"MtSRe Mount Stromlo Observatory Reprints",
"MtWAR Mount Wilson and Palomar Observatory Annual Report",
"MtWRe Mount Wilson and Palomar Observatory Reprints",
"MWOAR Mount Wilson Observatory Annual Report",
"MRSBu MRS Bulletin",
"MUSS. Muenchen Universitaets Schriften Serie",
"MROVG Munich R Oldenbourg Verlag GmbH",
"NISZ. Nabliudeniia Iskusstvennykh Sputnikov Zemli",
"NOGB. Nachr. Olbers-Ges. Bremen",
"NacEl Nachrichten Elektronik",
"NAZ.. Nachrichtenblatt der Astronomischen Zentralstelle Heidelberg",
"NVS.. Nachrichtenblatt der Vereinigung der Sternfreunde",
"NGFAW Nachrichtentechnische Gesellschaft Fachtagung ueber Antennen",
"NacZe Nachrichtentechnische Zeitschrift",
"NUFEM Nagoya University Faculty Engineering Memoirs",
"NUSEM Nagoya University School Engineering Memoirs",
"NaAIJ Nanjing Aeronautical Institute Journal",
"NUAAJ Nanjing University Aeronautics and Astronautics Journal",
"NRL.. Nanoscale Research Letters",
"Nanot Nanotechnology",
"NIUNA Napoli Istituto Universitario Navale Annali",
"NASCL NASA Circular Letter",
"NASCP NASA Conference Publication",
"NASRP NASA Reference Publication",
"NASSP NASA Special Publication",
"STIA. NASA STI/Recon Technical Report A",
"STIN. NASA STI/Recon Technical Report N",
"NBSSP National Bureau of Standards Special Publication",
"NBSTN National Bureau of Standards Technical Note",
"NaGe. National Geographic",
"NISTJ National Institute of Standards and Technology Journal of Research",
"PolRe National Institute Polar Research Memoirs",
"BAth. National Observatory of Athens Greece Bulletin of the Astronomical Institute",
"NRAOR National Radio Astronomy Observatory Reprints",
"NUDTJ National University Defense Technology Journal",
"NHESS Natural Hazards and Earth System Sciences",
"NatH. Natural History",
"Natur Nature",
"NatMa Nature Materials",
"NatNa Nature Nanotechnology",
"NaPho Nature Photonics",
"NPhS. Nature Physical Science",
"NatPh Nature Physics",
"NW... Naturwissenschaften",
"NInfo Nauchnye Informatsii",
"NRRv. Naval Research Reviews",
"Navig Navigation",
"NavAu Navigation Australia",
"NavPa Navigation Paris",
"NVVSR Nederlandse Vereiniging voor Weer en Sterrenkunde Werkgroep veranderlijke Sterren Reports",
"NCNS. Network: Computation in Neural Systems",
"NSpEc Networks and Spatial Economics",
"AnBog Neue Annalen der Koeniglichen Sternwarte in Bogenhausen bei Muenchen",
"NJMM. Neues Jahrbuch Mineralogie Monatshefte",
"NeCom Neural Computation",
"NN... Neural Networks",
"NeuL. Neuroscience Letters",
"Neuro The Neuroscientist",
"NPNDS Neutron Physics and Nuclear Data in Science and Technology",
"NewA. New Astronomy",
"NewAR New Astronomy Review",
"NJCh. New Journal of Chemistry",
"NJPh. New Journal of Physics",
"NewSc New Scientist",
"NTN.. New Technology News",
"NYASA New York Academy Sciences Annals",
"NZJGG New Zealand Journal Geology and Geophysics",
"NZJS. New Zealand Journal of Science",
"ASNYN News Letter of the Astronomical Society of New York",
"INGN. The Newsletter of the Isaac Newton Group of Telescopes",
"ICHIN Newsletters of the Interdivisional Commission on History of the IAGA",
"NOHIC Nizamiah JAPAL Rangapur Observatories Hyderabad India Contributions",
"NizRe Nizamiah Observatory Reprints",
"NCE.. Noise Control Engineering Journal",
"NDTE. Nondestructive Testing and Evaluation",
"NTCo. Nondestructive Testing Communications",
"NPPSB Nonequilibrium Problems in the Physical Sciences and Biology",
"NATM. Nonlinear Analysis Theory Methods Applications",
"NlOpt Nonlinear Optics",
"NPGeo Nonlinear Processes in Geophysics",
"NSAP. Nonlinear, Statistical and Applied Physics",
"Nonli Nonlinearity",
"NATi. Nordisk Astronomisk Tidsskrift",
"SApMM North Holland Series Applied Mathematics Mechanics",
"NHCWP North Hollywood Calif Western Periodicals Co",
"NPUJ. Northwestern Polytechnical University Journal",
"NoDef Not Defined",
"NRA&A Nouvelle Revue d'Aeronautique et d'Astronautique",
"NROpt Nouvelle Revue d'Optique",
"NROA. Nouvelle Revue d'Optique Appliquee",
"UGC.. Nova Acta Regiae Soc. Sci. Upsaliensis Ser. V",
"NoIGG Novosibirsk Institut Geologii i Geofiziki SO AN SSSR",
"NovIG Novosibirsk Institut Gidrodinamiki SO AN SSSR Dinamika Sploshnoi Sredy",
"NoIzN Novosibirsk Izdatel Nauka",
"NTTRv NTT Review",
"NDS.. Nuclear Data Sheets",
"NuEnD Nuclear Engineering and Design",
"NucFu Nuclear Fusion",
"NucFS Nuclear Fusion Special Supplement",
"NuGeo Nuclear Geophysics",
"NucIM Nuclear Instruments and Methods",
"NIMPA Nuclear Instruments and Methods in Physics Research A",
"NIMPR Nuclear Instruments and Methods in Physics Research",
"NIMPB Nuclear Instruments and Methods in Physics Research B",
"NucPh Nuclear Physics",
"NuPhA Nuclear Physics A",
"NuPhB Nuclear Physics B",
"NuPhS Nuclear Physics B Proceedings Supplements",
"NSE.. Nuclear Science Engineering",
"NucTe Nuclear Technology",
"NucTF Nuclear Technology Fusion",
"NAR.. Nucleic Acids Research",
"NuAlg Numerical Algorithms",
"NFAO. Numerical Functional Analysis and Optimization",
"NumHT Numerical Heat Transfer",
"NHTA. Numerical Heat Transfer Part A - Applications",
"NHTB. Numerical Heat Transfer Part B - Fundamentals",
"NuMat Numerische Mathematik",
"NCimA Nuovo Cimento A Serie",
"NCimB Nuovo Cimento B Serie",
"NCimC Nuovo Cimento C Geophysics Space Physics C",
"NCimD Nuovo Cimento D Serie",
"NCimL Nuovo Cimento Lettere",
"NCimR Nuovo Cimento Rivista Serie",
"NCimS Nuovo Cimento Serie",
"OVS.. Observation of Variable Stars",
"Obser Observation pi",
"OAORP Observations astronomiques faites a l'Observatoire royal de Paris",
"O&T.. Observations et Travaux",
"USNOO Observations made at the U.S. Naval Observatory",
"USNOY Observations made at the U.S. Naval Observatory during the Year",
"OOVRO Observations Owens Valley Radio Observatory",
"Bes1K Observatoire de Besancon",
"OBN1K Observatoire de Besancon - CNES",
"Gen1K Observatoire de Geneve",
"LyoRe Observatoire de Lyon Reprints",
"Meu1K Observatoire de Meudon",
"Nic1K Observatoire de Nice",
"CORB. Observatoire Royal de Belgique Communications Serie B",
"LPlaC Observatorio Astronomico de La Plata Circular",
"LPlaS Observatorio Astronomico de La Plata Separata Astronomica",
"RosOB Observatorio Astronomico Municipal de Rosario Argentia  Boletin",
"RioB. Observatorio Nacional Publicacoes do Servico Astronomico Rio de Janeiro",
"Obs.. The Observatory",
"HelR. Observatory and Astrophysics Laboratory University of Helsinki Report",
"PLPla Observatory Astronomical La Plata Series Astronomies",
"ObVyS Obzory Vysokotemperaturnoi Sverkhprovodimosti",
"ONRAS Occasional Notes of the Royal Astronomical Society",
"ORROE Occasional Reports of the Royal Observatory Edinburgh",
"OcDyn Ocean Dynamics",
"OcEng Ocean Engineering",
"OcMod Ocean Modelling",
"OcPhE Ocean Physics and Engineering",
"OcSci Ocean Science",
"OcSciDOcean Science Discussions",
"OSJaJ Oceanographical Society of Japan Journal",
"AcOC. Oceanologica Acta",
"Ocgy. Oceanology",
"Ocean Oceanus Summer",
"OAP.. Odessa Astronomical Publications",
"BOOde Odesskij Gosudarstvennyi Universitet im. I. I. Mechnikova Byulletin Astronomicheskoj Observatorii",
"IzOde Odesskij Gosudarstvennyi Universitet im. I. I. Mechnikova Izvestiya Astronomicheskoj Observatorii",
"OAWMN Oesterreichische Akademie Wissenschaften Mathematisch naturwissenschaftliche Klasse Sitzungsberichte Abteilung",
"Oikos Oikos",
"Okean Okeanologiia",
"OCzAS Ondrejov Czechoslovakia Czechoslovak Academy Sciences CAS Astronomical Institute Publications",
"ONERA ONERA TP",
"OAJ.. The Open Astronomy Journal",
"OEJV. Open European Journal on Variable Stars",
"OLear Open Learning",
"OSID. Open Systems and Information Dynamics",
"AcOpt Optica Acta",
"OQE.. Optical and Quantum Electronics",
"OptEn Optical Engineering",
"OptFT Optical Fiber Technology",
"OptMa Optical Materials",
"OptPE Optical Physics and Engineering",
"OptQE Optical Quantum Electronics",
"OptRv Optical Review",
"OpSCN Optical Sciences Center Newsletter",
"OSAJI Optical Society of America Journal Optics and Image Science",
"OptPN Optics & Photonics News",
"OptLE Optics and Lasers in Engineering",
"OptSp Optics and Spectroscopy",
"OptCo Optics Communications",
"OExpr Optics Express",
"OptLT Optics Laser Technology",
"OptL. Optics Letters",
"OptN. Optics News",
"Optik Optik",
"OpAt. Optika Atmosfery",
"OpAtO Optika Atmosfery i Okeana",
"OpSp. Optika i Spektroskopiia",
"OpMeP Optiko Mekhanicheskaia Promyshlennost",
"OCAM. Optimal Control Applications and Methods",
"OptEL Optoelectronics Letters",
"OERv. Opto-Electronics Review",
"OpPuT Optoelektronika i Poluprovodnikovaia Tekhnika",
"OrGeo Organic Geochemistry",
"OrLi. Origins of Life",
"OLEB. Origins of Life and Evolution of the Biosphere",
"Orion Orion: Zeitschrift f&uuml",
"IGS.. Orlando FL Academic Press Inc International Geophysics Series",
"OrNav Ortung und Navigation",
"BuENS Osaka Prefecture University Bulletin Series Engineering Natural Sciences",
"OsUTR Osaka University Technology Reports",
"Osir. Osiris",
"NapCo Osservatorio Astronomico di Capodimonte Napoli Contributi Astronomici",
"TerCo Osservatorio Astronomico di Collurania Teramo Contributi",
"TerMm Osservatorio Astronomico di Collurania Teramo Memorie ed Osservazioni",
"TerNC Osservatorio Astronomico di Collurania Teramo Note e Comunicazioni",
"PadCR Osservatorio Astronomico di Padova Comunicazioni e Rassegne",
"RomCo Osservatorio Astronomico di Roma su Monte Mario Contributi Scientifici",
"TriP. Osservatorio Astronomico di Trieste Pubblicazioni",
"TreP. Osservatorio Privato Specola Ariel Treviso Italia Pubblicazione",
"OsCar Osteoarthritis and Cartilage",
"OtObI Otbor i Obrabotka Informatsii",
"OtPI. Otbor i Peredacha Informatsii",
"OISNP Oxford Pergamon Press International Series on Natural Philosophy",
"OISTS Oxford Pergamon Press International Tables Selected Constants",
"OxfOO Oxford University Observatory Observations",
"OxM.. Oxidation of Metals",
"OzSE. Ozone: Science & Engineering",
"Palb. Paleobiology",
"PalOc Paleoceanography",
"PMetR Papers in Meteorological Research",
"PMG.. Papers Meteorology Geophysics",
"ParC. Parallel Computing",
"Paras Parasitology",
"ParAc Particle Accelerators",
"PaReL Pattern Recognition Letters",
"PerMS Perceptual Motor Skills",
"PZ... Peremennye Zvezdy",
"PZP.. Peremennye Zvezdy Prilozhenie",
"PMHu. Periodica Mathematica Hungarica",
"PPEE. Periodica Polytechnica Electrical Engineering",
"PPME. Periodica Polytechnica Mechanical Engineering",
"PPTE. Periodica Polytechnica Transportation Engineering",
"PerCo Perkins Observatory Contributions",
"PTMJ. Phase Transitions: A Multinational Journal",
"PhDT. Ph.D. Thesis",
"PhiJR Philips Journal Research",
"PhiRR Philips Research Reports",
"PhiTR Philips Technical Review",
"PMag. Philosophical Magazine",
"PMagL Philosophical Magazine Letters",
"PMagA Philosophical Magazine, Part A",
"PMagB Philosophical Magazine, Part B",
"RSPT. Philosophical Transactions Series I",
"Phoen Phoenix Mitteilungsblatt fuer Veraenderlichenbeobachter",
"PhInt Photo Interpretation",
"PcPb. Photochemistry and Photobiology",
"Pg... Photogrammetria",
"PgE.. Photogrammetric Engineering",
"PgERS Photogrammetric Engineering and Remote Sensing",
"PhNan Photonics and Nanostructures",
"PhoSp Photonics Spectra",
"PsynR Photosynthesis Research",
"Psyn. Photosynthetica",
"PhyL. Physic Letters",
"Phy.. Physica",
"PhyA. Physica A Statistical Mechanics and its Applications",
"PhyB. Physica B Condensed Matter",
"PhyC. Physica C Superconductivity",
"PhyD. Physica D Nonlinear Phenomena",
"PhyE. Physica E Low-Dimensional Systems and Nanostructures",
"PEFPN Physica Energiae Fortis et Physica Nuclearis",
"PhyNr Physica Norvegica",
"PhyS. Physica Scripta",
"PhySB Physica Scripta B",
"PhST. Physica Scripta Volume T",
"PSSAR Physica Status Solidi Applied Research",
"PSSBR Physica Status Solidi B Basic Research",
"PSSCR Physica Status Solidi C Current Topics",
"PhySS Physica Status Solids",
"PhAco Physical Acoustics",
"PhBio Physical Biology",
"PCESR Physical Chemical and Earth Sciences Research Reports",
"PCCP. Physical Chemistry Chemical Physics (Incorporating Faraday Transactions)",
"PCSE. Physical Chemistry: Science and Engineering",
"PhGeo Physical Geography",
"PPHTS Physical Properties of High Temperature Superconductors",
"PhyR. Physical Research",
"PhRv. Physical Review",
"PhRvA Physical Review A",
"PhRvB Physical Review B",
"PhRvC Physical Review C",
"PhRvD Physical Review D",
"PhRvE Physical Review E",
"PhRvL Physical Review Letters",
"PhRvI Physical Review Series I",
"PhRvS Physical Review Special Topics Accelerators and Beams",
"PRSTP Physical Review Special Topics Physics Education",
"PSD.. Physical Sciences Data",
"PSCEC Physical Sciences Series of the Commission of European Communities",
"PhChH PhysicoChemical Hydrodynamics",
"DokPh Physics - Doklady",
"PCS.. Physics and Chemistry in Space",
"PCE.. Physics and Chemistry of the Earth",
"PCEA. Physics and Chemistry of the Earth A",
"PCEB. Physics and Chemistry of the Earth B",
"PCEC. Physics and Chemistry of the Earth C",
"PCED. Physics and Chemistry of the Earth Delta",
"PhChE Physics and Chemistry of Earth",
"PCL.. Physics and Chemistry of Liquids",
"PCMLD Physics and Chemistry of Materials with Low-Dimensional Structures",
"PCMLA Physics and Chemistry of Materials with Low-Dimensional Structures Series A",
"PCMLB Physics and Chemistry of Materials with Low-Dimensional Structures Series B",
"PCMLC Physics and Chemistry of Materials with Low-Dimensional Structures Series C",
"PCM.. Physics and Chemistry of Minerals",
"PEEI. Physics and Evolution of the Earth's Interior",
"PhApp Physics and its Applications",
"PTPPB Physics and Technology of Particle and Photon Beams",
"PhB.. Physics Bulletin",
"PhyEd Physics Education",
"PhyEs Physics Essays",
"PCHEI Physics in Collision: High-Energy ee/ep/pp Interactions",
"PMB.. Physics in Medicine and Biology",
"PhP.. Physics in Perspective",
"PhTec Physics in Technology",
"PhLF. Physics Laser Fusion",
"PhL.. Physics Letters",
"PhLA. Physics Letters A",
"PhLB. Physics Letters B",
"PhLC. Physics Letters Section C Physics Reports C",
"PhyNY Physics New York",
"PhyN. Physics Notes",
"PEPI. Physics of the Earth and Planetary Interiors",
"PhSS. Physics of the Solid State",
"PAN.. Physics of Atomic Nuclei",
"PAM.. Physics of Atoms and Molecules",
"PhFl. Physics of Fluids",
"PhFlB Physics of Fluids B",
"PhLRv Physics of Life Reviews",
"PLDS. Physics of Low-Dimensional Structures",
"PhMet Physics of Metals",
"PMM.. Physics of Metals and Metallography",
"PPN.. Physics of Particles and Nuclei",
"PPNL. Physics of Particles and Nuclei Letters",
"PhPl. Physics of Plasmas",
"PhQE. Physics of Quantum Electronics",
"PSL.. Physics of Solids and Liquids",
"PTF.. Physics of Thin Films",
"PhR.. Physics Reports",
"PhTea The Physics Teacher",
"PhT.. Physics Today",
"PhyU. Physics Uspekhi",
"PhyW. Physics World",
"PhuZ. Physik in unserer Zeit",
"PCTM. Physikalisch-Chemische Trenn- und Messmethoden",
"PhyG. Physikalische Gesellschaft",
"PhyGZ Physikalische Gesellschaft Z&uuml",
"PhyZ. Physikalische Zeitschrift",
"PhyCP Physiological Chemistry and Physics",
"PhyM. Physiological Measurement",
"PhylS Physiologist Supplement",
"PAZh. Pis ma Astronomicheskii Zhurnal",
"PZETF Pis ma Zhurnal Eksperimental noi i Teoreticheskoi Fiziki",
"PZhTF Pis ma Zhurnal Tekhnischeskoi Fiziki",
"P&SS. Planetary and Space Science",
"PlAst Planetary Astronomy",
"PlR.. Planetary Report",
"PSRD. Planetary Science Research Discoveries",
"PCPhy Plant and Cell Physiology",
"PlJ.. The Plant Journal",
"PFR.. Plasma and Fusion Research",
"PCPP. Plasma Chemistry and Plasma Processing",
"PlPh. Plasma Physics",
"PPCF. Plasma Physics and Controlled Fusion",
"PlPhR Plasma Physics Reports",
"PlST. Plasma Science and Technology",
"PSST. Plasma Sources Science Technology",
"Pl&I. Plasmas and Ions",
"PlPo. Plasmas and Polymers",
"PRFVT Plastiques Renforces Fibres de Verre Textile",
"PMCPA PMC Physics A",
"PMCPB PMC Physics B",
"PMCPC PMC Physics C",
"PMTF. PMTF Zhurnal Prikladnoi Mekhaniki i Tekhnicheskoi Fiziki",
"PnGid Pnevmatika i Gidravlika",
"PolSi Poliarnye Siianiia",
"PSSNN Poliarnye Siianiia i Svechenie Nochnogo Neba",
"PASAM Polish Academy of Science Arch Mech",
"PASAS Polish Academy of Science Artificial Satellites",
"PASIG Polish Academy of Sciences Institute of Geophysics Publications",
"PASTA Polish Academy of Sciences Theory Aggregation Coagulation",
"PCZNN Politechnika Czestochowska Zeszyty Naukowe Nauki Techniczne Mechanika",
"PGZNM Politechnika Gdanska Zeszyty Naukowe Mechanika",
"PSZNM Politechnika Slaska Zeszyty Naukowe Mechanika",
"PolAt Pollution Atmospherique",
"CraR. Polskie Towarzyslwo Milosnikow Astronomii",
"PolTM Poluprovodnikovaia Tekhnika i Mikroelektronika",
"PolPP Poluprovodnikovye Pribory i ikh Primenenie",
"Poly. Polymer",
"PoCom Polymer Composites",
"PolPh Polymer Physics",
"PPTEn Polymer-Plastics Technology and Engineering",
"PomAK Pomiary Automatyka Kontrola",
"PATi. Popular Astronomisk Tidsskrift",
"PA... Popular Astronomy",
"PorMe Poroshkovaia Metallurgiia",
"PoAn. Postepy Astronautyki",
"PoAst Postepy Astronomii Krakow",
"PSci. Pour la Science",
"PDiff Powder Diffraction",
"PUAMA Poznan Uniwersytet im Adama Mickiewicza Seria Akustyka",
"PUAMF Poznan Uniwersytet im Adama Mickiewicza Seria Fizyka",
"PrAst Practical Astronomy",
"NaiRe Pradesh  State Observatory Naini Tal Insia Reprints",
"PraAc Prague Academia",
"Prama Pramana",
"PreR. Precambrian Research",
"Prib. Priborostroenie",
"PriTE Pribory i Tekhnika Eksperimenta",
"PriMM Prikladnaia Matematika i Mekhanika",
"PriMP Prikladnaia Matematika i Programmirovanie",
"PriM. Prikladnaia Mekhanika",
"Prir. Priroda",
"Priv. Private Communication",
"PrEM. Probabilistic Engineering Mechanics",
"PrAiA Problemy Arktiki i Antarktiki",
"PrBio Problemy Bioniki",
"PrDRV Problemy Difraktsii i Rasprostraneniia Voln",
"PrFA. Problemy Fiziki Atmosfery",
"PrFKL Problemy Iadernoi Fiziki i Kosmicheskikh Luchei",
"PrKFi Problemy Kosmicheskoi Fiziki",
"PrMas Problemy Mashinostroeniia",
"PrPro Problemy Prochnosti",
"PrSP. Problemy Sluchainogo Poiska",
"PrTE. Problemy Tekhnicheskoi Elektrodinamiki",
"PrTGE Problemy Teorii Gravitatsii i Elementarnykh Chastits",
"PrTPT Problemy Teploenergetiki i Prikladnoi Teplofiziki",
"PJA.. Proceeding of the Japan Academy",
"PJAA. Proceeding of the Japan Academy, Series A",
"PJAB. Proceeding of the Japan Academy, Series B",
"PBioS Proceedings: Biological Sciences",
"PMPES Proceedings: Mathematical, Physical and Engineering Sciences",
"PAMS. Proceedings of the American Mathematical Society",
"PAPhS Proceedings of the American Philosophical Society",
"PASAu Proceedings of the Astronomical Society of Australia",
"PEMS. Proceedings of the Edinburgh Mathematical Society",
"PINSA Proceedings of the Indian National Science Academy Part A",
"PINSB Proceedings of the Indian National Science Academy Part B",
"PIGP. Proceedings of the Institute of General Physics, Adademy of the Sciences of Russia",
"PIRE. Proceedings of the IRE",
"PNAS. Proceedings of the National Academy of Science",
"PNSBP Proceedings of the National Society of Black Physicists",
"PPS.. Proceedings of the Physical Society",
"PPSA. Proceedings of the Physical Society A",
"PPSB. Proceedings of the Physical Society B",
"PPSL. Proceedings of the Physical Society of London",
"PRIAA Proceedings of the Royal Irish Academy Section A",
"PRNAS Proceedings of the Royal Netherlands Academy of Arts and Sciences",
"PSEBM Proceedings of The Society for Experimental Biology and Medicine",
"PrVP. Proceedings of Vibration Problems",
"PELIS Program: electronic library & information systems",
"PrAeS Progress in Aerospace Sciences",
"PrAA. Progress in Astronautics and Aeronautics",
"PABei Progress in Astronomy",
"PBB.. Progress in Biochemistry and Biophysics",
"PBBC. Progress in Biophysics and Biophysical Chemistry",
"PBMB. Progress in Biophysics and Molecular Biology",
"PrECS Progress in Energy and Combustion Science",
"PLTP. Progress in Low Temperature Physics",
"PrMS. Progress in Materials Science",
"PMatP Progress in Mathematical Physics",
"PMRP. Progress in Medical Radiation Physics",
"PMetP Progress in Metal Physics",
"PNSci Progress in Natural Science",
"PrOce Progress in Oceanography",
"POrCo Progress in Organic Coatings",
"PrPNP Progress in Particle and Nuclear Physics",
"PPcPp Progress in Photochemistry and Photophysics",
"PPGeo Progress in Physical Geography",
"PrPh. Progress in Physics",
"PQE.. Progress in Quantum Electronics",
"PrSS. Progress In Surface Science",
"PTCP. Progress in Theoretical Chemistry and Physics",
"PThPh Progress of Theoretical Physics",
"PThPS Progress of Theoretical Physics Supplement",
"ProTe Promyshlennaia Teplotekhnika",
"PrEx. Propellants and Explosives",
"PrExP Propellants and Explosives Pyrotechnics",
"PUFir Pubblicazioni della R. Universita degli studi di Firenze",
"PSAIL Pubblicazioni della Stazione Astronomica Internazionale di Latitudine",
"POMil Pubblicazioni dell'Osservatorio Astronomico di Milano-Merate",
"POPad Pubblicazioni dell'Osservatorio Astronomico di Padova",
"POPal Pubblicazioni dell'Osservatorio Astronomico di Palermo",
"POTor Pubblicazioni Varie Fuori Serie dell'Osservatorio Astronomico di Torino",
"PKCat Publ. House Czech. Acad. Sci.",
"PUS.. Public Understanding of Science",
"PMad. Publicacion Facultad de Ciencias Madrid",
"POClu Publicatiile Observatorului Astronomical Universitatii din Cluj",
"POPar Publication de l'Observatoire de Paris Notes et Informations",
"POStr Publication de l'Observatoire de Strasbourg",
"PUSK. Publication der Koeniglichen Sternwarte in Kiel",
"PPCAS Publication of the Pomona College Astronomical Society",
"PCARS Publication of COMU Astrophysics Research Center",
"PKAS. Publication of Korean Astronomical Society",
"PSCDS Publication Speciale du Centre de Donnees Stellaires",
"PULei Publicationen der K. Universitoats-Sternwarte zu Leipzig",
"PLAGL Publications de l'Institut d'Astronomie et de Geophysique Louvain",
"POBeo Publications de l'Observatoire Astronomique de Beograd",
"POBor Publications de l'Observatoire de l'Universite de Bordeaux",
"POTou Publications de l'Observatoire de Toulouse",
"PASK. Publications of the Academy of Science Kasakstan Sect. Astrobotanics",
"PAllO Publications of the Allegheny Observatory of the University of Pittsburgh",
"PAICU Publications of the Astronomical Institute of the Charles University",
"PAICz Publications of the Astronomical Institute of the Czechoslovak Academy of Sciences",
"PUAms Publications of the Astronomical Institute of the University of Amsterdam",
"PBrn. Publications of the Astronomical Institute of the University of Borneo",
"POHel Publications of the Astronomical Observatory Helsinki",
"POMin Publications of the Astronomical Observatory University of Minnesota",
"PASP. Publications of the Astronomical Society of the Pacific",
"PASPS Publications of the Astronomical Society of the Pacific Supplement",
"PASA. Publications of the Astronomical Society of Australia",
"PASJ. Publications of the Astronomical Society of Japan",
"PADEU Publications of the Astronomy Deparment of the Eotvos Lorand University",
"PAIB. Publications of the Astronomy Institute of Bonn",
"PAB.. Publications of The Astrophysics Branch Ottawa",
"PBeiO Publications of the Beijing Astronomical Observatory",
"PBosO Publications of the Bosscha Observatory Lembang Indonesia",
"PCinO Publications of the Cincinnati Observatory",
"PCooO Publications of the Cook Observatory",
"PDDO. Publications of the David Dunlap Observatory",
"PDAA. Publications of the Department of Astronomy Austin Texas",
"PDAUC Publications of the Department of Astronomy University of Chile",
"PDAO. Publications of the Dominion Astrophysical Observatory Victoria",
"PDO.. Publications of the Dominion Observatory Ottawa",
"PDreO Publications of the Dresden Observatory",
"PF&CO Publications of the Flower and Cook Astronomical Observatory",
"PFAO. Publications of the Flower Astronomical Observatory",
"PGLO. Publications of the Goethe Link Observatory",
"PGooO Publications of the Goodsell Observatory, Carleton College",
"PIstO Publications of the Istanbul University Observatory",
"PGro. Publications of the Kapteyn Astronomical Laboratory Groningen",
"PKirO Publications of the Kirkwood Observatory of Indiana University",
"PAth. Publications of the Laborotory of Astronomy University of Athens",
"PMcCO Publications of the Leander McCormick Observatory",
"PManO Publications of the Manila Observatory",
"PMunO Publications of the Munich Observatory",
"PNAOJ Publications of the National Astronomical Observatory of Japan",
"POLyo Publications of the Observatoire de Lyon",
"PGenA Publications of the Observatoire Geneve Series A",
"PGenB Publications of the Observatoire Geneve Series B",
"POHP. Publications of the Observatoire Haute-Provence",
"POANC Publications of the Observatorie Astronomie Nacional Cerro Calan",
"POIst Publications of the Observatory Astronomie University Istambul",
"POslO Publications of the Oslo Observatory",
"POVRO Publications of the Owens Valley Observatory",
"PPMtO Publications of the Purple Mountain Observatory",
"PRCO. Publications of the Riverview College Observatory",
"PROE. Publications of the Royal Observatory of Edinburgh",
"PSprO Publications of the Sproul Observatory",
"PSSAI Publications of the Sternberg State Astronomical Institute",
"PTarO Publications of the Tartuskoj Astrofizica Observatory",
"PTasO Publications of the Tashkent Astronomical Observatory",
"PUSNO Publications of the U.S. Naval Observatory Second Series",
"PVVO. Publications of the Van Vleck Observatory",
"PVasO Publications of the Vassar College Observatory",
"PW&SO Publications of the Warner & Swasey Observatory",
"PWasO Publications of the Washburn Observatory",
"PYerO Publications of the Yerkes Observatory",
"PYunO Publications of the Yunnan Observatory",
"POBol Publications of dell'Osservatorio Astronomie de Bologna",
"PLawO Publications of Laws Observatory, University of Missouri",
"PLicO Publications of Lick Observatory",
"POMic Publications of Michigan Observatory",
"PCat. Publications of Osservatorio Astrofisico di Catania",
"PWHHO Publications of West Hendon House Observatory, Sunderland",
"POxf. Publications University of Oxford Department of Astrophysics",
"PAIKH Publikationen des Astrophysikalischen Instituts Koenigstuhl-Heidelberg",
"POPot Publikationen des Astrophysikalischen Observatoriums zu Potsdam",
"PCopO Publikationer og mindre Meddeler fra Kobenhavns Observatorium",
"PGAOI Pulkovo Glavnaia Astronomicheskaia Observatoriia Izvestiia",
"PApCh Pure & Applied Chemistry",
"PApGe Pure and Applied Geophysics",
"PApPh Pure and Applied Physics",
"PApOp Pure Applied Optics",
"QUnJ. Qinghua University Journal",
"QREI. Quality Reliability Engineering International",
"QuEle Quantitative Electronics",
"QuFin Quantitative Finance",
"QuSOp Quantum and Semiclassical Optics",
"QuOpt Quantum Optics",
"QJRAS Quarterly Journal of the Royal Astronomical Society",
"QJRMS Quarterly Journal of the Royal Meteorological Society",
"QJMat The Quarterly Journal of Mathematics",
"QJMAM Quarterly Journal of Mechanics and Applied Mathematics",
"QApMa Quarterly of Applied Mathematics",
"QRBio Quarterly Reviews of Biophysics",
"QuRes Quaternary Research",
"QSRv. Quaternary Science Reviews",
"Quest Quest",
"RadRe Radcliffe Observatory Pretoria South Africa Reprints",
"Rad.. Radiant, Journal of the Dutch Meteor Society",
"REB.. Radiation and Environmental Biophysics",
"RadEf Radiation Effects",
"REDS. Radiation Effects and Defects in Solids",
"RaPC. Radiation Physics and Chemistry",
"RaRe. Radiation Research",
"RaEE. Radio and Electronic Engineer",
"REEP. Radio Engineering and Electronic Physics",
"RaRLJ Radio Research Laboratories Journal",
"RaRLR Radio Research Laboratories Review",
"RaSc. Radio Science",
"RaScB Radio Science Bulletin",
"RaScS Radio Science Supplement",
"Radel Radioelectronika",
"RaF.. Radiofizika",
"RaSol Radioizluchenie Solntsa",
"R&QE. Radiophysics and Quantum Electronics",
"RaT.. Radiotekhnika",
"RaEl. Radiotekhnika i Elektronika",
"RERE. Radiotekhnika i Elektronika Radio Engineering Electronic Physics",
"RatK. Radiotekhnika Kharkov",
"RTRE. Radiotekhnika Tecommunications Radio Engineering Radio Engineering",
"RamJ. The Ramanujan Journal",
"RaPro Raschety Prochnost",
"RF... Raumfahrtforschung",
"RCAEn RCA Engineer",
"RCARv RCA Review",
"RTI.. Real-Time Imaging",
"RDCMP Recent Development in Condensed Matter Physics",
"RRDAP Recent Research Development in Applied Physics",
"RRDBC Recent Research Development in Biophysical Chemistry",
"RRDBB Recent Research Development in Biophysics and Biochemistry",
"RRDCP Recent Research Development in Chemical Physics",
"RRDPC Recent Research Development in Physical Chemistry",
"RRDP. Recent Research Development in Physics",
"RRDPF Recent Research Development in Physics of Fluids",
"RRDSP Recent Research Development in Statistical Physics",
"Rech. La Recherche",
"ReAer La Recherche Aerospatiale",
"ReAeB La Recherche Aerospatiale Bimonthly Bulletin ESA",
"ReSp. La Recherche Spatiale",
"ReAA. Recherches Aeronautiques et Aerospatiales",
"RAOU. Recherches Astronomiques de l'Observatoire d'Utrecht",
"RZh.. Referationyj Zhurnal",
"RJEHM Regional Journal of Energy Heat and Mass Transfer",
"RCD.. Regular and Chaotic Dynamics",
"RSEMS Remote Sensing Electro Magnetic Spectrum",
"RSEnv Remote Sensing of Environment",
"RSQ.. Remote Sensing Quarterly",
"Renor Renormalization",
"RISRJ Report Ionosphere Space Research Japan",
"HarOR Report of the Committee of the Overseers of Harvard College appointed to visit the Observatory",
"RNAOJ Report of the National Astronomical Observatory of Japan",
"YalRY Reports for the year presented by the Board of Managers of the Observatory of Yale University to the President and Fellows",
"ROLun Reports of the Lund Observatory",
"RpMP. Reports on Mathematical Physics",
"RPPh. Reports on Progress in Physics",
"RTAMS Representation Theory of the American Mathematical Society",
"BeiRe Reprints Beijing Astronomical Observatory Academia Sinica",
"ROCi. Republic Observatory Johannesburg Circular",
"ChPAS Republic of China National Science Council Proceedings Applied Sciences",
"RBSEJ Research Based Science Education Journal",
"ReNEv Research in Nondestructive Evaluation",
"RSTEd Research in Science and Technological Education",
"RScEd Research in Science Education",
"RLEMR Research Laboratory Engineering Materials Report",
"RLPME Research Laboratory Precision Machinery Electronics Bulletin",
"RLPhy Research Letters in Physics",
"RMA.. Research Measurement Approach",
"RNOST Research News & Opportunities in Science and Theology",
"RRP.. Research Reports in Physics",
"RTP.. Research Trends in Physics",
"RNAO. Resultados del Observatorio Nacional Argentino",
"ROCor Resultados del Observatorio Nacional Argentino en Cordoba",
"RDR.. Review of Derivatives Research",
"RvES. The Review of Economic Studies",
"RvE&S The Review of Economics and Statistics",
"RvPCJ Review of Physical Chemistry of Japan",
"RvPT. Review of Physics in Technology",
"RScI. Review of Scientific Instruments",
"RvAqS Reviews in Aquatic Sciences",
"RvMaP Reviews in Mathematical Physics",
"RvMA. Reviews in Modern Astronomy",
"RvGeo Reviews of Geophysics",
"RvGSP Reviews of Geophysics and Space Physics",
"RvGeS Reviews of Geophysics Supplement",
"RvMin Reviews of Mineralogy",
"RvMP. Reviews of Modern Physics",
"RvMPS Reviews of Modern Physics Supplement",
"RvOp. Reviews of Optics",
"RvPP. Reviews of Plasma Physics",
"RvA.. Revista Astronomica Organo de la Asociacion Argengina Amigos de la Astronomia Buenos Aires",
"RBrFi Revista Brasileira de Fisica",
"RvCF. Revista Colombiana de Fisica",
"IORP. Revista do observatorio : publicacao mensal do Imperial Observatorio do Rio de Janeiro",
"RMxAA Revista Mexicana de Astronomia y Astrofisica",
"RMxF. Revista Mexicana de Fisica",
"RvMad Revista Real Acad. Ciencias Exact. Fis. Nat. Madrid",
"RTrTe Revista Transporturilor si Telecomunicatiilor",
"AerRv Revue Aerospatiale",
"RvAc. Revue d'Acoustique",
"RvGPG Revue de Geographie Physique et de Geologie Dynamique",
"RvGDG Revue de Geologie Dynamique et de Geographie Physique",
"RvPA. Revue de Physique Appliquee",
"RvPD. Revue du Palais de la Decouverte",
"RvFEQ Revue Francaise de l'Electricite Quarter",
"RFrM. Revue Francaise de Mecanique",
"RFrMQ Revue Francaise de Mecanique Quarter",
"RRMPA Revue Roumaine de Mathematiques Pures et Appliquees",
"RvRP. Revue Roumaine de Physique",
"RvRST Revue Roumaine des Sciences Techniques Serie de Mecanique Appliquee",
"RST.. Revue Scientifique et Technique CECLES CERS",
"RvT.. Revue Technique Thomson CSF",
"RNISZ Rezul taty Nabliudenii Iskusstvennykh Sputnikov Zemli",
"RWTHA Rheinisch Westfaelische Technische Hochschule Aerodynamisches Institut Abhandlungen",
"AcRhe Rheologica Acta",
"RA... Ricerche Astronomiche",
"RIzZi Riga Izdatel Zinatne",
"Rise. Rise hvezd Popularne vedecky astronomicky casopis Praha",
"RRA.. River Research and Applications",
"RIG.. Rivista Italiana di Geofisica",
"RIGSA Rivista Italiana di Geofisica e Scienze Affini",
"RvTS. Rivista Tecnica Selenia",
"Robot Robotica",
"RMRE. Rock Mechanics and Rock Engineering",
"RMFMR Rock Mechanics Felsmechanik Mecanique des Roches",
"Roczn Rocznik Astronomiczny Observatorjum Krakowskiego Krakow",
"RoAJ. Romanian Astronomical Journal",
"RoIE. Rossiiskaia Akademiia Nauk Izvestiia Energetika",
"RoIMZ Rossiiskaia Akademiia Nauk Izvestiia Mekhanika Zhidkosti i Gaza",
"RoISF Rossiiskaia Akademiia Nauk Izvestiia Seriia Fizicheskaia",
"RoDok Rossijskaya Akademiya Nauk Doklady",
"RoIMT Rossijskaya Akademiya Nauk Izvestiya Mekhanika Tverdogo Tela",
"IzRos Rossijskaya Akademiya Nauk Izvestiya Seriya Fizicheskaya",
"RWPWZ Rostock Wilhelm Pieck Universitaet Wissenschaftliche Zeitschrift Mathematisch Naturwissenschaftliche Reihe",
"PVSS. Royal Astronomical Society of New Zealand Publications of Variable Star Section",
"VSSCi Royal Astronomical Society of New Zealand Variable Star Section Circulars",
"VSSRe Royal Astronomical Society of New Zealand Variable Star Section Reprints",
"VSSSC Royal Astronomical Society of New Zealand Variable Star Section Special Circulars",
"RGOB. Royal Greenwich Observatory Bulletin",
"RGOO. Royal Greenwich Observatory Observations",
"ROAn. Royal Observatory Annals",
"CapMi Royal Observatory Cape Mimeogram",
"CoRSE Royal Society Edinburgh Communications Physical Sciences",
"RSEPS Royal Society of Edinburgh Proceedings Section",
"RSN&R Royal Society of London Notes & Records",
"RSPTA Royal Society of London Philosophical Transactions Series A",
"RSPTB Royal Society of London Philosophical Transactions Series B",
"RSPSA Royal Society of London Proceedings Series A",
"RSPSB Royal Society of London Proceedings Series B",
"RSPS. Royal Society of London Proceedings Series I",
"RoIn. Rozprawy Inzynierskie",
"RoIET Rozprawy Inzynierskie Engineering Transactions",
"Ruimt Ruimtevaart",
"RJET. Russian Journal of Engineering Thermophysics",
"RJMP. Russian Journal of Mathematical Physics",
"RJPC. Russian Journal Physical Chemistry",
"RJPCA Russian Journal Physical Chemistry A",
"RJTAM Russian Journal Theoretical and Applied Mechanics",
"RuMaS Russian Mathematical Surveys",
"RuMet Russian Metallurgy",
"RuPhJ Russian Physics Journal",
"Sadha Sadhana",
"STVF. Samoletostroenie Tekhnika Vozdushnogo Flota",
"SAMPJ SAMPE Journal",
"SAMPQ SAMPE Quarterly",
"UISTS San Diego CA Univelt Inc Science Technology Series",
"MaMeA Sankt Peterburgskii Universitet Vestnik Seriia Matematika Mekhanika Astronomiia",
"SAOSR SAO Special Report",
"SatCo Satellite Communications",
"SBARM SBARMO Bulletin",
"SJCLI The Scandinavian Journal of Clinical and Laboratory Investigation",
"SJMet Scandinavian Journal of Metallurgy",
"SUVSR Scandinavian Union of Amateur Astronomers Variable Star Section",
"SNG.. Schweizerische Naturforschende Gesellschaft",
"SRToh Sci. Rep. Tohoku Univ. Eighth Ser.",
"Sci.. Science",
"Sc&Ed Science & Education",
"SCSA. Science and Culture Series: Astrophysics",
"SCSP. Science and Culture Series: Physics",
"SECM. Science and Engineering of Composite Materials",
"STAdM Science and Technology of Advanced Materials",
"SCSMP Science China Series Mathematics Physics Astronomy Technological Sciences",
"SciDi Science Dimension",
"SciEd Science Education",
"ScChA Science in China A: Mathematics",
"ScChB Science in China B: Chemistry",
"ScChC Science in China C: Life Sciences",
"ScChD Science in China D: Earth Sciences",
"ScChE Science in China E: Technological Sciences",
"ScChF Science in China F: Information Sciences",
"ScChG Science in China G: Physics and Astronomy",
"SISN. Science Information Systems Newsletter",
"SciN. Science News",
"ScTEn Science of the Total Environment",
"ScPr. Science Progress",
"Scis. Sciences",
"Sc&Te Sciences et Techniques",
"SciB. Scientia (Bologna)",
"SciSn Scientia Sinica",
"SSSMP Scientia Sinica Series Mathematical Physical Technical Sciences",
"SciAm Scientific American",
"SMS.. Scientific Modeling and Simulation SMNS",
"Scim. Scientometrics",
"SFSN. Scripta Faculty Science Nat. Ujep Brunensis Physica",
"ScM.. Scripta Metallurgica",
"ScMM. Scripta Metallurgica et Materialia",
"SedG. Sedimentary Geology",
"Sedim Sedimentology",
"BSSA. Seismological Society America Bulletin",
"SEGeo Seismology and Exploration Geophysics",
"STSSP Selected Topics in Solid State Physics",
"SeScT Semiconductor Science Technology",
"SeSTS Semiconductor Science Technology Supplement",
"Semic Semiconductors",
"TrKra Seminar Kraevym Zadacham Trudy",
"SDia. Seminars in Dialysis",
"GEOCS Semi-Regular Variables",
"SenAR Sendai Astronomiaj Raportoj",
"SenIm Sensing and Imaging",
"SPTS. Sensor Physics and Technology Series",
"SeRv. Sensor Review",
"SeAc. Sensors and Actuators",
"SeAcA Sensors and Actuators A Physical",
"SeAcB Sensors and Actuators B Chemical",
"SAERI Seoul Korea Atomic Energy Research Institute",
"SanS. Separata Universidad de Chile Departamento de Astronomia Santiago",
"SS&T. Separation Science and Technology",
"SerAJ Serbian Astronomical Journal",
"AnShO Shanghai Observatory Annals",
"SV... Shock and Vibration",
"SVD.. Shock Vibration Digest",
"SVICB Shock Vibration Information Center Shock Vibration Bulletin",
"SVICP Shock Vibration Information Center Shock Vibration Computer Programs",
"SVICD Shock Vibration Information Center Shock Vibration Digest",
"SVICI Shock Vibration Information Center Shock Vibration Inform Digest",
"ShWav Shock Waves",
"SJAM. SIAM Journal of Applied Mathematics",
"SJCO. SIAM Journal of Control Optimization",
"SJMA. SIAM Journal of Mathematical Analysis",
"SJNA. SIAM Journal of Numerical Analysis",
"SIAMR SIAM Review",
"SiMaJ Siberian Mathematical Journal",
"SiFTZ Sibirskii Fiziko Tekhnicheskii Zhurnal",
"SIDPQ SID Proceedings Quarter",
"SiFoE Siemens Forschungs und Entwicklungsberichte",
"Sig.. Signal",
"SigPr Signal Processing",
"Simul Simulation",
"SiMol Single Molecules",
"SZPA. SIRIUS. Zeitschrift fuer Populaere Astronomie",
"Situ. Situ",
"SkInq Skeptical Inquirer",
"SRT.. Skin Research and Technology",
"S&T.. Sky and Telescope",
"SkyN. Sky News",
"SlaOb Slaboproudy Obzor",
"SBE.. Small Business Economics",
"SMaS. Smart Material Structures",
"Smith Smithsonian",
"SmCES Smithsonian Contributions to the Earth Sciences",
"SCoA. Smithsonian Contributions to Astrophysics",
"SSS.. Social Studies of Science",
"MSAIQ Societa Astronomica Italiana Memorie Quarter",
"SFPTB Societe Francaise de Photogrammetrie et de Teledetection Bulletin",
"SASS. Society for Astronomical Sciences Annual Symposium",
"SEEJ. Society of Environmental Engineers Journal",
"SIAM. Society of Industrial and Applied Mathematics",
"SIBAN Sofia Izdatel Bolgarskoi Akademii Nauk",
"SSSAJ Soil Science Society of America Journal",
"SoCe. Solar Cells",
"SoEn. Solar Energy",
"SoEnM Solar Energy Materials",
"SoPh. Solar Physics",
"SoSyR Solar System Research",
"STERJ Solar Terrestrial and Environmental Research Japan",
"SMArc Solid Mechanics Archives",
"SSCom Solid State Communications",
"SSEle Solid State Electronics",
"SSIon Solid State Ionics",
"SSNMR Solid State Nuclear Magnetic Resonance",
"SSPAR Solid State Physics Advances in Research and Applications",
"SSPAS Solid State Physics Advances in Research and Applications Supplement",
"SSTec Solid State Technology",
"BSolD Solnechnye Dann. Bull. Akad. Nauk SSSR",
"SoKie Sonderdrucke der Sternwarte Kiel",
"SoMue Sonderdrucke Universitaet Muenster Astronomisches Institut",
"SoShe Soobshchenie Shemakhinskoj Astrofizicheskoj Observatorii",
"SoByu Soobshcheniya Byurakanskoj Observatorii Akademiya Nauk Armyanskoj SSR Erevan",
"SoSht Soobshcheniya Gosudarstvennogo Astronomicheskogo Instituta",
"SoSAO Soobshcheniya Spetsial'noj Astrofizicheskoj Observatorii",
"SMTS. Soprotivlenie Materialov i Teoriia Sooruzhenii",
"SSHMP Sources and Studies in the History of Mathematics and Physical Sciences",
"SHMPS Sources in the History of Mathematics and Physical Sciences",
"SAAOC South African Astronomical Observatory Circular",
"SAAOR South African Astronomical Observatory Republic",
"SAJPh South African Journal of Physics",
"SAJSc South African Journal of Science",
"SouSt Southern Stars",
"IBSAE Sovetskaia Antarkticheskaia Ekspeditsiia Informatsionnyi Biulleten",
"SovAe Soviet Aeronomii",
"SvA.. Soviet Astronomy",
"SvAL. Soviet Astronomy Letters",
"JETP. Soviet Journal of Experimental and Theoretical Physics",
"JETPL Soviet Journal of Experimental and Theoretical Physics Letters",
"SvJNP Soviet Journal of Nuclear Physics",
"SvJPP Soviet Journal of Plasma Physics",
"SvJQE Soviet Journal of Quantum Electronics",
"SvPAC Soviet Physics Acoustics",
"SvPhA Soviet Physics Astronomy",
"SvPC. Soviet Physics Crystallography",
"SPhD. Soviet Physics Doklady",
"SvPhJ Soviet Physics Journal",
"SvPS. Soviet Physics Semiconductors",
"SvPSS Soviet Physics Solid State",
"SPTP. Soviet Physics Technical Physics",
"SvPhU Soviet Physics Uspekhi",
"SvRP. Soviet Radiophysics",
"SSRvA Soviet Scientific Reviews A Physics Reviews",
"SSRvC Soviet Scientific Reviews C Mathematical Physics Reviews",
"SSRvD Soviet Scientific Reviews D Physicochemical Biology Reviews",
"SSRvE Soviet Scientific Reviews E Astrophysics and Space Physics Reviews",
"SvTRv Soviet Technology Reviews",
"Space Space",
"SSPRv Space and Solar Power Review",
"SpCoB Space Communication Broadcasting",
"SpCom Space Communications",
"SpEd. Space Education",
"SLSci Space Life Sciences",
"SpMar Space Markets",
"SpMME Space Medicine Medical Engineering",
"SpPol Space Policy",
"SpPow Space Power",
"SPRMD Space Power Resources and Manufacturing Development",
"SpRBu Space Research Bulgaria",
"SSI.. Space Science Instrumentation",
"SSRv. Space Science Reviews",
"SpT.. Space Technology",
"STICA Space Technology Industrial and Commercial Applications",
"SpWea Space Weather",
"SpWd. Space World",
"SpWdU Space World U",
"SpWdW Space World W",
"SpWdY Space World Y",
"SpFl. Spaceflight",
"Spvw. Spaceview",
"VatAR Specola Astronomica Vaticana Annual Reports",
"AtlSV Specola Astronomica Vaticana Atlas Stellarum Variabilium",
"VatCo Specola Astronomica Vaticana Comunicazione",
"VatMA Specola Astronomica Vaticana Miscellanea Astronomica",
"VatRS Specola Astronomica Vaticana Ricerche Spettroscopiche",
"VatRA Specola Astronomica Vaticana Richerche Astronomiche",
"AcSpe Spectrochimica Acta",
"SpecL Spectroscopy Letters",
"SRMO. Specula Regia Monachiensi Observationes astronomicae",
"SScT. Speculations in Science and Technology",
"Spika Spika",
"SpEng Sports Engineering",
"STMP. Springer Tracts in Modern Physics",
"SSCP. Springer Verlag Springer Series on Chemical Physics",
"SSEp. Springer Verlag Springer Series on Electrophysics",
"SSGSR Springer Verlag Springer Series on Group Geophysics Space Research",
"SSOS. Springer Verlag Springer Series on Optical Sciences",
"SVPCS Springer Verlag Springer Series on Physics Chemistry Space",
"SSSSS Springer Verlag Springer Series on Solid State Sciences",
"SSSyn Springer Verlag Springer Series on Synergetics",
"SSWP. Springer Verlag Springer Series on Wave Phenomena",
"SprRe Sproul Observatory Reprints",
"SANUG Srpska Akademiia Nauka i Umetnosti Glas Odeljenje Tekhnichkikh Nauka",
"StSky Star Sky",
"StarD StarDate Magazine",
"StMet Statistical Methodology",
"StCom Statistics and Computing",
"StReL Staub Reinhaltung Luft",
"SMSPS Stephan Mueller Special Publication Series",
"Stern Die Sterne",
"S&W.. Sterne und Weltraum",
"Sterz Sternzeit Mitteilungen der Astrnomischen Vereinigungen Aachen",
"IEWS. Stevenage Herts England Peter Peregrinus Ltd IEE Electromagnetic Waves Series",
"SteRe Steward Observatory Reprints",
"SAA.. Stochastic Analysis and Applications",
"SHH.. Stochastic Hydrology and Hydraulics",
"SSRp. Stochastics and Stochastics Reports",
"StoAn Stockholms Observatoriums Annaler",
"StoMe Stockholms Observatoriums Meddelande",
"StoOR Stockholms Observatoriums Reports",
"Strab Strabismus",
"Strai Strain",
"SGC.. Stratigraphy and Geological Correlation",
"Stroj Strojarstvo",
"StrOp Structural Optimization",
"SASn. Studia Astronomica Sinica",
"StBio Studia Biophysica",
"StGG. Studia Geophysica et Geodaetica",
"SSTor Studia Societatis Scientiarum Torunensis Sectio F Astronomia",
"StHPM Studies in the History and Philosophy of Modern Physics",
"StHMP Studies in the History of Mathematics and the Physical Sciences",
"StAM. Studies in Applied Mathematics",
"SCMP. Studies in Condensed Matter Physics",
"SGORS Studies in Geophysical Optics and Remote Sensing",
"StGeo Studies in Geophysics",
"StHEP Studies in High Energy Physics",
"StHCG Studies in High Energy Physics Cosmology and Gravitation",
"StMaP Studies in Mathematical Physics",
"StPTC Studies in Physical and Theoretical Chemistry",
"Sttur Studies in turbulence",
"SCA.. Studii si Cercetari de Astronomie Bucuresti",
"StCeF Studii si Cercetari de Fizica",
"StCeM Studii si Cercetari Matematice",
"StCMA Studii si Cercetary de Mecanica Aplicata",
"SSTA. Subsurface Sensing Technologies and Applications",
"SunGe Sun and Geosphere",
"Sunwo Sunworld",
"SuScT Superconductor Science Technology",
"SuMi. Superlattices and Microstructures",
"AnMuS Supplementband zu den Annalen der Munchener Sternwarte",
"SAnAp Supplements aux Annales d'Astrophysique",
"SuCT. Surface and Coatings Technology",
"SurIA Surface and Interface Analysis",
"SRL.. Surface Review and Letters",
"SuRvL Surface Reviews and Letters",
"SurSc Surface Science",
"SurSL Surface Science Letter",
"SurSR Surface Science Reports",
"SurSS Surface Science Spectra",
"SGeo. Surveys in Geophysics",
"SHEP. Surveys in High Energy Physics",
"SvPro Svarochnoe Proizvodstvo",
"SvUNT Sverdlovsk Ural skii Nauchnyi Tsentr AN SSSR",
"SydOP Sydney Observatory Papers",
"SynMe Synthetic Metals",
"SAMS. Systems Analysis Modelling Simulation",
"SyTec Systems Technology",
"TMPGO Tagung ueber Mathematische Probleme Geodaesie Oberwolfach West Germany Bulleting Geodesique",
"TANEs Tartu Akademiia Nauk Estonskoi SSR",
"TarOT Tartu Astrofuusika Observatoorium Teated",
"TarPr Tartuskoj Astrofizicheskoj Observatorii Preprint",
"IzTas Tashkent Izdatel Fan",
"IzGeo Tbilisi Georgian SSR Izdatel Metsniereba",
"TIzSS Tbilisi Izdatel Sabchota Sakartvelo",
"TecN. Technical News",
"TePhL Technical Physics Letters",
"TeLoA Technika Lotnicza i Astronautyczna",
"TBBM. Techniques of Biochemical and Biophysical Morphology",
"TPhy. Techniques of Physics",
"ToIzL Technisch oekonomische Informationen zivilen Luftfahrt",
"TMKF. Technische Mitteilungen Krupp Forschungsberichte",
"TUnGG Technische Univ Geodesy Global Geodyn",
"Tech. Technology",
"TeCu. Technology and Culture",
"TecRv Technology Review",
"Tecto Tectonics",
"Tectp Tectonophysics",
"TekEl Tekhnicheskaia Elektrodinamika",
"TJAu. Telecommunication Journal of Australia",
"TDAPR Telecommunications and Data Acquisition Progress Report",
"TMOPR Telecommunications and Mission Operations Progress Report",
"TRET. Telecommunications and Radio Engineering Telecommunications",
"TelIn Telematics Informatics",
"Telet Telettra S",
"Tell. Tellus",
"TellA Tellus Series A",
"TellB Tellus Series B Chemical and Physical Meteorology B",
"TSDMO Tellus Series Dynamic Meteorology and Oceanography",
"TeoEl Teoreticheskaia Elektrotekhnika",
"TeoPM Teoreticheskaia i Prikladnaia Mekhanika",
"TFFAP Teoriia Funktsii Funktsional nyi Analiz i ikh Prilozheniia",
"TeoVP Teoriia Veroiatnostei i ee Primeneniia",
"Teplo Teploenergetika",
"Tepsg Teplofizicheskie svoistva gazov",
"TepT. Teplofizika i Teplotekhnika",
"TepVT Teplofizika Vysokikh Temperatur",
"TFizG Teploobmen i Fizicheskaia Gazodinamika",
"TNEK. Teplovye Napriazheniia Elementakh Konstruktsii",
"LTerm La Termotecnica",
"Tesla TESLA Electronics",
"TTPhy Teubner Texte zur Physik",
"TexMi Textures and Microstructures",
"AcTC. Theoretica Chimica Acta",
"ThApC Theoretical and Applied Climatology",
"ThAFM Theoretical and Applied Fracture Mechanics",
"ThCFD Theoretical and Computational Fluid Dynamics",
"TMP.. Theoretical and Mathematical Physics",
"ThAst Theoretical Astrophysics",
"TPAG. Theory and Practice of Applied Geophysics",
"ThEng Thermal Engineering",
"Th&Ae Thermophysics and Aeromechanics",
"TSF.. Thin Solid Films",
"TETB. Thyssen Edelstahl Technische Berichte",
"TrTIM Tiflis Izdatel Metsniereba Akademiia Nauk Gruzinskoi SSR Institut Geofiziki Trudy",
"TrGru Tiflis Izdatel Metsniereba Akademiia Nauk Gruzinskoi SSR Matematicheskii Institut Trudy",
"IzTif Tiflis Izdatel Tbilisskogo Universiteta",
"CorTi Tirada Aparte Universidad Nacional de Cordoba Argentina Observatorio Astronomico",
"TiEng Tissue Engineering",
"TNKS. Tochnost i Nadezhnost Kiberneticheskikh Sistem",
"TSRSG Tohoku University Science Reports Series Geophysics",
"TokAB Tokyo Astronomical Bulletin",
"TokRe Tokyo Astronomical Observatory Reprints",
"TUFER Tokyo Denki University Faculty of Engineering Research Reports",
"TAEMm Tokyo Metropolitan College Aeronautical Engineering Memoirs",
"TUFEJ Tokyo University Faculty of Engineering Journal Series",
"TUISR Tokyo University Institute Industrial Science Report",
"TUASB Tokyo University Institute of Space and Aeronautical Science Bulletin",
"TUASR Tokyo University Institute of Space and Aeronautical Science Report",
"TIOA. Tomsk Institut Optiki Atmosfery CO AN SSSR",
"TApA. Top. Astrophys. Astron. Space Sci.",
"TApPh Topics in Applied Physics",
"ToCat Topics in Catalysis",
"TCPh. Topics in Current Physics",
"TPhCh Topics in Physical Chemistry",
"ToASC Torino Accademia delle Scienze Classe di Scienze Fisiche Matematiche e Naturali Atti",
"TosRv Toshiba Review",
"TouCE Toulouse Cepadues Editions",
"TAGU. Transactions of the American Geophysical Union",
"TAMS. Transactions of the American Mathematical Society",
"TAPS. Transactions of the American Philosophical Society",
"TOYal Transactions of the Astronomical Observatory of Yale University",
"TCaPS Transactions of the Cambridge Philosophical Society",
"TIMC. Transactions of the Institute of Measurement and Control",
"IAUTA Transactions of the International Astronomical Union, Series A",
"IAUTB Transactions of the International Astronomical Union, Series B",
"TIUCS Transactions of the International Union for Cooperation in Solar Research",
"TLHSQ Transactions of the Literary and Historical Society of Quebec",
"TrOS. Transactions of the Optical Society",
"TrStT Transactions of Space Technology Japan",
"TPM.. Transport in Porous Media",
"TTSP. Transport Theory and Statistical Physics",
"TSSLW Travaux de la Societe des Sciences et des Letters de Wroclaw",
"TOMar Travaux de l'Observatoire de Marseille",
"TraGe Travaux Geophysiques",
"TrGeo Treatise on Geochemistry",
"TTP.. Trends in Theoretical Physics",
"TriL. Tribology Letters",
"TrLit Trudy Akademiia Nauk Litovskoi",
"TrSSR Trudy Akademiia Nauk SSSR Fizicheskii Institut",
"TrRig Trudy Astrofiz. Lab. Riga",
"TrAlm Trudy Astrofizicheskogo Instituta Alma-Ata",
"TrLen Trudy Astronomicheskoj Observatorii Leningrad",
"TrPul Trudy Glavnoj Astronomicheskoj Observatorii v Pulkovo",
"TrSht Trudy Gosudarstvennogo Astronomicheskogo Instituta",
"TrDus Trudy Instituta Astrofiziki Dushanbe",
"TrSta Trudy Instituta Astrofiziki Stalinabad",
"TrKaz Trudy Kazanskaia Gorodkoj Astronomicheskoj Observatorii",
"TrMMO Trudy Moskovskoe Matematicheskoe Obshchestvo",
"TrPet Trudy Seminar imeni G Petrovskogo",
"TrTas Trudy Tashkentskoj Astronomicheskoj Observatorii",
"TrTsA TsAGI Trudy",
"ZaTsA TsAGI Uchenye Zapiski",
"TrTsI TsIAM Trudy",
"TsHUJ Tsing Hua University Journal",
"TITas Tsirkulyar Astronomicheskogo Instituta Akademiya Nauk Uzbekskoj SSR",
"TsShe Tsirkulyar Shemakhinskoj Astrofizicheskoj Observatorii",
"TsSta Tsirkulyar Stalinabadskoj Astronomicheskoj Observatorii",
"TsTas Tsirkulyar Tashkentskoj Astronomicheskoj Observatorii",
"TsPul Tsirkulyary Glavnoj Astronomicheskoj Observatorii i Pulkove",
"TUAID Tuebingen Universitaet Astronomisches Institut Diplomarbeit",
"TJJPT Tuijin Jishu Journal of Propulsion Technology",
"TurTe Turbulentnye techeniia",
"TJPh. Turkish Journal of Physics",
"UGSJR U S Geological Survey Journal Research",
"UkFiZ Ukrainskii Fizicheskii Zhurnal",
"UkMaZ Ukrainskii Matematicheskii Zhurnal",
"UkMJ. Ukranian Mathematical Journal",
"Ultmi Ultramicroscopy",
"UltIm Ultrasonic Imaging",
"Ultra Ultrasonics",
"USOC. Unified System Orbit Computation USOC",
"UMIB. Unione Matematica Italiana Bollettino",
"UNPSA United Nations Programme on Space Applications",
"UNAer Universita di Napoli Aeritalia S",
"UCAFR Universitas Comeniana Acta Facultatis Rerum Naturalium Physica",
"UMt1K Universite de Montpellier",
"UECBu University Electro Communications Bulletin",
"UnECR University Electro Communications Reports",
"StARe University Observatory St. Andrews Scotland Reprints",
"HawRe University of Hawaii Reprints",
"ADUrb University of Illinois Astronomy Department Urbana Illinois",
"MicRe University of Michigan Observatory Reprints",
"XXFD. University of Minnesota 1969 (XXFD)",
"LP... University of Minnesota Minneapolis",
"OklRe University of Oklahoma Observatory Reprints",
"MAUTx University of Texas Monographs in Astronomy",
"PAUTx University of Texas Publications in Astronomy",
"Unpub Unpublished",
"UAPET Updates in Applied Physics and Electrical Technology",
"UppAn Uppsala Astronomical Observatory Annals",
"UppOR Uppsala Astronomical Observatory Reports",
"USM.. Upravliaiushchie Sistemy i Mashiny",
"Urani Urania",
"UrMad Urania Madrid",
"USNOC U.S. Naval Observatory Circulars",
"USNOR U.S. Naval Observatory Reports",
"UsFiN Uspekhi Fizicheskikh Nauk",
"UMAM. Uspekhi Mekhaniki Advances Mechanics",
"RpCCA USSR Report Cybernetics Computers Automation Technology JPRS UCC",
"RpESc USSR Report Earth Sciences JPRS UES",
"RpSpR USSR Report Space",
"RpBAM USSR Report Space Biology Aerospace Medicine JPRS USB",
"RpEEE USSR Rept Electron Elec Eng JPRS UEE",
"RpEn. USSR Rept Energy JPRS UEN",
"RpEE. USSR Rept Eng Equipment JPRS UEQ",
"RLSBB USSR Rept Life Sci Biomed Behavioral Sci JPRS",
"RMTME USSR Rept Machine Tools Metalworking Equipment JPRS UMM",
"RpMSM USSR Rept Mater Sci Met JPRS",
"RpPhM USSR Rept Phys Math JPRS UPM",
"RSBAM USSR Rept Space Biol Aerospace Med Jun JPRS",
"RpSBA USSR Rept Space Biol Aerospace Med Sep",
"RpTr. USSR Rept Transportation JPRS UTR",
"UtMat Utilitas Mathematica",
"UtrOv Utrechtse Sterrekundige Overdrukken",
"Vacuu Vacuum",
"VVORe Van Vleck Observatory Reprints",
"VSOLB Variable Star Observers League in Japan - Bulletin",
"VatOP Vatican Observatory Publications",
"VDIF. VDI Forschungsheft",
"VDIZ. VDI Z",
"VDIZF VDI Zeitschriften Fortschritt Berichte Reihe Stroemungstechnik",
"VSD.. Vehicle System Dynamics",
"VeWFS Veroeffentlichung der Wilhelm Foerster Sterwarte",
"VeHei Veroeffentlichungen der Badischen Sternwarte zu Heidelberg",
"VeKar Veroeffentlichungen der Grossherzoglichen Sternwarte zu Karlsruhe",
"VeBam Veroeffentlichungen der Remeis-Sternwarte zu Bamberg",
"VeBab Veroeffentlichungen der Sternwarte Babelsberg",
"VeMun Veroeffentlichungen der Sternwarte Munchen",
"VeSon Veroeffentlichungen der Sternwarte Sonneberg",
"VeKie Veroeffentlichungen der Universitaets-Sternwarte Kiel",
"VeKoe Veroeffentlichungen der Universitaets-Sternwarte Koenigsberg Pr.",
"VeBB. Veroeffentlichungen der Universitaetssternwarte zu Berlin-Babelsberg",
"VeGoe Veroeffentlichungen der Universitaets-Sternwarte zu Goettingen",
"VeJen Veroeffentlichungen der Universitaets-Sternwarte zu Jena",
"VeLei Veroeffentlichungen der Universitaetssternwarte zu Leipzig",
"VeBoc Veroeffentlichungen des Astronomischen Instituts der Ruhr-Universitaet Bochum",
"VeARI Veroeffentlichungen des Astronomischen Rechen-Instituts Heidelberg",
"VeABD Veroeffentlichungen des Astronomischen Rechen-Instituts zu Berlin-Dahlem",
"VeBon Veroeffentlichungen des Astronomisches Institute der Universitaet Bonn",
"VeFra Veroeffentlichungen des Astronomisches Institute der Universitaet Frankfurt",
"VeKAB Veroeffentlichungen des Koeniglichen Astronomischen Rechen-Instituts zu Berlin",
"VeZPE Veroffentlichungen des Zentralinstituts Physik der Erde",
"VeLdn Verslag van den staat der Sterrewacht te Leiden",
"Vert. Vertica",
"Vertf Vertiflite",
"VKha. Vestnik Khar'kovskogo Universiteta",
"VKie. Vestnik Kievskogo Universiteta Seriya Astronomii",
"VeMos Vestnik Moskovskogo Universiteta Seriya 3 Fizika Astronomiya",
"VISBD Vibration Inst Shock Vibration Digest",
"VIAEA Vienna International Atomic Energy Agency",
"VAG.. Vierteljahresschrift der Astronomischen Gesellschaft",
"VMed. Vierteljahrschrift f&uuml",
"VNG.. Vierteljahrsschrift der Naturforschenden Gesellschaft in Z&uuml",
"VilCo Villanova University Observatory Contributions",
"VilOB Vilnius Astronomijos Observatorijos Biuletenis",
"IzVil Vilnius Izdatel Mokslas",
"VJS.. Virginia Journal of Science",
"ViGeo Vissha Geodeziia",
"VA... Vistas in Astronomy",
"VTJ.. Vitro Technical Journal",
"yCat. VizieR Online Data Catalog",
"VICFD VKI An Introduction to Computational Fluid Dynamics",
"VIMT. VKI An Introduction to Modeling Turbulence",
"VADVS VKI Advanced Design of Ventilation Systems",
"VAFC. VKI Axial Flow Compressors",
"VBLT. VKI Boundary Layers in Turbomachines",
"VCCPP VKI Combined Cycles for Power Plants",
"VCFD. VKI Computational Fluid Dynamics",
"VCFDI VKI Computational Fluid Dynamics for Industrial Flows",
"VCGFV VKI Computer Graphics Flow Visualization and Computational Fluid Dynamics",
"VGTET VKI Gas Turbine Engine Transient Behaviour",
"VIHE. VKI Industrial Heat Exchangers",
"VKILV VKI Laser Velocimetry",
"VKIMT VKI Measurement and Techniques",
"VMTA. VKI Measurement Techniques in Aerodynamics",
"VMHT. VKI Methodology Hypersonic Testing",
"VMATP VKI Modeling and Applications of Transport Phenomena in Porous Media",
"VADMT VKI New Approaches in the Description and Modeling of Turbulence",
"VNGG. VKI Numerical Grid Generation",
"VNMFT VKI Numerical Methods for Flows in Turbomachinery",
"VPIDV VKI Particle Image Displacement Velocimetry",
"VKIRT VKI Radial Turbines",
"VKISP VKI Spacecraft Propulsion",
"VTSF. VKI Turbulent Shear Flows",
"VVRD. VKI Vibration Rotor Dynamics",
"VLSID VLSI Design",
"VAC.. Voies Aviation Civile Fall Winter",
"VANTS Voprosy Atomnoi Nauki i Tekhniki Seriia Fizika Plazmy i Problemy Upravliaemykh Termoiadernykh Reaktsii",
"VopDP Voprosy Dinamiki i Prochnosti",
"VETT. Voprosy Elektroniki Tverdogo Tela",
"VopGA Voprosy Gidrodinamiki Atmosfery",
"VopK. Voprosy Kibernetiki",
"VMOIP Voprosy Metrologicheskogo Obespecheniia Izmereniia Parametrov Tekhnologicheskikh Lazerov",
"VoTAS Voprosy Teorii Atomnykh Stolknovenii",
"VopTP Voprosy Teorii Plazmy",
"VTSAU Voprosy Teorii Sistem Avtomaticheskogo Upravleniia",
"VossZ Vossische Zeitung",
"IzYak Vsesoiuznaia Konferentsiia Kosmicheskim Lucham Yakutsk USSR Akademiia Nauk SSSR Izvestiia Seriia Fizicheskaia",
"IzYer Vsesoiuznaia Konferentsiia Kosmicheskim Lucham Yerevan Armenian SSR Aademiia Nauk SSSR Izvestiia Seriia Fizicheskaia",
"RaUkr Vsesoiuznyi Simpozium Difraktsii i Rasprostraneniiu Voln Lvov Ukrainian SSR Radiofizika",
"VnPM. Vychislitel naia i Prikladnaia Matematika",
"VnMP. Vychislitel nye Metody i Programmirovanie",
"VyGeo Vyssha Geodeziia",
"W&S.. Waerme und Stoffuebertragung",
"WarRe Warsaw University Reprints",
"WasOA Washburn Observatory Astrophysics",
"GMS.. Washington DC American Geophysical Union Geophysical Monograph Series",
"WRR.. Water Resources Research",
"WavEl Wave Electronics",
"WaMot Wave Motion",
"WRCM. Waves in Random and Complex Media",
"WRM.. Waves in Random Media",
"Wear. Wear",
"WearB Wear B",
"Wthr. Weather",
"WtFor Weather and Forecasting",
"WeiEn Weight Engineering",
"WeldJ Welding Journal",
"Welt. Die Weltall",
"JIMO. WGN, Journal of the International Meteor Organization",
"WilOO Williamstown Observatory Observations",
"WiEn. Wind Energy",
"WiEng Wind Engineering",
"WisBT Wissenschaftliche Berichte AEG Telefunken",
"WisZe Wissenschaftliche Zeitschrift",
"WCRp. World Climate Report",
"WroRe Wroclaw Astronomical Observatory Reprints",
"Wuli. Wuli",
"YaFiz Yadernaya Fizika",
"YalOY Yale University Observatory Reports for the year",
"YUFEM Yamaguchi University Faculty of Engineering Memoirs",
"YUTR. Yamaguchi University Technology Reports",
"YamC. Yamamoto Circular",
"ZaDN. Zagadnienia Drgan Nieliniowych",
"ZaLab Zavodskaia Laboratoriia",
"ZaMM. Zeitschrift Angewandte Mathematik und Mechanik",
"ZaMP. Zeitschrift Angewandte Mathematik und Physik",
"ZFHDG Zeitschrift der Fachsektion Hydrogeologie in der Deutschen Geologischen Gesellschaft",
"ZeIE. Zeitschrift elektrische Informations und Energietechnik",
"ZAGeo Zeitschrift fur Angewandte Geographie",
"ZAPhy Zeitschrift fur Angewandte Physik",
"ZAAC. Zeitschrift fur Anorganische und Allgemeine Chemie",
"ZA... Zeitschrift fur Astrophysik",
"ZEVGA Zeitschrift fur Eisenbahnwesen und Verkehrstechnik Glasers Annalen",
"ZFlu. Zeitschrift fur Flugwissenschaften",
"ZFlWe Zeitschrift fur Flugwissenschaften und Weltraumforschung",
"ZGeo. Zeitschrift fur Geophysik",
"ZGlGl Zeitschrift fur Gletscherkunde und Glazialgeologie",
"ZKri. Zeitschrift fur Kristallographie",
"ZMetl Zeitschrift fur Metallkunde",
"ZeMet Zeitschrift fur Meteorologie",
"ZPhy. Zeitschrift fur Physik",
"ZPhyA Zeitschrift fur Physik A Hadrons and Nuclei",
"ZPhyB Zeitschrift fur Physik B Condensed Matter",
"ZPhyC Zeitschrift fur Physik C Particles and Fields",
"ZPhyD Zeitschrift fur Physik D Atoms Molecules Clusters",
"ZPC.. Zeitschrift fur Physikalische Chemie",
"ZPCF. Zeitschrift fur Physikalische Chemie Frankfurt",
"ZPCL. Zeitschrift fur Physikalische Chemie Leipzig",
"ZPCNF Zeitschrift fur Physikalische Chemie Neue Folge",
"ZPCW. Zeitschrift fur Physikalische Chemie Wiesbaden",
"ZEAPC Zeitschrift f&uuml",
"ZMP.. Zeitschrift f&uuml",
"ZNatA Zeitschrift Naturforschung Teil A",
"ZNatB Zeitschrift Naturforschung Teil B",
"ZePAN Zeitschrift Physik Atomic Nuclei",
"ZWer. Zeitschrift Werkstofftechnik",
"ZemVs Zemlia i Vselennaia",
"Zenit Zenit",
"MiTau Zentralinstitut fuer Astrophysik Mitteilungen des Karl-Schwarzschild-Observatoriums Tautenburg",
"MitVS Zentralinstitut fuer Astrophysik Sternwarte Sonneberg Mitteilungen ueber Veraenderliche Sterne",
"ZhPmR ZhETF Pis ma Redaktsiiu",
"ZhETF Zhurnal Eksperimental noi i Teoreticheskoi Fiziki",
"ZhFK. Zhurnal Fizicheskoi Khimii",
"ZNPFK Zhurnal Nauchnoi i Prikladnoi Fotografii i Kinematografii",
"ZhPhy Zhurnal Physik",
"ZhPS. Zhurnal Prikladnoi Spektroskopii",
"ZhTFi Zhurnal Tekhnicheskoi Fiziki",
"ZVMMF Zhurnal Vychislitel noi Matematiki i Matematicheskoi Fiziki",
"ZiZa. Ziran Zazhi",
"Zprav Zpravodaj VZLU",
};
static const int njournals = sizeof( journals ) / sizeof( journals[0] );

