/*
CLASS:sexp_conv_options:
*/
#ifndef GABA_DEFINE
struct sexp_conv_options
{
  struct lsh_object super;
  sexp_argp_state input;
  sexp_argp_state output;
  int once;
  int mode;
  struct alist *algorithms;
  struct hash_algorithm *hash;
  int hash_name;
  struct int_list *select;
  struct lsh_string *before;
  struct lsh_string *after;
};
extern struct lsh_class sexp_conv_options_class;
#endif /* !GABA_DEFINE */

#ifndef GABA_DECLARE
static void
do_sexp_conv_options_mark(struct lsh_object *o,
  void (*mark)(struct lsh_object *o))
{
  struct sexp_conv_options *i = (struct sexp_conv_options *) o;
  mark((struct lsh_object *) i->algorithms);
  mark((struct lsh_object *) i->hash);
  mark((struct lsh_object *) i->select);
}
static void
do_sexp_conv_options_free(struct lsh_object *o)
{
  struct sexp_conv_options *i = (struct sexp_conv_options *) o;
  lsh_string_free(i->before);
  lsh_string_free(i->after);
}
struct lsh_class sexp_conv_options_class =
{
  STATIC_HEADER,
  NULL,
  "sexp_conv_options",
  sizeof(struct sexp_conv_options),
  do_sexp_conv_options_mark,
  do_sexp_conv_options_free,
};
#endif /* !GABA_DECLARE */

