
#include <config.h>
#include <stdio.h>
#include <string.h>
#include "ksba.h"
#include "asn1-func.h"

static const static_asn tmttv2_asn1_tab[] = {
  {"TMTTv2",136, {0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},0},
  {NULL,6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"identified-organization",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {"dod",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"6"},
  {"internet",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"security",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"5"},
  {"mechanisms",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"5"},
  {"teletrust",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"foo",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"17"},
  {"id-ce",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"joint-iso-ccitt",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"ds",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"5"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"29"},
  {"Certificate",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"tbsCertificate",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"TBSCertificate"},
  {"signatureAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"signature",3, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"AlgorithmIdentifier",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"algorithm",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"parameters",134, {0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0},0},
  {"algorithm",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"TBSCertificate",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1},"0"},
  {NULL,131, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"v1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"Version"},
  {"serialNumber",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CertificateSerialNumber"},
  {"signature",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"issuer",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Name"},
  {"validity",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Validity"},
  {"subject",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Name"},
  {"subjectPublicKeyInfo",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"SubjectPublicKeyInfo"},
  {"issuerUniqueID",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"UniqueIdentifier"},
  {"subjectUniqueID",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"2"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"UniqueIdentifier"},
  {"extensions",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"3"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"Extensions"},
  {"Version",2, {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"v1",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"0"},
  {"v2",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"v3",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"2"},
  {"CertificateSerialNumber",2, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"Name",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"rdnSequence",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},"RDNSequence"},
  {"RDNSequence",133, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"RelativeDistinguishedName"},
  {"RelativeDistinguishedName",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"AttributeTypeAndValue"},
  {"Attribute",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"type",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AttributeType"},
  {"values",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"AttributeValue"},
  {"Attributes",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"Attribute"},
  {"AttributeTypeAndValue",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"type",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AttributeType"},
  {"value",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"AttributeValue"},
  {"AttributeType",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"AttributeValue",134, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1},0},
  {"DirectoryString",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"printableString",19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},0},
  {"maxSize",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"teletexString",20, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},0},
  {"maxSize",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"utf8String",12, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},0},
  {"maxSize",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"bmpString",30, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},0},
  {"maxSize",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"universalString",28, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},0},
  {"maxSize",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"Validity",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"notBefore",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Time"},
  {"notAfter",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"Time"},
  {"Time",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"utcTime",23, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1},0},
  {"generalTime",24, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},0},
  {"SubjectPublicKeyInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"algorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"subjectPublicKey",3, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"Extensions",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"Extension"},
  {"Extension",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"extnID",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"critical",1, {0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1},0},
  {NULL,131, {0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0},0},
  {"extnValue",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"UniqueIdentifier",3, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"AuthorityKeyIdentifier",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"keyIdentifier",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"KeyIdentifier"},
  {"authorityCertIssuer",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"GeneralNames"},
  {"authorityCertSerialNumber",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"2"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"CertificateSerialNumber"},
  {"KeyIdentifier",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"KeyUsage",3, {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"digitalSignature",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"0"},
  {"nonRepudiation",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"keyEncipherment",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"dataEncipherment",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {"keyAgreement",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"4"},
  {"keyCertSign",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"5"},
  {"cRLSign",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"6"},
  {"encipherOnly",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"7"},
  {"decipherOnly",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"8"},
  {"CertificatePolicies",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"PolicyInformation"},
  {"PolicyInformation",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"policyIdentifier",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CertPolicyId"},
  {"policyQualifiers",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"PolicyQualifierInfo"},
  {"CertPolicyId",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"PolicyQualifierInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"policyQualifierId",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"PolicyQualifierId"},
  {"qualifier",134, {0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0},0},
  {"policyQualifierId",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"PolicyQualifierId",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"PolicyMappingsSyntax",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0},0},
  {"issuerDomainPolicy",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CertPolicyId"},
  {"subjectDomainPolicy",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"CertPolicyId"},
  {"SubjectAltName",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"GeneralNames"},
  {"GeneralNames",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"GeneralName"},
  {"GeneralName",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"otherName",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"OtherName"},
  {"rfc822Name",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"1"},
  {NULL,22, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},0},
  {"dNSName",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"2"},
  {NULL,22, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},0},
  {"x400Address",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"3"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"ORAddress"},
  {"directoryName",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"4"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"Name"},
  {"ediPartyName",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"5"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"EDIPartyName"},
  {"uniformResourceIdentifier",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"6"},
  {NULL,22, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},0},
  {"iPAddress",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"7"},
  {NULL,4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},0},
  {"registeredID",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},"8"},
  {NULL,6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},0},
  {"OtherName",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"type-id",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"value",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},"0"},
  {NULL,134, {0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0},0},
  {"type-id",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"EDIPartyName",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"nameAssigner",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"DirectoryString"},
  {"partyName",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"DirectoryString"},
  {"SubjectDirectoryAttributes",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"Attribute"},
  {"BiometricData",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0},0},
  {"typeId",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"value",134, {0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0},0},
  {"typeId",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"BasicConstraints",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"cA",1, {0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1},0},
  {NULL,131, {0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0},0},
  {"pathLenConstraint",2, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,1,0,0,0,0,0,0,1,0},0},
  {"0",132, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"MAX"},
  {"NameConstraints",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"permittedSubtrees",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"GeneralSubtrees"},
  {"excludedSubtrees",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"GeneralSubtrees"},
  {"GeneralSubtrees",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"GeneralSubtree"},
  {"GeneralSubtree",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"base",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"GeneralName"},
  {"minimum",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1},"0"},
  {NULL,131, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"BaseDistance"},
  {"maximum",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"BaseDistance"},
  {"BaseDistance",2, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"0",132, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"MAX"},
  {"PolicyConstraintsSyntax",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0},0},
  {"requireExplicitPolicy",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"SkipCerts"},
  {"inhibitPolicyMapping",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"SkipCerts"},
  {"SkipCerts",2, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"0",132, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"MAX"},
  {"CRLDistPointsSyntax",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"DistributionPoint"},
  {"DistributionPoint",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"distributionPoint",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"DistributionPointName"},
  {"reasons",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"ReasonFlags"},
  {"cRLIssuer",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"2"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"GeneralNames"},
  {"DistributionPointName",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"fullName",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"GeneralNames"},
  {"nameRelativeToCRLIssuer",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"RelativeDistinguishedName"},
  {"ReasonFlags",3, {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"unused",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"0"},
  {"keyCompromise",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"cACompromise",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"affiliationChanged",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {"superseded",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"4"},
  {"cessationOfOperation",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"5"},
  {"certificateHold",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"6"},
  {"IssuerCertDistributionPoint",22, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"SubjectCertDistributionPoint",22, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"PolicyDistributionPoint",22, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"TestIdentifier",12, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"CertificateList",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"tbsCertList",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"TBSCertList"},
  {"signatureAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"signatureValue",3, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"TBSCertList",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1},"Version"},
  {"signature",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"issuer",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Name"},
  {"thisUpdate",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Time"},
  {"nextUpdate",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1},"Time"},
  {"revokedCertificates",133, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},0},
  {NULL,16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1,0},0},
  {"userCertificate",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CertificateSerialNumber"},
  {"revocationDate",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Time"},
  {"crlEntryExtensions",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},"Extensions"},
  {"crlExtensions",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"Extensions"},
  {"CRLReason",10, {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"unspecified",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"0"},
  {"keyCompromise",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"cACompromise",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"affiliationChanged",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {"superseded",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"4"},
  {"cessationOfOperation",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"5"},
  {"certificateHold",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"6"},
  {"removeFromCRL",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"8"},
  {"InvalidityDate",24, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"CertificateIssuer",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"GeneralNames"},
  {"cRLNumber",2, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"1",132, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"MAX"},
  {"issuingDistributionPoint",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"distributionPoint",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"DistributionPointName"},
  {"onlyContainsUserCerts",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1},"1"},
  {NULL,131, {0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1},0},
  {NULL,1, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"onlyContainsCACerts",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,1},"2"},
  {NULL,131, {0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1},0},
  {NULL,1, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"onlySomeReasons",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"3"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"ReasonFlags"},
  {"indirectCRL",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0},"4"},
  {NULL,131, {0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,0,0,1},0},
  {NULL,1, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"CertificationRequestInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"certificationRequestInfo",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Version"},
  {"subject",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Name"},
  {"subjectPublicKeyInfo",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"SubjectPublicKeyInfo"},
  {"attributes",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"Attributes"},
  {"ORAddress",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"built-in-standard-attributes",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"BuiltInStandardAttributes"},
  {"built-in-domain-defined-attributes",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1},"BuiltInDomainDefinedAttributes"},
  {"extension-attributes",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},"ExtensionAttributes"},
  {"BuiltInStandardAttributes",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"country-name",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1},"CountryName"},
  {"administration-domain-name",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1},"AdministrationDomainName"},
  {"network-address",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"NetworkAddress"},
  {"terminal-identifier",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"TerminalIdentifier"},
  {"private-domain-name",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"2"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"PrivateDomainName"},
  {"organization-name",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"3"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"OrganizationName"},
  {"numeric-user-identifier",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"4"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"NumericUserIdentifier"},
  {"personal-name",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"5"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"PersonalName"},
  {"organizational-unit-names",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"6"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"OrganizationalUnitNames"},
  {"CountryName",130, {1,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},"1"},
  {NULL,137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},0},
  {"x121-dcc-code",18, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},0},
  {NULL,132, {0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"ub-country-name-numeric-length"},
  {"iso-3166-alpha2-code",19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},0},
  {NULL,132, {0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"ub-country-name-alpha-length"},
  {"AdministrationDomainName",130, {1,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},"2"},
  {NULL,137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},0},
  {"numeric",18, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},0},
  {"ub-domain-name-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"0"},
  {"printable",19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},0},
  {"ub-domain-name-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"0"},
  {"NetworkAddress",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"X121Address"},
  {"X121Address",18, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"ub-x121-address-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"TerminalIdentifier",19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"ub-terminal-id-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"PrivateDomainName",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"numeric",18, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},0},
  {"ub-domain-name-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"printable",19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},0},
  {"ub-domain-name-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"OrganizationName",19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"ub-organization-name-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"NumericUserIdentifier",18, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"ub-numeric-user-id-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"PersonalName",17, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"surname",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},"0"},
  {NULL,19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0},0},
  {"ub-surname-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"given-name",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"1"},
  {NULL,19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0},0},
  {"ub-given-name-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"initials",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"2"},
  {NULL,19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0},0},
  {"ub-initials-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"generation-qualifier",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"3"},
  {NULL,19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1,0,0,0,0,0,1,0},0},
  {"ub-generation-qualifier-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"OrganizationalUnitNames",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"ub-organizational-units",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"OrganizationalUnitName"},
  {"OrganizationalUnitName",19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"ub-organizational-unit-name-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"BuiltInDomainDefinedAttributes",133, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"ub-domain-defined-attributes",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"BuiltInDomainDefinedAttribute"},
  {"BuiltInDomainDefinedAttribute",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"type",19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"ub-domain-defined-attribute-type-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"value",19, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},0},
  {"ub-domain-defined-attribute-value-length",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"ExtensionAttributes",135, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"ub-extension-attributes",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"ExtensionAttribute"},
  {"ExtensionAttribute",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},0},
  {"extension-attribute-type",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},"0"},
  {NULL,2, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0},0},
  {"0",132, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"ub-extension-attributes"},
  {"extension-attribute-value",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},"1"},
  {NULL,134, {0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0},0},
  {"extension-attribute-type",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {0,0}
};
static const static_asn cms_asn1_tab[] = {
  {"CryptographicMessageSyntax",136, {0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},0},
  {NULL,6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs-9",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"9"},
  {"smime",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"16"},
  {"modules",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"0"},
  {"cms",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"ContentInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"contentType",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"ContentType"},
  {"content",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},"0"},
  {NULL,134, {0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,1,0},0},
  {"contentType",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"ContentType",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"SignedData",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CMSVersion"},
  {"digestAlgorithms",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"DigestAlgorithmIdentifiers"},
  {"encapContentInfo",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"EncapsulatedContentInfo"},
  {"certificates",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"CertificateSet"},
  {"crls",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"CertificateRevocationLists"},
  {"signerInfos",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"SignerInfos"},
  {"DigestAlgorithmIdentifiers",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"DigestAlgorithmIdentifier"},
  {"SignerInfos",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"SignerInfo"},
  {"EncapsulatedContentInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"eContentType",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"ContentType"},
  {"eContent",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"0"},
  {NULL,4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"SignerInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CMSVersion"},
  {"sid",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"SignerIdentifier"},
  {"digestAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"DigestAlgorithmIdentifier"},
  {"signedAttrs",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"SignedAttributes"},
  {"signatureAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"SignatureAlgorithmIdentifier"},
  {"signature",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"SignatureValue"},
  {"unsignedAttrs",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"UnsignedAttributes"},
  {"SignerIdentifier",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"issuerAndSerialNumber",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1},"IssuerAndSerialNumber"},
  {"subjectKeyIdentifier",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"SubjectKeyIdentifier"},
  {"SignedAttributes",135, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"Attribute"},
  {"UnsignedAttributes",135, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"Attribute"},
  {"Attribute",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"attrType",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"attrValues",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"AttributeValue"},
  {"AttributeValue",134, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1},0},
  {"SignatureValue",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"EnvelopedData",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CMSVersion"},
  {"originatorInfo",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"OriginatorInfo"},
  {"recipientInfos",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"RecipientInfos"},
  {"encryptedContentInfo",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"EncryptedContentInfo"},
  {"unprotectedAttrs",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"UnprotectedAttributes"},
  {"OriginatorInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"certs",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"CertificateSet"},
  {"crls",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"CertificateRevocationLists"},
  {"RecipientInfos",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"RecipientInfo"},
  {"EncryptedContentInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"contentType",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"ContentType"},
  {"contentEncryptionAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"ContentEncryptionAlgorithmIdentifier"},
  {"encryptedContent",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"EncryptedContent"},
  {"EncryptedContent",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"UnprotectedAttributes",135, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"Attribute"},
  {"RecipientInfo",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"ktri",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1},"KeyTransRecipientInfo"},
  {"kari",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"KeyAgreeRecipientInfo"},
  {"kekri",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},"2"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"KEKRecipientInfo"},
  {"EncryptedKey",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"KeyTransRecipientInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CMSVersion"},
  {"rid",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"RecipientIdentifier"},
  {"keyEncryptionAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"KeyEncryptionAlgorithmIdentifier"},
  {"encryptedKey",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"EncryptedKey"},
  {"RecipientIdentifier",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"issuerAndSerialNumber",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1},"IssuerAndSerialNumber"},
  {"subjectKeyIdentifier",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"SubjectKeyIdentifier"},
  {"KeyAgreeRecipientInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CMSVersion"},
  {"originator",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"OriginatorIdentifierOrKey"},
  {"ukm",130, {2,1,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"UserKeyingMaterial"},
  {"keyEncryptionAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"KeyEncryptionAlgorithmIdentifier"},
  {"recipientEncryptedKeys",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"RecipientEncryptedKeys"},
  {"OriginatorIdentifierOrKey",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"issuerAndSerialNumber",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1},"IssuerAndSerialNumber"},
  {"subjectKeyIdentifier",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"SubjectKeyIdentifier"},
  {"originatorKey",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"OriginatorPublicKey"},
  {"OriginatorPublicKey",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"algorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"publicKey",3, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"RecipientEncryptedKeys",133, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"RecipientEncryptedKey"},
  {"RecipientEncryptedKey",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"rid",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"KeyAgreeRecipientIdentifier"},
  {"encryptedKey",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"EncryptedKey"},
  {"KeyAgreeRecipientIdentifier",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"issuerAndSerialNumber",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1},"IssuerAndSerialNumber"},
  {"rKeyId",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"RecipientKeyIdentifier"},
  {"RecipientKeyIdentifier",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"subjectKeyIdentifier",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"SubjectKeyIdentifier"},
  {"date",24, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1},0},
  {"other",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},"OtherKeyAttribute"},
  {"SubjectKeyIdentifier",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"KEKRecipientInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CMSVersion"},
  {"kekid",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"KEKIdentifier"},
  {"keyEncryptionAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"KeyEncryptionAlgorithmIdentifier"},
  {"encryptedKey",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"EncryptedKey"},
  {"KEKIdentifier",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"keyIdentifier",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"date",24, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,1},0},
  {"other",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0},"OtherKeyAttribute"},
  {"DigestedData",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CMSVersion"},
  {"digestAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"DigestAlgorithmIdentifier"},
  {"encapContentInfo",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"EncapsulatedContentInfo"},
  {"digest",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"Digest"},
  {"Digest",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"EncryptedData",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CMSVersion"},
  {"encryptedContentInfo",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"EncryptedContentInfo"},
  {"unprotectedAttrs",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"UnprotectedAttributes"},
  {"AuthenticatedData",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CMSVersion"},
  {"originatorInfo",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"OriginatorInfo"},
  {"recipientInfos",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"RecipientInfos"},
  {"macAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"MessageAuthenticationCodeAlgorithm"},
  {"digestAlgorithm",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"DigestAlgorithmIdentifier"},
  {"encapContentInfo",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"EncapsulatedContentInfo"},
  {"authenticatedAttributes",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,1},"2"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"AuthAttributes"},
  {"mac",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"MessageAuthenticationCode"},
  {"unauthenticatedAttributes",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,1,0},"3"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"UnauthAttributes"},
  {"AuthAttributes",135, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"Attribute"},
  {"UnauthAttributes",135, {0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"MAX",132, {0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,1,0,0,0,1},"1"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"Attribute"},
  {"MessageAuthenticationCode",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"DigestAlgorithmIdentifier",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"SignatureAlgorithmIdentifier",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"KeyEncryptionAlgorithmIdentifier",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"ContentEncryptionAlgorithmIdentifier",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"MessageAuthenticationCodeAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"CertificateRevocationLists",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"CertificateList"},
  {"CertificateChoices",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"certificate",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1},"Certificate"},
  {"extendedCertificate",130, {2,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0},"0"},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0},"ExtendedCertificate"},
  {"CertificateSet",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"CertificateChoices"},
  {"IssuerAndSerialNumber",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"issuer",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Name"},
  {"serialNumber",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"CertificateSerialNumber"},
  {"CMSVersion",2, {0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"v0",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"0"},
  {"v1",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"v2",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"v3",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {"v4",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"4"},
  {"UserKeyingMaterial",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"OtherKeyAttribute",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"keyAttrId",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"keyAttr",134, {0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0},0},
  {"keyAttrId",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"MessageDigest",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"SigningTime",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Time"},
  {"Time",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"utcTime",23, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,1},0},
  {"generalTime",24, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},0},
  {"Countersignature",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"SignerInfo"},
  {"sha-1",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"identified-organization",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {"oiw",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"14"},
  {"secsig",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {"algorithm",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"26"},
  {"md5",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"digestAlgorithm",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"5"},
  {"id-dsa-with-sha1",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"x9-57",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"10040"},
  {"x9cm",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"4"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"3"},
  {"rsaEncryption",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs-1",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"dh-public-number",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"ansi-x942",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"10046"},
  {"number-type",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"id-alg-ESDH",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs-9",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"9"},
  {"smime",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"16"},
  {"alg",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"5"},
  {"id-alg-CMS3DESwrap",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs-9",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"9"},
  {"smime",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"16"},
  {"alg",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"6"},
  {"id-alg-CMSRC2wrap",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs-9",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"9"},
  {"smime",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"16"},
  {"alg",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"7"},
  {"des-ede3-cbc",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"encryptionAlgorithm",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"7"},
  {"rc2-cbc",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"encryptionAlgorithm",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"2"},
  {"hMAC-SHA1",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"identified-organization",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"3"},
  {"dod",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"6"},
  {"internet",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"security",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"5"},
  {"mechanisms",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"5"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"8"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"2"},
  {"KeyWrapAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AlgorithmIdentifier"},
  {"RC2wrapParameter",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"RC2ParameterVersion"},
  {"RC2ParameterVersion",2, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"CBCParameter",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"IV"},
  {"IV",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"RC2CBCParameter",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"rc2ParameterVersion",2, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"iv",4, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"id-ct-contentInfo",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs-9",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"9"},
  {"smime",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"16"},
  {"ct",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"6"},
  {"id-data",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs7",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"7"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"1"},
  {"id-signedData",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs7",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"7"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"2"},
  {"id-envelopedData",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs7",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"7"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"3"},
  {"id-digestedData",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs7",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"7"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"5"},
  {"id-encryptedData",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs7",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"7"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"6"},
  {"id-ct-authData",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs-9",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"9"},
  {"smime",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"16"},
  {"ct",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"2"},
  {"id-contentType",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs9",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"9"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"3"},
  {"id-messageDigest",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs9",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"9"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"4"},
  {"id-signingTime",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs9",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"9"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"5"},
  {"id-countersignature",6, {0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"iso",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"member-body",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"2"},
  {"us",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"840"},
  {"rsadsi",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"113549"},
  {"pkcs",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"1"},
  {"pkcs9",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"9"},
  {NULL,128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"6"},
  {"ExtendedCertificate",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"extendedCertificateInfo",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"ExtendedCertificateInfo"},
  {"signatureAlgorithm",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"SignatureAlgorithmIdentifier"},
  {"signature",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"Signature"},
  {"ExtendedCertificateInfo",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"version",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"CMSVersion"},
  {"certificate",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"Certificate"},
  {"attributes",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"UnauthAttributes"},
  {"Signature",3, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"Name",137, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"rdnSequence",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0},"RDNSequence"},
  {"RDNSequence",133, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"RelativeDistinguishedName"},
  {"RelativeDistinguishedName",135, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {NULL,129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0},"AttributeTypeAndValue"},
  {"AttributeTypeAndValue",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"type",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},"AttributeType"},
  {"value",129, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},"AttributeValue"},
  {"AttributeType",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"AttributeValue",134, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1},0},
  {"AlgorithmIdentifier",16, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1},0},
  {"algorithm",6, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1},0},
  {"parameters",134, {0,0,0,0,0,0,0,0,0,0,1,0,0,0,1,0,0,0,0,1,0,1,0},0},
  {"algorithm",128, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {"Certificate",134, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1},0},
  {"CertificateList",134, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,1},0},
  {"CertificateSerialNumber",2, {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},0},
  {0,0}
};


const static_asn *
_ksba_asn_lookup_table (const char *name)
{
  if (!strcmp (name, "cms"))
    return cms_asn1_tab;
  if (!strcmp (name, "tmttv2"))
    return tmttv2_asn1_tab;

  return NULL;
}
