/* colons-test_callback.c - Callback to test colons events
 *      Copyright (C) 1999 Michael Roth <mroth@gnupg.org>
 *
 * This file is part of PGG (Privacy Guard Glue).
 *
 * PGG is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * PGG is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 */


#include <pggtest.h>
#include <pggcolons.h>


extern struct { int colon; char *text; } expected_event[];
extern int expected_event_index;


/*
 * This callback function is called from the PggColons object each
 * time a new colon event is available.
 * This function compares the events with the expected ones. 
 * The 'opaque' argument is not used in this test.
 */
int colons_test_callback(void *opaque, int colon, const char *text)
{
    if (expected_event[expected_event_index].colon == -1) {
        PGG_DEBUG(("To many events got."));
        exit(1);
    }
    
    if (expected_event[expected_event_index].colon != colon) {
        PGG_DEBUG(("Unexpected event colon: %d.  Expected: %d (at index: %d).", 
            colon, 
            expected_event[expected_event_index].colon,
            expected_event_index ));
        exit(1);
    }
    
    if (strcmp(expected_event[expected_event_index].text, text)) {
        PGG_DEBUG(("Unexpected event text: \"%s\".  Expected: \"%s\" (at index: %d).",
            text,
            expected_event[expected_event_index].text,
            expected_event_index ));
        exit(1);
    }
    
    ++expected_event_index;
    return 0;
}


